/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.io;

import com.limegroup.gnutella.io.InterestWriteChannel;
import com.limegroup.gnutella.io.InterruptedIOException;
import com.limegroup.gnutella.io.Shutdownable;
import com.limegroup.gnutella.io.WriteObserver;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

class BufferOutputStream
extends OutputStream
implements Shutdownable {
    private static final Log LOG;
    private final Object LOCK = new Object();
    private final Shutdownable handler;
    private final WriteObserver writeObserver;
    private final ByteBuffer buffer;
    private final InterestWriteChannel channel;
    private boolean shutdown = false;
    static /* synthetic */ Class class$0;

    static {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("com.limegroup.gnutella.io.BufferOutputStream");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        LOG = LogFactory.getLog((Class)clazz);
    }

    BufferOutputStream(ByteBuffer byteBuffer, Shutdownable shutdownable, WriteObserver writeObserver, InterestWriteChannel interestWriteChannel) {
        this.handler = shutdownable;
        this.buffer = byteBuffer;
        this.channel = interestWriteChannel;
        this.writeObserver = writeObserver;
    }

    Object getBufferLock() {
        return this.LOCK;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void write(int n) throws IOException {
        Object object = this.LOCK;
        synchronized (object) {
            this.waitImpl();
            this.buffer.put((byte)(n & 0xFF));
            this.channel.interest(this.writeObserver, true);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void write(byte[] byArray, int n, int n2) throws IOException {
        Object object = this.LOCK;
        synchronized (object) {
            while (n2 > 0) {
                this.waitImpl();
                int n3 = Math.min(this.buffer.remaining(), n2);
                this.buffer.put(byArray, n, n3);
                n += n3;
                n2 -= n3;
                this.channel.interest(this.writeObserver, true);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void flush() throws IOException {
        Object object = this.LOCK;
        synchronized (object) {
            while (this.buffer.position() > 0) {
                if (this.shutdown) {
                    throw new IOException("socket closed");
                }
                try {
                    this.LOCK.wait();
                }
                catch (InterruptedException interruptedException) {
                    throw new InterruptedIOException(interruptedException);
                }
            }
        }
    }

    private void waitImpl() throws IOException {
        while (!this.buffer.hasRemaining()) {
            if (this.shutdown) {
                throw new IOException("socket closed");
            }
            try {
                this.LOCK.wait();
            }
            catch (InterruptedException interruptedException) {
                throw new InterruptedIOException(interruptedException);
            }
        }
        if (this.shutdown) {
            throw new IOException("socket closed");
        }
    }

    public void close() {
        this.handler.shutdown();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void shutdown() {
        Object object = this.LOCK;
        synchronized (object) {
            this.shutdown = true;
            this.LOCK.notify();
        }
    }
}

