/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.downloader;

import com.limegroup.gnutella.tigertree.HashTree;

public class ConnectionStatus {
    static final int TYPE_NO_FILE = 0;
    static final int TYPE_QUEUED = 1;
    static final int TYPE_CONNECTED = 2;
    static final int TYPE_NO_DATA = 3;
    static final int TYPE_PARTIAL_DATA = 4;
    static final int TYPE_THEX_RESPONSE = 5;
    private final int STATUS;
    private final int QUEUE_POSITION;
    private final int QUEUE_POLL_TIME;
    private final HashTree HASH_TREE;
    private static final ConnectionStatus NO_FILE = new ConnectionStatus(0);
    private static final ConnectionStatus CONNECTED = new ConnectionStatus(2);
    private static final ConnectionStatus NO_DATA = new ConnectionStatus(3);
    private static final ConnectionStatus PARTIAL_DATA = new ConnectionStatus(4);

    private ConnectionStatus(int n) {
        if (n == 1 || n == 5) {
            throw new IllegalArgumentException();
        }
        this.STATUS = n;
        this.QUEUE_POSITION = -1;
        this.QUEUE_POLL_TIME = -1;
        this.HASH_TREE = null;
    }

    private ConnectionStatus(int n, int n2, int n3) {
        if (n != 1) {
            throw new IllegalArgumentException();
        }
        this.STATUS = n;
        this.QUEUE_POSITION = n2;
        this.QUEUE_POLL_TIME = n3;
        this.HASH_TREE = null;
    }

    private ConnectionStatus(int n, HashTree hashTree) {
        if (n != 5) {
            throw new IllegalArgumentException();
        }
        if (hashTree == null) {
            throw new NullPointerException("null tree");
        }
        this.STATUS = n;
        this.HASH_TREE = hashTree;
        this.QUEUE_POSITION = -1;
        this.QUEUE_POLL_TIME = -1;
    }

    static ConnectionStatus getNoFile() {
        return NO_FILE;
    }

    static ConnectionStatus getConnected() {
        return CONNECTED;
    }

    static ConnectionStatus getNoData() {
        return NO_DATA;
    }

    static ConnectionStatus getPartialData() {
        return PARTIAL_DATA;
    }

    static ConnectionStatus getQueued(int n, int n2) {
        n2 *= 1000;
        return new ConnectionStatus(1, n, n2 += 1000);
    }

    static ConnectionStatus getThexResponse(HashTree hashTree) {
        return new ConnectionStatus(5, hashTree);
    }

    int getType() {
        return this.STATUS;
    }

    boolean isNoFile() {
        return this.STATUS == 0;
    }

    public boolean isConnected() {
        return this.STATUS == 2;
    }

    boolean isNoData() {
        return this.STATUS == 3;
    }

    boolean isPartialData() {
        return this.STATUS == 4;
    }

    boolean isQueued() {
        return this.STATUS == 1;
    }

    public boolean isThexResponse() {
        return this.STATUS == 5;
    }

    int getQueuePosition() {
        if (!this.isQueued()) {
            throw new IllegalStateException();
        }
        return this.QUEUE_POSITION;
    }

    int getQueuePollTime() {
        if (!this.isQueued()) {
            throw new IllegalStateException();
        }
        return this.QUEUE_POLL_TIME;
    }

    public HashTree getHashTree() {
        if (!this.isThexResponse()) {
            throw new IllegalStateException();
        }
        return this.HASH_TREE;
    }

    public String toString() {
        switch (this.STATUS) {
            case 0: {
                return "No File";
            }
            case 1: {
                return "Queued";
            }
            case 2: {
                return "Connected";
            }
            case 3: {
                return "No Data";
            }
            case 4: {
                return "Partial Data";
            }
            case 5: {
                return "Thex Response";
            }
        }
        return "Unknown: " + this.STATUS;
    }
}

