/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.dime;

import com.limegroup.gnutella.dime.DIMERecord;
import java.io.IOException;
import java.io.InputStream;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.NoSuchElementException;

public class DIMEParser
implements Iterator {
    private final InputStream IN;
    private boolean _lastRead = false;
    private boolean _firstRead = false;

    public DIMEParser(InputStream inputStream) {
        this.IN = inputStream;
    }

    public Object next() {
        try {
            return this.nextRecord();
        }
        catch (IOException iOException) {
            throw new NoSuchElementException(iOException.getMessage());
        }
    }

    public DIMERecord nextRecord() throws IOException {
        return this.getNext();
    }

    public List getRecords() throws IOException {
        if (this._lastRead) {
            return Collections.EMPTY_LIST;
        }
        LinkedList<DIMERecord> linkedList = new LinkedList<DIMERecord>();
        while (!this._lastRead) {
            linkedList.add(this.getNext());
        }
        return linkedList;
    }

    public boolean hasNext() {
        return !this._lastRead;
    }

    public void remove() {
        throw new UnsupportedOperationException();
    }

    private DIMERecord getNext() throws IOException {
        if (this._lastRead) {
            throw new IOException("already read last message.");
        }
        DIMERecord dIMERecord = DIMERecord.createFromStream(this.IN);
        if (dIMERecord.isLastRecord()) {
            this._lastRead = true;
        }
        if (!this._firstRead && !dIMERecord.isFirstRecord()) {
            throw new IOException("middle of stream.");
        }
        if (this._firstRead && dIMERecord.isFirstRecord()) {
            throw new IOException("two first records.");
        }
        this._firstRead = true;
        return dIMERecord;
    }
}

