/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.dime;

import com.limegroup.gnutella.ByteOrder;
import com.limegroup.gnutella.dime.DIMEException;
import com.limegroup.gnutella.dime.DIMERecord;
import com.limegroup.gnutella.io.BufferUtils;
import com.limegroup.gnutella.io.ReadState;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.ReadableByteChannel;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class AsyncDimeRecordReader
extends ReadState {
    private static final Log LOG;
    private ByteBuffer header = ByteBuffer.allocate(12);
    private static final int OPTIONS = 0;
    private static final int OPTIONS_P = 1;
    private static final int ID = 2;
    private static final int ID_P = 3;
    private static final int TYPE = 4;
    private static final int TYPE_P = 5;
    private static final int DATA = 6;
    private static final int DATA_P = 7;
    private static final int TOTAL = 8;
    private ByteBuffer[] parts;
    static /* synthetic */ Class class$0;

    static {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("com.limegroup.gnutella.dime.AsyncDimeRecordReader");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        LOG = LogFactory.getLog((Class)clazz);
    }

    public DIMERecord getRecord() throws DIMEException {
        if (this.parts == null || this.parts[6].hasRemaining() || this.parts[7].hasRemaining()) {
            return null;
        }
        try {
            return new DIMERecord(this.header.get(0), this.header.get(1), this.parts[0].array(), this.parts[2].array(), this.parts[4].array(), this.parts[6].array());
        }
        catch (IllegalArgumentException illegalArgumentException) {
            throw new DIMEException(illegalArgumentException);
        }
    }

    protected boolean processRead(ReadableByteChannel readableByteChannel, ByteBuffer byteBuffer) throws IOException {
        if (this.fill(this.header, readableByteChannel, byteBuffer)) {
            LOG.debug((Object)"Header not full, leaving.");
            return true;
        }
        if (this.parts == null) {
            this.createOtherStructures();
        }
        int n = 0;
        while (n < 8) {
            if ((n == 0 || !this.parts[n - 1].hasRemaining()) && this.fill(this.parts[n], readableByteChannel, byteBuffer)) {
                return true;
            }
            ++n;
        }
        return false;
    }

    private boolean fill(ByteBuffer byteBuffer, ReadableByteChannel readableByteChannel, ByteBuffer byteBuffer2) throws IOException {
        int n = BufferUtils.readAll(byteBuffer2, readableByteChannel, byteBuffer);
        LOG.debug((Object)("Filling current.  Left: " + byteBuffer.remaining()));
        if (byteBuffer.hasRemaining()) {
            if (n == -1) {
                throw new IOException("EOF");
            }
            return true;
        }
        return false;
    }

    private void createOtherStructures() throws DIMEException {
        try {
            DIMERecord.validateFirstBytes(this.header.get(0), this.header.get(1));
        }
        catch (IllegalArgumentException illegalArgumentException) {
            throw new DIMEException(illegalArgumentException);
        }
        byte[] byArray = this.header.array();
        int n = ByteOrder.beb2int(byArray, 2, 2);
        int n2 = ByteOrder.beb2int(byArray, 4, 2);
        int n3 = ByteOrder.beb2int(byArray, 6, 2);
        int n4 = ByteOrder.beb2int(byArray, 8, 4);
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("creating dime record.  optionsLength: " + n + ", idLength: " + n2 + ", typeLength: " + n3 + ", dataLength: " + n4));
        }
        if (n4 < 0) {
            throw new DIMEException("data too big.");
        }
        this.parts = new ByteBuffer[8];
        this.parts[0] = this.createBuffer(n);
        this.parts[1] = this.createBuffer(DIMERecord.calculatePaddingLength(n));
        this.parts[2] = this.createBuffer(n2);
        this.parts[3] = this.createBuffer(DIMERecord.calculatePaddingLength(n2));
        this.parts[4] = this.createBuffer(n3);
        this.parts[5] = this.createBuffer(DIMERecord.calculatePaddingLength(n3));
        this.parts[6] = this.createBuffer(n4);
        this.parts[7] = this.createBuffer(DIMERecord.calculatePaddingLength(n4));
    }

    private ByteBuffer createBuffer(int n) {
        if (n == 0) {
            return BufferUtils.getEmptyBuffer();
        }
        return ByteBuffer.allocate(n);
    }

    public long getAmountProcessed() {
        long l = this.header.position();
        if (this.parts != null) {
            int n = 0;
            while (n < 8) {
                l += (long)this.parts[n].position();
                ++n;
            }
        }
        return l;
    }
}

