/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.connection;

import com.limegroup.gnutella.connection.ConnectionStats;
import com.limegroup.gnutella.connection.MessageQueue;
import com.limegroup.gnutella.connection.OutputRunner;
import com.limegroup.gnutella.connection.SentMessageHandler;
import com.limegroup.gnutella.io.ChannelWriter;
import com.limegroup.gnutella.io.InterestWriteChannel;
import com.limegroup.gnutella.messages.Message;
import com.limegroup.gnutella.util.BufferByteArrayOutputStream;
import java.io.IOException;
import java.nio.ByteBuffer;

public class MessageWriter
implements ChannelWriter,
OutputRunner {
    private final MessageQueue queue;
    private final BufferByteArrayOutputStream out;
    private final ConnectionStats stats;
    private final SentMessageHandler sendHandler;
    private InterestWriteChannel channel;
    private boolean flipped = false;
    private boolean shutdown = false;

    public MessageWriter(ConnectionStats connectionStats, MessageQueue messageQueue, SentMessageHandler sentMessageHandler) {
        this(connectionStats, messageQueue, sentMessageHandler, null);
    }

    public MessageWriter(ConnectionStats connectionStats, MessageQueue messageQueue, SentMessageHandler sentMessageHandler, InterestWriteChannel interestWriteChannel) {
        this.stats = connectionStats;
        this.queue = messageQueue;
        this.sendHandler = sentMessageHandler;
        this.channel = interestWriteChannel;
        this.out = new BufferByteArrayOutputStream();
    }

    public synchronized InterestWriteChannel getWriteChannel() {
        return this.channel;
    }

    public synchronized void setWriteChannel(InterestWriteChannel interestWriteChannel) {
        this.channel = interestWriteChannel;
        interestWriteChannel.interest(this, true);
    }

    public synchronized void send(Message message) {
        if (this.shutdown) {
            return;
        }
        this.stats.addSent();
        this.queue.add(message);
        int n = this.queue.resetDropped();
        this.stats.addSentDropped(n);
        if (this.channel != null) {
            this.channel.interest(this, true);
        }
    }

    public synchronized boolean handleWrite() throws IOException {
        if (this.channel == null) {
            throw new IllegalStateException("writing with no source.");
        }
        if (this.writeRemaining()) {
            return true;
        }
        do {
            Message message = this.queue.removeNext();
            int n = this.queue.resetDropped();
            this.stats.addSentDropped(n);
            if (message == null) {
                this.channel.interest(this, false);
                return false;
            }
            message.writeQuickly(this.out);
            this.sendHandler.processSentMessage(message);
        } while (!this.writeRemaining());
        return true;
    }

    private boolean writeRemaining() throws IOException {
        if (this.shutdown) {
            throw new IOException("connection shut down.");
        }
        ByteBuffer byteBuffer = this.out.buffer();
        if (this.flipped || byteBuffer.position() > 0) {
            if (!this.flipped) {
                byteBuffer.flip();
                this.flipped = true;
            }
            this.channel.write(byteBuffer);
            if (byteBuffer.hasRemaining()) {
                return true;
            }
            this.flipped = false;
            byteBuffer.clear();
        }
        return false;
    }

    public synchronized void shutdown() {
        this.shutdown = true;
    }

    public void handleIOException(IOException iOException) {
        throw new RuntimeException("Unsupported", iOException);
    }
}

