/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.altlocs;

import com.limegroup.gnutella.Endpoint;
import com.limegroup.gnutella.ErrorService;
import com.limegroup.gnutella.PushEndpoint;
import com.limegroup.gnutella.RemoteFileDesc;
import com.limegroup.gnutella.RouterService;
import com.limegroup.gnutella.URN;
import com.limegroup.gnutella.altlocs.DirectAltLoc;
import com.limegroup.gnutella.altlocs.PushAltLoc;
import com.limegroup.gnutella.filters.IP;
import com.limegroup.gnutella.http.HTTPHeaderValue;
import com.limegroup.gnutella.settings.ConnectionSettings;
import com.limegroup.gnutella.settings.UploadSettings;
import com.limegroup.gnutella.util.IpPort;
import com.limegroup.gnutella.util.IpPortForSelf;
import com.limegroup.gnutella.util.NetworkUtils;
import java.io.IOException;
import java.net.URL;
import java.util.Collections;
import java.util.StringTokenizer;

public abstract class AlternateLocation
implements HTTPHeaderValue,
Comparable {
    public static final String ALT_VENDOR = "ALT";
    public static final int MESH_PING = 0;
    public static final int MESH_LEGACY = 1;
    public static final int MESH_RESPONSE = 2;
    protected final URN SHA1_URN;
    private String DISPLAY_STRING;
    protected volatile int hashCode = 0;
    protected volatile int _count = 0;
    private final Average legacy;
    private final Average ping;
    private final Average response;

    public static AlternateLocation create(String string) throws IOException {
        if (string == null || string.equals("")) {
            throw new IOException("null or empty location");
        }
        URL uRL = AlternateLocation.createUrl(string);
        URN uRN = URN.createSHA1UrnFromURL(uRL);
        return new DirectAltLoc(uRL, uRN);
    }

    public static AlternateLocation create(String string, URN uRN) throws IOException {
        if (string == null || string.equals("")) {
            throw new IOException("null or empty location");
        }
        if (uRN == null) {
            throw new IOException("null URN.");
        }
        if (string.toLowerCase().startsWith("http")) {
            URL uRL = AlternateLocation.createUrl(string);
            URN uRN2 = URN.createSHA1UrnFromURL(uRL);
            DirectAltLoc directAltLoc = new DirectAltLoc(uRL, uRN2);
            if (!directAltLoc.SHA1_URN.equals(uRN)) {
                throw new IOException("mismatched URN");
            }
            return directAltLoc;
        }
        if (string.indexOf(";") == -1) {
            IpPort ipPort = AlternateLocation.createUrlFromMini(string, uRN);
            return new DirectAltLoc(ipPort, uRN);
        }
        PushEndpoint pushEndpoint = new PushEndpoint(string);
        return new PushAltLoc(pushEndpoint, uRN);
    }

    public static AlternateLocation create(RemoteFileDesc remoteFileDesc) throws IOException {
        if (remoteFileDesc == null) {
            throw new NullPointerException("cannot accept null RFD");
        }
        URN uRN = remoteFileDesc.getSHA1Urn();
        if (uRN == null) {
            throw new NullPointerException("cannot accept null URN");
        }
        remoteFileDesc.getPort();
        if (!remoteFileDesc.needsPush()) {
            return new DirectAltLoc(new Endpoint(remoteFileDesc.getHost(), remoteFileDesc.getPort()), uRN);
        }
        PushEndpoint pushEndpoint = remoteFileDesc.getPushAddr() != null ? remoteFileDesc.getPushAddr() : new PushEndpoint(remoteFileDesc.getClientGUID(), Collections.EMPTY_SET, 0, 0, null);
        return new PushAltLoc(pushEndpoint, uRN);
    }

    public static AlternateLocation create(URN uRN) {
        if (uRN == null) {
            throw new NullPointerException("null sha1");
        }
        try {
            boolean bl = RouterService.isConnected() ? RouterService.acceptedIncomingConnection() : ConnectionSettings.EVER_ACCEPTED_INCOMING.getValue();
            if (bl && NetworkUtils.isValidExternalIpPort(IpPortForSelf.instance())) {
                return new DirectAltLoc(uRN);
            }
            return new PushAltLoc(uRN);
        }
        catch (IOException iOException) {
            ErrorService.error(iOException);
            return null;
        }
    }

    protected AlternateLocation(URN uRN) throws IOException {
        if (uRN == null) {
            throw new IOException("null sha1");
        }
        this.SHA1_URN = uRN;
        this.legacy = new Average();
        this.ping = new Average();
        this.response = new Average();
    }

    public URN getSHA1Urn() {
        return this.SHA1_URN;
    }

    public synchronized int getCount() {
        return this._count;
    }

    public abstract boolean isDemoted();

    public String httpStringValue() {
        if (this.DISPLAY_STRING == null) {
            this.DISPLAY_STRING = this.generateHTTPString();
        }
        return this.DISPLAY_STRING;
    }

    public abstract RemoteFileDesc createRemoteFileDesc(int var1);

    public abstract boolean isMe();

    public synchronized void increment() {
        ++this._count;
    }

    abstract void demote();

    abstract void promote();

    public abstract AlternateLocation createClone();

    public synchronized void send(long l, int n) {
        switch (n) {
            case 1: {
                this.legacy.send(l);
                return;
            }
            case 0: {
                this.ping.send(l);
                return;
            }
            case 2: {
                this.response.send(l);
                return;
            }
        }
        throw new IllegalArgumentException("unknown mesh type");
    }

    public synchronized boolean canBeSent(int n) {
        switch (n) {
            case 1: {
                if (!UploadSettings.EXPIRE_LEGACY.getValue()) {
                    return true;
                }
                return this.legacy.canBeSent(UploadSettings.LEGACY_BIAS.getValue(), UploadSettings.LEGACY_EXPIRATION_DAMPER.getValue());
            }
            case 0: {
                if (!UploadSettings.EXPIRE_PING.getValue()) {
                    return true;
                }
                return this.ping.canBeSent(UploadSettings.PING_BIAS.getValue(), UploadSettings.PING_EXPIRATION_DAMPER.getValue());
            }
            case 2: {
                if (!UploadSettings.EXPIRE_RESPONSE.getValue()) {
                    return true;
                }
                return this.response.canBeSent(UploadSettings.RESPONSE_BIAS.getValue(), UploadSettings.RESPONSE_EXPIRATION_DAMPER.getValue());
            }
        }
        throw new IllegalArgumentException("unknown mesh type");
    }

    public synchronized boolean canBeSentAny() {
        return this.canBeSent(1) || this.canBeSent(0) || this.canBeSent(2);
    }

    synchronized void resetSent() {
        this.ping.reset();
        this.legacy.reset();
        this.response.reset();
    }

    private static URL createUrl(String string) throws IOException {
        String string2 = string.toLowerCase();
        if (!string2.startsWith("http")) {
            throw new IOException("invalid location: " + string);
        }
        if (string2.lastIndexOf("http://") > 4) {
            throw new IOException("invalid location: " + string);
        }
        String string3 = AlternateLocation.removeTimestamp(string2);
        URL uRL = new URL(string3);
        String string4 = uRL.getHost();
        if (string4 == null || string4.equals("")) {
            throw new IOException("invalid location: " + string);
        }
        if (uRL.getPort() == -1) {
            uRL = new URL("http", uRL.getHost(), 80, uRL.getFile());
        }
        return uRL;
    }

    private static IpPort createUrlFromMini(String string, URN uRN) throws IOException {
        int n = string.indexOf(58);
        String string2 = n == -1 ? string : string.substring(0, n);
        try {
            new IP(string2);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            throw new IOException("invalid location: " + string);
        }
        if (string2.indexOf(47) != -1) {
            throw new IOException("invalid location: " + string);
        }
        if (!NetworkUtils.isValidAddress(string2)) {
            throw new IOException("invalid location: " + string);
        }
        if (n == -1) {
            n = 6346;
        } else {
            if (string.length() < n + 1) {
                throw new IOException("invalid location: " + string);
            }
            try {
                n = Short.parseShort(string.substring(n + 1));
            }
            catch (NumberFormatException numberFormatException) {
                throw new IOException("invalid location: " + string);
            }
        }
        if (!NetworkUtils.isValidPort(n)) {
            throw new IOException("invalid port: " + n);
        }
        return new Endpoint(string2, n);
    }

    private static String removeTimestamp(String string) {
        StringTokenizer stringTokenizer = new StringTokenizer(string);
        int n = stringTokenizer.countTokens();
        if (n == 1) {
            return string;
        }
        String string2 = null;
        int n2 = 0;
        while (n2 < n) {
            string2 = stringTokenizer.nextToken();
            ++n2;
        }
        n2 = string.indexOf(string2);
        if (n2 == -1) {
            return null;
        }
        return string.substring(0, n2);
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (!(object instanceof AlternateLocation)) {
            return false;
        }
        AlternateLocation alternateLocation = (AlternateLocation)object;
        return this.SHA1_URN.equals(alternateLocation.SHA1_URN);
    }

    public int compareTo(Object object) {
        AlternateLocation alternateLocation = (AlternateLocation)object;
        int n = this._count - alternateLocation._count;
        if (n != 0) {
            return n;
        }
        return n;
    }

    protected abstract String generateHTTPString();

    public int hashCode() {
        return 629 + this.SHA1_URN.hashCode();
    }

    private static class Average {
        private int numTimes;
        private double average;
        private long lastSentTime;
        private double cachedTreshold = -1.0;

        private Average() {
        }

        public void send(long l) {
            if (this.lastSentTime == 0L) {
                this.lastSentTime = l;
            }
            this.average = (this.average * (double)this.numTimes + (double)(l - this.lastSentTime)) / (double)(++this.numTimes);
            this.lastSentTime = l;
            this.cachedTreshold = -1.0;
        }

        public boolean canBeSent(float f, float f2) {
            if (this.numTimes < 2 || this.average == 0.0) {
                return true;
            }
            if (this.cachedTreshold == -1.0) {
                this.cachedTreshold = Math.abs(Math.log(this.average) / Math.log(f2));
            }
            return (double)this.numTimes < this.cachedTreshold * (double)f;
        }

        public void reset() {
            this.numTimes = 0;
            this.average = 0.0;
            this.lastSentTime = 0L;
        }
    }
}

