/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella;

import com.limegroup.gnutella.ErrorService;
import com.limegroup.gnutella.RouterService;
import com.limegroup.gnutella.settings.ApplicationSettings;
import com.limegroup.gnutella.settings.ConnectionSettings;
import com.limegroup.gnutella.util.NetworkUtils;
import com.limegroup.gnutella.util.ThreadFactory;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Random;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.cybergarage.upnp.Action;
import org.cybergarage.upnp.Argument;
import org.cybergarage.upnp.ControlPoint;
import org.cybergarage.upnp.Device;
import org.cybergarage.upnp.DeviceList;
import org.cybergarage.upnp.Service;
import org.cybergarage.upnp.device.DeviceChangeListener;

public class UPnPManager
extends ControlPoint
implements DeviceChangeListener {
    private static final Log LOG;
    private static final String ROUTER_DEVICE = "urn:schemas-upnp-org:device:InternetGatewayDevice:1";
    private static final String WAN_DEVICE = "urn:schemas-upnp-org:device:WANDevice:1";
    private static final String WANCON_DEVICE = "urn:schemas-upnp-org:device:WANConnectionDevice:1";
    private static final String SERVICE_TYPE = "urn:schemas-upnp-org:service:WANIPConnection:1";
    private static final String TCP_PREFIX = "LimeTCP";
    private static final String UDP_PREFIX = "LimeUDP";
    private String _guidSuffix;
    private static final int WAIT_TIME = 3000;
    private static final UPnPManager INSTANCE;
    private volatile Device _router;
    private volatile Service _service;
    private volatile Mapping _tcp;
    private volatile Mapping _udp;
    private final Object DEVICE_LOCK = new Object();
    static /* synthetic */ Class class$0;

    static {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("com.limegroup.gnutella.UPnPManager");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        LOG = LogFactory.getLog((Class)clazz);
        INSTANCE = new UPnPManager();
    }

    public static UPnPManager instance() {
        return INSTANCE;
    }

    private UPnPManager() {
        this.addDeviceChangeListener(this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean start() {
        LOG.debug((Object)"Starting UPnP Manager.");
        Object object = this.DEVICE_LOCK;
        synchronized (object) {
            try {
                return super.start();
            }
            catch (Exception exception) {
                ConnectionSettings.DISABLE_UPNP.setValue(true);
                ErrorService.error(exception);
                return false;
            }
        }
    }

    public boolean isNATPresent() {
        return this._router != null && this._service != null;
    }

    public boolean mappingsExist() {
        return this._tcp != null || this._udp != null;
    }

    public InetAddress getNATAddress() throws UnknownHostException {
        if (!this.isNATPresent()) {
            return null;
        }
        Action action = this._service.getAction("GetExternalIPAddress");
        if (action == null) {
            LOG.debug((Object)"Couldn't find GetExternalIPAddress action!");
            return null;
        }
        if (!action.postControlAction()) {
            LOG.debug((Object)"couldn't get our external address");
            return null;
        }
        Argument argument = action.getOutputArgumentList().getArgument("NewExternalIPAddress");
        return InetAddress.getByName(argument.getValue());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void waitForDevice() {
        if (this.isNATPresent()) {
            return;
        }
        Object object = this.DEVICE_LOCK;
        synchronized (object) {
            try {
                this.DEVICE_LOCK.wait(3000L);
            }
            catch (InterruptedException interruptedException) {}
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void deviceAdded(Device device) {
        if (this.isNATPresent()) {
            return;
        }
        Object object = this.DEVICE_LOCK;
        synchronized (object) {
            if (LOG.isTraceEnabled()) {
                LOG.trace((Object)("Device added: " + device.getFriendlyName()));
            }
            if (device.getDeviceType().equals(ROUTER_DEVICE) && device.isRootDevice()) {
                this._router = device;
            }
            if (this._router == null) {
                LOG.debug((Object)"didn't get router device");
                return;
            }
            this.discoverService();
            if (this._service == null) {
                LOG.debug((Object)"couldn't find service");
                this._router = null;
            } else {
                if (LOG.isDebugEnabled()) {
                    LOG.debug((Object)("Found service, router: " + this._router.getFriendlyName() + ", service: " + this._service));
                }
                this.DEVICE_LOCK.notify();
                this.stop();
            }
        }
    }

    private void discoverService() {
        Iterator iterator = this._router.getDeviceList().iterator();
        while (iterator.hasNext()) {
            Device device = (Device)iterator.next();
            if (!device.getDeviceType().equals(WAN_DEVICE)) continue;
            DeviceList deviceList = device.getDeviceList();
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("found " + device.getDeviceType() + ", size: " + deviceList.size() + ", on: " + device.getFriendlyName()));
            }
            int n = 0;
            while (n < device.getDeviceList().size()) {
                Device device2 = deviceList.getDevice(n);
                if (device2.getDeviceType().equals(WANCON_DEVICE)) {
                    if (LOG.isDebugEnabled()) {
                        LOG.debug((Object)("found " + device2.getDeviceType() + ", on: " + device2.getFriendlyName()));
                    }
                    this._service = device2.getService(SERVICE_TYPE);
                    return;
                }
                ++n;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int mapPort(int n) {
        if (LOG.isTraceEnabled()) {
            LOG.trace((Object)("Attempting to map port: " + n));
        }
        Random random = null;
        String string = NetworkUtils.ip2string(RouterService.getAcceptor().getAddress(false));
        int n2 = n;
        Mapping mapping = new Mapping("", n, string, n2, "UDP", UDP_PREFIX + this.getGUIDSuffix());
        int n3 = 20;
        while (!this.addMapping(mapping)) {
            if (n3 < 0) break;
            --n3;
            if (random == null) {
                random = new Random();
            }
            n = random.nextInt(50000) + 2000;
            mapping = new Mapping("", n, string, n2, "UDP", UDP_PREFIX + this.getGUIDSuffix());
        }
        if (n3 < 0) {
            LOG.debug((Object)"couldn't map a port :(");
            return 0;
        }
        Mapping mapping2 = new Mapping("", n, string, n2, "TCP", TCP_PREFIX + this.getGUIDSuffix());
        if (!this.addMapping(mapping2)) {
            LOG.debug((Object)" couldn't map tcp to whatever udp was mapped. leaving udp around...");
            mapping2 = null;
        }
        Object object = this.DEVICE_LOCK;
        synchronized (object) {
            this._tcp = mapping2;
            this._udp = mapping;
        }
        ThreadFactory.startThread(new StaleCleaner(), "Stale Mapping Cleaner");
        return n;
    }

    private boolean addMapping(Mapping mapping) {
        Action action;
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("adding " + mapping));
        }
        if ((action = this._service.getAction("AddPortMapping")) == null) {
            LOG.debug((Object)"Couldn't find AddPortMapping action!");
            return false;
        }
        action.setArgumentValue("NewRemoteHost", mapping._externalAddress);
        action.setArgumentValue("NewExternalPort", mapping._externalPort);
        action.setArgumentValue("NewInternalClient", mapping._internalAddress);
        action.setArgumentValue("NewInternalPort", mapping._internalPort);
        action.setArgumentValue("NewProtocol", mapping._protocol);
        action.setArgumentValue("NewPortMappingDescription", mapping._description);
        action.setArgumentValue("NewEnabled", "1");
        action.setArgumentValue("NewLeaseDuration", 0);
        boolean bl = action.postControlAction();
        if (LOG.isTraceEnabled()) {
            LOG.trace((Object)("Post succeeded: " + bl));
        }
        return bl;
    }

    private boolean removeMapping(Mapping mapping) {
        Action action;
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("removing " + mapping));
        }
        if ((action = this._service.getAction("DeletePortMapping")) == null) {
            LOG.debug((Object)"Couldn't find DeletePortMapping action!");
            return false;
        }
        action.setArgumentValue("NewRemoteHost", mapping._externalAddress);
        action.setArgumentValue("NewExternalPort", mapping._externalPort);
        action.setArgumentValue("NewProtocol", mapping._protocol);
        boolean bl = action.postControlAction();
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("Remove succeeded: " + bl));
        }
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clearMappingsOnShutdown() {
        Mapping mapping;
        Mapping mapping2;
        Object object = this.DEVICE_LOCK;
        synchronized (object) {
            mapping2 = this._tcp;
            mapping = this._udp;
        }
        object = new Thread("UPnP Waiter"){

            public void run() {
                Thread thread = new Thread(this, "UPnP Cleaner", mapping2, mapping){
                    final /* synthetic */ 1 this$1;
                    private final /* synthetic */ Mapping val$tcp;
                    private final /* synthetic */ Mapping val$udp;
                    {
                        this.this$1 = var1_1;
                        this.val$tcp = mapping;
                        this.val$udp = mapping2;
                    }

                    public void run() {
                        UPnPManager.access$0().debug((Object)"start cleaning");
                        if (this.val$tcp != null) {
                            UPnPManager.access$5(1.access$0(this.this$1), this.val$tcp);
                        }
                        if (this.val$udp != null) {
                            UPnPManager.access$5(1.access$0(this.this$1), this.val$udp);
                        }
                        UPnPManager.access$0().debug((Object)"done cleaning");
                    }
                };
                thread.setDaemon(true);
                thread.start();
                Thread.yield();
                try {
                    LOG.debug((Object)"waiting for UPnP cleaners to finish");
                    thread.join(30000L);
                }
                catch (InterruptedException interruptedException) {}
                LOG.debug((Object)"UPnP cleaners done");
            }

            static /* synthetic */ UPnPManager access$0(1 var0) {
                return var0.UPnPManager.this;
            }
        };
        RouterService.addShutdownItem((Thread)object);
    }

    public void finalize() {
        this.stop();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String getGUIDSuffix() {
        Object object = this.DEVICE_LOCK;
        synchronized (object) {
            if (this._guidSuffix == null) {
                this._guidSuffix = ApplicationSettings.CLIENT_ID.getValue().substring(0, 10);
            }
            return this._guidSuffix;
        }
    }

    public void deviceRemoved(Device device) {
    }

    private final class Mapping {
        public final String _externalAddress;
        public final int _externalPort;
        public final String _internalAddress;
        public final int _internalPort;
        public final String _protocol;
        public final String _description;

        public Mapping(String string, String string2, String string3, String string4, String string5, String string6) throws NumberFormatException {
            this._externalAddress = string;
            this._externalPort = Integer.parseInt(string2);
            this._internalAddress = string3;
            this._internalPort = Integer.parseInt(string4);
            this._protocol = string5;
            this._description = string6;
        }

        public Mapping(String string, int n, String string2, int n2, String string3, String string4) {
            if (!NetworkUtils.isValidPort(n) || !NetworkUtils.isValidPort(n2)) {
                throw new IllegalArgumentException();
            }
            this._externalAddress = string;
            this._externalPort = n;
            this._internalAddress = string2;
            this._internalPort = n2;
            this._protocol = string3;
            this._description = string4;
        }

        public String toString() {
            return String.valueOf(this._externalAddress) + ":" + this._externalPort + "->" + this._internalAddress + ":" + this._internalPort + "@" + this._protocol + " desc: " + this._description;
        }
    }

    private class StaleCleaner
    implements Runnable {
        private StaleCleaner() {
        }

        private String list(List list) {
            String string = "";
            Iterator iterator = list.iterator();
            while (iterator.hasNext()) {
                Argument argument = (Argument)iterator.next();
                string = String.valueOf(string) + argument.getName() + "->" + argument.getValue() + ", ";
            }
            return string;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            LOG.debug((Object)"Looking for stale mappings...");
            HashSet<Mapping> hashSet = new HashSet<Mapping>();
            Action action = UPnPManager.this._service.getAction("GetGenericPortMappingEntry");
            if (action == null) {
                LOG.debug((Object)"Couldn't find GetGenericPortMappingEntry action!");
                return;
            }
            try {
                int n = 0;
                while (true) {
                    action.setArgumentValue("NewPortMappingIndex", n);
                    if (LOG.isDebugEnabled()) {
                        LOG.debug((Object)("Stale Iteration: " + n + ", generic.input: " + this.list((List)action.getInputArgumentList()) + ", generic.output: " + this.list((List)action.getOutputArgumentList())));
                    }
                    if (action.postControlAction()) {
                        hashSet.add(new Mapping(action.getArgumentValue("NewRemoteHost"), action.getArgumentValue("NewExternalPort"), action.getArgumentValue("NewInternalClient"), action.getArgumentValue("NewInternalPort"), action.getArgumentValue("NewProtocol"), action.getArgumentValue("NewPortMappingDescription")));
                        ++n;
                        continue;
                    }
                    break;
                }
            }
            catch (NumberFormatException numberFormatException) {
                LOG.error((Object)"NFE reading mappings!", (Throwable)numberFormatException);
                return;
            }
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("Stale cleaner found " + hashSet.size() + " total mappings"));
            }
            Iterator iterator = hashSet.iterator();
            while (iterator.hasNext()) {
                Mapping mapping = (Mapping)iterator.next();
                if (LOG.isDebugEnabled()) {
                    LOG.debug((Object)("Analyzing: " + mapping));
                }
                if (mapping._description == null || !mapping._description.equals(UPnPManager.TCP_PREFIX + UPnPManager.this.getGUIDSuffix()) && !mapping._description.equals(UPnPManager.UDP_PREFIX + UPnPManager.this.getGUIDSuffix())) continue;
                Object object = UPnPManager.this.DEVICE_LOCK;
                synchronized (object) {
                    if (UPnPManager.this._udp != null && mapping._externalPort == ((UPnPManager)UPnPManager.this)._udp._externalPort && mapping._internalAddress.equals(((UPnPManager)UPnPManager.this)._udp._internalAddress) && mapping._internalPort == ((UPnPManager)UPnPManager.this)._udp._internalPort) {
                        continue;
                    }
                }
                if (LOG.isDebugEnabled()) {
                    LOG.debug((Object)("mapping " + mapping + " appears to be stale"));
                }
                UPnPManager.this.removeMapping(mapping);
            }
        }
    }
}

