/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella;

import com.limegroup.gnutella.ReplyHandler;
import com.limegroup.gnutella.UDPService;
import com.limegroup.gnutella.filters.SpamFilter;
import com.limegroup.gnutella.messages.Message;
import com.limegroup.gnutella.messages.PingReply;
import com.limegroup.gnutella.messages.PushRequest;
import com.limegroup.gnutella.messages.QueryReply;
import com.limegroup.gnutella.messages.vendor.StatisticVendorMessage;
import com.limegroup.gnutella.messages.vendor.UDPCrawlerPong;
import com.limegroup.gnutella.settings.ApplicationSettings;
import com.limegroup.gnutella.statistics.SentMessageStatHandler;
import com.limegroup.gnutella.util.DataUtils;
import com.limegroup.gnutella.util.NetworkUtils;
import java.io.IOException;
import java.net.InetAddress;

public final class UDPReplyHandler
implements ReplyHandler {
    private final InetAddress IP;
    private final int PORT;
    private static final UDPService UDP_SERVICE = UDPService.instance();
    private static volatile SpamFilter _personalFilter = SpamFilter.newPersonalFilter();

    public UDPReplyHandler(InetAddress inetAddress, int n) {
        if (!NetworkUtils.isValidPort(n)) {
            throw new IllegalArgumentException("invalid port: " + n);
        }
        if (!NetworkUtils.isValidAddress(inetAddress)) {
            throw new IllegalArgumentException("invalid ip: " + inetAddress);
        }
        this.IP = inetAddress;
        this.PORT = n;
    }

    public static void setPersonalFilter(SpamFilter spamFilter) {
        _personalFilter = spamFilter;
    }

    public void handlePingReply(PingReply pingReply, ReplyHandler replyHandler) {
        UDP_SERVICE.send(pingReply, this.IP, this.PORT);
        SentMessageStatHandler.UDP_PING_REPLIES.addMessage(pingReply);
    }

    public void handleQueryReply(QueryReply queryReply, ReplyHandler replyHandler) {
        UDP_SERVICE.send(queryReply, this.IP, this.PORT);
        SentMessageStatHandler.UDP_QUERY_REPLIES.addMessage(queryReply);
    }

    public void handlePushRequest(PushRequest pushRequest, ReplyHandler replyHandler) {
        UDP_SERVICE.send(pushRequest, this.IP, this.PORT);
        SentMessageStatHandler.UDP_PUSH_REQUESTS.addMessage(pushRequest);
    }

    public void countDroppedMessage() {
    }

    public boolean isPersonalSpam(Message message) {
        return !_personalFilter.allow(message);
    }

    public boolean isOpen() {
        return true;
    }

    public int getNumMessagesReceived() {
        return 0;
    }

    public boolean isOutgoing() {
        return false;
    }

    public boolean isKillable() {
        return false;
    }

    public boolean isSupernodeClientConnection() {
        return false;
    }

    public boolean isLeafConnection() {
        return false;
    }

    public boolean isHighDegreeConnection() {
        return false;
    }

    public boolean isUltrapeerQueryRoutingConnection() {
        return false;
    }

    public boolean isGoodUltrapeer() {
        return false;
    }

    public boolean isGoodLeaf() {
        return false;
    }

    public boolean supportsPongCaching() {
        return false;
    }

    public boolean allowNewPings() {
        return true;
    }

    public void handleStatisticVM(StatisticVendorMessage statisticVendorMessage) throws IOException {
        UDPService.instance().send(statisticVendorMessage, this.IP, this.PORT);
    }

    public InetAddress getInetAddress() {
        return this.IP;
    }

    public String getAddress() {
        return this.IP.getHostAddress();
    }

    public boolean isStable() {
        return false;
    }

    public String getLocalePref() {
        return ApplicationSettings.DEFAULT_LOCALE.getValue();
    }

    public String toString() {
        return String.valueOf(this.IP.toString()) + ":" + this.PORT;
    }

    public void handleUDPCrawlerPong(UDPCrawlerPong uDPCrawlerPong) {
        UDPService.instance().send(uDPCrawlerPong, this.IP, this.PORT);
    }

    public void reply(Message message) {
        UDPService.instance().send(message, this.IP, this.PORT);
    }

    public int getPort() {
        return this.PORT;
    }

    public byte[] getClientGUID() {
        return DataUtils.EMPTY_GUID;
    }
}

