/*
 * Decompiled with CFR 0.152.
 */
package org.logi.crypto.protocols;

import java.math.BigInteger;
import org.logi.crypto.Crypto;
import org.logi.crypto.keys.CipherKey;
import org.logi.crypto.keys.DHKey;
import org.logi.crypto.keys.Key;

class DHEKEKeyEx
extends Crypto {
    int modSize;
    String keyType;
    protected BigInteger m;
    protected BigInteger g;
    protected BigInteger myPrivate;
    protected BigInteger myPublic;
    protected byte[] myRandom;
    protected CipherKey secretKey;
    protected boolean completed = false;
    protected CipherKey sessionKey;
    protected int pbs;
    protected int cbs;

    public Key sessionKey() {
        return this.completed ? this.sessionKey : null;
    }

    public boolean completed() {
        return this.completed;
    }

    public int maxMessageSize() {
        return 65536;
    }

    public DHEKEKeyEx(int n, String string, CipherKey cipherKey) {
        this.m = DHKey.getModulus(n);
        this.g = DHKey.getGenerator(this.m);
        this.modSize = this.m.bitLength();
        do {
            this.myPrivate = new BigInteger(this.modSize, random);
        } while (this.myPrivate.compareTo(this.m) > 0);
        this.myPublic = this.g.modPow(this.myPrivate, this.m);
        this.keyType = string;
        this.secretKey = cipherKey;
    }
}

