/*
 * Decompiled with CFR 0.152.
 */
package org.logi.crypto.modes;

import org.logi.crypto.keys.CipherKey;
import org.logi.crypto.modes.EncryptMode;

public class EncryptCBC
extends EncryptMode {
    private CipherKey key;
    private byte[] buffer;
    private int bufPos;
    private int ibs;
    private int obs;
    private byte[] last;

    public CipherKey getKey() {
        return this.key;
    }

    public int plainBlockSize() {
        return this.key.plainBlockSize();
    }

    public void setKey(CipherKey cipherKey) {
        this.key = cipherKey;
        this.ibs = cipherKey.plainBlockSize();
        this.obs = cipherKey.cipherBlockSize();
        this.buffer = new byte[cipherKey.plainBlockSize()];
    }

    public synchronized byte[] flush() {
        if (this.bufPos == 0) {
            return EMPTY_ARRAY;
        }
        byte[] byArray = new byte[this.buffer.length - this.bufPos];
        random.nextBytes(byArray);
        byte[] byArray2 = this.encrypt(byArray, 0, byArray.length);
        return byArray2;
    }

    public synchronized byte[] encrypt(byte[] byArray, int n, int n2) {
        int n3;
        int n4;
        byte[] byArray2;
        int n5 = (this.bufPos + n2) / this.ibs;
        int n6 = 0;
        if (this.last == null) {
            byArray2 = new byte[n5 * this.obs + this.ibs];
            n4 = 0;
            while (n4 < this.ibs) {
                byArray2[n4] = (byte)random.nextInt();
                ++n4;
            }
            this.last = new byte[this.ibs];
            System.arraycopy(byArray2, 0, this.last, 0, this.ibs);
            n6 = this.ibs;
        } else {
            byArray2 = new byte[n5 * this.obs];
        }
        if (this.bufPos > 0) {
            n4 = Math.min(n2, this.buffer.length - this.bufPos);
            System.arraycopy(byArray, n, this.buffer, this.bufPos, n4);
            this.bufPos += n4;
            n += n4;
            n2 -= n4;
            --n5;
            if (this.bufPos == this.buffer.length) {
                n3 = 0;
                while (n3 < this.ibs) {
                    int n7 = n3;
                    this.buffer[n7] = (byte)(this.buffer[n7] ^ this.last[n3]);
                    ++n3;
                }
                this.key.encrypt(this.buffer, 0, byArray2, 0);
                System.arraycopy(byArray2, 0, this.last, 0, this.ibs);
                n6 += this.obs;
                this.bufPos = 0;
            } else {
                return byArray2;
            }
        }
        n4 = n;
        if (n5 > 0) {
            n3 = 0;
            while (n3 < this.ibs) {
                this.buffer[n3] = (byte)(byArray[n + n3] ^ this.last[n3]);
                ++n3;
            }
            this.key.encrypt(this.buffer, 0, byArray2, n6);
            n += this.ibs;
            n6 += this.obs;
            n3 = 1;
            while (n3 < n5) {
                int n8 = 0;
                while (n8 < this.ibs) {
                    this.buffer[n8] = (byte)(byArray[n + n8] ^ byArray2[n6 + n8 - this.obs]);
                    ++n8;
                }
                this.key.encrypt(this.buffer, 0, byArray2, n6);
                n += this.ibs;
                n6 += this.obs;
                ++n3;
            }
            System.arraycopy(byArray2, n6 - this.obs, this.last, 0, this.ibs);
        }
        this.bufPos = n2 - (n - n4);
        if (this.bufPos != 0) {
            System.arraycopy(byArray, n, this.buffer, 0, this.bufPos);
        }
        return byArray2;
    }

    public EncryptCBC(CipherKey cipherKey) {
        this.setKey(cipherKey);
    }

    public EncryptCBC() {
    }
}

