/*
 * Decompiled with CFR 0.152.
 */
package org.logi.crypto.hash;

import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import org.logi.crypto.CryptoCorruptError;
import org.logi.crypto.hash.Fingerprint;
import org.logi.crypto.hash.HashState;

public class SHA1State
extends HashState {
    MessageDigest md;

    public String getName() {
        return "SHA1";
    }

    public void reset() {
        this.md.reset();
    }

    public void update(byte[] byArray, int n, int n2) {
        this.md.update(byArray, n, n2);
    }

    public Fingerprint calculate() {
        try {
            byte[] byArray = ((MessageDigest)this.md.clone()).digest();
            return new Fingerprint("SHA1", byArray, 0, byArray.length);
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            throw new CryptoCorruptError("SHA1 algortihm is not cloneable java class library.");
        }
    }

    public int blockSize() {
        return 8;
    }

    public int hashSize() {
        return 20;
    }

    public SHA1State() {
        try {
            this.md = MessageDigest.getInstance("SHA");
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            throw new CryptoCorruptError("SHA1 algortihm is missing from the java class library.");
        }
    }
}

