/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.util;

import com.limegroup.gnutella.util.CommonUtils;
import java.awt.Component;
import java.io.File;

public class SystemUtils {
    private static boolean isLoaded;

    static {
        boolean bl;
        try {
            if (CommonUtils.isMacOSX()) {
                System.loadLibrary("SystemUtilities");
            } else if (CommonUtils.isWindows()) {
                System.loadLibrary("GenericWindowsUtils");
                if (CommonUtils.isWindows2000orXP()) {
                    System.loadLibrary("WindowsV5PlusUtils");
                }
                System.loadLibrary("WindowsFirewall");
            }
            bl = true;
        }
        catch (UnsatisfiedLinkError unsatisfiedLinkError) {
            bl = false;
        }
        isLoaded = bl;
    }

    private SystemUtils() {
    }

    public static long getIdleTime() {
        if (SystemUtils.supportsIdleTime()) {
            return SystemUtils.idleTime();
        }
        return 0L;
    }

    public static boolean supportsIdleTime() {
        if (isLoaded) {
            if (CommonUtils.isWindows2000orXP()) {
                return true;
            }
            if (CommonUtils.isMacOSX()) {
                return true;
            }
        }
        return false;
    }

    public static long setOpenFileLimit(int n) {
        if (isLoaded && CommonUtils.isMacOSX()) {
            return SystemUtils.setOpenFileLimit0(n);
        }
        return -1L;
    }

    static void setWriteable(String string) {
        if (isLoaded && (CommonUtils.isWindows() || CommonUtils.isMacOSX())) {
            SystemUtils.setFileWriteable(string);
        }
    }

    private static final native long idleTime();

    private static final native int setFileWriteable(String var0);

    private static final native int setOpenFileLimit0(int var0);

    public static final String getRunningPath() {
        if (CommonUtils.isWindows() && isLoaded) {
            return SystemUtils.getRunningPathNative();
        }
        return "";
    }

    public static final boolean setWindowIcon(Component component, File file) {
        if (CommonUtils.isWindows() && isLoaded) {
            String string = SystemUtils.setWindowIconNative(component, System.getProperty("sun.boot.library.path"), file.getPath());
            return string.equals("");
        }
        return false;
    }

    public static final boolean isFirewallPresent() {
        if (CommonUtils.isWindows() && isLoaded) {
            return SystemUtils.firewallPresentNative();
        }
        return false;
    }

    public static final boolean isFirewallEnabled() {
        if (CommonUtils.isWindows() && isLoaded) {
            return SystemUtils.firewallEnabledNative();
        }
        return false;
    }

    public static final boolean isFirewallExceptionsNotAllowed() {
        if (CommonUtils.isWindows() && isLoaded) {
            return SystemUtils.firewallExceptionsNotAllowedNative();
        }
        return false;
    }

    public static final boolean isProgramListedOnFirewall(String string) {
        if (CommonUtils.isWindows() && isLoaded) {
            return SystemUtils.firewallIsProgramListedNative(string);
        }
        return false;
    }

    public static final boolean isProgramEnabledOnFirewall(String string) {
        if (CommonUtils.isWindows() && isLoaded) {
            return SystemUtils.firewallIsProgramEnabledNative(string);
        }
        return false;
    }

    public static final boolean addProgramToFirewall(String string, String string2) {
        if (CommonUtils.isWindows() && isLoaded) {
            return SystemUtils.firewallAddNative(string, string2);
        }
        return false;
    }

    public static final boolean removeProgramFromFirewall(String string) {
        if (CommonUtils.isWindows() && isLoaded) {
            return SystemUtils.firewallRemoveNative(string);
        }
        return false;
    }

    private static final native String getRunningPathNative();

    private static final native String setWindowIconNative(Component var0, String var1, String var2);

    private static final native boolean firewallPresentNative();

    private static final native boolean firewallEnabledNative();

    private static final native boolean firewallExceptionsNotAllowedNative();

    private static final native boolean firewallIsProgramListedNative(String var0);

    private static final native boolean firewallIsProgramEnabledNative(String var0);

    private static final native boolean firewallAddNative(String var0, String var1);

    private static final native boolean firewallRemoveNative(String var0);
}

