/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.util;

import com.limegroup.gnutella.io.ConnectObserver;
import com.limegroup.gnutella.util.CommonUtils;
import com.limegroup.gnutella.util.IpPort;
import com.limegroup.gnutella.util.LimitedSocketController;
import com.limegroup.gnutella.util.NetworkUtils;
import com.limegroup.gnutella.util.SimpleSocketController;
import com.limegroup.gnutella.util.SocketController;
import java.io.IOException;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.Socket;

public class Sockets {
    private static final SocketController CONTROLLER = CommonUtils.isWindowsXP() ? new LimitedSocketController(4) : new SimpleSocketController();

    private Sockets() {
    }

    public static Socket connect(String string, int n, int n2) throws IOException {
        return Sockets.connect(string, n, n2, null);
    }

    public static Socket connect(String string, int n, int n2, ConnectObserver connectObserver) throws IOException {
        InetAddress inetAddress = InetAddress.getByName(string);
        InetSocketAddress inetSocketAddress = new InetSocketAddress(inetAddress, n);
        return Sockets.connect(inetSocketAddress, n2, connectObserver);
    }

    public static Socket connect(IpPort ipPort, int n, ConnectObserver connectObserver) throws IOException {
        InetSocketAddress inetSocketAddress = new InetSocketAddress(ipPort.getInetAddress(), ipPort.getPort());
        return Sockets.connect(inetSocketAddress, n, connectObserver);
    }

    public static Socket connect(InetSocketAddress inetSocketAddress, int n, ConnectObserver connectObserver) throws IOException {
        if (!NetworkUtils.isValidPort(inetSocketAddress.getPort())) {
            throw new IllegalArgumentException("port out of range: " + inetSocketAddress.getPort());
        }
        return CONTROLLER.connect(inetSocketAddress, n, connectObserver);
    }

    public static boolean removeConnectObserver(ConnectObserver connectObserver) {
        return CONTROLLER.removeConnectObserver(connectObserver);
    }

    public static int getNumAllowedSockets() {
        return CONTROLLER.getNumAllowedSockets();
    }
}

