/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.udpconnect;

import com.limegroup.gnutella.udpconnect.SynMessage;
import com.limegroup.gnutella.udpconnect.UDPConnectionMessage;
import com.limegroup.gnutella.udpconnect.UDPSelectionKey;
import com.limegroup.gnutella.udpconnect.UDPSocketChannel;
import java.io.IOException;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.nio.channels.IllegalSelectorException;
import java.nio.channels.SelectableChannel;
import java.nio.channels.SelectionKey;
import java.nio.channels.Selector;
import java.nio.channels.spi.AbstractSelectableChannel;
import java.nio.channels.spi.AbstractSelector;
import java.nio.channels.spi.SelectorProvider;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class UDPMultiplexor
extends AbstractSelector {
    private static final Log LOG;
    public static final byte UNASSIGNED_SLOT = 0;
    private volatile UDPSocketChannel[] _channels;
    private final List channelsToRemove = new LinkedList();
    private Set selectedKeys = new HashSet(256);
    private int _lastConnectionID = 0;
    static /* synthetic */ Class class$0;

    static {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("com.limegroup.gnutella.udpconnect.UDPMultiplexor");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        LOG = LogFactory.getLog((Class)clazz);
    }

    UDPMultiplexor(SelectorProvider selectorProvider) {
        super(selectorProvider);
        this._channels = new UDPSocketChannel[256];
    }

    public boolean isConnectedTo(InetAddress inetAddress) {
        UDPSocketChannel[] uDPSocketChannelArray = this._channels;
        if (this._lastConnectionID == 0) {
            return false;
        }
        int n = 0;
        while (n < uDPSocketChannelArray.length) {
            UDPSocketChannel uDPSocketChannel = uDPSocketChannelArray[n];
            if (uDPSocketChannel != null && inetAddress.equals(uDPSocketChannel.getRemoteSocketAddress().getAddress())) {
                return true;
            }
            ++n;
        }
        return false;
    }

    public void routeMessage(UDPConnectionMessage uDPConnectionMessage, InetSocketAddress inetSocketAddress) {
        UDPSocketChannel uDPSocketChannel;
        UDPSocketChannel[] uDPSocketChannelArray = this._channels;
        int n = uDPConnectionMessage.getConnectionID() & 0xFF;
        if (n == 0 && uDPConnectionMessage instanceof SynMessage) {
            int n2 = 1;
            while (n2 < uDPSocketChannelArray.length) {
                UDPSocketChannel uDPSocketChannel2 = uDPSocketChannelArray[n2];
                if (uDPSocketChannel2 != null && uDPSocketChannel2.isConnectionPending() && uDPSocketChannel2.getRemoteSocketAddress().equals(inetSocketAddress)) {
                    uDPSocketChannel2.getProcessor().handleMessage(uDPConnectionMessage);
                    break;
                }
                ++n2;
            }
        } else if (uDPSocketChannelArray[n] != null && (uDPSocketChannel = uDPSocketChannelArray[n]).getRemoteSocketAddress().equals(inetSocketAddress)) {
            uDPSocketChannel.getProcessor().handleMessage(uDPConnectionMessage);
        }
    }

    protected void implCloseSelector() throws IOException {
        throw new IllegalStateException("should never be closed.");
    }

    protected synchronized SelectionKey register(AbstractSelectableChannel abstractSelectableChannel, int n, Object object) {
        if (!(abstractSelectableChannel instanceof UDPSocketChannel)) {
            throw new IllegalSelectorException();
        }
        UDPSocketChannel uDPSocketChannel = (UDPSocketChannel)abstractSelectableChannel;
        UDPSocketChannel[] uDPSocketChannelArray = new UDPSocketChannel[this._channels.length];
        int n2 = 0;
        while (n2 < this._channels.length) {
            uDPSocketChannelArray[n2] = this._channels[n2];
            ++n2;
        }
        n2 = 1;
        while (n2 <= uDPSocketChannelArray.length) {
            int n3 = (this._lastConnectionID + n2) % 256;
            if (n3 != 0 && uDPSocketChannelArray[n3] == null) {
                this._lastConnectionID = n3;
                uDPSocketChannelArray[n3] = uDPSocketChannel;
                uDPSocketChannel.getProcessor().setConnectionId((byte)n3);
                this._channels = uDPSocketChannelArray;
                return new UDPSelectionKey(this, object, abstractSelectableChannel, n);
            }
            ++n2;
        }
        LOG.warn((Object)"Attempting to add over connection limit");
        this.channelsToRemove.add(abstractSelectableChannel);
        return new UDPSelectionKey(this, object, abstractSelectableChannel, n);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Set keys() {
        UDPSocketChannel[] uDPSocketChannelArray = this._channels;
        HashSet<SelectionKey> hashSet = new HashSet<SelectionKey>();
        int n = 0;
        while (n < uDPSocketChannelArray.length) {
            if (uDPSocketChannelArray[n] != null) {
                hashSet.add(uDPSocketChannelArray[n].keyFor(this));
            }
            ++n;
        }
        UDPMultiplexor uDPMultiplexor = this;
        synchronized (uDPMultiplexor) {
            Iterator iterator = this.channelsToRemove.iterator();
            while (iterator.hasNext()) {
                hashSet.add(((SelectableChannel)iterator.next()).keyFor(this));
            }
        }
        return hashSet;
    }

    public int select() throws IOException {
        throw new UnsupportedOperationException("blocking select not supported");
    }

    public int select(long l) throws IOException {
        throw new UnsupportedOperationException("blocking select not supported");
    }

    public Set selectedKeys() {
        return this.selectedKeys;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int selectNow() throws IOException {
        Object object;
        UDPSocketChannel[] uDPSocketChannelArray = this._channels;
        UDPSocketChannel[] uDPSocketChannelArray2 = null;
        this.selectedKeys.clear();
        int n = 0;
        while (n < uDPSocketChannelArray.length) {
            UDPSelectionKey uDPSelectionKey;
            object = uDPSocketChannelArray[n];
            if (object != null && (uDPSelectionKey = (UDPSelectionKey)((AbstractSelectableChannel)object).keyFor(this)) != null) {
                if (uDPSelectionKey.isValid()) {
                    int n2 = ((UDPSocketChannel)object).getProcessor().readyOps();
                    int n3 = n2 & uDPSelectionKey.interestOps();
                    if (n3 != 0) {
                        uDPSelectionKey.setReadyOps(n3);
                        this.selectedKeys.add(uDPSelectionKey);
                    }
                } else {
                    if (uDPSocketChannelArray2 == null) {
                        uDPSocketChannelArray2 = new UDPSocketChannel[uDPSocketChannelArray.length];
                    }
                    uDPSocketChannelArray2[n] = object;
                }
            }
            ++n;
        }
        UDPMultiplexor uDPMultiplexor = this;
        synchronized (uDPMultiplexor) {
            if (uDPSocketChannelArray2 != null) {
                object = new UDPSocketChannel[this._channels.length];
                int n4 = 0;
                while (n4 < this._channels.length) {
                    object[n4] = this._channels[n4] == uDPSocketChannelArray2[n4] ? null : this._channels[n4];
                    ++n4;
                }
                this._channels = object;
            }
            if (!this.channelsToRemove.isEmpty()) {
                object = this.channelsToRemove.iterator();
                while (object.hasNext()) {
                    SelectableChannel selectableChannel = (SelectableChannel)object.next();
                    UDPSelectionKey uDPSelectionKey = (UDPSelectionKey)selectableChannel.keyFor(this);
                    uDPSelectionKey.cancel();
                    uDPSelectionKey.setReadyOps(0);
                    this.selectedKeys.add(uDPSelectionKey);
                }
                this.channelsToRemove.clear();
            }
        }
        return this.selectedKeys.size();
    }

    public Selector wakeup() {
        return this;
    }
}

