/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.messages;

import com.limegroup.gnutella.Assert;
import com.limegroup.gnutella.ByteOrder;
import com.limegroup.gnutella.ErrorService;
import com.limegroup.gnutella.GUID;
import com.limegroup.gnutella.Response;
import com.limegroup.gnutella.RouterService;
import com.limegroup.gnutella.UDPService;
import com.limegroup.gnutella.messages.BadGGEPPropertyException;
import com.limegroup.gnutella.messages.BadPacketException;
import com.limegroup.gnutella.messages.GGEP;
import com.limegroup.gnutella.messages.GGEPParser;
import com.limegroup.gnutella.messages.IPPortCombo;
import com.limegroup.gnutella.messages.Message;
import com.limegroup.gnutella.messages.QueryReplyData;
import com.limegroup.gnutella.messages.SecureGGEPData;
import com.limegroup.gnutella.messages.SecureMessage;
import com.limegroup.gnutella.search.HostData;
import com.limegroup.gnutella.statistics.DroppedSentMessageStatHandler;
import com.limegroup.gnutella.statistics.ReceivedErrorStat;
import com.limegroup.gnutella.statistics.SentMessageStatHandler;
import com.limegroup.gnutella.util.DataUtils;
import com.limegroup.gnutella.util.IpPort;
import com.limegroup.gnutella.util.IpPortSet;
import com.limegroup.gnutella.util.NetworkUtils;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.security.Signature;
import java.security.SignatureException;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Set;

public class QueryReply
extends Message
implements SecureMessage {
    public static final int XML_MAX_SIZE = 32768;
    public static final int COMMON_PAYLOAD_LEN = 4;
    private static final byte PUSH_MASK = 1;
    private static final byte BUSY_MASK = 4;
    private static final byte UPLOADED_MASK = 8;
    private static final byte SPEED_MASK = 16;
    private static final byte GGEP_MASK = 32;
    private static final byte CHAT_MASK = 1;
    static final int TRUE = 1;
    static final int FALSE = 0;
    static final int UNDEFINED = -1;
    private static final GGEPUtil _ggepUtil = new GGEPUtil();
    private byte[] _payload;
    private byte[] _address = new byte[4];
    private int _secureStatus = 0;
    private boolean _parsed = false;
    private volatile QueryReplyData _data;
    private byte[] clientGUID = null;

    public QueryReply(byte[] byArray, byte by, int n, byte[] byArray2, long l, Response[] responseArray, byte[] byArray3, boolean bl) {
        this(byArray, by, n, byArray2, l, responseArray, byArray3, DataUtils.EMPTY_BYTE_ARRAY, false, false, false, false, false, false, true, bl, false, Collections.EMPTY_SET);
    }

    public QueryReply(byte[] byArray, byte by, int n, byte[] byArray2, long l, Response[] responseArray, byte[] byArray3, boolean bl, boolean bl2, boolean bl3, boolean bl4, boolean bl5, boolean bl6) {
        this(byArray, by, n, byArray2, l, responseArray, byArray3, DataUtils.EMPTY_BYTE_ARRAY, true, bl, bl2, bl3, bl4, bl5, true, bl6, false, Collections.EMPTY_SET);
    }

    public QueryReply(byte[] byArray, byte by, int n, byte[] byArray2, long l, Response[] responseArray, byte[] byArray3, byte[] byArray4, boolean bl, boolean bl2, boolean bl3, boolean bl4, boolean bl5, boolean bl6) throws IllegalArgumentException {
        this(byArray, by, n, byArray2, l, responseArray, byArray3, byArray4, bl, bl2, bl3, bl4, bl5, bl6, Collections.EMPTY_SET);
    }

    public QueryReply(byte[] byArray, byte by, int n, byte[] byArray2, long l, Response[] responseArray, byte[] byArray3, byte[] byArray4, boolean bl, boolean bl2, boolean bl3, boolean bl4, boolean bl5, boolean bl6, Set set) throws IllegalArgumentException {
        this(byArray, by, n, byArray2, l, responseArray, byArray3, byArray4, true, bl, bl2, bl3, bl4, bl5, true, bl6, false, set);
    }

    public QueryReply(byte[] byArray, byte by, int n, byte[] byArray2, long l, Response[] responseArray, byte[] byArray3, byte[] byArray4, boolean bl, boolean bl2, boolean bl3, boolean bl4, boolean bl5, boolean bl6, boolean bl7, Set set) throws IllegalArgumentException {
        this(byArray, by, n, byArray2, l, responseArray, byArray3, byArray4, true, bl, bl2, bl3, bl4, bl5, true, bl6, bl7, set);
    }

    public QueryReply(byte[] byArray, byte by, byte by2, byte[] byArray2) throws BadPacketException {
        this(byArray, by, by2, byArray2, -1);
    }

    public QueryReply(byte[] byArray, byte by, byte by2, byte[] byArray2, int n) throws BadPacketException {
        super(byArray, (byte)-127, by, by2, byArray2.length, n);
        this._payload = byArray2;
        if (!NetworkUtils.isValidPort(this.getPort())) {
            ReceivedErrorStat.REPLY_INVALID_PORT.incrementStat();
            throw new BadPacketException("invalid port");
        }
        if ((this.getSpeed() & 0xFFFFFFFF00000000L) != 0L) {
            ReceivedErrorStat.REPLY_INVALID_SPEED.incrementStat();
            throw new BadPacketException("invalid speed: " + this.getSpeed());
        }
        this.setAddress();
        if (!NetworkUtils.isValidAddress(this.getIPBytes())) {
            ReceivedErrorStat.REPLY_INVALID_ADDRESS.incrementStat();
            throw new BadPacketException("invalid address");
        }
    }

    public QueryReply(byte[] byArray, QueryReply queryReply) {
        super(byArray, (byte)-127, queryReply.getTTL(), queryReply.getHops(), queryReply.getLength());
        this._payload = queryReply._payload;
        this.setAddress();
    }

    private QueryReply(byte[] byArray, byte by, int n, byte[] byArray2, long l, Response[] responseArray, byte[] byArray3, byte[] byArray4, boolean bl, boolean bl2, boolean bl3, boolean bl4, boolean bl5, boolean bl6, boolean bl7, boolean bl8, boolean bl9, Set set) {
        super(byArray, (byte)-127, by, (byte)0, 0, 16);
        if (byArray4.length > 32768) {
            throw new IllegalArgumentException("xml too large: " + new String(byArray4));
        }
        int n2 = responseArray.length;
        if (!NetworkUtils.isValidPort(n)) {
            throw new IllegalArgumentException("invalid port: " + n);
        }
        if (byArray2.length != 4) {
            throw new IllegalArgumentException("invalid ip length: " + byArray2.length);
        }
        if (!NetworkUtils.isValidAddress(byArray2)) {
            throw new IllegalArgumentException("invalid address: " + NetworkUtils.ip2string(byArray2));
        }
        if ((l & 0xFFFFFFFF00000000L) != 0L) {
            throw new IllegalArgumentException("invalid speed: " + l);
        }
        if (n2 >= 256) {
            throw new IllegalArgumentException("invalid num responses: " + n2);
        }
        this._data = new QueryReplyData();
        this._data.setXmlBytes(byArray4);
        this._data.setProxies(set);
        this._data.setSupportsFWTransfer(bl9);
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        try {
            byteArrayOutputStream.write(n2);
            ByteOrder.short2leb((short)n, byteArrayOutputStream);
            byteArrayOutputStream.write(byArray2, 0, byArray2.length);
            ByteOrder.int2leb((int)l, byteArrayOutputStream);
            int n3 = n2;
            while (n3 > 0) {
                Response response = responseArray[n2 - n3];
                response.writeToStream(byteArrayOutputStream);
                --n3;
            }
            if (bl) {
                byteArrayOutputStream.write(76);
                byteArrayOutputStream.write(73);
                byteArrayOutputStream.write(77);
                byteArrayOutputStream.write(69);
                byteArrayOutputStream.write(4);
                n3 = _ggepUtil.getQRGGEP(false, false, false, Collections.EMPTY_SET).length;
                boolean bl10 = set != null && set.size() > 0;
                byte by2 = (byte)((bl2 && !bl8 ? 1 : 0) | 4 | 8 | 0x10 | 0x20);
                byte by3 = (byte)(1 | (bl3 && !bl8 ? 4 : 0) | (bl4 ? 8 : 0) | (bl5 || bl8 ? 16 : 0) | (bl7 || bl8 || bl10 || bl9 ? 32 : (n3 > 0 ? 32 : 0)));
                byteArrayOutputStream.write(by2);
                byteArrayOutputStream.write(by3);
                int n4 = byArray4.length + 1;
                if (n4 > 32768) {
                    n4 = 32768;
                }
                ByteOrder.short2leb((short)n4, byteArrayOutputStream);
                int n5 = bl6 ? 1 : 0;
                byteArrayOutputStream.write(n5);
                byte[] byArray5 = _ggepUtil.getQRGGEP(bl7, bl8, bl9, set);
                byteArrayOutputStream.write(byArray5, 0, byArray5.length);
                this.writeSecureGGEP(byteArrayOutputStream, byArray4);
                byteArrayOutputStream.write(byArray4, 0, byArray4.length);
                byteArrayOutputStream.write(0);
            }
            byteArrayOutputStream.write(byArray3, 0, 16);
            this._payload = byteArrayOutputStream.toByteArray();
            this.updateLength(this._payload.length);
        }
        catch (IOException iOException) {
            ErrorService.error(iOException);
        }
        this.setAddress();
    }

    protected void writeSecureGGEP(ByteArrayOutputStream byteArrayOutputStream, byte[] byArray) {
    }

    private void setAddress() {
        this._address[0] = this._payload[3];
        this._address[1] = this._payload[4];
        this._address[2] = this._payload[5];
        this._address[3] = this._payload[6];
    }

    public void setOOBAddress(InetAddress inetAddress, int n) {
        this._address = inetAddress.getAddress();
        ByteOrder.short2leb((short)n, this._payload, 1);
    }

    public void setGUID(GUID gUID) {
        super.setGUID(gUID);
    }

    public void writePayload(OutputStream outputStream) throws IOException {
        outputStream.write(this._payload);
        SentMessageStatHandler.TCP_QUERY_REPLIES.addMessage(this);
    }

    public void setBrowseHostReply(boolean bl) {
        this.parseResults();
        this._data.setBrowseHostReply(bl);
    }

    public boolean isBrowseHostReply() {
        this.parseResults();
        return this._data.isBrowseHostReply();
    }

    public byte[] getXMLBytes() {
        this.parseResults();
        return this._data.getXmlBytes();
    }

    public short getResultCount() {
        return (short)ByteOrder.ubyte2int(this._payload[0]);
    }

    public short getUniqueResultCount() {
        this.parseResults();
        return this._data.getUniqueResultURNs();
    }

    public int getPort() {
        return ByteOrder.ushort2int(ByteOrder.leb2short(this._payload, 1));
    }

    public String getIP() {
        return NetworkUtils.ip2string(this._address);
    }

    public byte[] getIPBytes() {
        return this._address;
    }

    public long getSpeed() {
        return ByteOrder.uint2long(ByteOrder.leb2int(this._payload, 7));
    }

    public Response[] getResultsArray() throws BadPacketException {
        this.parseResults();
        Response[] responseArray = this._data.getResponses();
        if (responseArray == null) {
            throw new BadPacketException();
        }
        return responseArray;
    }

    public Iterator getResults() throws BadPacketException {
        this.parseResults();
        Response[] responseArray = this._data.getResponses();
        if (responseArray == null) {
            throw new BadPacketException();
        }
        List<Response> list = Arrays.asList(responseArray);
        return list.iterator();
    }

    public List getResultsAsList() throws BadPacketException {
        this.parseResults();
        Response[] responseArray = this._data.getResponses();
        if (responseArray == null) {
            throw new BadPacketException("results are null");
        }
        List<Response> list = Arrays.asList(responseArray);
        return list;
    }

    public String getVendor() throws BadPacketException {
        this.parseResults();
        String string = this._data.getVendor();
        if (string == null) {
            throw new BadPacketException();
        }
        return string;
    }

    public boolean getNeedsPush() throws BadPacketException {
        this.parseResults();
        switch (this._data.getPushFlag()) {
            case -1: {
                throw new BadPacketException();
            }
            case 1: {
                return true;
            }
            case 0: {
                return false;
            }
        }
        Assert.that(false, "Bad value for push flag: " + this._data.getPushFlag());
        return false;
    }

    public boolean getIsBusy() throws BadPacketException {
        this.parseResults();
        switch (this._data.getBusyFlag()) {
            case -1: {
                throw new BadPacketException();
            }
            case 1: {
                return true;
            }
            case 0: {
                return false;
            }
        }
        Assert.that(false, "Bad value for busy flag: " + this._data.getBusyFlag());
        return false;
    }

    public boolean getHadSuccessfulUpload() throws BadPacketException {
        this.parseResults();
        switch (this._data.getUploadedFlag()) {
            case -1: {
                throw new BadPacketException();
            }
            case 1: {
                return true;
            }
            case 0: {
                return false;
            }
        }
        Assert.that(false, "Bad value for uploaded flag: " + this._data.getUploadedFlag());
        return false;
    }

    public boolean getIsMeasuredSpeed() throws BadPacketException {
        this.parseResults();
        switch (this._data.getMeasuredSpeedFlag()) {
            case -1: {
                throw new BadPacketException();
            }
            case 1: {
                return true;
            }
            case 0: {
                return false;
            }
        }
        Assert.that(false, "Bad value for measured speed flag: " + this._data.getMeasuredSpeedFlag());
        return false;
    }

    public byte[] getSecureSignature() {
        this.parseResults();
        SecureGGEPData secureGGEPData = this._data.getSecureGGEP();
        if (secureGGEPData != null) {
            try {
                return secureGGEPData.getGGEP().getBytes("SIG");
            }
            catch (BadGGEPPropertyException badGGEPPropertyException) {
                return null;
            }
        }
        return null;
    }

    public void updateSignatureWithSecuredBytes(Signature signature) throws SignatureException {
        this.parseResults();
        SecureGGEPData secureGGEPData = this._data.getSecureGGEP();
        if (secureGGEPData != null) {
            signature.update(this._payload, 0, secureGGEPData.getStartIndex());
            int n = secureGGEPData.getEndIndex();
            int n2 = this._payload.length - 16 - n;
            signature.update(this._payload, n, n2);
        }
    }

    public synchronized int getSecureStatus() {
        return this._secureStatus;
    }

    public synchronized void setSecureStatus(int n) {
        this._secureStatus = n;
    }

    public boolean getSupportsChat() {
        this.parseResults();
        return this._data.isSupportsChat();
    }

    public boolean getSupportsFWTransfer() {
        this.parseResults();
        return this._data.isSupportsFWTransfer();
    }

    public byte getFWTransferVersion() {
        this.parseResults();
        return this._data.getFwTransferVersion();
    }

    public boolean getSupportsBrowseHost() {
        this.parseResults();
        return this._data.isSupportsBrowseHost();
    }

    public boolean isReplyToMulticastQuery() {
        this.parseResults();
        return this._data.isReplyToMulticast();
    }

    public Set getPushProxies() {
        this.parseResults();
        return this._data.getProxies();
    }

    public HostData getHostData() throws BadPacketException {
        this.parseResults();
        HostData hostData = this._data.getHostData();
        if (hostData == null) {
            throw new BadPacketException();
        }
        return hostData;
    }

    public boolean hasSecureData() {
        this.parseResults();
        return this._data.getSecureGGEP() != null;
    }

    private synchronized void parseResults() {
        if (this._parsed) {
            return;
        }
        this._parsed = true;
        this.parseResults2();
    }

    private void parseResults2() {
        Object object;
        int n = 11;
        this._data = new QueryReplyData();
        int n2 = this.getResultCount();
        Response[] responseArray = new Response[n2];
        HashSet hashSet = new HashSet();
        short s = 0;
        try {
            object = new ByteArrayInputStream(this._payload, n, this._payload.length - n);
            while (n2 > 0) {
                Response response;
                responseArray[responseArray.length - n2] = response = Response.createFromStream((InputStream)object);
                n += response.getLength();
                if (response.getUrns().isEmpty()) {
                    s = (short)(s + 1);
                } else {
                    hashSet.addAll(response.getUrns());
                }
                --n2;
            }
            this._data.setResponses(responseArray);
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            return;
        }
        catch (IOException iOException) {
            return;
        }
        s = (short)(s + (short)hashSet.size());
        this._data.setUniqueResultURNs(s);
        try {
            int n3;
            int n4;
            if (n >= this._payload.length - 16) {
                throw new BadPacketException("No QHD");
            }
            object = null;
            int n5 = -1;
            int n6 = -1;
            int n7 = -1;
            int n8 = -1;
            boolean bl = false;
            boolean bl2 = false;
            boolean bl3 = false;
            Set set = null;
            try {
                object = new String(this._payload, n, 4, "ISO-8859-1");
                Assert.that(((String)object).length() == 4, "Vendor length wrong.  Wrong character encoding?");
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                Assert.that(false, "No support for ISO-8859-1 encoding");
            }
            int n9 = ByteOrder.ubyte2int(this._payload[n += 4]);
            if (n9 <= 0) {
                throw new BadPacketException("Common payload length zero.");
            }
            if (++n + n9 > this._payload.length - 16) {
                throw new BadPacketException("Common payload length imprecise!");
            }
            if (n9 > 1) {
                n4 = this._payload[n];
                n3 = this._payload[n + 1];
                if ((n3 & 1) != 0) {
                    int n10 = n5 = (n4 & 1) == 1 ? 1 : 0;
                }
                if ((n4 & 4) != 0) {
                    int n11 = n6 = (n3 & 4) != 0 ? 1 : 0;
                }
                if ((n4 & 8) != 0) {
                    int n12 = n7 = (n3 & 8) != 0 ? 1 : 0;
                }
                if ((n4 & 0x10) != 0) {
                    int n13 = n8 = (n3 & 0x10) != 0 ? 1 : 0;
                }
                if ((n4 & 0x20) != 0 && (n3 & 0x20) != 0) {
                    GGEPParser gGEPParser = new GGEPParser();
                    gGEPParser.scanForGGEPs(this._payload, n + 2);
                    GGEP gGEP = gGEPParser.getNormalGGEP();
                    if (gGEP != null) {
                        try {
                            bl2 = gGEP.hasKey("BH");
                            if (gGEP.hasKey("FW")) {
                                this._data.setFwTransferVersion(gGEP.getBytes("FW")[0]);
                                this._data.setSupportsFWTransfer(this._data.getFwTransferVersion() > 0);
                            }
                            bl3 = gGEP.hasKey("MCAST");
                            set = _ggepUtil.getPushProxies(gGEP);
                        }
                        catch (BadGGEPPropertyException badGGEPPropertyException) {}
                    }
                    if (gGEPParser.getSecureGGEP() != null) {
                        this._data.setSecureGGEP(new SecureGGEPData(gGEPParser));
                    }
                }
                n += 2;
            }
            if (n9 > 2) {
                int n14;
                int n15;
                if ((n15 = (n4 = (n14 = ByteOrder.ubyte2int(this._payload[n++]))) | (n3 = (n14 = ByteOrder.ubyte2int(this._payload[n++])) << 8)) > 1) {
                    int n16 = this._payload.length - 16 - n15;
                    byte[] byArray = new byte[n15 - 1];
                    System.arraycopy(this._payload, n16, byArray, 0, n15 - 1);
                    this._data.setXmlBytes(byArray);
                } else {
                    this._data.setXmlBytes(DataUtils.EMPTY_BYTE_ARRAY);
                }
            }
            if ((n4 = this._payload.length - n) > 0 && (((String)object).equals("LIME") || ((String)object).equals("RAZA"))) {
                n3 = this._payload[n];
                boolean bl4 = bl = (n3 & 1) != 0;
            }
            if (n > this._payload.length - 16) {
                throw new BadPacketException("Common payload length too large.");
            }
            Assert.that(object != null);
            this._data.setVendor(((String)object).toUpperCase(Locale.US));
            this._data.setPushFlag(n5);
            this._data.setBusyFlag(n6);
            this._data.setUploadedFlag(n7);
            this._data.setMeasuredSpeedFlag(n8);
            this._data.setSupportsChat(bl);
            this._data.setSupportsBrowseHost(bl2);
            this._data.setReplyToMulticast(bl3);
            if (set == null) {
                this._data.setProxies(Collections.EMPTY_SET);
            } else {
                this._data.setProxies(set);
            }
            this._data.setHostData(new HostData(this));
        }
        catch (BadPacketException badPacketException) {
            return;
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            return;
        }
    }

    public byte[] getClientGUID() {
        if (this.clientGUID == null) {
            byte[] byArray = new byte[16];
            int n = super.getLength();
            System.arraycopy(this._payload, n - 16, byArray, 0, 16);
            this.clientGUID = byArray;
        }
        return this.clientGUID;
    }

    public Message stripExtendedPayload() {
        return this;
    }

    public String toString() {
        return "QueryReply::\r\n" + this.getResultCount() + " hits\r\n" + super.toString() + "\r\n" + "ip: " + this.getIP() + "\r\n";
    }

    public int calculateQualityOfService(boolean bl) {
        int n;
        int n2;
        try {
            n2 = this.getIsBusy() ? 1 : -1;
        }
        catch (BadPacketException badPacketException) {
            n2 = 0;
        }
        boolean bl2 = this.isReplyToMulticastQuery();
        if (bl2) {
            bl = false;
            n = -1;
        } else if (NetworkUtils.isPrivateAddress(this.getIPBytes())) {
            n = 1;
        } else {
            try {
                n = this.getNeedsPush() ? 1 : -1;
            }
            catch (BadPacketException badPacketException) {
                n = 0;
            }
        }
        boolean bl3 = false;
        if (this.getPushProxies() != null && this.getPushProxies().size() > 1) {
            bl3 = true;
        }
        if (this.getSupportsFWTransfer() && UDPService.instance().canDoFWT()) {
            bl = false;
            n = -1;
        }
        if (Arrays.equals(this._address, RouterService.getAddress())) {
            return 3;
        }
        if (bl2) {
            return 4;
        }
        if (bl && n == 1) {
            return -1;
        }
        if (n2 == 0 || n == 0) {
            return 0;
        }
        if (n2 == 1) {
            Assert.that(n == -1 || !bl);
            if (n == 1) {
                return 0;
            }
            return 1;
        }
        if (n2 == -1) {
            Assert.that(n == -1 || !bl);
            if (n == 1 && !bl3) {
                return 2;
            }
            return 3;
        }
        Assert.that(false, "Unexpected case!");
        return -1;
    }

    public static boolean isFirewalledQuality(int n) {
        return n == 0 || n == 2;
    }

    public void recordDrop() {
        DroppedSentMessageStatHandler.TCP_QUERY_REPLIES.addMessage(this);
    }

    static class GGEPUtil {
        private final byte[] _standardGGEP;
        private final byte[] _bhGGEP;
        private final byte[] _mcGGEP;
        private final byte[] _comboGGEP;

        public GGEPUtil() {
            GGEP gGEP;
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            try {
                gGEP = new GGEP(false);
                gGEP.write(byteArrayOutputStream);
            }
            catch (IOException iOException) {}
            this._standardGGEP = byteArrayOutputStream.toByteArray();
            byteArrayOutputStream.reset();
            try {
                gGEP = new GGEP(false);
                gGEP.put("BH");
                gGEP.write(byteArrayOutputStream);
            }
            catch (IOException iOException) {}
            this._bhGGEP = byteArrayOutputStream.toByteArray();
            Assert.that(this._bhGGEP != null);
            byteArrayOutputStream.reset();
            try {
                gGEP = new GGEP(false);
                gGEP.put("MCAST");
                gGEP.write(byteArrayOutputStream);
            }
            catch (IOException iOException) {}
            this._mcGGEP = byteArrayOutputStream.toByteArray();
            Assert.that(this._mcGGEP != null);
            byteArrayOutputStream.reset();
            try {
                gGEP = new GGEP(false);
                gGEP.put("MCAST");
                gGEP.put("BH");
                gGEP.write(byteArrayOutputStream);
            }
            catch (IOException iOException) {}
            this._comboGGEP = byteArrayOutputStream.toByteArray();
            Assert.that(this._comboGGEP != null);
        }

        public byte[] getQRGGEP(boolean bl, boolean bl2, boolean bl3, Set set) {
            byte[] byArray = this._standardGGEP;
            if (set != null && set.size() > 0) {
                GGEP gGEP = new GGEP();
                if (bl) {
                    gGEP.put("BH");
                }
                if (bl2) {
                    gGEP.put("MCAST");
                }
                if (bl3) {
                    gGEP.put("FW", new byte[]{1});
                }
                ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
                int n = 0;
                Iterator iterator = set.iterator();
                while (iterator.hasNext() && n < 4) {
                    IpPort ipPort = (IpPort)iterator.next();
                    String string = ipPort.getAddress();
                    int n2 = ipPort.getPort();
                    try {
                        IPPortCombo iPPortCombo = new IPPortCombo(string, n2);
                        byteArrayOutputStream.write(iPPortCombo.toBytes());
                        ++n;
                    }
                    catch (UnknownHostException unknownHostException) {
                    }
                    catch (IOException iOException) {
                        ErrorService.error(iOException);
                    }
                }
                try {
                    if (n > 0) {
                        gGEP.put("PUSH", byteArrayOutputStream.toByteArray());
                    }
                    byteArrayOutputStream.reset();
                    gGEP.write(byteArrayOutputStream);
                    byArray = byteArrayOutputStream.toByteArray();
                }
                catch (IOException iOException) {
                    ErrorService.error(iOException);
                }
            } else if (bl && bl2) {
                byArray = this._comboGGEP;
            } else if (bl) {
                byArray = this._bhGGEP;
            } else if (bl2) {
                byArray = this._mcGGEP;
            }
            return byArray;
        }

        public Set getPushProxies(GGEP gGEP) {
            IpPortSet ipPortSet = null;
            if (gGEP.hasKey("PUSH")) {
                try {
                    byte[] byArray = gGEP.getBytes("PUSH");
                    ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byArray);
                    while (byteArrayInputStream.available() > 0) {
                        byte[] byArray2 = new byte[6];
                        if (byteArrayInputStream.read(byArray2, 0, byArray2.length) != byArray2.length) continue;
                        try {
                            if (ipPortSet == null) {
                                ipPortSet = new IpPortSet();
                            }
                            ipPortSet.add(IPPortCombo.getCombo(byArray2));
                        }
                        catch (BadPacketException badPacketException) {}
                    }
                }
                catch (BadGGEPPropertyException badGGEPPropertyException) {}
            }
            if (ipPortSet == null) {
                return Collections.EMPTY_SET;
            }
            return ipPortSet;
        }
    }
}

