/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.messages;

import com.limegroup.gnutella.Assert;
import com.limegroup.gnutella.ByteOrder;
import com.limegroup.gnutella.GUID;
import java.io.IOException;
import java.io.OutputStream;
import java.io.Serializable;

public abstract class Message
implements Serializable,
Comparable {
    public static final byte F_PING = 0;
    public static final byte F_PING_REPLY = 1;
    public static final byte F_PUSH = 64;
    public static final byte F_QUERY = -128;
    public static final byte F_QUERY_REPLY = -127;
    public static final byte F_ROUTE_TABLE_UPDATE = 48;
    public static final byte F_VENDOR_MESSAGE = 49;
    public static final byte F_VENDOR_MESSAGE_STABLE = 50;
    public static final byte F_UDP_CONNECTION = 65;
    public static final int N_UNKNOWN = -1;
    public static final int N_TCP = 1;
    public static final int N_UDP = 2;
    public static final int N_MULTICAST = 3;
    private byte[] guid;
    private final byte func;
    private byte ttl;
    private byte hops;
    private int length;
    private int priority = 0;
    private final long creationTime = System.currentTimeMillis();
    private final int network;

    public static byte[] makeGuid() {
        return GUID.makeGuid();
    }

    protected void repOk() {
        Assert.that(this.guid.length == 16);
        Assert.that(this.func == 0 || this.func == 1 || this.func == 64 || this.func == -128 || this.func == -127 || this.func == 49 || this.func == 50 || this.func == 65, "Bad function code");
        if (this.func == 64) {
            Assert.that(this.length == 26, "Bad push length: " + this.length);
        }
        Assert.that(this.ttl >= 0, "Negative TTL: " + this.ttl);
        Assert.that(this.hops >= 0, "Negative hops: " + this.hops);
        Assert.that(this.length >= 0, "Negative length: " + this.length);
    }

    protected Message(byte by, byte by2, int n) {
        this(by, by2, n, -1);
    }

    protected Message(byte by, byte by2, int n, int n2) {
        this(Message.makeGuid(), by, by2, 0, n, n2);
    }

    protected Message(byte[] byArray, byte by, byte by2, byte by3, int n) {
        this(byArray, by, by2, by3, n, -1);
    }

    protected Message(byte[] byArray, byte by, byte by2, byte by3, int n, int n2) {
        if (byArray.length != 16) {
            throw new IllegalArgumentException("invalid guid length: " + byArray.length);
        }
        this.guid = byArray;
        this.func = by;
        this.ttl = by2;
        this.hops = by3;
        this.length = n;
        this.network = n2;
    }

    public void writeQuickly(OutputStream outputStream) throws IOException {
        outputStream.write(this.guid, 0, 16);
        outputStream.write(this.func);
        outputStream.write(this.ttl);
        outputStream.write(this.hops);
        ByteOrder.int2leb(this.length, outputStream);
        this.writePayload(outputStream);
    }

    public void write(OutputStream outputStream, byte[] byArray) throws IOException {
        System.arraycopy(this.guid, 0, byArray, 0, this.guid.length);
        byArray[16] = this.func;
        byArray[17] = this.ttl;
        byArray[18] = this.hops;
        ByteOrder.int2leb(this.length, byArray, 19);
        outputStream.write(byArray);
        this.writePayload(outputStream);
    }

    public void write(OutputStream outputStream) throws IOException {
        this.write(outputStream, new byte[23]);
    }

    protected abstract void writePayload(OutputStream var1) throws IOException;

    public int getNetwork() {
        return this.network;
    }

    public boolean isMulticast() {
        return this.network == 3;
    }

    public boolean isUDP() {
        return this.network == 2;
    }

    public boolean isTCP() {
        return this.network == 1;
    }

    public boolean isUnknownNetwork() {
        return this.network == -1;
    }

    public byte[] getGUID() {
        return this.guid;
    }

    public byte getFunc() {
        return this.func;
    }

    public byte getTTL() {
        return this.ttl;
    }

    public void setTTL(byte by) throws IllegalArgumentException {
        if (by < 0) {
            throw new IllegalArgumentException("invalid TTL: " + by);
        }
        this.ttl = by;
    }

    protected void setGUID(GUID gUID) {
        this.guid = gUID.bytes();
    }

    public void setHops(byte by) throws IllegalArgumentException {
        if (by < 0) {
            throw new IllegalArgumentException("invalid hops: " + by);
        }
        this.hops = by;
    }

    public byte getHops() {
        return this.hops;
    }

    public int getLength() {
        return this.length;
    }

    protected void updateLength(int n) {
        this.length = n;
    }

    public int getTotalLength() {
        return 23 + this.length;
    }

    public byte hop() {
        this.hops = (byte)(this.hops + 1);
        if (this.ttl > 0) {
            byte by = this.ttl;
            this.ttl = (byte)(by - 1);
            return by;
        }
        return this.ttl;
    }

    public long getCreationTime() {
        return this.creationTime;
    }

    public int getPriority() {
        return this.priority;
    }

    public void setPriority(int n) {
        this.priority = n;
    }

    public abstract Message stripExtendedPayload();

    public int compareTo(Object object) {
        Message message = (Message)object;
        return message.getPriority() - this.getPriority();
    }

    public String toString() {
        return "{guid=" + new GUID(this.guid).toString() + ", ttl=" + this.ttl + ", hops=" + this.hops + ", priority=" + this.getPriority() + "}";
    }

    public abstract void recordDrop();
}

