/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.messages;

import com.limegroup.gnutella.ByteOrder;
import com.limegroup.gnutella.messages.BadPacketException;
import com.limegroup.gnutella.util.IpPort;
import com.limegroup.gnutella.util.NetworkUtils;
import java.net.InetAddress;
import java.net.UnknownHostException;

public class IPPortCombo
implements IpPort {
    private int _port;
    private InetAddress _addr;
    public static final String DELIM = ":";

    public static IPPortCombo getCombo(byte[] byArray) throws BadPacketException {
        return new IPPortCombo(byArray);
    }

    private IPPortCombo(byte[] byArray) throws BadPacketException {
        if (byArray.length != 6) {
            throw new BadPacketException("Weird Input");
        }
        int n = ByteOrder.ushort2int(ByteOrder.leb2short(byArray, 4));
        if (!NetworkUtils.isValidPort(n)) {
            throw new BadPacketException("Bad Port: " + n);
        }
        this._port = n;
        try {
            byte[] byArray2 = new byte[]{byArray[0], byArray[1], byArray[2], byArray[3]};
            this._addr = InetAddress.getByAddress(byArray2);
        }
        catch (UnknownHostException unknownHostException) {
            throw new BadPacketException("bad host.");
        }
        if (!NetworkUtils.isValidAddress(this._addr)) {
            throw new BadPacketException("invalid addr: " + this._addr);
        }
    }

    public IPPortCombo(String string, int n) throws UnknownHostException, IllegalArgumentException {
        if (!NetworkUtils.isValidPort(n)) {
            throw new IllegalArgumentException("Bad Port: " + n);
        }
        this._port = n;
        this._addr = InetAddress.getByName(string);
        if (!NetworkUtils.isValidAddress(this._addr)) {
            throw new IllegalArgumentException("invalid addr: " + this._addr);
        }
    }

    public int getPort() {
        return this._port;
    }

    public InetAddress getInetAddress() {
        return this._addr;
    }

    public String getAddress() {
        return this._addr.getHostAddress();
    }

    public byte[] toBytes() {
        byte[] byArray = new byte[6];
        int n = 0;
        while (n < 4) {
            byArray[n] = this._addr.getAddress()[n];
            ++n;
        }
        ByteOrder.short2leb((short)this._port, byArray, 4);
        return byArray;
    }

    public boolean equals(Object object) {
        if (object instanceof IPPortCombo) {
            IPPortCombo iPPortCombo = (IPPortCombo)object;
            return this._addr.equals(iPPortCombo._addr) && this._port == iPPortCombo._port;
        }
        return false;
    }

    public int hashCode() {
        return this._addr.hashCode() * this._port;
    }

    public String toString() {
        return String.valueOf(this.getAddress()) + DELIM + this.getPort();
    }
}

