/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.io;

import com.limegroup.gnutella.ErrorService;
import com.limegroup.gnutella.io.AcceptChannelObserver;
import com.limegroup.gnutella.io.ByteBufferCache;
import com.limegroup.gnutella.io.ConnectObserver;
import com.limegroup.gnutella.io.IOErrorObserver;
import com.limegroup.gnutella.io.NBThrottle;
import com.limegroup.gnutella.io.ReadObserver;
import com.limegroup.gnutella.io.ReadTimeout;
import com.limegroup.gnutella.io.ReadWriteObserver;
import com.limegroup.gnutella.io.Shutdownable;
import com.limegroup.gnutella.io.TimeoutController;
import com.limegroup.gnutella.io.Timeoutable;
import com.limegroup.gnutella.io.WriteObserver;
import com.limegroup.gnutella.util.ManagedThread;
import java.io.IOException;
import java.net.SocketTimeoutException;
import java.nio.channels.CancelledKeyException;
import java.nio.channels.ClosedSelectorException;
import java.nio.channels.SelectableChannel;
import java.nio.channels.SelectionKey;
import java.nio.channels.Selector;
import java.nio.channels.ServerSocketChannel;
import java.nio.channels.SocketChannel;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class NIODispatcher
implements Runnable {
    private static final Log LOG;
    private static final NIODispatcher INSTANCE;
    private static final long SPIN_AMOUNT = 5000L;
    private static final int MAX_IGNORES = 5;
    private final Thread dispatchThread;
    private Selector primarySelector = null;
    private long iteration = 0L;
    private volatile boolean wokeup = false;
    private final Object Q_LOCK = new Object();
    private final Map OTHER_SELECTORS = new HashMap();
    private final List POLLERS = new ArrayList();
    private Collection LATER = new LinkedList();
    private final List THROTTLE = new ArrayList();
    private final TimeoutController TIMEOUTER = new TimeoutController();
    private final ByteBufferCache BUFFER_CACHE = new ByteBufferCache();
    private long lastCacheClearTime;
    private static final long CACHE_CLEAR_INTERVAL = 30000L;
    static /* synthetic */ Class class$0;

    static {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("com.limegroup.gnutella.io.NIODispatcher");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        LOG = LogFactory.getLog((Class)clazz);
        INSTANCE = new NIODispatcher();
    }

    public static final NIODispatcher instance() {
        return INSTANCE;
    }

    private NIODispatcher() {
        boolean bl = false;
        try {
            this.primarySelector = Selector.open();
        }
        catch (IOException iOException) {
            bl = true;
        }
        if (!bl) {
            this.dispatchThread = new ManagedThread(this, "NIODispatcher");
            this.dispatchThread.start();
        } else {
            this.dispatchThread = null;
        }
    }

    public boolean isRunning() {
        return this.dispatchThread != null;
    }

    public boolean isDispatchThread() {
        return Thread.currentThread() == this.dispatchThread;
    }

    public ByteBufferCache getBufferCache() {
        return this.BUFFER_CACHE;
    }

    public void addThrottle(final NBThrottle nBThrottle) {
        if (Thread.currentThread() == this.dispatchThread) {
            this.THROTTLE.add(nBThrottle);
        } else {
            this.invokeLater(new Runnable(){

                public void run() {
                    NIODispatcher.this.THROTTLE.add(nBThrottle);
                }
            });
        }
    }

    public void register(SelectableChannel selectableChannel, IOErrorObserver iOErrorObserver) {
        this.register(selectableChannel, iOErrorObserver, 0, 0);
    }

    public void registerAccept(SelectableChannel selectableChannel, AcceptChannelObserver acceptChannelObserver) {
        this.register(selectableChannel, acceptChannelObserver, 16, 0);
    }

    public void registerConnect(SelectableChannel selectableChannel, ConnectObserver connectObserver, int n) {
        this.register(selectableChannel, connectObserver, 8, n);
    }

    public void registerRead(SelectableChannel selectableChannel, ReadObserver readObserver) {
        this.register(selectableChannel, readObserver, 1, 0);
    }

    public void registerWrite(SelectableChannel selectableChannel, WriteObserver writeObserver) {
        this.register(selectableChannel, writeObserver, 4, 0);
    }

    public void registerReadWrite(SelectableChannel selectableChannel, ReadWriteObserver readWriteObserver) {
        this.register(selectableChannel, readWriteObserver, 5, 0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void register(SelectableChannel selectableChannel, IOErrorObserver iOErrorObserver, int n, int n2) {
        if (Thread.currentThread() == this.dispatchThread) {
            this.registerImpl(this.getSelectorFor(selectableChannel), selectableChannel, n, iOErrorObserver, n2);
        } else {
            Object object = this.Q_LOCK;
            synchronized (object) {
                this.LATER.add(new RegisterOp(selectableChannel, iOErrorObserver, n, n2));
            }
            this.wakeup();
        }
    }

    public void interestWrite(SelectableChannel selectableChannel, boolean bl) {
        this.interest(selectableChannel, 4, bl);
    }

    public void interestRead(SelectableChannel selectableChannel, boolean bl) {
        this.interest(selectableChannel, 1, bl);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void interest(SelectableChannel selectableChannel, int n, boolean bl) {
        block9: {
            try {
                int n2;
                Selector selector = this.getSelectorFor(selectableChannel);
                SelectionKey selectionKey = selectableChannel.keyFor(selector);
                if (selectionKey == null || !selectionKey.isValid()) break block9;
                Object object = selectionKey.attachment();
                synchronized (object) {
                    if ((n & 1) == 1) {
                        ((Attachment)selectionKey.attachment()).changeReadStatus(bl);
                    }
                    n2 = selectionKey.interestOps();
                    if (bl) {
                        selectionKey.interestOps(n2 | n);
                    } else {
                        selectionKey.interestOps(n2 & ~n);
                    }
                }
                if (bl && (n2 & n) != n) {
                    this.wakeup();
                }
            }
            catch (CancelledKeyException cancelledKeyException) {}
        }
    }

    private Selector getSelectorFor(SelectableChannel selectableChannel) {
        Selector selector = (Selector)this.OTHER_SELECTORS.get(selectableChannel.getClass());
        if (selector == null) {
            return this.primarySelector;
        }
        return selector;
    }

    public void shutdown(Shutdownable shutdownable) {
        shutdownable.shutdown();
    }

    public void attach(SelectionKey selectionKey, IOErrorObserver iOErrorObserver) {
        selectionKey.attach(new Attachment(iOErrorObserver));
    }

    public void registerSelector(final Selector selector, final Class clazz) {
        if (Thread.currentThread() == this.dispatchThread) {
            this.POLLERS.add(selector);
            this.OTHER_SELECTORS.put(clazz, selector);
        } else {
            this.invokeLater(new Runnable(){

                public void run() {
                    NIODispatcher.this.POLLERS.add(selector);
                    NIODispatcher.this.OTHER_SELECTORS.put(clazz, selector);
                }
            });
        }
    }

    public void removeSelector(final Selector selector) {
        if (Thread.currentThread() == this.dispatchThread) {
            this.POLLERS.remove(selector);
            this.OTHER_SELECTORS.remove(selector);
        } else {
            this.invokeLater(new Runnable(){

                public void run() {
                    NIODispatcher.this.POLLERS.remove(selector);
                    NIODispatcher.this.OTHER_SELECTORS.remove(selector);
                }
            });
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void invokeLater(Runnable runnable) {
        if (Thread.currentThread() == this.dispatchThread) {
            runnable.run();
        } else {
            Object object = this.Q_LOCK;
            synchronized (object) {
                this.LATER.add(runnable);
            }
            this.wakeup();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void invokeReallyLater(Runnable runnable) {
        Object object = this.Q_LOCK;
        synchronized (object) {
            this.LATER.add(runnable);
        }
        this.wakeup();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void invokeAndWait(final Runnable runnable) throws InterruptedException {
        if (Thread.currentThread() == this.dispatchThread) {
            runnable.run();
        } else {
            Runnable runnable2;
            Runnable runnable3 = runnable2 = new Runnable(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public void run() {
                    runnable.run();
                    4 var1_1 = this;
                    synchronized (var1_1) {
                        this.notify();
                    }
                }
            };
            synchronized (runnable3) {
                Object object = this.Q_LOCK;
                synchronized (object) {
                    this.LATER.add(runnable2);
                }
                this.wakeup();
                runnable2.wait();
            }
        }
    }

    public IOErrorObserver attachment(Object object) {
        return ((Attachment)object).attachment;
    }

    private void cancel(SelectionKey selectionKey, Shutdownable shutdownable) {
        selectionKey.cancel();
        if (shutdownable != null) {
            shutdownable.shutdown();
        }
    }

    private void processAccept(long l, SelectionKey selectionKey, AcceptChannelObserver acceptChannelObserver, Attachment attachment) throws IOException {
        ServerSocketChannel serverSocketChannel;
        SocketChannel socketChannel;
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("Handling accept: " + acceptChannelObserver));
        }
        if ((socketChannel = (serverSocketChannel = (ServerSocketChannel)selectionKey.channel()).accept()) == null) {
            return;
        }
        if (socketChannel.isOpen()) {
            socketChannel.configureBlocking(false);
            acceptChannelObserver.handleAcceptChannel(socketChannel);
        } else {
            try {
                socketChannel.close();
            }
            catch (IOException iOException) {
                LOG.error((Object)"SocketChannel.close()", (Throwable)iOException);
            }
        }
    }

    private void processConnect(long l, SelectionKey selectionKey, ConnectObserver connectObserver, Attachment attachment) throws IOException {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("Handling connect: " + connectObserver));
        }
        SocketChannel socketChannel = (SocketChannel)selectionKey.channel();
        attachment.clearTimeout();
        boolean bl = socketChannel.finishConnect();
        if (bl) {
            selectionKey.interestOps(0);
            connectObserver.handleConnect(socketChannel.socket());
        } else {
            this.cancel(selectionKey, connectObserver);
        }
    }

    private void processRead(long l, ReadObserver readObserver, Attachment attachment) throws IOException {
        attachment.updateReadTimeout(l);
        readObserver.handleRead();
    }

    private void processWrite(long l, WriteObserver writeObserver, Attachment attachment) throws IOException {
        writeObserver.handleWrite();
    }

    private void registerImpl(Selector selector, SelectableChannel selectableChannel, int n, IOErrorObserver iOErrorObserver, int n2) {
        try {
            Attachment attachment = new Attachment(iOErrorObserver);
            SelectionKey selectionKey = selectableChannel.register(selector, n, attachment);
            attachment.setKey(selectionKey);
            if (n2 != 0) {
                attachment.addTimeout(System.currentTimeMillis(), n2);
            } else if ((n & 1) != 0) {
                attachment.changeReadStatus(true);
            }
        }
        catch (IOException iOException) {
            iOErrorObserver.handleIOException(iOException);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void runPendingTasks() {
        Collection collection;
        long l = System.currentTimeMillis();
        int n = 0;
        while (n < this.THROTTLE.size()) {
            ((NBThrottle)this.THROTTLE.get(n)).tick(l);
            ++n;
        }
        Iterator iterator = this.Q_LOCK;
        synchronized (iterator) {
            collection = this.LATER;
            this.LATER = new LinkedList();
        }
        if (l > this.lastCacheClearTime + 30000L) {
            this.BUFFER_CACHE.clearCache();
            this.lastCacheClearTime = l;
        }
        if (!collection.isEmpty()) {
            iterator = collection.iterator();
            while (iterator.hasNext()) {
                Runnable runnable = (Runnable)iterator.next();
                try {
                    runnable.run();
                }
                catch (Throwable throwable) {
                    LOG.error((Object)throwable);
                    ErrorService.error(throwable);
                }
            }
        }
    }

    private Collection pollOtherSelectors() {
        Set<SelectionKey> set = null;
        boolean bl = false;
        int n = 0;
        while (n < this.POLLERS.size()) {
            Set<SelectionKey> set2;
            Selector selector = (Selector)this.POLLERS.get(n);
            int n2 = 0;
            try {
                n2 = selector.selectNow();
            }
            catch (IOException iOException) {
                LOG.error((Object)"Error performing secondary select", (Throwable)iOException);
            }
            if (n2 != 0 && !(set2 = selector.selectedKeys()).isEmpty()) {
                if (set == null) {
                    set = set2;
                } else if (!bl) {
                    bl = true;
                    set = new HashSet<SelectionKey>(set);
                    set.addAll(set2);
                } else {
                    set.addAll(set2);
                }
            }
            ++n;
        }
        return set == null ? Collections.EMPTY_SET : set;
    }

    private void readyThrottles(Collection collection) {
        int n = 0;
        while (n < this.THROTTLE.size()) {
            ((NBThrottle)this.THROTTLE.get(n)).selectableKeys(collection);
            ++n;
        }
    }

    private void wakeup() {
        if (!this.wokeup && Thread.currentThread() != this.dispatchThread) {
            this.wokeup = true;
            this.primarySelector.wakeup();
        }
    }

    private void process() throws ProcessingException, SpinningException {
        boolean bl = false;
        long l = -1L;
        int n = 0;
        int n2 = 0;
        while (true) {
            Set<SelectionKey> set;
            this.runPendingTasks();
            Collection collection = this.pollOtherSelectors();
            boolean bl2 = !collection.isEmpty();
            try {
                if (!bl2 && bl) {
                    l = System.currentTimeMillis();
                }
                if (!bl2) {
                    this.primarySelector.select(100L);
                } else {
                    this.primarySelector.selectNow();
                }
            }
            catch (NullPointerException nullPointerException) {
                LOG.warn((Object)"npe", (Throwable)nullPointerException);
                continue;
            }
            catch (CancelledKeyException cancelledKeyException) {
                LOG.warn((Object)"cancelled", (Throwable)cancelledKeyException);
                continue;
            }
            catch (IOException iOException) {
                throw new ProcessingException(iOException);
            }
            Set<SelectionKey> set2 = this.primarySelector.selectedKeys();
            if (!bl2 && !this.wokeup) {
                if (set2.isEmpty()) {
                    long l2 = System.currentTimeMillis();
                    if (l == -1L) {
                        LOG.trace((Object)"No keys selected, starting spin check.");
                        bl = true;
                    } else if (l + 30L >= l2) {
                        if (LOG.isWarnEnabled()) {
                            LOG.warn((Object)("Spinning detected, current spins: " + n));
                        }
                        if ((long)n++ > 5000L) {
                            throw new SpinningException();
                        }
                    } else {
                        bl = false;
                        l = -1L;
                        n = 0;
                        n2 = 0;
                    }
                    this.TIMEOUTER.processTimeouts(l2);
                    continue;
                }
                if (bl && ++n2 > 5) {
                    bl = false;
                    n = 0;
                    l = -1L;
                    n2 = 0;
                }
            }
            if (LOG.isTraceEnabled()) {
                LOG.trace((Object)("Selected keys: (" + set2.size() + "), polled: (" + collection.size() + ")."));
            }
            if (bl2) {
                set = new HashSet<SelectionKey>(set2.size() + collection.size());
                set.addAll(set2);
                set.addAll(collection);
            } else {
                set = set2;
            }
            this.readyThrottles(set);
            long l3 = System.currentTimeMillis();
            Iterator iterator = set.iterator();
            while (iterator.hasNext()) {
                SelectionKey selectionKey = (SelectionKey)iterator.next();
                this.process(l3, selectionKey, selectionKey.attachment(), 65535);
            }
            set2.clear();
            ++this.iteration;
            this.TIMEOUTER.processTimeouts(l3);
            this.wokeup = false;
        }
    }

    void process(long l, SelectionKey selectionKey, Object object, int n) {
        Attachment attachment = (Attachment)object;
        IOErrorObserver iOErrorObserver = attachment.attachment;
        if (attachment.lastMod <= this.iteration) {
            attachment.handled = 0;
        }
        attachment.lastMod = this.iteration + 1L;
        if (selectionKey.isValid()) {
            try {
                try {
                    int n2 = ~attachment.handled;
                    int n3 = selectionKey.readyOps();
                    if ((n & n3 & n2 & 0x10) != 0) {
                        this.processAccept(l, selectionKey, (AcceptChannelObserver)iOErrorObserver, attachment);
                        Attachment attachment2 = attachment;
                        attachment2.handled = attachment2.handled | 0x10;
                    } else if ((n & n3 & n2 & 8) != 0) {
                        this.processConnect(l, selectionKey, (ConnectObserver)iOErrorObserver, attachment);
                        Attachment attachment3 = attachment;
                        attachment3.handled = attachment3.handled | 8;
                    } else {
                        if ((n & n3 & n2 & 1) != 0) {
                            this.processRead(l, (ReadObserver)iOErrorObserver, attachment);
                            Attachment attachment4 = attachment;
                            attachment4.handled = attachment4.handled | 1;
                        }
                        if ((n & n3 & n2 & 4) != 0) {
                            this.processWrite(l, (WriteObserver)iOErrorObserver, attachment);
                            Attachment attachment5 = attachment;
                            attachment5.handled = attachment5.handled | 4;
                        }
                    }
                }
                catch (CancelledKeyException cancelledKeyException) {
                    LOG.warn((Object)"Ignoring cancelled key", (Throwable)cancelledKeyException);
                }
                catch (IOException iOException) {
                    LOG.warn((Object)"IOX processing", (Throwable)iOException);
                    iOErrorObserver.handleIOException(iOException);
                }
            }
            catch (Throwable throwable) {
                ErrorService.error(throwable, "Unhandled exception while dispatching");
                this.safeCancel(selectionKey, iOErrorObserver);
            }
        } else {
            if (LOG.isErrorEnabled()) {
                LOG.error((Object)("SelectionKey cancelled for: " + iOErrorObserver));
            }
            this.safeCancel(selectionKey, iOErrorObserver);
        }
    }

    private void safeCancel(SelectionKey selectionKey, Shutdownable shutdownable) {
        try {
            this.cancel(selectionKey, shutdownable);
        }
        catch (Throwable throwable) {}
    }

    private void swapSelector() {
        Selector selector = this.primarySelector;
        Set<SelectionKey> set = Collections.EMPTY_SET;
        try {
            if (selector != null) {
                set = selector.keys();
            }
        }
        catch (ClosedSelectorException closedSelectorException) {
            LOG.warn((Object)"error getting keys", (Throwable)closedSelectorException);
        }
        try {
            this.primarySelector = Selector.open();
        }
        catch (IOException iOException) {
            LOG.error((Object)"Can't make a new selector!!!", (Throwable)iOException);
            throw new RuntimeException(iOException);
        }
        Iterator iterator = set.iterator();
        while (iterator.hasNext()) {
            try {
                SelectionKey selectionKey = (SelectionKey)iterator.next();
                SelectableChannel selectableChannel = selectionKey.channel();
                Attachment attachment = (Attachment)selectionKey.attachment();
                int n = selectionKey.interestOps();
                try {
                    SelectionKey selectionKey2 = selectableChannel.register(this.primarySelector, n, attachment);
                    attachment.setKey(selectionKey2);
                }
                catch (IOException iOException) {
                    attachment.attachment.handleIOException(iOException);
                }
            }
            catch (CancelledKeyException cancelledKeyException) {
                LOG.warn((Object)"key cancelled while swapping", (Throwable)cancelledKeyException);
            }
        }
        try {
            if (selector != null) {
                selector.close();
            }
        }
        catch (IOException iOException) {
            LOG.warn((Object)"error closing old selector", (Throwable)iOException);
        }
    }

    public void run() {
        while (true) {
            try {
                if (this.primarySelector == null) {
                    this.primarySelector = Selector.open();
                }
                this.process();
                continue;
            }
            catch (SpinningException spinningException) {
                LOG.warn((Object)"selector is spinning!", (Throwable)spinningException);
                this.swapSelector();
                continue;
            }
            catch (ProcessingException processingException) {
                LOG.warn((Object)"unknown exception while selecting", (Throwable)processingException);
                this.swapSelector();
                continue;
            }
            catch (IOException iOException) {
                LOG.error((Object)"Unable to create a new Selector!!!", (Throwable)iOException);
                throw new RuntimeException(iOException);
            }
            catch (Throwable throwable) {
                LOG.error((Object)"Error in Selector!", throwable);
                ErrorService.error(throwable);
                this.swapSelector();
                continue;
            }
            break;
        }
    }

    class Attachment
    implements Timeoutable {
        private final IOErrorObserver attachment;
        private long lastMod;
        private int handled;
        private SelectionKey key;
        private boolean timeoutActive = false;
        private long storedTimeoutLength = Long.MAX_VALUE;
        private long storedExpireTime = Long.MAX_VALUE;

        Attachment(IOErrorObserver iOErrorObserver) {
            this.attachment = iOErrorObserver;
        }

        synchronized void clearTimeout() {
            this.timeoutActive = false;
        }

        synchronized void updateReadTimeout(long l) {
            if (this.attachment instanceof ReadTimeout) {
                long l2 = ((ReadTimeout)((Object)this.attachment)).getReadTimeout();
                if (l2 != 0L) {
                    long l3 = l + l2;
                    if (l3 < this.storedExpireTime || this.storedExpireTime == -1L || this.storedExpireTime < l) {
                        this.addTimeout(l, l2);
                    } else {
                        this.storedExpireTime = l3;
                        this.storedTimeoutLength = l2;
                        this.timeoutActive = true;
                    }
                } else {
                    this.clearTimeout();
                }
            }
        }

        synchronized void changeReadStatus(boolean bl) {
            if (bl) {
                this.updateReadTimeout(System.currentTimeMillis());
            } else {
                this.clearTimeout();
            }
        }

        synchronized void addTimeout(long l, long l2) {
            this.timeoutActive = true;
            this.storedTimeoutLength = l2;
            this.storedExpireTime = l + l2;
            NIODispatcher.this.TIMEOUTER.addTimeout(this, l, l2);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void notifyTimeout(long l, long l2, long l3) {
            boolean bl = false;
            long l4 = 0L;
            Attachment attachment = this;
            synchronized (attachment) {
                if (this.timeoutActive) {
                    if (l2 == this.storedExpireTime) {
                        bl = true;
                        this.timeoutActive = false;
                        l4 = this.storedTimeoutLength;
                        this.storedExpireTime = -1L;
                    } else if (l2 < this.storedExpireTime) {
                        NIODispatcher.this.TIMEOUTER.addTimeout(this, l, this.storedExpireTime - l);
                    } else {
                        this.storedExpireTime = -1L;
                        if (LOG.isWarnEnabled()) {
                            LOG.warn((Object)("Ignoring extra timeout for: " + this.attachment));
                        }
                    }
                } else {
                    this.storedExpireTime = -1L;
                    this.storedTimeoutLength = -1L;
                }
            }
            if (bl) {
                NIODispatcher.this.cancel(this.key, this.attachment);
                this.attachment.handleIOException(new SocketTimeoutException("operation timed out (" + l4 + ")"));
            }
        }

        public void setKey(SelectionKey selectionKey) {
            this.key = selectionKey;
        }
    }

    private class RegisterOp
    implements Runnable {
        private final SelectableChannel channel;
        private final IOErrorObserver handler;
        private final int op;
        private final int timeout;

        RegisterOp(SelectableChannel selectableChannel, IOErrorObserver iOErrorObserver, int n, int n2) {
            this.channel = selectableChannel;
            this.handler = iOErrorObserver;
            this.op = n;
            this.timeout = n2;
        }

        public void run() {
            NIODispatcher.this.registerImpl(NIODispatcher.this.getSelectorFor(this.channel), this.channel, this.op, this.handler, this.timeout);
        }
    }

    private static class SpinningException
    extends Exception {
    }

    private static class ProcessingException
    extends Exception {
        public ProcessingException() {
        }

        public ProcessingException(Throwable throwable) {
            super(throwable);
        }
    }
}

