/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.io;

import com.limegroup.gnutella.io.BufferUtils;
import com.limegroup.gnutella.io.ChannelReadObserver;
import com.limegroup.gnutella.io.ChannelWriter;
import com.limegroup.gnutella.io.IOState;
import com.limegroup.gnutella.io.IOStateObserver;
import com.limegroup.gnutella.io.InterestReadChannel;
import com.limegroup.gnutella.io.InterestWriteChannel;
import com.limegroup.gnutella.io.NIODispatcher;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.ClosedChannelException;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class IOStateMachine
implements ChannelReadObserver,
ChannelWriter,
InterestReadChannel {
    private static final Log LOG;
    private IOStateObserver observer;
    private List states;
    private IOState currentState;
    private InterestWriteChannel writeSink;
    private InterestReadChannel readSink;
    private ByteBuffer readBuffer;
    private volatile boolean shutdown;
    static /* synthetic */ Class class$0;

    static {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("com.limegroup.gnutella.io.IOStateMachine");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        LOG = LogFactory.getLog((Class)clazz);
    }

    public IOStateMachine(IOStateObserver iOStateObserver, List list) {
        this(iOStateObserver, list, 2048);
    }

    public IOStateMachine(IOStateObserver iOStateObserver, List list, int n) {
        this.observer = iOStateObserver;
        this.states = list;
        this.readBuffer = NIODispatcher.instance().getBufferCache().getHeap(n);
        if (!list.isEmpty()) {
            this.currentState = (IOState)list.remove(0);
        }
    }

    public void addState(final IOState iOState) {
        NIODispatcher.instance().invokeLater(new Runnable(){

            public void run() {
                if (LOG.isDebugEnabled()) {
                    LOG.debug((Object)("Adding single state: " + iOState));
                }
                IOStateMachine.this.states.add(iOState);
                if (IOStateMachine.this.states.size() == 1) {
                    IOStateMachine.this.nextState(false, false);
                }
            }
        });
    }

    public void addStates(final List list) {
        NIODispatcher.instance().invokeLater(new Runnable(){

            public void run() {
                if (LOG.isDebugEnabled()) {
                    LOG.debug((Object)("Adding multiple states: " + list));
                }
                IOStateMachine.this.states.addAll(list);
                if (IOStateMachine.this.states.size() == list.size()) {
                    IOStateMachine.this.nextState(false, false);
                }
            }
        });
    }

    public void addStates(final IOState[] iOStateArray) {
        NIODispatcher.instance().invokeLater(new Runnable(){

            public void run() {
                if (LOG.isDebugEnabled()) {
                    LOG.debug((Object)"Adding multiple states...");
                }
                int n = 0;
                while (n < iOStateArray.length) {
                    if (LOG.isDebugEnabled()) {
                        LOG.debug((Object)(" state[" + n + "]: " + iOStateArray[n]));
                    }
                    IOStateMachine.this.states.add(iOStateArray[n]);
                    ++n;
                }
                if (IOStateMachine.this.states.size() == iOStateArray.length) {
                    IOStateMachine.this.nextState(false, false);
                }
            }
        });
    }

    public void handleRead() {
        if (this.currentState != null) {
            if (this.currentState.isWriting()) {
                LOG.warn((Object)"Got a read notification while writing.");
                this.processCurrentState(null, true);
                this.readSink.interest(false);
            } else {
                this.processCurrentState(this.currentState, true);
            }
        } else {
            LOG.warn((Object)"Got a read notification with no current state");
            this.processCurrentState(null, true);
            this.readSink.interest(false);
        }
    }

    public boolean handleWrite() {
        if (this.currentState != null) {
            if (this.currentState.isReading()) {
                LOG.warn((Object)"Got a write notification while reading");
                this.writeSink.interest(this, false);
                return false;
            }
            return this.processCurrentState(this.currentState, false);
        }
        LOG.warn((Object)"Got a write notification with no current state");
        this.writeSink.interest(this, false);
        return false;
    }

    private boolean processCurrentState(IOState iOState, boolean bl) {
        block15: {
            if (!this.shutdown) {
                try {
                    if (bl) {
                        if (iOState == null) {
                            if (LOG.isDebugEnabled()) {
                                LOG.debug((Object)"Processing a read with no state");
                            }
                            while (this.readBuffer.hasRemaining() && this.readSink.read(this.readBuffer) > 0) {
                            }
                        } else if (!iOState.process(this.readSink, this.readBuffer)) {
                            this.nextState(true, false);
                        }
                        break block15;
                    }
                    if (!iOState.process(this.writeSink, null)) {
                        this.nextState(false, true);
                        break block15;
                    }
                    return true;
                }
                catch (IOException iOException) {
                    if (LOG.isWarnEnabled()) {
                        LOG.warn((Object)("IOX while processing state: " + iOState), (Throwable)iOException);
                    }
                    this.shutdown = true;
                    try {
                        this.close();
                    }
                    catch (IOException iOException2) {}
                    NIODispatcher.instance().getBufferCache().release(this.readBuffer);
                    this.observer.handleIOException(iOException);
                }
            } else if (LOG.isDebugEnabled()) {
                LOG.debug((Object)"Ignoring processing because machine is shutdown");
            }
        }
        return false;
    }

    private void nextState(boolean bl, boolean bl2) {
        if (this.states.isEmpty()) {
            LOG.debug((Object)"No more states, processing finished.");
            this.readSink.interest(false);
            this.writeSink.interest(this, false);
            this.observer.handleStatesFinished();
        } else {
            this.currentState = (IOState)this.states.remove(0);
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("Incrementing state to: " + this.currentState));
            }
            if (this.currentState.isReading() && !bl) {
                this.writeSink.interest(this, false);
                if (this.readSink != null) {
                    this.readSink.interest(true);
                }
            }
            if (this.currentState.isWriting() && !bl2) {
                this.readSink.interest(false);
                if (this.writeSink != null) {
                    this.writeSink.interest(this, true);
                }
            }
            if (this.currentState.isReading()) {
                this.processCurrentState(this.currentState, true);
            }
        }
    }

    public InterestWriteChannel getWriteChannel() {
        return this.writeSink;
    }

    public void setWriteChannel(InterestWriteChannel interestWriteChannel) {
        this.writeSink = interestWriteChannel;
        if (this.currentState != null) {
            this.writeSink.interest(this, true);
        }
    }

    public InterestReadChannel getReadChannel() {
        return this.readSink;
    }

    public void setReadChannel(InterestReadChannel interestReadChannel) {
        this.readSink = interestReadChannel;
        if (this.currentState != null) {
            this.readSink.interest(true);
        }
    }

    public boolean isOpen() {
        return this.readSink.isOpen() && this.writeSink.isOpen();
    }

    public void close() throws IOException {
        this.readSink.close();
        this.writeSink.close();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void shutdown() {
        IOStateMachine iOStateMachine = this;
        synchronized (iOStateMachine) {
            if (this.shutdown) {
                return;
            }
            this.shutdown = true;
        }
        if (!this.isOpen()) {
            this.observer.shutdown();
        }
        NIODispatcher.instance().invokeLater(new Runnable(){

            public void run() {
                NIODispatcher.instance().getBufferCache().release(IOStateMachine.this.readBuffer);
            }
        });
    }

    public void interest(boolean bl) {
        if (this.currentState != null) {
            this.readSink.interest(bl);
        }
    }

    public int read(ByteBuffer byteBuffer) throws ClosedChannelException {
        if (this.shutdown) {
            throw new ClosedChannelException();
        }
        return BufferUtils.transfer(this.readBuffer, byteBuffer);
    }

    public void handleIOException(IOException iOException) {
    }
}

