/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.io;

import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;

public class HeapByteBufferCache {
    private final TreeMap CACHE = new TreeMap();
    private final Map SLICED = new IdentityHashMap();

    public ByteBuffer get() {
        return this.get(8192);
    }

    public synchronized ByteBuffer get(int n) {
        if (this.CACHE.isEmpty()) {
            ByteBuffer byteBuffer = ByteBuffer.allocate(n);
            return byteBuffer;
        }
        Integer n2 = new Integer(n);
        List list = (List)this.CACHE.get(n2);
        if (list != null) {
            if (list.isEmpty()) {
                return ByteBuffer.allocate(n);
            }
            return (ByteBuffer)list.remove(list.size() - 1);
        }
        Comparable comparable = (Comparable)this.CACHE.lastKey();
        if (comparable.compareTo(n2) < 0) {
            return ByteBuffer.allocate(n);
        }
        ByteBuffer byteBuffer = null;
        Object object = this.CACHE.entrySet().iterator();
        while (object.hasNext()) {
            Map.Entry entry = object.next();
            if (n2.compareTo(entry.getKey()) > 0 || (list = (List)entry.getValue()).isEmpty()) continue;
            byteBuffer = (ByteBuffer)list.remove(list.size() - 1);
            break;
        }
        if (byteBuffer == null) {
            return ByteBuffer.allocate(n);
        }
        byteBuffer.limit(n);
        object = byteBuffer.slice();
        this.SLICED.put(object, byteBuffer);
        return object;
    }

    public synchronized void put(ByteBuffer byteBuffer) {
        ByteBuffer byteBuffer2 = (ByteBuffer)this.SLICED.remove(byteBuffer);
        if (byteBuffer2 == null) {
            byteBuffer2 = byteBuffer;
        }
        byteBuffer2.clear();
        Integer n = new Integer(byteBuffer2.capacity());
        ArrayList<ByteBuffer> arrayList = (ArrayList<ByteBuffer>)this.CACHE.get(n);
        if (arrayList == null) {
            arrayList = new ArrayList<ByteBuffer>(1);
            this.CACHE.put(n, arrayList);
        }
        arrayList.add(byteBuffer2);
    }

    public synchronized void clear() {
        this.CACHE.clear();
    }
}

