/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.io;

import com.limegroup.gnutella.io.DirectByteBufferCache;
import com.limegroup.gnutella.io.HeapByteBufferCache;
import java.nio.ByteBuffer;

public class ByteBufferCache {
    private final DirectByteBufferCache DIRECT = new DirectByteBufferCache();
    private final HeapByteBufferCache HEAP = new HeapByteBufferCache();

    public ByteBuffer getDirect() {
        return this.DIRECT.get();
    }

    public ByteBuffer getHeap() {
        return this.HEAP.get();
    }

    public ByteBuffer getHeap(int n) {
        return this.HEAP.get(n);
    }

    public void release(ByteBuffer byteBuffer) {
        if (byteBuffer.isDirect()) {
            this.DIRECT.put(byteBuffer);
        } else {
            this.HEAP.put(byteBuffer);
        }
    }

    public void clearCache() {
        this.DIRECT.clear();
        this.HEAP.clear();
    }
}

