/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.io;

import com.limegroup.gnutella.io.InterestReadChannel;
import com.limegroup.gnutella.io.InterruptedIOException;
import com.limegroup.gnutella.io.ReadTimeout;
import com.limegroup.gnutella.io.Shutdownable;
import java.io.IOException;
import java.io.InputStream;
import java.net.SocketException;
import java.nio.ByteBuffer;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

class BufferInputStream
extends InputStream
implements Shutdownable {
    private static final Log LOG;
    private final Object LOCK = new Object();
    private final Shutdownable shutdownHandler;
    private final ReadTimeout readTimeoutHandler;
    private final ByteBuffer buffer;
    private InterestReadChannel channel;
    private boolean shutdown = false;
    private boolean finished = false;
    static /* synthetic */ Class class$0;

    static {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("com.limegroup.gnutella.io.BufferInputStream");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        LOG = LogFactory.getLog((Class)clazz);
    }

    BufferInputStream(ByteBuffer byteBuffer, ReadTimeout readTimeout, Shutdownable shutdownable, InterestReadChannel interestReadChannel) {
        this.readTimeoutHandler = readTimeout;
        this.shutdownHandler = shutdownable;
        this.buffer = byteBuffer;
        this.channel = interestReadChannel;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void setReadChannel(InterestReadChannel interestReadChannel) {
        Object object = this.LOCK;
        synchronized (object) {
            this.channel = interestReadChannel;
        }
    }

    Object getBufferLock() {
        return this.LOCK;
    }

    void finished() {
        this.finished = true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int read() throws IOException {
        Object object = this.LOCK;
        synchronized (object) {
            block4: {
                this.waitImpl();
                if (!this.finished || this.buffer.position() != 0) break block4;
                return -1;
            }
            this.buffer.flip();
            byte by = this.buffer.get();
            this.buffer.compact();
            this.channel.interest(true);
            return by & 0xFF;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int read(byte[] byArray, int n, int n2) throws IOException {
        if (n2 == 0) {
            return 0;
        }
        Object object = this.LOCK;
        synchronized (object) {
            block7: {
                this.waitImpl();
                if (!this.finished || this.buffer.position() != 0) break block7;
                return -1;
            }
            this.buffer.flip();
            int n3 = Math.min(this.buffer.remaining(), n2);
            this.buffer.get(byArray, n, n3);
            if (this.buffer.hasRemaining()) {
                this.buffer.compact();
            } else {
                this.buffer.clear();
            }
            this.channel.interest(true);
            return n3;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int available() throws IOException {
        Object object = this.LOCK;
        synchronized (object) {
            return this.buffer.position();
        }
    }

    private void waitImpl() throws IOException {
        long l = this.readTimeoutHandler.getReadTimeout();
        if (l == -1L) {
            throw new SocketException("unable to get read timeout");
        }
        boolean bl = false;
        while (this.buffer.position() == 0 && !this.finished) {
            if (this.shutdown) {
                throw new IOException("socket closed");
            }
            if (bl && l != 0L) {
                throw new java.io.InterruptedIOException("read timed out (" + l + ")");
            }
            try {
                this.LOCK.wait(l);
            }
            catch (InterruptedException interruptedException) {
                throw new InterruptedIOException(interruptedException);
            }
            bl = true;
        }
        if (this.shutdown) {
            throw new IOException("socket closed");
        }
    }

    public void close() throws IOException {
        this.shutdownHandler.shutdown();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void shutdown() {
        Object object = this.LOCK;
        synchronized (object) {
            this.shutdown = true;
            this.LOCK.notify();
        }
    }
}

