/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.http;

import com.limegroup.gnutella.http.HTTPHeaderName;
import com.limegroup.gnutella.http.HTTPHeaderValue;
import com.limegroup.gnutella.http.HTTPUtils;
import com.limegroup.gnutella.http.WriteHeadersIOState;
import com.limegroup.gnutella.statistics.Statistic;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.Iterator;
import java.util.Map;

public class SimpleWriteHeaderState
extends WriteHeadersIOState {
    private final String connectLine;
    private final Map headers;

    public SimpleWriteHeaderState(String string, Map map, Statistic statistic) {
        super(statistic);
        this.connectLine = string;
        this.headers = map;
    }

    protected ByteBuffer createOutgoingData() throws IOException {
        StringBuffer stringBuffer = new StringBuffer(this.connectLine.length() + this.headers.size() * 25);
        stringBuffer.append(this.connectLine).append("\r\n");
        Iterator iterator = this.headers.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry entry = iterator.next();
            Object k = entry.getKey();
            Object v = entry.getValue();
            if (k instanceof String && v instanceof String) {
                stringBuffer.append(HTTPUtils.createHeader((String)k, (String)v));
                continue;
            }
            if (k instanceof HTTPHeaderName && v instanceof String) {
                stringBuffer.append(HTTPUtils.createHeader((HTTPHeaderName)k, (String)v));
                continue;
            }
            if (k instanceof HTTPHeaderName && v instanceof HTTPHeaderValue) {
                stringBuffer.append(HTTPUtils.createHeader((HTTPHeaderName)k, (HTTPHeaderValue)v));
                continue;
            }
            if (k instanceof String && v instanceof HTTPHeaderValue) {
                stringBuffer.append(HTTPUtils.createHeader((String)k, (HTTPHeaderValue)v));
                continue;
            }
            throw new IllegalArgumentException("bad header: " + k + ", value: " + v);
        }
        stringBuffer.append("\r\n");
        return ByteBuffer.wrap(stringBuffer.toString().getBytes());
    }

    protected void processWrittenHeaders() throws IOException {
    }
}

