/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.http;

import com.limegroup.gnutella.RouterService;
import com.limegroup.gnutella.UDPService;
import com.limegroup.gnutella.http.ConstantHTTPHeaderValue;
import com.limegroup.gnutella.http.HTTPHeaderName;
import com.limegroup.gnutella.http.HTTPHeaderValue;
import com.limegroup.gnutella.http.HTTPHeaderValueCollection;
import com.limegroup.gnutella.http.ProblemReadingHeaderException;
import com.limegroup.gnutella.settings.ChatSettings;
import com.limegroup.gnutella.statistics.BandwidthStat;
import com.limegroup.gnutella.util.StringUtils;
import java.io.IOException;
import java.io.OutputStream;
import java.io.Writer;
import java.net.URLEncoder;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashSet;
import java.util.Locale;
import java.util.Set;
import java.util.TimeZone;

public final class HTTPUtils {
    private static final String CRLF = "\r\n";
    private static final String COLON_SPACE = ": ";
    private static final String COLON = ":";
    private static final String SLASH = "/";

    private HTTPUtils() {
    }

    public static void writeHeader(HTTPHeaderName hTTPHeaderName, String string, OutputStream outputStream) throws IOException {
        if (hTTPHeaderName == null) {
            throw new NullPointerException("null name in writing http header");
        }
        if (string == null) {
            throw new NullPointerException("null value in writing http header: " + hTTPHeaderName);
        }
        if (outputStream == null) {
            throw new NullPointerException("null os in writing http header: " + hTTPHeaderName);
        }
        String string2 = HTTPUtils.createHeader(hTTPHeaderName, string);
        outputStream.write(string2.getBytes());
        BandwidthStat.HTTP_HEADER_UPSTREAM_BANDWIDTH.addData(string2.length());
    }

    public static void writeHeader(HTTPHeaderName hTTPHeaderName, String string, Writer writer) throws IOException {
        if (hTTPHeaderName == null) {
            throw new NullPointerException("null name in writing http header");
        }
        if (string == null) {
            throw new NullPointerException("null value in writing http header: " + hTTPHeaderName);
        }
        if (writer == null) {
            throw new NullPointerException("null os in writing http header: " + hTTPHeaderName);
        }
        String string2 = HTTPUtils.createHeader(hTTPHeaderName, string);
        writer.write(string2);
        BandwidthStat.HTTP_HEADER_UPSTREAM_BANDWIDTH.addData(string2.length());
    }

    public static void writeHeader(HTTPHeaderName hTTPHeaderName, HTTPHeaderValue hTTPHeaderValue, OutputStream outputStream) throws IOException {
        if (hTTPHeaderName == null) {
            throw new NullPointerException("null name in writing http header");
        }
        if (hTTPHeaderValue == null) {
            throw new NullPointerException("null value in writing http header: " + hTTPHeaderName);
        }
        if (outputStream == null) {
            throw new NullPointerException("null os in writing http header: " + hTTPHeaderName);
        }
        String string = HTTPUtils.createHeader(hTTPHeaderName, hTTPHeaderValue.httpStringValue());
        outputStream.write(string.getBytes());
        BandwidthStat.HTTP_HEADER_UPSTREAM_BANDWIDTH.addData(string.length());
    }

    public static void writeHeader(HTTPHeaderName hTTPHeaderName, HTTPHeaderValue hTTPHeaderValue, Writer writer) throws IOException {
        if (hTTPHeaderName == null) {
            throw new NullPointerException("null name in writing http header");
        }
        if (hTTPHeaderValue == null) {
            throw new NullPointerException("null value in writing http header: " + hTTPHeaderName);
        }
        if (writer == null) {
            throw new NullPointerException("null os in writing http header: " + hTTPHeaderName);
        }
        String string = HTTPUtils.createHeader(hTTPHeaderName, hTTPHeaderValue.httpStringValue());
        writer.write(string);
        BandwidthStat.HTTP_HEADER_UPSTREAM_BANDWIDTH.addData(string.length());
    }

    public static String createHeader(HTTPHeaderName hTTPHeaderName, HTTPHeaderValue hTTPHeaderValue) {
        return HTTPUtils.createHeader(hTTPHeaderName.httpStringValue(), hTTPHeaderValue.httpStringValue());
    }

    public static String createHeader(HTTPHeaderName hTTPHeaderName, String string) {
        return HTTPUtils.createHeader(hTTPHeaderName.httpStringValue(), string);
    }

    public static String createHeader(String string, HTTPHeaderValue hTTPHeaderValue) {
        return HTTPUtils.createHeader(string, hTTPHeaderValue.httpStringValue());
    }

    public static String createHeader(String string, String string2) {
        StringBuffer stringBuffer = new StringBuffer(string.length() + string2.length() + 4);
        return stringBuffer.append(string).append(COLON_SPACE).append(string2).append(CRLF).toString();
    }

    public static String extractHeaderValue(String string) {
        int n = string.indexOf(COLON);
        if (n <= 0) {
            return null;
        }
        return string.substring(n + 1).trim();
    }

    public static void writeHeader(HTTPHeaderName hTTPHeaderName, int n, Writer writer) throws IOException {
        HTTPUtils.writeHeader(hTTPHeaderName, String.valueOf(n), writer);
    }

    public static void writeHeader(HTTPHeaderName hTTPHeaderName, int n, OutputStream outputStream) throws IOException {
        HTTPUtils.writeHeader(hTTPHeaderName, String.valueOf(n), outputStream);
    }

    public static void writeContentDisposition(String string, Writer writer) throws IOException {
        HTTPUtils.writeHeader(HTTPHeaderName.CONTENT_DISPOSITION, "attachment; filename=\"" + HTTPUtils.encode(string, "US-ASCII") + "\"", writer);
    }

    public static void writeDate(Writer writer) throws IOException {
        HTTPUtils.writeHeader(HTTPHeaderName.DATE, HTTPUtils.getDateValue(), writer);
    }

    public static void writeDate(OutputStream outputStream) throws IOException {
        HTTPUtils.writeHeader(HTTPHeaderName.DATE, HTTPUtils.getDateValue(), outputStream);
    }

    public static void writeFeatures(Writer writer) throws IOException {
        Set set = HTTPUtils.getFeaturesValue();
        if (set.size() > 0) {
            HTTPUtils.writeHeader(HTTPHeaderName.FEATURES, (HTTPHeaderValue)new HTTPHeaderValueCollection(set), writer);
        }
    }

    public static void writeFeatures(OutputStream outputStream) throws IOException {
        Set set = HTTPUtils.getFeaturesValue();
        if (set.size() > 0) {
            HTTPUtils.writeHeader(HTTPHeaderName.FEATURES, (HTTPHeaderValue)new HTTPHeaderValueCollection(set), outputStream);
        }
    }

    private static Set getFeaturesValue() {
        HashSet<HTTPHeaderValue> hashSet = new HashSet<HTTPHeaderValue>(4);
        hashSet.add(ConstantHTTPHeaderValue.BROWSE_FEATURE);
        if (ChatSettings.CHAT_ENABLED.getValue()) {
            hashSet.add(ConstantHTTPHeaderValue.CHAT_FEATURE);
        }
        hashSet.add(ConstantHTTPHeaderValue.PUSH_LOCS_FEATURE);
        if (!RouterService.acceptedIncomingConnection() && UDPService.instance().canDoFWT()) {
            hashSet.add(ConstantHTTPHeaderValue.FWT_PUSH_LOCS_FEATURE);
        }
        return hashSet;
    }

    public static float parseFeatureToken(String string) throws ProblemReadingHeaderException {
        int n = string.indexOf(SLASH);
        if (n == -1 || n >= string.length() - 1) {
            throw new ProblemReadingHeaderException("invalid feature token");
        }
        String string2 = string.substring(n + 1);
        try {
            return Float.parseFloat(string2);
        }
        catch (NumberFormatException numberFormatException) {
            throw new ProblemReadingHeaderException(numberFormatException);
        }
    }

    private static String getDateValue() {
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat("EEE, d MMM yyyy HH:mm:ss z", Locale.US);
        simpleDateFormat.setTimeZone(TimeZone.getTimeZone("GMT"));
        return simpleDateFormat.format(new Date());
    }

    private static String encode(String string, String string2) throws IOException {
        return StringUtils.replace(URLEncoder.encode(string, string2), "+", "%20");
    }
}

