/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.handshaking;

import com.limegroup.gnutella.RouterService;
import com.limegroup.gnutella.handshaking.DefaultHandshakeResponder;
import com.limegroup.gnutella.handshaking.HandshakeResponse;
import com.limegroup.gnutella.handshaking.HandshakeStatus;
import com.limegroup.gnutella.handshaking.HeaderNames;
import com.limegroup.gnutella.handshaking.UltrapeerHeaders;
import com.limegroup.gnutella.statistics.HandshakingStat;
import com.limegroup.gnutella.util.NetworkUtils;
import java.util.Properties;

public class UltrapeerHandshakeResponder
extends DefaultHandshakeResponder {
    public UltrapeerHandshakeResponder(String string) {
        super(string);
    }

    protected HandshakeResponse respondToOutgoing(HandshakeResponse handshakeResponse) {
        HandshakeStatus handshakeStatus = this._manager.allowConnection(handshakeResponse);
        if (!handshakeStatus.isAcceptable()) {
            HandshakingStat.UP_OUTGOING_REJECT_FULL.incrementStat();
            return HandshakeResponse.createRejectOutgoingResponse(handshakeStatus);
        }
        Properties properties = new Properties();
        if (handshakeResponse.hasLeafGuidance()) {
            if (this._manager.allowLeafDemotion() && handshakeResponse.isGoodUltrapeer()) {
                HandshakingStat.UP_OUTGOING_GUIDANCE_FOLLOWED.incrementStat();
                properties.put("X-Ultrapeer", "False");
            } else {
                HandshakingStat.UP_OUTGOING_GUIDANCE_IGNORED.incrementStat();
            }
        } else {
            HandshakingStat.UP_OUTGOING_ACCEPT.incrementStat();
        }
        if (handshakeResponse.isDeflateAccepted()) {
            properties.put(HeaderNames.CONTENT_ENCODING, HeaderNames.DEFLATE_VALUE);
        }
        return HandshakeResponse.createAcceptOutgoingResponse(properties);
    }

    protected HandshakeResponse respondToIncoming(HandshakeResponse handshakeResponse) {
        if (handshakeResponse.isCrawler()) {
            HandshakingStat.INCOMING_CRAWLER.incrementStat();
            return HandshakeResponse.createCrawlerResponse();
        }
        UltrapeerHeaders ultrapeerHeaders = new UltrapeerHeaders(this.getRemoteIP());
        ultrapeerHeaders.put("Listen-IP", String.valueOf(NetworkUtils.ip2string(RouterService.getAddress())) + ":" + RouterService.getPort());
        HandshakeStatus handshakeStatus = this.reject(handshakeResponse, ultrapeerHeaders);
        if (!handshakeStatus.isAcceptable()) {
            return HandshakeResponse.createUltrapeerRejectIncomingResponse(handshakeResponse, handshakeStatus);
        }
        if (handshakeResponse.isDeflateAccepted()) {
            ultrapeerHeaders.put(HeaderNames.CONTENT_ENCODING, HeaderNames.DEFLATE_VALUE);
        }
        return HandshakeResponse.createAcceptIncomingResponse(handshakeResponse, ultrapeerHeaders);
    }

    private HandshakeStatus reject(HandshakeResponse handshakeResponse, Properties properties) {
        HandshakeStatus handshakeStatus = this._manager.allowConnectionAsLeaf(handshakeResponse);
        boolean bl = handshakeStatus.isAcceptable();
        if (handshakeResponse.isLeaf()) {
            if (!bl) {
                HandshakingStat.UP_INCOMING_REJECT_LEAF.incrementStat();
            } else {
                HandshakingStat.UP_INCOMING_ACCEPT_LEAF.incrementStat();
            }
            return handshakeStatus;
        }
        boolean bl2 = this._manager.supernodeNeeded();
        if (bl && !bl2) {
            HandshakingStat.UP_INCOMING_GUIDED.incrementStat();
            properties.put("X-Ultrapeer-Needed", Boolean.FALSE.toString());
            return HandshakeStatus.OK;
        }
        HandshakeStatus handshakeStatus2 = this._manager.allowConnection(handshakeResponse);
        boolean bl3 = handshakeStatus2.isAcceptable();
        if (bl3) {
            HandshakingStat.UP_INCOMING_ACCEPT_UP.incrementStat();
            properties.put("X-Ultrapeer-Needed", Boolean.TRUE.toString());
            return handshakeStatus2;
        }
        if (!bl) {
            HandshakingStat.UP_INCOMING_REJECT_NO_ROOM_LEAF.incrementStat();
            return handshakeStatus;
        }
        HandshakingStat.UP_INCOMING_REJECT_NO_ROOM_UP.incrementStat();
        return handshakeStatus2;
    }
}

