/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.handshaking;

import com.limegroup.gnutella.handshaking.HandshakeObserver;
import com.limegroup.gnutella.handshaking.HandshakeResponder;
import com.limegroup.gnutella.handshaking.HandshakeResponse;
import com.limegroup.gnutella.handshaking.HandshakeState;
import com.limegroup.gnutella.handshaking.HandshakeSupport;
import com.limegroup.gnutella.handshaking.Handshaker;
import com.limegroup.gnutella.handshaking.NoGnutellaOkException;
import com.limegroup.gnutella.io.IOStateMachine;
import com.limegroup.gnutella.io.IOStateObserver;
import com.limegroup.gnutella.io.NIOMultiplexor;
import java.io.IOException;
import java.net.Socket;
import java.net.SocketException;
import java.util.List;
import java.util.Properties;

public class AsyncOutgoingHandshaker
implements Handshaker,
IOStateObserver {
    private final HandshakeSupport support;
    private final IOStateMachine shaker;
    private final Socket socket;
    private final HandshakeObserver observer;

    public AsyncOutgoingHandshaker(Properties properties, HandshakeResponder handshakeResponder, Socket socket, HandshakeObserver handshakeObserver) {
        this.socket = socket;
        this.support = new HandshakeSupport(socket.getInetAddress().getHostAddress());
        List list = HandshakeState.getOutgoingHandshakeStates(this.support, properties, handshakeResponder);
        this.shaker = new IOStateMachine(this, list);
        this.observer = handshakeObserver;
    }

    public void shake() throws SocketException {
        this.socket.setSoTimeout(8000);
        ((NIOMultiplexor)((Object)this.socket)).setReadObserver(this.shaker);
        ((NIOMultiplexor)((Object)this.socket)).setWriteObserver(this.shaker);
    }

    public HandshakeResponse getWrittenHeaders() {
        return this.support.getWrittenHandshakeResponse();
    }

    public HandshakeResponse getReadHeaders() {
        return this.support.getReadHandshakeResponse();
    }

    public void handleStatesFinished() {
        this.observer.handleHandshakeFinished(this);
    }

    public void handleIOException(IOException iOException) {
        if (iOException instanceof NoGnutellaOkException) {
            NoGnutellaOkException noGnutellaOkException = (NoGnutellaOkException)iOException;
            this.observer.handleNoGnutellaOk(noGnutellaOkException.getCode(), noGnutellaOkException.getMessage());
        } else {
            this.observer.handleBadHandshake();
        }
    }

    public void shutdown() {
        this.observer.handleBadHandshake();
    }
}

