/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.downloader;

import com.limegroup.gnutella.downloader.Interval;
import com.limegroup.gnutella.downloader.SelectionStrategy;
import com.limegroup.gnutella.util.IntervalSet;
import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.Random;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class RandomDownloadStrategy
implements SelectionStrategy {
    private static final Log LOG;
    private static final int MAX_FRAGMENTS = 16;
    protected static Random pseudoRandom;
    protected final long completedSize;
    static /* synthetic */ Class class$0;

    static {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("com.limegroup.gnutella.downloader.RandomDownloadStrategy");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        LOG = LogFactory.getLog((Class)clazz);
        pseudoRandom = new Random();
    }

    public RandomDownloadStrategy(long l) {
        this.completedSize = l;
    }

    public Interval pickAssignment(IntervalSet intervalSet, IntervalSet intervalSet2, long l) throws NoSuchElementException {
        long l2 = intervalSet2.getFirst().low;
        long l3 = intervalSet2.getLast().high;
        if (l < 1L) {
            throw new IllegalArgumentException("Block size cannot be " + l);
        }
        if (l2 < 0L) {
            throw new IllegalArgumentException("lowerBound must be >= 0, " + l2 + "<0");
        }
        if (l3 >= this.completedSize) {
            throw new IllegalArgumentException("Greatest needed byte must be less than completedSize " + l3 + " >= " + this.completedSize);
        }
        if (intervalSet.isEmpty()) {
            throw new NoSuchElementException();
        }
        long l4 = this.getIdealLocation(intervalSet2, l);
        Iterator iterator = intervalSet.getAllIntervals();
        Interval interval = null;
        Interval interval2 = null;
        while (iterator.hasNext()) {
            Interval interval3 = (Interval)iterator.next();
            if ((long)interval3.low < l4) {
                interval2 = this.optimizeIntervalBelow(interval3, l4, l);
            }
            if ((long)interval3.high < l4) continue;
            interval = this.optimizeIntervalAbove(interval3, l4, l);
            break;
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("idealLocation=" + l4 + " intervalAbove=" + interval + " intervalBelow=" + interval2 + " out of possibilites:" + intervalSet));
        }
        if (interval == null) {
            return interval2;
        }
        if (interval2 == null) {
            return interval;
        }
        return (pseudoRandom.nextInt() & 1) == 1 ? interval : interval2;
    }

    protected long alignHigh(long l, long l2) {
        l += l2;
        l -= l % l2;
        return l - 1L;
    }

    protected long alignLow(long l, long l2) {
        l -= l % l2;
        return l;
    }

    private long getIdealLocation(IntervalSet intervalSet, long l) {
        int n = intervalSet.getNumberOfIntervals();
        if (n >= 16) {
            int n2 = pseudoRandom.nextInt(n + 1);
            if (n2 == n) {
                return intervalSet.getLast().high + 1;
            }
            return ((Interval)intervalSet.getAllIntervalsAsList().get((int)n2)).low;
        }
        return this.getRandomLocation(intervalSet.getFirst().low, intervalSet.getLast().high, l);
    }

    private Interval optimizeIntervalAbove(Interval interval, long l, long l2) {
        long l3;
        long l4 = interval.low;
        if (l4 < l) {
            l4 = l;
        }
        if ((l3 = this.alignHigh(l4, l2)) > (long)interval.high) {
            l3 = interval.high;
        }
        if ((long)interval.high == l3 && (long)interval.low == l4) {
            return interval;
        }
        return new Interval(l4, l3);
    }

    private Interval optimizeIntervalBelow(Interval interval, long l, long l2) {
        long l3;
        long l4 = interval.high;
        if (l4 >= l) {
            l4 = l - 1L;
        }
        if ((l3 = this.alignLow(l4, l2)) < (long)interval.low) {
            l3 = interval.low;
        }
        if ((long)interval.high == l4 && (long)interval.low == l3) {
            return interval;
        }
        return new Interval(l3, l4);
    }

    private long getRandomLocation(long l, long l2, long l3) {
        long l4 = l / l3;
        long l5 = l2 / l3;
        if (l4 >= l5) {
            return l;
        }
        return l3 * (l4 + Math.abs(pseudoRandom.nextLong() % (l5 - l4 + 1L)));
    }
}

