/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.downloader;

import com.limegroup.gnutella.Assert;
import com.limegroup.gnutella.AssertFailure;
import com.limegroup.gnutella.BandwidthTracker;
import com.limegroup.gnutella.BandwidthTrackerImpl;
import com.limegroup.gnutella.CreationTimeCache;
import com.limegroup.gnutella.InsufficientDataException;
import com.limegroup.gnutella.PushEndpoint;
import com.limegroup.gnutella.PushEndpointForSelf;
import com.limegroup.gnutella.RemoteFileDesc;
import com.limegroup.gnutella.RouterService;
import com.limegroup.gnutella.UDPService;
import com.limegroup.gnutella.URN;
import com.limegroup.gnutella.altlocs.AlternateLocation;
import com.limegroup.gnutella.altlocs.DirectAltLoc;
import com.limegroup.gnutella.altlocs.PushAltLoc;
import com.limegroup.gnutella.downloader.ConnectionStatus;
import com.limegroup.gnutella.downloader.ContentUrnMismatchException;
import com.limegroup.gnutella.downloader.FileNotFoundException;
import com.limegroup.gnutella.downloader.Interval;
import com.limegroup.gnutella.downloader.ManagedDownloader;
import com.limegroup.gnutella.downloader.NoHTTPOKException;
import com.limegroup.gnutella.downloader.NotSharingException;
import com.limegroup.gnutella.downloader.QueuedException;
import com.limegroup.gnutella.downloader.RangeNotAvailableException;
import com.limegroup.gnutella.downloader.TryAgainLaterException;
import com.limegroup.gnutella.downloader.UnknownCodeException;
import com.limegroup.gnutella.downloader.VerifyingFile;
import com.limegroup.gnutella.http.ConstantHTTPHeaderValue;
import com.limegroup.gnutella.http.HTTPHeaderName;
import com.limegroup.gnutella.http.HTTPHeaderValue;
import com.limegroup.gnutella.http.HTTPHeaderValueCollection;
import com.limegroup.gnutella.http.HTTPUtils;
import com.limegroup.gnutella.http.ProblemReadingHeaderException;
import com.limegroup.gnutella.http.SimpleReadHeaderState;
import com.limegroup.gnutella.http.SimpleWriteHeaderState;
import com.limegroup.gnutella.io.IOState;
import com.limegroup.gnutella.io.IOStateMachine;
import com.limegroup.gnutella.io.IOStateObserver;
import com.limegroup.gnutella.io.InterestReadChannel;
import com.limegroup.gnutella.io.NBThrottle;
import com.limegroup.gnutella.io.NIOMultiplexor;
import com.limegroup.gnutella.io.ReadSkipState;
import com.limegroup.gnutella.io.ReadState;
import com.limegroup.gnutella.io.Throttle;
import com.limegroup.gnutella.io.ThrottleReader;
import com.limegroup.gnutella.settings.ChatSettings;
import com.limegroup.gnutella.settings.ConnectionSettings;
import com.limegroup.gnutella.settings.DownloadSettings;
import com.limegroup.gnutella.settings.UploadSettings;
import com.limegroup.gnutella.statistics.BandwidthStat;
import com.limegroup.gnutella.statistics.DownloadStat;
import com.limegroup.gnutella.statistics.NumericalDownloadStat;
import com.limegroup.gnutella.tigertree.HashTree;
import com.limegroup.gnutella.tigertree.ThexReader;
import com.limegroup.gnutella.util.CommonUtils;
import com.limegroup.gnutella.util.IOUtils;
import com.limegroup.gnutella.util.IntervalSet;
import com.limegroup.gnutella.util.IpPortImpl;
import com.limegroup.gnutella.util.NetworkUtils;
import com.limegroup.gnutella.util.Sockets;
import java.io.IOException;
import java.net.InetAddress;
import java.net.Socket;
import java.net.SocketException;
import java.nio.ByteBuffer;
import java.nio.channels.ReadableByteChannel;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Properties;
import java.util.Set;
import java.util.StringTokenizer;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class HTTPDownloader
implements BandwidthTracker {
    private static final Log LOG;
    public static final int BUF_LENGTH = 2048;
    private static final int MIN_RETRY_AFTER = 60;
    private static final int MAX_RETRY_AFTER = 3600;
    static int MIN_PARTIAL_FILE_BYTES;
    private static final Throttle THROTTLE;
    private RemoteFileDesc _rfd;
    private long _index;
    private String _filename;
    private byte[] _guid;
    private int _totalAmountRead;
    private int _amountRead;
    private int _amountToRead;
    private volatile boolean _disconnect;
    private int _initialReadingPoint;
    private int _initialWritingPoint;
    private long _contentLength;
    private volatile boolean _bodyConsumed = true;
    private Socket _socket;
    private IOStateMachine _stateMachine;
    private Observer observerHandler;
    private SimpleReadHeaderState _headerReader;
    private boolean _requestingThex;
    private ThexReader _thexReader;
    private final VerifyingFile _incompleteFile;
    private HashSet _locationsReceived;
    private Set _goodLocs;
    private Set _goodPushLocs;
    private Set _badPushLocs;
    private Set _badLocs;
    private Set _writtenGoodLocs;
    private Set _writtenBadLocs;
    private Set _writtenPushLocs;
    private Set _writtenBadPushLocs;
    private int _port;
    private String _host;
    private boolean _chatEnabled = false;
    private boolean _browseEnabled = false;
    private String _server = "";
    private String _thexUri = null;
    private String _root32 = null;
    private boolean _thexSucceeded = false;
    private BandwidthTrackerImpl bandwidthTracker = new BandwidthTrackerImpl();
    private boolean _isActive = false;
    private Interval _requestedInterval = null;
    private boolean _wantsFalts = false;
    private final boolean _inNetwork;
    static /* synthetic */ Class class$0;

    static {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("com.limegroup.gnutella.downloader.HTTPDownloader");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        LOG = LogFactory.getLog((Class)clazz);
        MIN_PARTIAL_FILE_BYTES = 0x100000;
        THROTTLE = new NBThrottle(false, Float.MAX_VALUE);
    }

    public HTTPDownloader(RemoteFileDesc remoteFileDesc, VerifyingFile verifyingFile, boolean bl) {
        this(null, remoteFileDesc, verifyingFile, bl);
    }

    public HTTPDownloader(Socket socket, RemoteFileDesc remoteFileDesc, VerifyingFile verifyingFile, boolean bl) {
        if (remoteFileDesc == null) {
            throw new NullPointerException("null rfd");
        }
        this._rfd = remoteFileDesc;
        this._socket = socket;
        this._incompleteFile = verifyingFile;
        this._filename = remoteFileDesc.getFileName();
        this._index = remoteFileDesc.getIndex();
        this._guid = remoteFileDesc.getClientGUID();
        this._amountToRead = 0;
        this._port = remoteFileDesc.getPort();
        this._host = remoteFileDesc.getHost();
        this._chatEnabled = remoteFileDesc.chatEnabled();
        this._browseEnabled = remoteFileDesc.browseHostEnabled();
        this._locationsReceived = new HashSet();
        this._goodLocs = new HashSet();
        this._badLocs = new HashSet();
        this._goodPushLocs = new HashSet();
        this._badPushLocs = new HashSet();
        this._writtenGoodLocs = new HashSet();
        this._writtenBadLocs = new HashSet();
        this._writtenPushLocs = new HashSet();
        this._writtenBadPushLocs = new HashSet();
        this._amountRead = 0;
        this._totalAmountRead = 0;
        this._inNetwork = bl;
        HTTPDownloader.applyRate();
    }

    Collection getLocationsReceived() {
        return this._locationsReceived;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void addSuccessfulAltLoc(AlternateLocation alternateLocation) {
        if (alternateLocation instanceof DirectAltLoc) {
            Set set = this._badLocs;
            synchronized (set) {
                this._writtenBadLocs.remove(alternateLocation);
                this._badLocs.remove(alternateLocation);
            }
            set = this._goodLocs;
            synchronized (set) {
                if (!this._writtenGoodLocs.contains(alternateLocation)) {
                    this._goodLocs.add(alternateLocation);
                }
            }
        }
        Set set = this._badPushLocs;
        synchronized (set) {
            this._writtenBadPushLocs.remove(alternateLocation);
            this._badPushLocs.remove(alternateLocation);
        }
        set = this._goodPushLocs;
        synchronized (set) {
            if (!this._writtenPushLocs.contains(alternateLocation)) {
                this._goodPushLocs.add(alternateLocation);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void addFailedAltLoc(AlternateLocation alternateLocation) {
        if (alternateLocation instanceof DirectAltLoc) {
            Set set = this._goodLocs;
            synchronized (set) {
                this._writtenGoodLocs.remove(alternateLocation);
                this._goodLocs.remove(alternateLocation);
            }
            set = this._badLocs;
            synchronized (set) {
                if (!this._writtenBadLocs.contains(alternateLocation)) {
                    this._badLocs.add(alternateLocation);
                }
            }
        }
        Set set = this._goodPushLocs;
        synchronized (set) {
            this._writtenPushLocs.remove(alternateLocation);
            this._goodPushLocs.remove(alternateLocation);
        }
        set = this._badPushLocs;
        synchronized (set) {
            if (!this._writtenBadPushLocs.contains(alternateLocation)) {
                this._badPushLocs.add(alternateLocation);
            }
        }
    }

    public void connectTCP(int n) throws IOException {
        if (this._socket == null) {
            long l = System.currentTimeMillis();
            this._socket = Sockets.connect(this._host, this._port, n);
            NumericalDownloadStat.TCP_CONNECT_TIME.addData((int)(System.currentTimeMillis() - l));
        }
        this._socket.setKeepAlive(true);
        this.observerHandler = new Observer();
        this._stateMachine = new IOStateMachine(this.observerHandler, new LinkedList(), 2048);
        this._stateMachine.setReadChannel(new ThrottleReader(THROTTLE));
        ((NIOMultiplexor)((Object)this._socket)).setReadObserver(this._stateMachine);
        ((NIOMultiplexor)((Object)this._socket)).setWriteObserver(this._stateMachine);
        this._socket.setSoTimeout(8000);
    }

    public void connectHTTP(int n, int n2, boolean bl, IOStateObserver iOStateObserver) {
        this.connectHTTP(n, n2, bl, -1, iOStateObserver);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void connectHTTP(int n, int n2, boolean bl, int n3, IOStateObserver iOStateObserver) {
        Object object;
        Object object2;
        HTTPHeaderValue hTTPHeaderValue;
        if (n < 0) {
            throw new IllegalArgumentException("invalid start: " + n);
        }
        if (n2 <= n) {
            throw new IllegalArgumentException("stop(" + n2 + ") <= start(" + n + ")");
        }
        Object object3 = this;
        synchronized (object3) {
            this._isActive = true;
            this._amountToRead = n2 - n;
            this._amountRead = 0;
            this._initialReadingPoint = n;
            this._initialWritingPoint = n;
            this._bodyConsumed = false;
            this._contentLength = 0L;
            this._requestedInterval = new Interval(this._initialReadingPoint, n2 - 1);
        }
        this.observerHandler.setDelegate(iOStateObserver);
        object3 = new LinkedHashMap();
        HashSet<HTTPHeaderValue> hashSet = new HashSet<HTTPHeaderValue>();
        object3.put("HOST", String.valueOf(this._host) + ":" + this._port);
        object3.put("User-Agent", CommonUtils.getHttpServer());
        if (bl) {
            object3.put("X-Queue", "0.1");
            hashSet.add(ConstantHTTPHeaderValue.QUEUE_FEATURE);
        }
        if (RouterService.acceptedIncomingConnection() || UDPService.instance().canDoFWT()) {
            hashSet.add(ConstantHTTPHeaderValue.PUSH_LOCS_FEATURE);
            if (!RouterService.acceptedIncomingConnection()) {
                hashSet.add(ConstantHTTPHeaderValue.FWT_PUSH_LOCS_FEATURE);
            }
        }
        if (this.isPartialFileValid() && (RouterService.acceptedIncomingConnection() || this._wantsFalts) && (hTTPHeaderValue = AlternateLocation.create(this._rfd.getSHA1Urn())) != null) {
            this.addSuccessfulAltLoc((AlternateLocation)hTTPHeaderValue);
        }
        if ((hTTPHeaderValue = this._rfd.getSHA1Urn()) != null) {
            object3.put(HTTPHeaderName.GNUTELLA_CONTENT_URN, hTTPHeaderValue);
        }
        HashSet<Object> hashSet2 = null;
        Set set = this._goodLocs;
        synchronized (set) {
            if (this._goodLocs.size() > 0) {
                hashSet2 = new HashSet<Object>();
                object2 = this._goodLocs.iterator();
                while (object2.hasNext()) {
                    object = object2.next();
                    hashSet2.add(object);
                    this._writtenGoodLocs.add(object);
                }
                this._goodLocs.clear();
            }
        }
        if (hashSet2 != null) {
            object3.put(HTTPHeaderName.ALT_LOCATION, new HTTPHeaderValueCollection(hashSet2));
        }
        hashSet2 = null;
        set = this._badLocs;
        synchronized (set) {
            if (this._badLocs.size() > 0) {
                hashSet2 = new HashSet();
                object2 = this._badLocs.iterator();
                while (object2.hasNext()) {
                    object = object2.next();
                    hashSet2.add(object);
                    this._writtenBadLocs.add(object);
                }
                this._badLocs.clear();
            }
        }
        if (hashSet2 != null) {
            object3.put(HTTPHeaderName.NALTS, new HTTPHeaderValueCollection(hashSet2));
        }
        if (this._wantsFalts) {
            hashSet2 = null;
            set = this._goodPushLocs;
            synchronized (set) {
                if (this._goodPushLocs.size() > 0) {
                    hashSet2 = new HashSet();
                    object2 = this._goodPushLocs.iterator();
                    while (object2.hasNext()) {
                        object = (PushAltLoc)object2.next();
                        if (((PushAltLoc)object).getPushAddress().getProxies().isEmpty()) {
                            if (((PushAltLoc)object).getPushAddress() instanceof PushEndpointForSelf) continue;
                            Assert.that(false, "empty pushloc in downloader");
                        }
                        hashSet2.add(object);
                        this._writtenPushLocs.add(object);
                    }
                    this._goodPushLocs.clear();
                }
            }
            if (hashSet2 != null) {
                object3.put(HTTPHeaderName.FALT_LOCATION, new HTTPHeaderValueCollection(hashSet2));
            }
            hashSet2 = null;
            set = this._badPushLocs;
            synchronized (set) {
                if (this._badPushLocs.size() > 0) {
                    hashSet2 = new HashSet();
                    object2 = this._badPushLocs.iterator();
                    while (object2.hasNext()) {
                        object = (PushAltLoc)object2.next();
                        Assert.that(!((PushAltLoc)object).getPushAddress().getProxies().isEmpty());
                        hashSet2.add(object);
                        this._writtenBadPushLocs.add(object);
                    }
                    this._badPushLocs.clear();
                }
            }
            if (hashSet2 != null) {
                object3.put(HTTPHeaderName.BFALT_LOCATION, new HTTPHeaderValueCollection(hashSet2));
            }
        }
        object3.put("Range", "bytes=" + this._initialReadingPoint + "-" + (n2 - 1));
        if (RouterService.acceptedIncomingConnection() && !NetworkUtils.isPrivateAddress(RouterService.getAddress())) {
            int n4 = RouterService.getPort();
            object2 = NetworkUtils.ip2string(RouterService.getAddress());
            object3.put("X-Node", String.valueOf(object2) + ":" + n4);
            hashSet.add(ConstantHTTPHeaderValue.BROWSE_FEATURE);
            if (ChatSettings.CHAT_ENABLED.getValue()) {
                object3.put("Chat", String.valueOf(object2) + ":" + n4);
                hashSet.add(ConstantHTTPHeaderValue.CHAT_FEATURE);
            }
        }
        if (hashSet.size() > 0) {
            object3.put(HTTPHeaderName.FEATURES, new HTTPHeaderValueCollection(hashSet));
        }
        if (n3 > 0) {
            object3.put(HTTPHeaderName.DOWNLOADED, "" + n3);
        }
        SimpleWriteHeaderState simpleWriteHeaderState = new SimpleWriteHeaderState("GET " + this._rfd.getUrl().getFile() + " HTTP/1.1", (Map)object3, this._inNetwork ? BandwidthStat.HTTP_HEADER_UPSTREAM_INNETWORK_BANDWIDTH : BandwidthStat.HTTP_HEADER_UPSTREAM_BANDWIDTH);
        object2 = new SimpleReadHeaderState(this._inNetwork ? BandwidthStat.HTTP_HEADER_DOWNSTREAM_INNETWORK_BANDWIDTH : BandwidthStat.HTTP_HEADER_DOWNSTREAM_BANDWIDTH, DownloadSettings.MAX_HEADERS.getValue(), DownloadSettings.MAX_HEADER_SIZE.getValue());
        this._stateMachine.addStates(new IOState[]{simpleWriteHeaderState, object2});
        this._headerReader = object2;
    }

    void consumeBody(IOStateObserver iOStateObserver) {
        if (!this._bodyConsumed) {
            if (this._contentLength != -1L) {
                this.consumeBody(this._contentLength, iOStateObserver);
            } else {
                iOStateObserver.handleIOException(new IOException("no content length"));
            }
        } else {
            iOStateObserver.handleStatesFinished();
        }
        this._bodyConsumed = true;
    }

    boolean isBodyConsumed() {
        return this._bodyConsumed;
    }

    public void requestHashTree(URN uRN, IOStateObserver iOStateObserver) {
        SimpleReadHeaderState simpleReadHeaderState;
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("requesting HashTree for " + this._thexUri + " from " + this._host + ":" + this._port));
        }
        this.observerHandler.setDelegate(iOStateObserver);
        LinkedHashMap<String, String> linkedHashMap = new LinkedHashMap<String, String>();
        linkedHashMap.put("HOST", String.valueOf(this._host) + ":" + this._port);
        linkedHashMap.put("User-Agent", CommonUtils.getHttpServer());
        SimpleWriteHeaderState simpleWriteHeaderState = new SimpleWriteHeaderState("GET " + this._thexUri + " HTTP/1.1", linkedHashMap, BandwidthStat.GNUTELLA_UPSTREAM_BANDWIDTH);
        this._headerReader = simpleReadHeaderState = new SimpleReadHeaderState(BandwidthStat.GNUTELLA_DOWNSTREAM_BANDWIDTH, DownloadSettings.MAX_HEADERS.getValue(), DownloadSettings.MAX_HEADER_SIZE.getValue());
        this._requestingThex = true;
        this._bodyConsumed = false;
        this._stateMachine.addStates(new IOState[]{simpleWriteHeaderState, simpleReadHeaderState});
    }

    boolean isRequestingThex() {
        return this._requestingThex;
    }

    public ConnectionStatus parseThexResponseHeaders() {
        this._requestingThex = false;
        try {
            int n = HTTPDownloader.parseHTTPCode(this._headerReader.getConnectLine(), this._rfd);
            boolean bl = false;
            if (n < 200 || n >= 300) {
                bl = true;
            }
            return this.parseThexHeaders(n, bl);
        }
        catch (IOException iOException) {
            return ConnectionStatus.getNoFile();
        }
    }

    public void downloadThexBody(URN uRN, IOStateObserver iOStateObserver) {
        this._thexReader = HashTree.createHashTreeReader(uRN.httpStringValue(), this._root32, this._rfd.getFileSize());
        this.observerHandler.setDelegate(iOStateObserver);
        this._stateMachine.addState(this._thexReader);
    }

    public HashTree getHashTree() {
        this._contentLength -= this._thexReader.getAmountProcessed();
        if (this._contentLength == 0L) {
            this._bodyConsumed = true;
        }
        HashTree hashTree = null;
        try {
            hashTree = this._thexReader.getHashTree();
        }
        catch (IOException iOException) {
            LOG.warn((Object)"Failed to create tree", (Throwable)iOException);
        }
        if (hashTree == null) {
            this._rfd.setTHEXFailed();
        } else {
            this._thexSucceeded = true;
        }
        return hashTree;
    }

    private ConnectionStatus parseThexHeaders(int n, boolean bl) throws IOException {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)(this._rfd + " consuming headers"));
        }
        this._contentLength = -1L;
        Iterator<Map.Entry<Object, Object>> iterator = this._headerReader.getHeaders().entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry<Object, Object> entry = iterator.next();
            String string = (String)entry.getKey();
            if (HTTPHeaderName.CONTENT_LENGTH.is(string)) {
                this._contentLength = HTTPDownloader.readContentLength((String)entry.getValue());
            }
            if (n != 503 || !HTTPHeaderName.QUEUE.is(string)) continue;
            String string2 = (String)entry.getValue();
            int[] nArray = new int[]{-1, -1, -1};
            this.parseQueueHeaders(string2, nArray);
            int n2 = nArray[0];
            int n3 = nArray[1];
            int n4 = nArray[2];
            if (n2 == -1 || n3 == -1 || n4 == -1) continue;
            this._bodyConsumed = true;
            return ConnectionStatus.getQueued(n4, n2);
        }
        if (this._contentLength == 0L) {
            this._bodyConsumed = true;
        }
        if (bl || this._contentLength == -1L) {
            return ConnectionStatus.getNoFile();
        }
        return ConnectionStatus.getConnected();
    }

    private void consumeBody(long l, IOStateObserver iOStateObserver) {
        if (LOG.isTraceEnabled()) {
            LOG.trace((Object)("enter consumeBody(" + l + ")"));
        }
        if (l < 0L) {
            iOStateObserver.handleIOException(new IOException("unknown content-length, can't consume"));
        }
        this.observerHandler.setDelegate(iOStateObserver);
        this._stateMachine.addState(new ReadSkipState(l));
    }

    public void parseHeaders() throws IOException {
        Object object;
        String string = this._headerReader.getConnectLine();
        Properties properties = this._headerReader.getHeaders();
        if (string == null || string.equals("")) {
            throw new IOException();
        }
        int n = HTTPDownloader.parseHTTPCode(string, this._rfd);
        this._contentLength = -1L;
        int[] nArray = new int[]{-1, -1, -1};
        Iterator iterator = properties.entrySet().iterator();
        while (iterator.hasNext()) {
            object = iterator.next();
            String string2 = (String)object.getKey();
            String string3 = (String)object.getValue();
            if (HTTPHeaderName.CONTENT_RANGE.is(string2)) {
                this.validateContentRange(this.parseContentRange(string3));
                continue;
            }
            if (HTTPHeaderName.CONTENT_LENGTH.is(string2)) {
                this._contentLength = HTTPDownloader.readContentLength(string3);
                continue;
            }
            if (HTTPHeaderName.CONTENT_URN.is(string2)) {
                this.checkContentUrnHeader(string3, this._rfd.getSHA1Urn());
                continue;
            }
            if (HTTPHeaderName.GNUTELLA_CONTENT_URN.is(string2)) {
                this.checkContentUrnHeader(string3, this._rfd.getSHA1Urn());
                continue;
            }
            if (HTTPHeaderName.ALT_LOCATION.is(string2)) {
                this.readAlternateLocations(string3);
                continue;
            }
            if (HTTPHeaderName.QUEUE.is(string2)) {
                this.parseQueueHeaders(string3, nArray);
                continue;
            }
            if (HTTPHeaderName.SERVER.is(string2)) {
                this._server = string3;
                continue;
            }
            if (HTTPHeaderName.AVAILABLE_RANGES.is(string2)) {
                this.parseAvailableRangesHeader(string3, this._rfd);
                continue;
            }
            if (HTTPHeaderName.RETRY_AFTER.is(string2)) {
                HTTPDownloader.parseRetryAfterHeader(string3, this._rfd);
                continue;
            }
            if (HTTPHeaderName.CREATION_TIME.is(string2)) {
                HTTPDownloader.parseCreationTimeHeader(string3, this._rfd);
                continue;
            }
            if (HTTPHeaderName.FEATURES.is(string2)) {
                this.parseFeatureHeader(string3);
                continue;
            }
            if (HTTPHeaderName.THEX_URI.is(string2)) {
                this.parseTHEXHeader(string3);
                continue;
            }
            if (HTTPHeaderName.FALT_LOCATION.is(string2)) {
                this.parseFALTHeader(string3);
                continue;
            }
            if (!HTTPHeaderName.PROXIES.is(string2)) continue;
            this.parseProxiesHeader(string3);
        }
        if (n < 200 || n >= 300) {
            if (n == 404) {
                throw new FileNotFoundException();
            }
            if (n == 410) {
                throw new NotSharingException();
            }
            if (n == 416) {
                if (this._rfd.isPartialSource()) {
                    iterator = this._rfd.getAvailableRanges().getAllIntervals();
                    while (iterator.hasNext()) {
                        object = (Interval)iterator.next();
                        if (!this._requestedInterval.isSubrange((Interval)object)) continue;
                        throw new ProblemReadingHeaderException("Bad ranges sent");
                    }
                } else {
                    throw new ProblemReadingHeaderException("no ranges sent");
                }
                throw new RangeNotAvailableException();
            }
            if (n == 503) {
                int n2 = nArray[0];
                int n3 = nArray[1];
                int n4 = nArray[2];
                if (n2 != -1 && n3 != -1 && n4 != -1) {
                    this._bodyConsumed = true;
                    throw new QueuedException(n2, n3, n4);
                }
                throw new TryAgainLaterException();
            }
            throw new UnknownCodeException(n);
        }
    }

    private void checkContentUrnHeader(String string, URN uRN) throws ContentUrnMismatchException {
        if (this._root32 == null && string.indexOf("urn:bitprint:") > -1) {
            this._root32 = string.substring(string.lastIndexOf(".") + 1).trim();
        }
        if (uRN == null) {
            return;
        }
        URN uRN2 = null;
        try {
            uRN2 = URN.createSHA1Urn(string);
        }
        catch (IOException iOException) {
            return;
        }
        if (!uRN.equals(uRN2)) {
            throw new ContentUrnMismatchException();
        }
    }

    private void readAlternateLocations(String string) {
        if (string == null) {
            return;
        }
        URN uRN = this._rfd.getSHA1Urn();
        if (uRN == null) {
            return;
        }
        StringTokenizer stringTokenizer = new StringTokenizer(string, ",");
        while (stringTokenizer.hasMoreTokens()) {
            try {
                RemoteFileDesc remoteFileDesc;
                AlternateLocation alternateLocation = AlternateLocation.create(stringTokenizer.nextToken().trim(), uRN);
                Assert.that(alternateLocation.getSHA1Urn().equals(uRN));
                if (alternateLocation.isMe() || !this._locationsReceived.add(remoteFileDesc = alternateLocation.createRemoteFileDesc(this._rfd.getSize()))) continue;
                if (alternateLocation instanceof DirectAltLoc) {
                    DownloadStat.ALTERNATE_COLLECTED.incrementStat();
                    continue;
                }
                DownloadStat.PUSH_ALTERNATE_COLLECTED.incrementStat();
            }
            catch (IOException iOException) {}
        }
    }

    private boolean isPartialFileValid() {
        return this._rfd.getSHA1Urn() != null && this._incompleteFile.getVerifiedBlockSize() > MIN_PARTIAL_FILE_BYTES && UploadSettings.ALLOW_PARTIAL_SHARING.getValue() && NetworkUtils.isValidPort(RouterService.getPort()) && NetworkUtils.isValidAddress(RouterService.getAddress());
    }

    public static int readContentLength(String string) {
        if (string == null) {
            return 0;
        }
        try {
            return Integer.parseInt(string.trim());
        }
        catch (NumberFormatException numberFormatException) {
            return 0;
        }
    }

    private static int parseHTTPCode(String string, RemoteFileDesc remoteFileDesc) throws IOException {
        StringTokenizer stringTokenizer = new StringTokenizer(string, " ");
        if (!stringTokenizer.hasMoreTokens()) {
            throw new NoHTTPOKException();
        }
        String string2 = stringTokenizer.nextToken();
        if (string2.toUpperCase().indexOf("HTTP") < 0) {
            throw new NoHTTPOKException("got: " + string);
        }
        remoteFileDesc.setHTTP11(string2.indexOf("1.1") > 0);
        if (!stringTokenizer.hasMoreTokens()) {
            throw new NoHTTPOKException();
        }
        string2 = stringTokenizer.nextToken();
        String string3 = string2.trim();
        try {
            return Integer.parseInt(string3);
        }
        catch (NumberFormatException numberFormatException) {
            throw new ProblemReadingHeaderException(numberFormatException);
        }
    }

    private void parseQueueHeaders(String string, int[] nArray) {
        if (string == null) {
            return;
        }
        StringTokenizer stringTokenizer = new StringTokenizer(string, " ,:=");
        while (stringTokenizer.hasMoreTokens()) {
            String string2 = stringTokenizer.nextToken();
            try {
                String string3;
                if (string2.equalsIgnoreCase("pollMin")) {
                    string3 = stringTokenizer.nextToken();
                    nArray[0] = Integer.parseInt(string3);
                    continue;
                }
                if (string2.equalsIgnoreCase("pollMax")) {
                    string3 = stringTokenizer.nextToken();
                    nArray[1] = Integer.parseInt(string3);
                    continue;
                }
                if (!string2.equalsIgnoreCase("position")) continue;
                string3 = stringTokenizer.nextToken();
                nArray[2] = Integer.parseInt(string3);
            }
            catch (NumberFormatException numberFormatException) {
                Arrays.fill(nArray, -1);
                break;
            }
            catch (NoSuchElementException noSuchElementException) {
                Arrays.fill(nArray, -1);
                break;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void validateContentRange(Interval interval) throws IOException {
        int n = interval.low;
        int n2 = interval.high + 1;
        HTTPDownloader hTTPDownloader = this;
        synchronized (hTTPDownloader) {
            if (this._disconnect) {
                throw new IOException("stolen from");
            }
            if (n < this._initialReadingPoint || n2 > this._initialReadingPoint + this._amountToRead) {
                throw new ProblemReadingHeaderException("invalid subrange given.  wanted low: " + this._initialReadingPoint + ", high: " + (this._initialReadingPoint + this._amountToRead - 1) + "... given low: " + n + ", high: " + n2);
            }
            this._initialReadingPoint = n;
            this._amountToRead = n2 - n;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Interval parseContentRange(String string) throws IOException {
        int n;
        int n2;
        int n3;
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("reading content range: " + string));
        }
        try {
            int n4 = string.indexOf("bytes") + 6;
            int n5 = string.indexOf(47);
            if (string.substring(n4, n5).equals("*")) {
                if (LOG.isDebugEnabled()) {
                    LOG.debug((Object)(this._rfd + " Content-Range like */?, " + string));
                }
                HTTPDownloader hTTPDownloader = this;
                synchronized (hTTPDownloader) {
                    return new Interval(0L, this._amountToRead - 1);
                }
            }
            int n6 = string.lastIndexOf("-");
            n3 = Integer.parseInt(string.substring(n4, n6));
            n2 = Integer.parseInt(string.substring(n6 + 1, n5));
            if (n2 < n3) {
                throw new ProblemReadingHeaderException("invalid range, high (" + n2 + ") less than low (" + n3 + ")");
            }
            if (string.substring(n5 + 1).equals("*")) {
                if (LOG.isDebugEnabled()) {
                    LOG.debug((Object)(this._rfd + " Content-Range like #-#/*, " + string));
                }
                return new Interval(n3, n2);
            }
            n = Integer.parseInt(string.substring(n5 + 1));
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            throw new ProblemReadingHeaderException(string);
        }
        catch (NumberFormatException numberFormatException) {
            throw new ProblemReadingHeaderException(string);
        }
        if (n2 == n) {
            --n3;
            --n2;
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)(this._rfd + " Content-Range like #-#/#, " + string));
        }
        return new Interval(n3, n2);
    }

    private void parseAvailableRangesHeader(String string, RemoteFileDesc remoteFileDesc) throws IOException {
        IntervalSet intervalSet = new IntervalSet();
        string = string.toLowerCase();
        int n = string.indexOf("bytes") + 6;
        while (n != -1 && n < string.length()) {
            int n2 = string.indexOf(45, n);
            if (n2 == -1) break;
            Interval interval = null;
            try {
                int n3 = Integer.parseInt(string.substring(n, n2).trim());
                n = n2 + 1;
                n2 = string.indexOf(44, n);
                if (n2 == -1) {
                    n2 = string.length();
                }
                int n4 = Integer.parseInt(string.substring(n, n2).trim());
                n = n2 + 1;
                if (n4 >= remoteFileDesc.getSize()) {
                    n4 = remoteFileDesc.getSize() - 1;
                }
                if (n3 > n4) continue;
                interval = new Interval(n3, n4);
            }
            catch (NumberFormatException numberFormatException) {
                throw new ProblemReadingHeaderException(numberFormatException);
            }
            intervalSet.add(interval);
        }
        remoteFileDesc.setAvailableRanges(intervalSet);
    }

    private static void parseRetryAfterHeader(String string, RemoteFileDesc remoteFileDesc) throws IOException {
        int n = 0;
        try {
            n = Integer.parseInt(string);
        }
        catch (NumberFormatException numberFormatException) {
            throw new ProblemReadingHeaderException(numberFormatException);
        }
        n = Math.max(n, 60);
        n = Math.min(n, 3600);
        remoteFileDesc.setRetryAfter(n);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void parseCreationTimeHeader(String string, RemoteFileDesc remoteFileDesc) throws IOException {
        long l = 0L;
        try {
            l = Long.parseLong(string);
        }
        catch (NumberFormatException numberFormatException) {
            throw new ProblemReadingHeaderException(numberFormatException);
        }
        if (remoteFileDesc.getSHA1Urn() != null) {
            CreationTimeCache creationTimeCache;
            CreationTimeCache creationTimeCache2 = creationTimeCache = CreationTimeCache.instance();
            synchronized (creationTimeCache2) {
                Long l2 = creationTimeCache.getCreationTime(remoteFileDesc.getSHA1Urn());
                if (l2 == null || l2 > l) {
                    creationTimeCache.addTime(remoteFileDesc.getSHA1Urn(), l);
                }
            }
        }
    }

    private void parseFeatureHeader(String string) {
        StringTokenizer stringTokenizer = new StringTokenizer(string, ",");
        while (stringTokenizer.hasMoreTokens()) {
            String string2 = stringTokenizer.nextToken();
            String string3 = "";
            int n = string2.indexOf("/");
            string3 = n == -1 ? string2.toLowerCase().trim() : string2.substring(0, n).toLowerCase().trim();
            if (string3.equals("chat")) {
                this._chatEnabled = true;
                continue;
            }
            if (string3.equals("browse")) {
                this._browseEnabled = true;
                continue;
            }
            if (string3.equals("fwalt")) {
                this._wantsFalts = true;
                continue;
            }
            if (!string3.equals("fwt")) continue;
            int n2 = 0;
            try {
                n2 = (int)HTTPUtils.parseFeatureToken(string2);
                this._wantsFalts = true;
            }
            catch (ProblemReadingHeaderException problemReadingHeaderException) {
                continue;
            }
            try {
                this.updatePEAddress();
                PushEndpoint.setFWTVersionSupported(this._rfd.getClientGUID(), n2);
            }
            catch (IOException iOException) {}
        }
    }

    private void parseTHEXHeader(String string) {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)(String.valueOf(this._host) + ":" + this._port + ">" + string));
        }
        if (string.indexOf(";") > 0) {
            StringTokenizer stringTokenizer = new StringTokenizer(string, ";");
            this._thexUri = stringTokenizer.nextToken();
            this._root32 = stringTokenizer.nextToken();
        } else {
            this._thexUri = string;
        }
    }

    private void parseFALTHeader(String string) {
        this._wantsFalts = true;
        this.readAlternateLocations(string);
    }

    private void parseProxiesHeader(String string) {
        if (this._rfd.getPushAddr() == null || string == null || string.length() < 12) {
            return;
        }
        try {
            PushEndpoint.overwriteProxies(this._rfd.getClientGUID(), string);
            this.updatePEAddress();
        }
        catch (IOException iOException) {}
    }

    private void updatePEAddress() throws IOException {
        IpPortImpl ipPortImpl = new IpPortImpl(this._socket.getInetAddress().getHostAddress(), this._socket.getPort());
        if (NetworkUtils.isValidExternalIpPort(ipPortImpl)) {
            PushEndpoint.setAddr(this._rfd.getClientGUID(), ipPortImpl);
        }
    }

    public void doDownload(IOStateObserver iOStateObserver) throws SocketException {
        this._socket.setSoTimeout(60000);
        this.observerHandler.setDelegate(iOStateObserver);
        this._stateMachine.addState(new DownloadState());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stop() {
        HTTPDownloader hTTPDownloader = this;
        synchronized (hTTPDownloader) {
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("WORKER:" + this + " signaled to stop at " + (this._initialReadingPoint + this._amountRead)));
            }
            this._isActive = false;
        }
        IOUtils.close(this._socket);
    }

    public synchronized void stopAt(int n) {
        this._disconnect = true;
        this._amountToRead = Math.min(this._amountToRead, n - this._initialReadingPoint);
    }

    public synchronized void startAt(int n) {
        this._initialWritingPoint = n;
    }

    synchronized void forgetRanges() {
        this._initialWritingPoint = 0;
        this._initialReadingPoint = 0;
        this._amountToRead = 0;
        this._totalAmountRead += this._amountRead;
        this._amountRead = 0;
    }

    public synchronized int getInitialReadingPoint() {
        return this._initialReadingPoint;
    }

    public synchronized int getInitialWritingPoint() {
        return this._initialWritingPoint;
    }

    public synchronized int getAmountRead() {
        return this._amountRead;
    }

    public synchronized int getTotalAmountRead() {
        return this._totalAmountRead + this._amountRead;
    }

    public synchronized int getAmountToRead() {
        return this._amountToRead;
    }

    public synchronized boolean isActive() {
        return this._isActive;
    }

    synchronized boolean isVictim() {
        return this._disconnect;
    }

    public InetAddress getInetAddress() {
        return this._socket.getInetAddress();
    }

    public boolean chatEnabled() {
        return this._chatEnabled;
    }

    public boolean browseEnabled() {
        return this._browseEnabled;
    }

    public boolean wantsFalts() {
        return this._wantsFalts;
    }

    public String getVendor() {
        return this._server;
    }

    public long getIndex() {
        return this._index;
    }

    public String getFileName() {
        return this._filename;
    }

    public byte[] getGUID() {
        return this._guid;
    }

    public int getPort() {
        return this._port;
    }

    public RemoteFileDesc getRemoteFileDesc() {
        return this._rfd;
    }

    public boolean isHTTP11() {
        return this._rfd.isHTTP11();
    }

    public boolean hasHashTree() {
        return this._thexUri != null && this._root32 != null && !this._rfd.hasTHEXFailed() && !this._thexSucceeded;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void measureBandwidth() {
        int n = 0;
        HTTPDownloader hTTPDownloader = this;
        synchronized (hTTPDownloader) {
            if (!this._isActive) {
                return;
            }
            n = this.getTotalAmountRead();
        }
        this.bandwidthTracker.measureBandwidth(n);
    }

    public float getMeasuredBandwidth() throws InsufficientDataException {
        return this.bandwidthTracker.getMeasuredBandwidth();
    }

    public float getAverageBandwidth() {
        return this.bandwidthTracker.getAverageBandwidth();
    }

    public static void setRate(float f) {
        THROTTLE.setRate(f);
    }

    public static void applyRate() {
        float f = Float.MAX_VALUE;
        int n = DownloadSettings.DOWNLOAD_SPEED.getValue();
        if (n < 100) {
            f = (float)n / 100.0f * ((float)ConnectionSettings.CONNECTION_SPEED.getValue() / 8.0f) * 1024.0f;
        }
        HTTPDownloader.setRate(f);
    }

    public String toString() {
        return "<" + this._host + ":" + this._port + ", " + this.getFileName() + ">";
    }

    public static void setThrottleSwitching(boolean bl) {
    }

    private class DownloadState
    extends ReadState {
        private long currPos;
        private volatile boolean doingWrite;

        DownloadState() {
            this.currPos = HTTPDownloader.this._initialReadingPoint;
        }

        void writeDone() {
            this.doingWrite = false;
        }

        protected boolean processRead(ReadableByteChannel readableByteChannel, ByteBuffer byteBuffer) throws IOException {
            if (this.doingWrite) {
                return true;
            }
            boolean bl = false;
            try {
                bl = this.readImpl(readableByteChannel, byteBuffer);
            }
            catch (IOException iOException) {
                LOG.debug((Object)"Error while reading", (Throwable)iOException);
                this.chunkCompleted();
                throw iOException;
            }
            if (!bl) {
                this.chunkCompleted();
                if (!HTTPDownloader.this.isHTTP11() || HTTPDownloader.this._disconnect) {
                    throw new IOException("stolen from");
                }
            }
            return bl;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void chunkCompleted() {
            HTTPDownloader.this._bodyConsumed = true;
            HTTPDownloader hTTPDownloader = HTTPDownloader.this;
            synchronized (hTTPDownloader) {
                HTTPDownloader.this._isActive = false;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        private boolean readImpl(ReadableByteChannel readableByteChannel, ByteBuffer byteBuffer) throws IOException {
            while (true) {
                long l;
                int n;
                int n2;
                int n3;
                int n4 = 0;
                HTTPDownloader hTTPDownloader = HTTPDownloader.this;
                synchronized (hTTPDownloader) {
                    if (HTTPDownloader.this._amountRead >= HTTPDownloader.this._amountToRead) {
                        LOG.debug((Object)"Read >= to needed, done.");
                        HTTPDownloader.this._isActive = false;
                        return false;
                    }
                    n3 = HTTPDownloader.this._amountToRead - HTTPDownloader.this._amountRead;
                }
                int n5 = Math.min(n3, byteBuffer.position());
                if (n5 != 0 && LOG.isDebugEnabled()) {
                    LOG.debug((Object)("Using preread data of: " + n5));
                }
                if (n3 - n5 > 0) {
                    if (byteBuffer.limit() > n3) {
                        byteBuffer.limit(n3);
                    }
                    while (byteBuffer.hasRemaining() && (n4 = readableByteChannel.read(byteBuffer)) > 0) {
                    }
                    byteBuffer.limit(byteBuffer.capacity());
                }
                int n6 = byteBuffer.position();
                if (HTTPDownloader.this._inNetwork) {
                    BandwidthStat.HTTP_BODY_DOWNSTREAM_INNETWORK_BANDWIDTH.addData(n6);
                } else {
                    BandwidthStat.HTTP_BODY_DOWNSTREAM_BANDWIDTH.addData(n6);
                }
                if (n6 == 0) {
                    if (n4 == -1) {
                        LOG.debug((Object)"EOF while reading");
                        throw new IOException("EOF");
                    }
                    if (n4 == 0) {
                        return true;
                    }
                }
                Object object = this;
                synchronized (object) {
                    if (HTTPDownloader.this._isActive) {
                        if ((n6 = Math.min(n6, HTTPDownloader.this._amountToRead - HTTPDownloader.this._amountRead)) <= 0) {
                            LOG.debug((Object)"Someone stole completely from us while reading");
                            HTTPDownloader.this._isActive = false;
                            byteBuffer.clear();
                            return false;
                        }
                        int n7 = Math.min(n6, Math.max(0, (int)((long)HTTPDownloader.this._initialWritingPoint - this.currPos)));
                        if (n7 > 0) {
                            LOG.debug((Object)("Amount we should skip: " + n7));
                        }
                        n2 = n6 - n7;
                        n = n7;
                        l = this.currPos + (long)n7;
                        HTTPDownloader hTTPDownloader2 = HTTPDownloader.this;
                        hTTPDownloader2._amountRead = hTTPDownloader2._amountRead + n6;
                        this.currPos += (long)n6;
                        if (n7 >= n6) {
                            if (LOG.isDebugEnabled()) {
                                LOG.debug((Object)("skipped full read of: " + n7 + " bytes"));
                            }
                            byteBuffer.clear();
                            continue;
                        }
                    } else {
                        if (LOG.isDebugEnabled()) {
                            LOG.debug((Object)("WORKER:" + this + " stopping at " + (HTTPDownloader.this._initialReadingPoint + HTTPDownloader.this._amountRead)));
                        }
                        byteBuffer.clear();
                        return false;
                    }
                }
                try {
                    if (!HTTPDownloader.this._incompleteFile.writeBlock(l, n, n2, byteBuffer.array())) {
                        LOG.debug((Object)"Scheduling callback for write.");
                        object = (InterestReadChannel)readableByteChannel;
                        object.interest(false);
                        this.doingWrite = true;
                        HTTPDownloader.this._incompleteFile.writeBlockWithCallback(l, n, n2, byteBuffer.array(), new DownloadRestarter((InterestReadChannel)object, byteBuffer, this));
                        return true;
                    }
                }
                catch (AssertFailure assertFailure) {
                    Object object2;
                    String string = "current worker " + System.identityHashCode(HTTPDownloader.this);
                    String string2 = null;
                    URN uRN = HTTPDownloader.this._rfd.getSHA1Urn();
                    string2 = uRN != null ? ((object2 = RouterService.getDownloadManager().getDownloaderForURN(uRN)) == null ? "couldn't find my downloader???" : ((ManagedDownloader)object2).getWorkersInfo()) : " sha1 not available ";
                    object2 = String.valueOf(assertFailure.getMessage()) + "\n\n" + string + "\n\n" + string2;
                    AssertFailure assertFailure2 = new AssertFailure((String)object2);
                    assertFailure2.setStackTrace(assertFailure.getStackTrace());
                    throw assertFailure2;
                }
                byteBuffer.clear();
            }
        }

        public long getAmountProcessed() {
            return -1L;
        }
    }

    private static class DownloadRestarter
    implements VerifyingFile.WriteCallback {
        private final DownloadState downloader;
        private final InterestReadChannel irc;
        private final ByteBuffer buffer;

        DownloadRestarter(InterestReadChannel interestReadChannel, ByteBuffer byteBuffer, DownloadState downloadState) {
            this.irc = interestReadChannel;
            this.buffer = byteBuffer;
            this.downloader = downloadState;
        }

        public void writeScheduled() {
            LOG.debug((Object)"Delayed write scheduled");
            this.buffer.clear();
            this.downloader.writeDone();
            this.irc.interest(true);
        }
    }

    private static class Observer
    implements IOStateObserver {
        private IOStateObserver delegate;
        private boolean handled = false;
        private boolean error = false;

        Observer() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void handleIOException(IOException iOException) {
            IOStateObserver iOStateObserver;
            Observer observer = this;
            synchronized (observer) {
                this.error = true;
                if (this.handled) {
                    LOG.warn((Object)"Ignoring iox", (Throwable)iOException);
                    return;
                }
                this.handled = true;
                iOStateObserver = this.delegate;
            }
            if (iOStateObserver != null) {
                iOStateObserver.handleIOException(iOException);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void handleStatesFinished() {
            IOStateObserver iOStateObserver;
            Observer observer = this;
            synchronized (observer) {
                if (this.handled) {
                    if (LOG.isWarnEnabled()) {
                        LOG.warn((Object)"Ignoring states finished", (Throwable)new Exception());
                    }
                    return;
                }
                this.handled = true;
                iOStateObserver = this.delegate;
            }
            if (iOStateObserver != null) {
                iOStateObserver.handleStatesFinished();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void shutdown() {
            IOStateObserver iOStateObserver;
            Observer observer = this;
            synchronized (observer) {
                this.error = true;
                if (this.handled) {
                    if (LOG.isWarnEnabled()) {
                        LOG.warn((Object)"Ignoring shutdown.");
                    }
                    return;
                }
                this.handled = true;
                iOStateObserver = this.delegate;
            }
            if (iOStateObserver != null) {
                iOStateObserver.shutdown();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void setDelegate(IOStateObserver iOStateObserver) {
            boolean bl = false;
            Observer observer = this;
            synchronized (observer) {
                this.handled = false;
                bl = this.error;
                this.delegate = iOStateObserver;
            }
            if (bl) {
                iOStateObserver.shutdown();
            }
        }
    }
}

