/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.altlocs;

import com.limegroup.gnutella.Endpoint;
import com.limegroup.gnutella.ErrorService;
import com.limegroup.gnutella.RemoteFileDesc;
import com.limegroup.gnutella.RouterService;
import com.limegroup.gnutella.URN;
import com.limegroup.gnutella.altlocs.AlternateLocation;
import com.limegroup.gnutella.util.DataUtils;
import com.limegroup.gnutella.util.IpPort;
import com.limegroup.gnutella.util.IpPortForSelf;
import com.limegroup.gnutella.util.IpPortImpl;
import com.limegroup.gnutella.util.NetworkUtils;
import java.io.IOException;
import java.net.URL;
import java.util.HashSet;

public class DirectAltLoc
extends AlternateLocation {
    private final IpPort _node;
    protected volatile boolean _demoted = false;

    protected DirectAltLoc(URL uRL, URN uRN) throws IOException {
        this(new IpPortImpl(uRL.getHost(), uRL.getPort()), uRN);
    }

    protected DirectAltLoc(URN uRN) throws IOException {
        this(new Endpoint(RouterService.getAddress(), RouterService.getPort()), uRN);
    }

    protected DirectAltLoc(IpPort ipPort, URN uRN) throws IOException {
        super(uRN);
        if (!NetworkUtils.isValidExternalIpPort(ipPort)) {
            throw new IOException("not a valid external address:port in direct altloc " + ipPort);
        }
        this._node = ipPort;
        if (this._node == IpPortForSelf.instance()) {
            this.hashCode = IpPortForSelf.instance().hashCode();
        }
    }

    protected String generateHTTPString() {
        String string = this._node.getInetAddress().getHostAddress();
        if (this._node.getPort() != 6346) {
            string = String.valueOf(string) + ":" + this._node.getPort();
        }
        return string;
    }

    public RemoteFileDesc createRemoteFileDesc(int n) {
        HashSet<URN> hashSet = new HashSet<URN>();
        hashSet.add(this.getSHA1Urn());
        int n2 = 3;
        RemoteFileDesc remoteFileDesc = new RemoteFileDesc(this._node.getAddress(), this._node.getPort(), 0L, "/uri-res/N2R?" + this.SHA1_URN, n, DataUtils.EMPTY_GUID, 1000, true, n2, false, null, hashSet, false, false, "ALT", System.currentTimeMillis(), null, -1L);
        return remoteFileDesc;
    }

    public synchronized AlternateLocation createClone() {
        DirectAltLoc directAltLoc = null;
        try {
            directAltLoc = new DirectAltLoc(this._node, this.SHA1_URN);
        }
        catch (IOException iOException) {
            ErrorService.error(iOException);
            return null;
        }
        directAltLoc._demoted = this._demoted;
        directAltLoc._count = this._count;
        return directAltLoc;
    }

    public boolean isMe() {
        return NetworkUtils.isMe(this._node);
    }

    public IpPort getHost() {
        return this._node;
    }

    public boolean equals(Object object) {
        if (object == null || !(object instanceof DirectAltLoc)) {
            return false;
        }
        if (!super.equals(object)) {
            return false;
        }
        DirectAltLoc directAltLoc = (DirectAltLoc)object;
        if (this._node == directAltLoc._node) {
            return true;
        }
        return this._node.getInetAddress().equals(directAltLoc._node.getInetAddress()) && this._node.getPort() == directAltLoc._node.getPort();
    }

    synchronized void demote() {
        this._demoted = true;
    }

    synchronized void promote() {
        this._demoted = false;
    }

    public synchronized boolean isDemoted() {
        return this._demoted;
    }

    public int compareTo(Object object) {
        if (this == object) {
            return 0;
        }
        int n = super.compareTo(object);
        if (!(object instanceof DirectAltLoc)) {
            if (n != 0) {
                return n;
            }
            return -1;
        }
        DirectAltLoc directAltLoc = (DirectAltLoc)object;
        if (this._demoted != directAltLoc._demoted) {
            if (this._demoted) {
                return 1;
            }
            return -1;
        }
        if (n != 0) {
            return n;
        }
        if (this._node == directAltLoc._node) {
            return 0;
        }
        n = this._node.getAddress().compareTo(directAltLoc._node.getAddress());
        if (n != 0) {
            return n;
        }
        n = this._node.getPort() - directAltLoc._node.getPort();
        return n;
    }

    public int hashCode() {
        if (this.hashCode == 0) {
            int n = super.hashCode();
            n = 37 * n + this._node.getInetAddress().hashCode();
            this.hashCode = n = 37 * n + this._node.getPort();
        }
        return this.hashCode;
    }

    public String toString() {
        return this._node + "," + this._count + "," + this._demoted;
    }
}

