/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella;

import com.limegroup.gnutella.FileManager;
import com.limegroup.gnutella.RouterService;
import com.limegroup.gnutella.http.HTTPRequestMethod;
import com.limegroup.gnutella.io.ConnectObserver;
import com.limegroup.gnutella.statistics.UploadStat;
import com.limegroup.gnutella.udpconnect.UDPConnection;
import com.limegroup.gnutella.util.IOUtils;
import com.limegroup.gnutella.util.NetworkUtils;
import com.limegroup.gnutella.util.Sockets;
import com.limegroup.gnutella.util.ThreadFactory;
import java.io.IOException;
import java.io.OutputStream;
import java.net.InetSocketAddress;
import java.net.Socket;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public final class PushManager {
    private static final Log LOG;
    private static final int CONNECT_TIMEOUT = 10000;
    static /* synthetic */ Class class$0;

    static {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("com.limegroup.gnutella.PushManager");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        LOG = LogFactory.getLog((Class)clazz);
    }

    public void acceptPushUpload(String string, int n, String string2, boolean bl, boolean bl2) {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("Accepting Push Upload from ip:" + string + " port:" + n + " FW:" + bl2));
        }
        if (string == null) {
            throw new NullPointerException("null host");
        }
        if (!NetworkUtils.isValidPort(n)) {
            throw new IllegalArgumentException("invalid port: " + n);
        }
        if (string2 == null) {
            throw new NullPointerException("null guid");
        }
        FileManager fileManager = RouterService.getFileManager();
        if (fileManager.getNumFiles() < 1 && fileManager.getNumIncompleteFiles() < 1) {
            return;
        }
        PushData pushData = new PushData(string, n, string2, bl);
        if (bl2) {
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("Adding push observer FW-FW to host: " + string + ":" + n));
            }
            UDPConnection uDPConnection = new UDPConnection();
            uDPConnection.connect(new InetSocketAddress(string, n), 20000, new PushObserver(pushData, true));
        } else {
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("Adding push observer to host: " + string + ":" + n));
            }
            try {
                Sockets.connect(string, n, 10000, new PushObserver(pushData, false));
            }
            catch (IOException iOException) {
                UploadStat.PUSH_FAILED.incrementStat();
            }
        }
    }

    private static class PushData {
        private final String host;
        private final int port;
        private final String guid;
        private final boolean forceAllow;

        PushData(String string, int n, String string2, boolean bl) {
            this.host = string;
            this.port = n;
            this.guid = string2;
            this.forceAllow = bl;
        }

        public boolean isForceAllow() {
            return this.forceAllow;
        }

        public String getGuid() {
            return this.guid;
        }

        public String getHost() {
            return this.host;
        }

        public int getPort() {
            return this.port;
        }
    }

    private static class PushObserver
    implements ConnectObserver {
        private final PushData data;
        private final boolean fwt;

        PushObserver(PushData pushData, boolean bl) {
            this.data = pushData;
            this.fwt = bl;
        }

        public void handleIOException(IOException iOException) {
        }

        public void shutdown() {
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("Push (fwt: " + this.fwt + ") connect to: " + this.data.getHost() + ":" + this.data.getPort() + " failed"));
            }
            if (this.fwt) {
                UploadStat.FW_FW_FAILURE.incrementStat();
            } else {
                UploadStat.PUSH_FAILED.incrementStat();
            }
        }

        public void handleConnect(Socket socket) throws IOException {
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("Push (fwt: " + this.fwt + ") connect to: " + this.data.getHost() + ":" + this.data.getPort() + " succeeded"));
            }
            ThreadFactory.startThread(new Pusher(this.data, socket, this.fwt), "PushUploadThread");
        }
    }

    private static class Pusher
    implements Runnable {
        PushData data;
        private Socket socket;
        private boolean fwTransfer;

        Pusher(PushData pushData, Socket socket, boolean bl) {
            this.data = pushData;
            this.socket = socket;
            this.fwTransfer = bl;
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        public void run() {
            try {
                block10: {
                    try {
                        OutputStream outputStream = this.socket.getOutputStream();
                        String string = "GIV 0:" + this.data.getGuid() + "/file\n\n";
                        outputStream.write(string.getBytes());
                        outputStream.flush();
                        this.socket.setSoTimeout(30000);
                        String string2 = IOUtils.readWord(this.socket.getInputStream(), 4);
                        if (this.fwTransfer) {
                            UploadStat.FW_FW_SUCCESS.incrementStat();
                        }
                        if (string2.equals("GET")) {
                            UploadStat.PUSHED_GET.incrementStat();
                            RouterService.getUploadManager().acceptUpload(HTTPRequestMethod.GET, this.socket, this.data.isForceAllow());
                            break block10;
                        }
                        if (!string2.equals("HEAD")) {
                            UploadStat.PUSHED_UNKNOWN.incrementStat();
                            throw new IOException();
                        }
                        UploadStat.PUSHED_HEAD.incrementStat();
                        RouterService.getUploadManager().acceptUpload(HTTPRequestMethod.HEAD, this.socket, this.data.isForceAllow());
                    }
                    catch (IOException iOException) {
                        if (LOG.isDebugEnabled()) {
                            LOG.debug((Object)("Failed push connect/transfer to " + this.data.getHost() + ":" + this.data.getPort() + ", fwt: " + this.fwTransfer));
                        }
                        if (this.fwTransfer) {
                            UploadStat.FW_FW_FAILURE.incrementStat();
                        }
                        UploadStat.PUSH_FAILED.incrementStat();
                    }
                }
                Object var4_6 = null;
            }
            catch (Throwable throwable) {
                Object var4_5 = null;
                IOUtils.close(this.socket);
                throw throwable;
            }
            IOUtils.close(this.socket);
        }
    }
}

