/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella;

import com.limegroup.gnutella.ActivityCallback;
import com.limegroup.gnutella.Assert;
import com.limegroup.gnutella.Connection;
import com.limegroup.gnutella.ConnectionManager;
import com.limegroup.gnutella.DownloadManager;
import com.limegroup.gnutella.Endpoint;
import com.limegroup.gnutella.ErrorService;
import com.limegroup.gnutella.FileManager;
import com.limegroup.gnutella.ForMeReplyHandler;
import com.limegroup.gnutella.GUID;
import com.limegroup.gnutella.ManagedConnection;
import com.limegroup.gnutella.MessageListener;
import com.limegroup.gnutella.MulticastService;
import com.limegroup.gnutella.PongCacher;
import com.limegroup.gnutella.QueryUnicaster;
import com.limegroup.gnutella.ReplyHandler;
import com.limegroup.gnutella.Response;
import com.limegroup.gnutella.RouteTable;
import com.limegroup.gnutella.RouterService;
import com.limegroup.gnutella.UDPReplyHandler;
import com.limegroup.gnutella.UDPService;
import com.limegroup.gnutella.UploadManager;
import com.limegroup.gnutella.guess.GUESSEndpoint;
import com.limegroup.gnutella.guess.OnDemandUnicaster;
import com.limegroup.gnutella.guess.QueryKey;
import com.limegroup.gnutella.messages.Message;
import com.limegroup.gnutella.messages.PingReply;
import com.limegroup.gnutella.messages.PingRequest;
import com.limegroup.gnutella.messages.PushRequest;
import com.limegroup.gnutella.messages.QueryReply;
import com.limegroup.gnutella.messages.QueryRequest;
import com.limegroup.gnutella.messages.StaticMessages;
import com.limegroup.gnutella.messages.vendor.ContentResponse;
import com.limegroup.gnutella.messages.vendor.GiveStatsVendorMessage;
import com.limegroup.gnutella.messages.vendor.HeadPing;
import com.limegroup.gnutella.messages.vendor.HeadPong;
import com.limegroup.gnutella.messages.vendor.HopsFlowVendorMessage;
import com.limegroup.gnutella.messages.vendor.LimeACKVendorMessage;
import com.limegroup.gnutella.messages.vendor.PushProxyAcknowledgement;
import com.limegroup.gnutella.messages.vendor.PushProxyRequest;
import com.limegroup.gnutella.messages.vendor.QueryStatusResponse;
import com.limegroup.gnutella.messages.vendor.ReplyNumberVendorMessage;
import com.limegroup.gnutella.messages.vendor.SimppRequestVM;
import com.limegroup.gnutella.messages.vendor.SimppVM;
import com.limegroup.gnutella.messages.vendor.StatisticVendorMessage;
import com.limegroup.gnutella.messages.vendor.TCPConnectBackRedirect;
import com.limegroup.gnutella.messages.vendor.TCPConnectBackVendorMessage;
import com.limegroup.gnutella.messages.vendor.UDPConnectBackRedirect;
import com.limegroup.gnutella.messages.vendor.UDPConnectBackVendorMessage;
import com.limegroup.gnutella.messages.vendor.UDPCrawlerPing;
import com.limegroup.gnutella.messages.vendor.UDPCrawlerPong;
import com.limegroup.gnutella.messages.vendor.VendorMessage;
import com.limegroup.gnutella.routing.PatchTableMessage;
import com.limegroup.gnutella.routing.QueryRouteTable;
import com.limegroup.gnutella.routing.ResetTableMessage;
import com.limegroup.gnutella.routing.RouteTableMessage;
import com.limegroup.gnutella.search.QueryDispatcher;
import com.limegroup.gnutella.search.QueryHandler;
import com.limegroup.gnutella.search.ResultCounter;
import com.limegroup.gnutella.settings.ConnectionSettings;
import com.limegroup.gnutella.settings.DownloadSettings;
import com.limegroup.gnutella.settings.SearchSettings;
import com.limegroup.gnutella.simpp.SimppManager;
import com.limegroup.gnutella.statistics.OutOfBandThroughputStat;
import com.limegroup.gnutella.statistics.ReceivedMessageStatHandler;
import com.limegroup.gnutella.statistics.RouteErrorStat;
import com.limegroup.gnutella.statistics.RoutedQueryStat;
import com.limegroup.gnutella.statistics.SentMessageStatHandler;
import com.limegroup.gnutella.udpconnect.UDPConnectionMessage;
import com.limegroup.gnutella.upelection.PromotionManager;
import com.limegroup.gnutella.util.FixedsizeHashMap;
import com.limegroup.gnutella.util.IOUtils;
import com.limegroup.gnutella.util.ManagedThread;
import com.limegroup.gnutella.util.NetworkUtils;
import com.limegroup.gnutella.util.NoMoreStorageException;
import com.limegroup.gnutella.util.ProcessingQueue;
import com.limegroup.gnutella.util.Sockets;
import java.io.IOException;
import java.io.OutputStream;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.Socket;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.IdentityHashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public abstract class MessageRouter {
    private static final Log LOG;
    protected static ConnectionManager _manager;
    private static final int OLD_CONNECTIONS_TO_USE = 15;
    protected byte[] _clientGUID;
    private final ReplyHandler FOR_ME_REPLY_HANDLER = ForMeReplyHandler.instance();
    private int MAX_ROUTE_TABLE_SIZE = 50000;
    private final int MAX_BYPASSED_RESULTS = 150;
    private RouteTable _pingRouteTable = new RouteTable(120, this.MAX_ROUTE_TABLE_SIZE);
    private RouteTable _queryRouteTable = new RouteTable(300, this.MAX_ROUTE_TABLE_SIZE);
    private RouteTable _pushRouteTable = new RouteTable(420, this.MAX_ROUTE_TABLE_SIZE);
    private RouteTable _headPongRouteTable = new RouteTable(10, this.MAX_ROUTE_TABLE_SIZE);
    private static final long CLEAR_TIME = 30000L;
    private static final long HOPS_FLOW_INTERVAL = 15000L;
    static int MAX_BUFFERED_REPLIES;
    private final Map _outOfBandReplies = new Hashtable();
    private final Map _bypassedResults = new HashMap();
    private static final FixedsizeHashMap _udpConnectBacks;
    private static final int MAX_UDP_CONNECTBACK_FORWARDS = 5;
    private static final FixedsizeHashMap _tcpConnectBacks;
    private static final int MAX_TCP_CONNECTBACK_FORWARDS = 5;
    private static final ProcessingQueue TCP_CONNECT_BACKER;
    protected final QueryUnicaster UNICASTER = QueryUnicaster.instance();
    private final QueryDispatcher DYNAMIC_QUERIER = QueryDispatcher.instance();
    private ActivityCallback _callback;
    private static FileManager _fileManager;
    private final QRPPropagator QRP_PROPAGATOR = new QRPPropagator();
    private QueryRouteTable _lastQueryRouteTable;
    private static final int HIGH_HOPS_RESPONSE_LIMIT = 10;
    private static final long TIMED_GUID_LIFETIME = 25000L;
    private volatile Map _messageListeners = Collections.EMPTY_MAP;
    private final Object MESSAGE_LISTENER_LOCK = new Object();
    private PromotionManager _promotionManager;
    private long _lastQueryKeyTime;
    private volatile Map messageHandlers = new IdentityHashMap();
    private volatile Map udpMessageHandlers = new IdentityHashMap();
    private volatile Map multicastMessageHandlers = new IdentityHashMap();
    static /* synthetic */ Class class$0;
    static /* synthetic */ Class class$1;
    static /* synthetic */ Class class$2;
    static /* synthetic */ Class class$3;
    static /* synthetic */ Class class$4;
    static /* synthetic */ Class class$5;
    static /* synthetic */ Class class$6;
    static /* synthetic */ Class class$7;
    static /* synthetic */ Class class$8;
    static /* synthetic */ Class class$9;
    static /* synthetic */ Class class$10;
    static /* synthetic */ Class class$11;
    static /* synthetic */ Class class$12;
    static /* synthetic */ Class class$13;
    static /* synthetic */ Class class$14;
    static /* synthetic */ Class class$15;
    static /* synthetic */ Class class$16;
    static /* synthetic */ Class class$17;
    static /* synthetic */ Class class$18;
    static /* synthetic */ Class class$19;
    static /* synthetic */ Class class$20;
    static /* synthetic */ Class class$21;
    static /* synthetic */ Class class$22;
    static /* synthetic */ Class class$23;
    static /* synthetic */ Class class$24;

    static {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("com.limegroup.gnutella.MessageRouter");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        LOG = LogFactory.getLog((Class)clazz);
        MAX_BUFFERED_REPLIES = 250;
        _udpConnectBacks = new FixedsizeHashMap(200);
        _tcpConnectBacks = new FixedsizeHashMap(200);
        TCP_CONNECT_BACKER = new ProcessingQueue("TCPConnectBack");
    }

    protected MessageRouter() {
        this._clientGUID = RouterService.getMyGUID();
        Class<?> clazz = class$1;
        if (clazz == null) {
            try {
                clazz = class$1 = Class.forName("com.limegroup.gnutella.messages.PingRequest");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        this.setMessageHandler(clazz, new PingRequestHandler());
        Class<?> clazz2 = class$2;
        if (clazz2 == null) {
            try {
                clazz2 = class$2 = Class.forName("com.limegroup.gnutella.messages.PingReply");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        this.setMessageHandler(clazz2, new PingReplyHandler());
        Class<?> clazz3 = class$3;
        if (clazz3 == null) {
            try {
                clazz3 = class$3 = Class.forName("com.limegroup.gnutella.messages.QueryRequest");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        this.setMessageHandler(clazz3, new QueryRequestHandler());
        Class<?> clazz4 = class$4;
        if (clazz4 == null) {
            try {
                clazz4 = class$4 = Class.forName("com.limegroup.gnutella.messages.QueryReply");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        this.setMessageHandler(clazz4, new QueryReplyHandler());
        Class<?> clazz5 = class$5;
        if (clazz5 == null) {
            try {
                clazz5 = class$5 = Class.forName("com.limegroup.gnutella.messages.PushRequest");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        this.setMessageHandler(clazz5, new PushRequestHandler());
        Class<?> clazz6 = class$6;
        if (clazz6 == null) {
            try {
                clazz6 = class$6 = Class.forName("com.limegroup.gnutella.routing.ResetTableMessage");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        this.setMessageHandler(clazz6, new ResetTableHandler());
        Class<?> clazz7 = class$7;
        if (clazz7 == null) {
            try {
                clazz7 = class$7 = Class.forName("com.limegroup.gnutella.routing.PatchTableMessage");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        this.setMessageHandler(clazz7, new PatchTableHandler());
        Class<?> clazz8 = class$8;
        if (clazz8 == null) {
            try {
                clazz8 = class$8 = Class.forName("com.limegroup.gnutella.messages.vendor.TCPConnectBackVendorMessage");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        this.setMessageHandler(clazz8, new TCPConnectBackHandler());
        Class<?> clazz9 = class$9;
        if (clazz9 == null) {
            try {
                clazz9 = class$9 = Class.forName("com.limegroup.gnutella.messages.vendor.UDPConnectBackVendorMessage");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        this.setMessageHandler(clazz9, new UDPConnectBackHandler());
        Class<?> clazz10 = class$10;
        if (clazz10 == null) {
            try {
                clazz10 = class$10 = Class.forName("com.limegroup.gnutella.messages.vendor.TCPConnectBackRedirect");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        this.setMessageHandler(clazz10, new TCPConnectBackRedirectHandler());
        Class<?> clazz11 = class$11;
        if (clazz11 == null) {
            try {
                clazz11 = class$11 = Class.forName("com.limegroup.gnutella.messages.vendor.UDPConnectBackRedirect");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        this.setMessageHandler(clazz11, new UDPConnectBackRedirectHandler());
        Class<?> clazz12 = class$12;
        if (clazz12 == null) {
            try {
                clazz12 = class$12 = Class.forName("com.limegroup.gnutella.messages.vendor.PushProxyRequest");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        this.setMessageHandler(clazz12, new PushProxyRequestHandler());
        Class<?> clazz13 = class$13;
        if (clazz13 == null) {
            try {
                clazz13 = class$13 = Class.forName("com.limegroup.gnutella.messages.vendor.QueryStatusResponse");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        this.setMessageHandler(clazz13, new QueryStatusResponseHandler());
        Class<?> clazz14 = class$14;
        if (clazz14 == null) {
            try {
                clazz14 = class$14 = Class.forName("com.limegroup.gnutella.messages.vendor.GiveStatsVendorMessage");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        this.setMessageHandler(clazz14, new GiveStatsHandler());
        Class<?> clazz15 = class$15;
        if (clazz15 == null) {
            try {
                clazz15 = class$15 = Class.forName("com.limegroup.gnutella.messages.vendor.StatisticVendorMessage");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        this.setMessageHandler(clazz15, new StatisticsHandler());
        Class<?> clazz16 = class$16;
        if (clazz16 == null) {
            try {
                clazz16 = class$16 = Class.forName("com.limegroup.gnutella.messages.vendor.HeadPing");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        this.setMessageHandler(clazz16, new HeadPingHandler());
        Class<?> clazz17 = class$17;
        if (clazz17 == null) {
            try {
                clazz17 = class$17 = Class.forName("com.limegroup.gnutella.messages.vendor.SimppRequestVM");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        this.setMessageHandler(clazz17, new SimppRequestVMHandler());
        Class<?> clazz18 = class$18;
        if (clazz18 == null) {
            try {
                clazz18 = class$18 = Class.forName("com.limegroup.gnutella.messages.vendor.SimppVM");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        this.setMessageHandler(clazz18, new SimppVMHandler());
        Class<?> clazz19 = class$19;
        if (clazz19 == null) {
            try {
                clazz19 = class$19 = Class.forName("com.limegroup.gnutella.messages.vendor.HeadPong");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        this.setMessageHandler(clazz19, new HeadPongHandler());
        Class<?> clazz20 = class$20;
        if (clazz20 == null) {
            try {
                clazz20 = class$20 = Class.forName("com.limegroup.gnutella.messages.vendor.VendorMessage");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        this.setMessageHandler(clazz20, new VendorMessageHandler());
        Class<?> clazz21 = class$3;
        if (clazz21 == null) {
            try {
                clazz21 = class$3 = Class.forName("com.limegroup.gnutella.messages.QueryRequest");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        this.setUDPMessageHandler(clazz21, new UDPQueryRequestHandler());
        Class<?> clazz22 = class$4;
        if (clazz22 == null) {
            try {
                clazz22 = class$4 = Class.forName("com.limegroup.gnutella.messages.QueryReply");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        this.setUDPMessageHandler(clazz22, new UDPQueryReplyHandler());
        Class<?> clazz23 = class$1;
        if (clazz23 == null) {
            try {
                clazz23 = class$1 = Class.forName("com.limegroup.gnutella.messages.PingRequest");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        this.setUDPMessageHandler(clazz23, new UDPPingRequestHandler());
        Class<?> clazz24 = class$2;
        if (clazz24 == null) {
            try {
                clazz24 = class$2 = Class.forName("com.limegroup.gnutella.messages.PingReply");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        this.setUDPMessageHandler(clazz24, new UDPPingReplyHandler());
        Class<?> clazz25 = class$5;
        if (clazz25 == null) {
            try {
                clazz25 = class$5 = Class.forName("com.limegroup.gnutella.messages.PushRequest");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        this.setUDPMessageHandler(clazz25, new UDPPushRequestHandler());
        Class<?> clazz26 = class$21;
        if (clazz26 == null) {
            try {
                clazz26 = class$21 = Class.forName("com.limegroup.gnutella.messages.vendor.LimeACKVendorMessage");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        this.setUDPMessageHandler(clazz26, new UDPLimeACKVendorMessageHandler());
        Class<?> clazz27 = class$22;
        if (clazz27 == null) {
            try {
                clazz27 = class$22 = Class.forName("com.limegroup.gnutella.messages.vendor.ReplyNumberVendorMessage");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        this.setUDPMessageHandler(clazz27, new UDPReplyNumberMessageHandler());
        Class<?> clazz28 = class$14;
        if (clazz28 == null) {
            try {
                clazz28 = class$14 = Class.forName("com.limegroup.gnutella.messages.vendor.GiveStatsVendorMessage");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        this.setUDPMessageHandler(clazz28, new UDPGiveStatsHandler());
        Class<?> clazz29 = class$15;
        if (clazz29 == null) {
            try {
                clazz29 = class$15 = Class.forName("com.limegroup.gnutella.messages.vendor.StatisticVendorMessage");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        this.setUDPMessageHandler(clazz29, new UDPStatisticsMessageHandler());
        Class<?> clazz30 = class$23;
        if (clazz30 == null) {
            try {
                clazz30 = class$23 = Class.forName("com.limegroup.gnutella.messages.vendor.UDPCrawlerPing");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        this.setUDPMessageHandler(clazz30, new UDPUDPCrawlerPingHandler());
        Class<?> clazz31 = class$16;
        if (clazz31 == null) {
            try {
                clazz31 = class$16 = Class.forName("com.limegroup.gnutella.messages.vendor.HeadPing");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        this.setUDPMessageHandler(clazz31, new UDPHeadPingHandler());
        Class<?> clazz32 = class$24;
        if (clazz32 == null) {
            try {
                clazz32 = class$24 = Class.forName("com.limegroup.gnutella.messages.vendor.ContentResponse");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        this.setUDPMessageHandler(clazz32, new UDPContentResponseHandler());
        Class<?> clazz33 = class$3;
        if (clazz33 == null) {
            try {
                clazz33 = class$3 = Class.forName("com.limegroup.gnutella.messages.QueryRequest");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        this.setMulticastMessageHandler(clazz33, new MulticastQueryRequestHandler());
        Class<?> clazz34 = class$1;
        if (clazz34 == null) {
            try {
                clazz34 = class$1 = Class.forName("com.limegroup.gnutella.messages.PingRequest");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        this.setMulticastMessageHandler(clazz34, new MulticastPingRequestHandler());
        Class<?> clazz35 = class$5;
        if (clazz35 == null) {
            try {
                clazz35 = class$5 = Class.forName("com.limegroup.gnutella.messages.PushRequest");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        this.setMulticastMessageHandler(clazz35, new MulticastPushRequestHandler());
    }

    private static Map setHandler(Map map, Class clazz, MessageHandler messageHandler) {
        if (clazz == null) {
            throw new NullPointerException("Class is null");
        }
        if (messageHandler == null) {
            throw new NullPointerException("MessageHandler is null");
        }
        IdentityHashMap<Class, MessageHandler> identityHashMap = new IdentityHashMap<Class, MessageHandler>(map);
        MessageHandler messageHandler2 = identityHashMap.put(clazz, messageHandler);
        if (messageHandler2 != null && LOG.isErrorEnabled()) {
            LOG.error((Object)("There was already a MessageHandler of type " + messageHandler2.getClass() + " registered for " + clazz));
        }
        return identityHashMap;
    }

    private static MessageHandler getHandler(Map map, Class clazz) {
        return (MessageHandler)map.get(clazz);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setMessageHandler(Class clazz, MessageHandler messageHandler) {
        Map map = this.messageHandlers;
        synchronized (map) {
            this.messageHandlers = MessageRouter.setHandler(this.messageHandlers, clazz, messageHandler);
        }
    }

    public MessageHandler getMessageHandler(Class clazz) {
        return MessageRouter.getHandler(this.messageHandlers, clazz);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setUDPMessageHandler(Class clazz, MessageHandler messageHandler) {
        Map map = this.udpMessageHandlers;
        synchronized (map) {
            this.udpMessageHandlers = MessageRouter.setHandler(this.udpMessageHandlers, clazz, messageHandler);
        }
    }

    public MessageHandler getUDPMessageHandler(Class clazz) {
        return MessageRouter.getHandler(this.udpMessageHandlers, clazz);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setMulticastMessageHandler(Class clazz, MessageHandler messageHandler) {
        Map map = this.multicastMessageHandlers;
        synchronized (map) {
            this.multicastMessageHandlers = MessageRouter.setHandler(this.multicastMessageHandlers, clazz, messageHandler);
        }
    }

    public MessageHandler getMulticastMessageHandler(Class clazz) {
        return MessageRouter.getHandler(this.multicastMessageHandlers, clazz);
    }

    public void initialize() {
        _manager = RouterService.getConnectionManager();
        this._callback = RouterService.getCallback();
        _fileManager = RouterService.getFileManager();
        this._promotionManager = RouterService.getPromotionManager();
        this.QRP_PROPAGATOR.start();
        RouterService.schedule(new Expirer(), 30000L, 30000L);
        RouterService.schedule(new ConnectBackExpirer(), 300000L, 300000L);
        RouterService.schedule(new HopsFlowManager(), 150000L, 15000L);
    }

    public void originateQueryGUID(byte[] byArray) {
        this._queryRouteTable.routeReply(byArray, this.FOR_ME_REPLY_HANDLER);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void queryKilled(GUID gUID) throws IllegalArgumentException {
        if (gUID == null) {
            throw new IllegalArgumentException("Input GUID is null!");
        }
        Map map = this._bypassedResults;
        synchronized (map) {
            if (!RouterService.getDownloadManager().isGuidForQueryDownloading(gUID)) {
                this._bypassedResults.remove(gUID);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void downloadFinished(GUID gUID) throws IllegalArgumentException {
        if (gUID == null) {
            throw new IllegalArgumentException("Input GUID is null!");
        }
        Map map = this._bypassedResults;
        synchronized (map) {
            if (!this._callback.isQueryAlive(gUID) && !RouterService.getDownloadManager().isGuidForQueryDownloading(gUID)) {
                this._bypassedResults.remove(gUID);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Set getGuessLocs(GUID gUID) {
        HashSet hashSet = new HashSet();
        Map map = this._bypassedResults;
        synchronized (map) {
            Set set = (Set)this._bypassedResults.get(gUID);
            if (set != null) {
                hashSet.addAll(set);
            }
        }
        return hashSet;
    }

    public String getPingRouteTableDump() {
        return this._pingRouteTable.toString();
    }

    public String getQueryRouteTableDump() {
        return this._queryRouteTable.toString();
    }

    public String getPushRouteTableDump() {
        return this._pushRouteTable.toString();
    }

    public void removeConnection(ReplyHandler replyHandler) {
        this.DYNAMIC_QUERIER.removeReplyHandler(replyHandler);
        this._pingRouteTable.removeReplyHandler(replyHandler);
        this._queryRouteTable.removeReplyHandler(replyHandler);
        this._pushRouteTable.removeReplyHandler(replyHandler);
        this._headPongRouteTable.removeReplyHandler(replyHandler);
    }

    public void handleMessage(Message message, ManagedConnection managedConnection) {
        message.hop();
        MessageHandler messageHandler = this.getMessageHandler(message.getClass());
        if (messageHandler != null) {
            messageHandler.handleMessage(message, null, managedConnection);
        } else if (message instanceof VendorMessage) {
            Class<?> clazz = class$20;
            if (clazz == null) {
                try {
                    clazz = class$20 = Class.forName("com.limegroup.gnutella.messages.vendor.VendorMessage");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            if ((messageHandler = this.getMessageHandler(clazz)) != null) {
                messageHandler.handleMessage(message, null, managedConnection);
            }
        }
        this.notifyMessageListener(message, managedConnection);
    }

    private final void notifyMessageListener(Message message, ReplyHandler replyHandler) {
        List list = (List)this._messageListeners.get(message.getGUID());
        if (list != null) {
            Iterator iterator = list.iterator();
            while (iterator.hasNext()) {
                MessageListener messageListener = (MessageListener)iterator.next();
                messageListener.processMessage(message, replyHandler);
            }
        }
    }

    public void handleUDPMessage(Message message, InetSocketAddress inetSocketAddress) {
        message.hop();
        if (message instanceof UDPConnectionMessage) {
            RouterService.getUDPMultiplexor().routeMessage((UDPConnectionMessage)message, inetSocketAddress);
            return;
        }
        InetAddress inetAddress = inetSocketAddress.getAddress();
        int n = inetSocketAddress.getPort();
        UDPReplyHandler uDPReplyHandler = new UDPReplyHandler(inetAddress, n);
        MessageHandler messageHandler = this.getUDPMessageHandler(message.getClass());
        if (messageHandler != null) {
            messageHandler.handleMessage(message, inetSocketAddress, uDPReplyHandler);
        }
        this.notifyMessageListener(message, uDPReplyHandler);
    }

    public void handleMulticastMessage(Message message, InetSocketAddress inetSocketAddress) {
        if (message.getTTL() > 1) {
            return;
        }
        message.hop();
        InetAddress inetAddress = inetSocketAddress.getAddress();
        int n = inetSocketAddress.getPort();
        if (NetworkUtils.isLocalAddress(inetAddress) && !ConnectionSettings.ALLOW_MULTICAST_LOOPBACK.getValue()) {
            return;
        }
        UDPReplyHandler uDPReplyHandler = new UDPReplyHandler(inetAddress, n);
        MessageHandler messageHandler = this.getMulticastMessageHandler(message.getClass());
        if (messageHandler != null) {
            messageHandler.handleMessage(message, inetSocketAddress, uDPReplyHandler);
        }
        this.notifyMessageListener(message, uDPReplyHandler);
    }

    protected boolean hasValidQueryKey(InetAddress inetAddress, int n, QueryRequest queryRequest) {
        QueryKey queryKey = queryRequest.getQueryKey();
        if (queryKey == null) {
            return false;
        }
        return queryKey.isFor(inetAddress, n);
    }

    protected void sendAcknowledgement(InetSocketAddress inetSocketAddress, byte[] byArray) {
        PingReply pingReply;
        ConnectionManager connectionManager = RouterService.getConnectionManager();
        Endpoint endpoint = connectionManager.getConnectedGUESSUltrapeer();
        if (endpoint != null) {
            try {
                pingReply = PingReply.createGUESSReply(byArray, (byte)1, endpoint);
            }
            catch (UnknownHostException unknownHostException) {
                pingReply = this.createPingReply(byArray);
            }
        } else {
            pingReply = this.createPingReply(byArray);
        }
        if (pingReply == null) {
            return;
        }
        UDPService.instance().send(pingReply, inetSocketAddress.getAddress(), inetSocketAddress.getPort());
        SentMessageStatHandler.UDP_PING_REPLIES.addMessage(pingReply);
    }

    private PingReply createPingReply(byte[] byArray) {
        GUESSEndpoint gUESSEndpoint = this.UNICASTER.getUnicastEndpoint();
        if (gUESSEndpoint == null) {
            if (RouterService.isIpPortValid()) {
                return PingReply.create(byArray, (byte)1);
            }
            return null;
        }
        return PingReply.createGUESSReply(byArray, (byte)1, gUESSEndpoint.getPort(), gUESSEndpoint.getAddress().getAddress());
    }

    final void handlePingRequestPossibleDuplicate(PingRequest pingRequest, ReplyHandler replyHandler) {
        if (this._pingRouteTable.tryToRouteReply(pingRequest.getGUID(), replyHandler) != null) {
            this.handlePingRequest(pingRequest, replyHandler);
        }
    }

    final void handleUDPPingRequestPossibleDuplicate(PingRequest pingRequest, ReplyHandler replyHandler, InetSocketAddress inetSocketAddress) {
        if (this._pingRouteTable.tryToRouteReply(pingRequest.getGUID(), replyHandler) != null) {
            this.handleUDPPingRequest(pingRequest, replyHandler, inetSocketAddress);
        }
    }

    final void handleQueryRequestPossibleDuplicate(QueryRequest queryRequest, ManagedConnection managedConnection) {
        boolean bl = queryRequest.getTTL() == 0 && (queryRequest.getHops() == 1 || queryRequest.getHops() == 2);
        ResultCounter resultCounter = this._queryRouteTable.tryToRouteReply(queryRequest.getGUID(), managedConnection);
        if (resultCounter != null) {
            if (bl) {
                this._queryRouteTable.setTTL(resultCounter, (byte)1);
            }
            this.handleQueryRequest(queryRequest, managedConnection, resultCounter, true);
        } else if (resultCounter == null && !bl) {
            if (this.wasProbeQuery(queryRequest)) {
                this.handleQueryRequest(queryRequest, managedConnection, resultCounter, false);
            } else {
                this.tallyDupQuery(queryRequest);
            }
        } else if (resultCounter == null && bl) {
            this.tallyDupQuery(queryRequest);
        } else {
            this.tallyDupQuery(queryRequest);
        }
    }

    private boolean wasProbeQuery(QueryRequest queryRequest) {
        return queryRequest.getTTL() > 0 && this._queryRouteTable.getAndSetTTL(queryRequest.getGUID(), (byte)1, (byte)(queryRequest.getTTL() + 1));
    }

    private void tallyDupQuery(QueryRequest queryRequest) {
        ReceivedMessageStatHandler.TCP_DUPLICATE_QUERIES.addMessage(queryRequest);
    }

    final boolean handleUDPQueryRequestPossibleDuplicate(QueryRequest queryRequest, ReplyHandler replyHandler) {
        ResultCounter resultCounter = this._queryRouteTable.tryToRouteReply(queryRequest.getGUID(), replyHandler);
        if (resultCounter != null) {
            this.handleQueryRequest(queryRequest, replyHandler, resultCounter, true);
            return true;
        }
        return false;
    }

    private final void handlePingRequest(PingRequest pingRequest, ReplyHandler replyHandler) {
        if (pingRequest.isHeartbeat() || replyHandler.allowNewPings()) {
            this.respondToPingRequest(pingRequest, replyHandler);
        }
    }

    protected void handleUDPPingRequest(PingRequest pingRequest, ReplyHandler replyHandler, InetSocketAddress inetSocketAddress) {
        if (pingRequest.isQueryKeyRequest()) {
            this.sendQueryKeyPong(pingRequest, inetSocketAddress);
        } else {
            this.respondToUDPPingRequest(pingRequest, inetSocketAddress, replyHandler);
        }
    }

    protected void sendQueryKeyPong(PingRequest pingRequest, InetSocketAddress inetSocketAddress) {
        long l = System.currentTimeMillis();
        if (l - this._lastQueryKeyTime < (long)SearchSettings.QUERY_KEY_DELAY.getValue()) {
            return;
        }
        this._lastQueryKeyTime = l;
        InetAddress inetAddress = inetSocketAddress.getAddress();
        int n = inetSocketAddress.getPort();
        QueryKey queryKey = QueryKey.getQueryKey(inetAddress, n);
        PingReply pingReply = PingReply.createQueryKeyReply(pingRequest.getGUID(), (byte)1, queryKey);
        UDPService.instance().send(pingReply, inetSocketAddress.getAddress(), inetSocketAddress.getPort());
    }

    protected void handleUDPPingReply(PingReply pingReply, ReplyHandler replyHandler, InetAddress inetAddress, int n) {
        if (pingReply.getQueryKey() != null) {
            OnDemandUnicaster.handleQueryKeyPong(pingReply);
            return;
        }
        if (pingReply.getPort() != n || !pingReply.getInetAddress().equals(inetAddress)) {
            this.UNICASTER.addUnicastEndpoint(inetAddress, n);
        }
        this.handlePingReply(pingReply, replyHandler);
    }

    protected void handleQueryRequest(QueryRequest queryRequest, ReplyHandler replyHandler, ResultCounter resultCounter, boolean bl) {
        if (!replyHandler.isPersonalSpam(queryRequest)) {
            this._callback.handleQueryString(queryRequest.getQuery());
        }
        this.updateMessage(queryRequest, replyHandler);
        if (replyHandler.isSupernodeClientConnection() && resultCounter != null) {
            if (queryRequest.desiresOutOfBandReplies()) {
                String string = replyHandler.getInetAddress().getHostAddress();
                String string2 = NetworkUtils.ip2string(RouterService.getAddress());
                if (!(queryRequest.getReplyAddress().equals(string) || queryRequest.getReplyAddress().equals(string2) && RouterService.isOOBCapable())) {
                    return;
                }
            }
            bl = false;
            this.respondToQueryRequest(queryRequest, this._clientGUID, replyHandler);
            this.multicastQueryRequest(queryRequest);
            if (replyHandler.isGoodLeaf()) {
                this.sendDynamicQuery(QueryHandler.createHandlerForNewLeaf(queryRequest, replyHandler, resultCounter), replyHandler);
            } else {
                this.sendDynamicQuery(QueryHandler.createHandlerForOldLeaf(queryRequest, replyHandler, resultCounter), replyHandler);
            }
        } else if (queryRequest.getTTL() > 0 && RouterService.isSupernode()) {
            if (replyHandler.isGoodUltrapeer()) {
                this.forwardQueryToUltrapeers(queryRequest, replyHandler);
            } else {
                this.forwardLimitedQueryToUltrapeers(queryRequest, replyHandler);
            }
        }
        if (bl) {
            this.forwardQueryRequestToLeaves(queryRequest, replyHandler);
            if (!(!queryRequest.isFirewalledSource() || RouterService.acceptedIncomingConnection() || queryRequest.canDoFirewalledTransfer() && UDPService.instance().canDoFWT())) {
                return;
            }
            this.respondToQueryRequest(queryRequest, this._clientGUID, replyHandler);
        }
    }

    protected void handleLimeACKMessage(LimeACKVendorMessage limeACKVendorMessage, InetSocketAddress inetSocketAddress) {
        GUID.TimedGUID timedGUID = new GUID.TimedGUID(new GUID(limeACKVendorMessage.getGUID()), 25000L);
        QueryResponseBundle queryResponseBundle = (QueryResponseBundle)this._outOfBandReplies.remove(timedGUID);
        if (queryResponseBundle != null && limeACKVendorMessage.getNumResults() > 0) {
            Object object;
            InetAddress inetAddress = inetSocketAddress.getAddress();
            int n = inetSocketAddress.getPort();
            Iterator iterator = null;
            if (limeACKVendorMessage.getNumResults() < queryResponseBundle._responses.length) {
                object = new Response[limeACKVendorMessage.getNumResults()];
                int n2 = 0;
                while (n2 < ((Response[])object).length) {
                    object[n2] = queryResponseBundle._responses[n2];
                    ++n2;
                }
                iterator = this.responsesToQueryReplies((Response[])object, queryResponseBundle._query, 1);
            } else {
                iterator = this.responsesToQueryReplies(queryResponseBundle._responses, queryResponseBundle._query, 1);
            }
            while (iterator.hasNext()) {
                object = (QueryReply)iterator.next();
                UDPService.instance().send((Message)object, inetAddress, n);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void handleReplyNumberMessage(ReplyNumberVendorMessage replyNumberVendorMessage, InetSocketAddress inetSocketAddress) {
        GUID gUID = new GUID(replyNumberVendorMessage.getGUID());
        int n = RouterService.getSearchResultHandler().getNumResultsForQuery(gUID);
        if (n < 0) {
            n = this.DYNAMIC_QUERIER.getLeafResultsForQuery(gUID);
        }
        if (n < 0 || n > 250) {
            OutOfBandThroughputStat.RESPONSES_BYPASSED.addData(replyNumberVendorMessage.getNumResults());
            if (!replyNumberVendorMessage.canReceiveUnsolicited()) {
                return;
            }
            DownloadManager downloadManager = RouterService.getDownloadManager();
            if (!this._callback.isQueryAlive(gUID) && !downloadManager.isGuidForQueryDownloading(gUID)) {
                return;
            }
            GUESSEndpoint gUESSEndpoint = new GUESSEndpoint(inetSocketAddress.getAddress(), inetSocketAddress.getPort());
            Map map = this._bypassedResults;
            synchronized (map) {
                HashSet<GUESSEndpoint> hashSet = (HashSet<GUESSEndpoint>)this._bypassedResults.get(gUID);
                if (hashSet == null) {
                    hashSet = new HashSet<GUESSEndpoint>();
                    this._bypassedResults.put(gUID, hashSet);
                }
                if (this._bypassedResults.size() <= 150) {
                    hashSet.add(gUESSEndpoint);
                }
            }
            return;
        }
        LimeACKVendorMessage limeACKVendorMessage = new LimeACKVendorMessage(gUID, replyNumberVendorMessage.getNumResults());
        UDPService.instance().send(limeACKVendorMessage, inetSocketAddress.getAddress(), inetSocketAddress.getPort());
        OutOfBandThroughputStat.RESPONSES_REQUESTED.addData(replyNumberVendorMessage.getNumResults());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean bufferResponsesForLaterDelivery(QueryRequest queryRequest, Response[] responseArray) {
        Map map = this._outOfBandReplies;
        synchronized (map) {
            block4: {
                if (this._outOfBandReplies.size() >= MAX_BUFFERED_REPLIES) break block4;
                GUID.TimedGUID timedGUID = new GUID.TimedGUID(new GUID(queryRequest.getGUID()), 25000L);
                this._outOfBandReplies.put(timedGUID, new QueryResponseBundle(queryRequest, responseArray));
                return true;
            }
            return false;
        }
    }

    protected void handleUDPConnectBackRequest(UDPConnectBackVendorMessage uDPConnectBackVendorMessage, Connection connection) {
        GUID gUID = uDPConnectBackVendorMessage.getConnectBackGUID();
        int n = uDPConnectBackVendorMessage.getConnectBackPort();
        InetAddress inetAddress = connection.getInetAddress();
        UDPConnectBackRedirect uDPConnectBackRedirect = new UDPConnectBackRedirect(gUID, inetAddress, n);
        int n2 = 0;
        ArrayList arrayList = new ArrayList(_manager.getInitializedConnections());
        Collections.shuffle(arrayList);
        Iterator iterator = arrayList.iterator();
        while (iterator.hasNext() && n2 < 5) {
            ManagedConnection managedConnection = (ManagedConnection)iterator.next();
            if (managedConnection == connection || managedConnection.remoteHostSupportsUDPRedirect() < 0) continue;
            managedConnection.send(uDPConnectBackRedirect);
            ++n2;
        }
    }

    protected void handleUDPConnectBackRedirect(UDPConnectBackRedirect uDPConnectBackRedirect, Connection connection) {
        if (!connection.isSupernodeSupernodeConnection()) {
            return;
        }
        GUID gUID = uDPConnectBackRedirect.getConnectBackGUID();
        int n = uDPConnectBackRedirect.getConnectBackPort();
        InetAddress inetAddress = uDPConnectBackRedirect.getConnectBackAddress();
        Endpoint endpoint = new Endpoint(inetAddress.getAddress(), n);
        if (_manager.isConnectedTo(endpoint.getAddress())) {
            return;
        }
        String string = inetAddress.getHostAddress();
        if (!this.shouldServiceRedirect(_udpConnectBacks, string)) {
            return;
        }
        PingRequest pingRequest = new PingRequest(gUID.bytes(), 1, 0);
        UDPService.instance().send(pingRequest, inetAddress, n);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private boolean shouldServiceRedirect(FixedsizeHashMap fixedsizeHashMap, Object object) {
        FixedsizeHashMap fixedsizeHashMap2 = fixedsizeHashMap;
        synchronized (fixedsizeHashMap2) {
            Object object2 = fixedsizeHashMap.get(object);
            if (object2 != null) {
                return false;
            }
            try {
                fixedsizeHashMap.put(object, fixedsizeHashMap);
                return true;
            }
            catch (NoMoreStorageException noMoreStorageException) {
                return false;
            }
        }
    }

    protected void handleTCPConnectBackRequest(TCPConnectBackVendorMessage tCPConnectBackVendorMessage, Connection connection) {
        int n = tCPConnectBackVendorMessage.getConnectBackPort();
        InetAddress inetAddress = connection.getInetAddress();
        TCPConnectBackRedirect tCPConnectBackRedirect = new TCPConnectBackRedirect(inetAddress, n);
        int n2 = 0;
        ArrayList arrayList = new ArrayList(_manager.getInitializedConnections());
        Collections.shuffle(arrayList);
        Iterator iterator = arrayList.iterator();
        while (iterator.hasNext() && n2 < 5) {
            ManagedConnection managedConnection = (ManagedConnection)iterator.next();
            if (managedConnection == connection || managedConnection.remoteHostSupportsTCPRedirect() < 0) continue;
            managedConnection.send(tCPConnectBackRedirect);
            ++n2;
        }
    }

    protected void handleTCPConnectBackRedirect(TCPConnectBackRedirect tCPConnectBackRedirect, Connection connection) {
        if (!connection.isSupernodeSupernodeConnection()) {
            return;
        }
        final int n = tCPConnectBackRedirect.getConnectBackPort();
        final String string = tCPConnectBackRedirect.getConnectBackAddress().getHostAddress();
        Endpoint endpoint = new Endpoint(string, n);
        if (_manager.isConnectedTo(endpoint.getAddress())) {
            return;
        }
        if (!this.shouldServiceRedirect(_tcpConnectBacks, string)) {
            return;
        }
        TCP_CONNECT_BACKER.add(new Runnable(){

            /*
             * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
             * Enabled aggressive block sorting
             * Enabled unnecessary exception pruning
             * Enabled aggressive exception aggregation
             */
            public void run() {
                Socket socket = null;
                try {
                    try {
                        socket = Sockets.connect(string, n, 12000);
                        OutputStream outputStream = socket.getOutputStream();
                        outputStream.write("CONNECT BACK\r\n\r\n".getBytes());
                        outputStream.flush();
                        if (LOG.isTraceEnabled()) {
                            LOG.trace((Object)("Succesful connectback to: " + string));
                        }
                        try {
                            Thread.sleep(500L);
                        }
                        catch (InterruptedException interruptedException) {
                            LOG.warn((Object)"Interrupted connectback", (Throwable)interruptedException);
                        }
                    }
                    catch (IOException iOException) {
                        LOG.warn((Object)"IOX during connectback", (Throwable)iOException);
                    }
                }
                catch (Throwable throwable) {
                    Object var4_6 = null;
                    IOUtils.close(socket);
                    throw throwable;
                }
                {
                    Object var4_7 = null;
                }
                IOUtils.close(socket);
            }
        });
    }

    protected void handlePushProxyRequest(PushProxyRequest pushProxyRequest, ManagedConnection managedConnection) {
        if (managedConnection.isSupernodeClientConnection() && RouterService.isIpPortValid()) {
            String string = NetworkUtils.ip2string(RouterService.getAddress());
            InetAddress inetAddress = null;
            try {
                inetAddress = InetAddress.getByName(string);
            }
            catch (UnknownHostException unknownHostException) {
                ErrorService.error(unknownHostException);
            }
            PushProxyAcknowledgement pushProxyAcknowledgement = new PushProxyAcknowledgement(inetAddress, RouterService.getPort(), pushProxyRequest.getClientGUID());
            managedConnection.send(pushProxyAcknowledgement);
            this._pushRouteTable.routeReply(pushProxyRequest.getClientGUID().bytes(), managedConnection);
        }
    }

    protected void handleQueryStatus(QueryStatusResponse queryStatusResponse, ManagedConnection managedConnection) {
        if (!managedConnection.isSupernodeClientConnection()) {
            return;
        }
        GUID gUID = queryStatusResponse.getQueryGUID();
        int n = queryStatusResponse.getNumResults();
        this.DYNAMIC_QUERIER.updateLeafResultsForQuery(gUID, n);
    }

    public void sendPingRequest(PingRequest pingRequest, ManagedConnection managedConnection) {
        if (pingRequest == null) {
            throw new NullPointerException("null ping");
        }
        if (managedConnection == null) {
            throw new NullPointerException("null connection");
        }
        this._pingRouteTable.routeReply(pingRequest.getGUID(), this.FOR_ME_REPLY_HANDLER);
        managedConnection.send(pingRequest);
    }

    public void sendQueryRequest(QueryRequest queryRequest, ManagedConnection managedConnection) {
        if (queryRequest == null) {
            throw new NullPointerException("null query");
        }
        if (managedConnection == null) {
            throw new NullPointerException("null connection");
        }
        this._queryRouteTable.routeReply(queryRequest.getGUID(), this.FOR_ME_REPLY_HANDLER);
        managedConnection.send(queryRequest);
    }

    public void broadcastPingRequest(PingRequest pingRequest) {
        if (pingRequest == null) {
            throw new NullPointerException("null ping");
        }
        this._pingRouteTable.routeReply(pingRequest.getGUID(), this.FOR_ME_REPLY_HANDLER);
        this.broadcastPingRequest(pingRequest, this.FOR_ME_REPLY_HANDLER, _manager);
    }

    public void sendDynamicQuery(QueryRequest queryRequest) {
        if (queryRequest == null) {
            throw new NullPointerException("null QueryHandler");
        }
        ResultCounter resultCounter = this._queryRouteTable.routeReply(queryRequest.getGUID(), this.FOR_ME_REPLY_HANDLER);
        if (RouterService.isSupernode()) {
            this.sendDynamicQuery(QueryHandler.createHandlerForMe(queryRequest, resultCounter), this.FOR_ME_REPLY_HANDLER);
        } else {
            this.originateLeafQuery(queryRequest);
        }
        this.multicastQueryRequest(QueryRequest.createMulticastQuery(queryRequest));
    }

    private void sendDynamicQuery(QueryHandler queryHandler, ReplyHandler replyHandler) {
        if (queryHandler == null) {
            throw new NullPointerException("null QueryHandler");
        }
        if (replyHandler == null) {
            throw new NullPointerException("null ReplyHandler");
        }
        this.DYNAMIC_QUERIER.addQuery(queryHandler);
    }

    private void broadcastPingRequest(PingRequest pingRequest, ReplyHandler replyHandler, ConnectionManager connectionManager) {
        List list = connectionManager.getInitializedConnections();
        int n = list.size();
        boolean bl = false;
        if (n > 3) {
            bl = true;
        }
        int n2 = 0;
        while (n2 < n) {
            ManagedConnection managedConnection = (ManagedConnection)list.get(n2);
            if (managedConnection.isStable() && (replyHandler == this.FOR_ME_REPLY_HANDLER || managedConnection != replyHandler && !managedConnection.isClientSupernodeConnection())) {
                double d = managedConnection.supportsPongCaching() ? 0.7 : 0.9;
                if (!bl || !(Math.random() < d)) {
                    managedConnection.send(pingRequest);
                }
            }
            ++n2;
        }
    }

    public final void forwardQueryRequestToLeaves(QueryRequest queryRequest, ReplyHandler replyHandler) {
        if (!RouterService.isSupernode()) {
            return;
        }
        List list = _manager.getInitializedClientConnections();
        List<ManagedConnection> list2 = new ArrayList<ManagedConnection>();
        int n = 0;
        while (n < list.size()) {
            ManagedConnection managedConnection = (ManagedConnection)list.get(n);
            if (managedConnection != replyHandler && managedConnection.shouldForwardQuery(queryRequest)) {
                list2.add(managedConnection);
            }
            ++n;
        }
        if (list.size() > 8 && (double)list2.size() / (double)list.size() > 0.8) {
            n = (int)Math.floor(Math.random() * (double)list2.size() * 0.75);
            list2 = list2.subList(n, n + list2.size() / 4);
        }
        n = list.size() - list2.size();
        RoutedQueryStat.LEAF_DROP.addData(n);
        int n2 = 0;
        while (n2 < list2.size()) {
            ManagedConnection managedConnection = (ManagedConnection)list2.get(n2);
            managedConnection.send(queryRequest);
            RoutedQueryStat.LEAF_SEND.incrementStat();
            ++n2;
        }
    }

    private boolean sendRoutedQueryToHost(QueryRequest queryRequest, ManagedConnection managedConnection, ReplyHandler replyHandler) {
        if (managedConnection.shouldForwardQuery(queryRequest)) {
            managedConnection.send(queryRequest);
            return true;
        }
        return false;
    }

    protected void unicastQueryRequest(QueryRequest queryRequest, ReplyHandler replyHandler) {
        queryRequest.setTTL((byte)1);
        this.UNICASTER.addQuery(queryRequest, replyHandler);
    }

    protected void multicastQueryRequest(QueryRequest queryRequest) {
        queryRequest.setTTL((byte)1);
        SentMessageStatHandler.MULTICAST_QUERY_REQUESTS.addMessage(queryRequest);
        MulticastService.instance().send(queryRequest);
    }

    private void forwardQueryToUltrapeers(QueryRequest queryRequest, ReplyHandler replyHandler) {
        List list = _manager.getInitializedConnections();
        int n = list.size();
        int n2 = 0;
        while (n2 < n) {
            ManagedConnection managedConnection = (ManagedConnection)list.get(n2);
            this.forwardQueryToUltrapeer(queryRequest, replyHandler, managedConnection);
            ++n2;
        }
    }

    private void forwardLimitedQueryToUltrapeers(QueryRequest queryRequest, ReplyHandler replyHandler) {
        List list = _manager.getInitializedConnections();
        int n = list.size();
        int n2 = 15;
        int n3 = 0;
        while (n3 < n) {
            if (n2 == 0) break;
            ManagedConnection managedConnection = (ManagedConnection)list.get(n3);
            if (!managedConnection.isGoodUltrapeer() || n - n3 <= n2) {
                this.forwardQueryToUltrapeer(queryRequest, replyHandler, managedConnection);
                --n2;
            }
            ++n3;
        }
    }

    private void forwardQueryToUltrapeer(QueryRequest queryRequest, ReplyHandler replyHandler, ManagedConnection managedConnection) {
        boolean bl;
        if (managedConnection == replyHandler) {
            return;
        }
        if (managedConnection.isClientSupernodeConnection()) {
            return;
        }
        if (queryRequest.isFeatureQuery() && !managedConnection.getRemoteHostSupportsFeatureQueries()) {
            return;
        }
        boolean bl2 = bl = queryRequest.getTTL() == 1;
        if (bl && managedConnection.isUltrapeerQueryRoutingConnection()) {
            boolean bl3 = this.sendRoutedQueryToHost(queryRequest, managedConnection, replyHandler);
            if (bl3) {
                RoutedQueryStat.ULTRAPEER_SEND.incrementStat();
            } else {
                RoutedQueryStat.ULTRAPEER_DROP.incrementStat();
            }
        } else {
            managedConnection.send(queryRequest);
        }
    }

    private void originateLeafQuery(QueryRequest queryRequest) {
        List list = _manager.getInitializedConnections();
        int n = queryRequest.isWhatIsNewRequest() ? 2 : 3;
        int n2 = !queryRequest.isWhatIsNewRequest() ? 0 : (int)Math.floor(Math.random() * (double)(list.size() - 1));
        int n3 = Math.min(n, list.size());
        boolean bl = queryRequest.desiresOutOfBandReplies();
        int n4 = n2;
        while (n4 < n2 + n3) {
            ManagedConnection managedConnection = (ManagedConnection)list.get(n4);
            QueryRequest queryRequest2 = queryRequest;
            if (bl && managedConnection.remoteHostSupportsLeafGuidance() < 0) {
                queryRequest2 = QueryRequest.unmarkOOBQuery(queryRequest);
            }
            managedConnection.send(queryRequest2);
            ++n4;
        }
    }

    public boolean originateQuery(QueryRequest queryRequest, ManagedConnection managedConnection) {
        if (queryRequest == null) {
            throw new NullPointerException("null query");
        }
        if (managedConnection == null) {
            throw new NullPointerException("null connection");
        }
        if (queryRequest.isFeatureQuery() && !managedConnection.getRemoteHostSupportsFeatureQueries()) {
            return false;
        }
        managedConnection.originateQuery(queryRequest);
        return true;
    }

    protected abstract void respondToPingRequest(PingRequest var1, ReplyHandler var2);

    protected abstract void respondToUDPPingRequest(PingRequest var1, InetSocketAddress var2, ReplyHandler var3);

    protected abstract boolean respondToQueryRequest(QueryRequest var1, byte[] var2, ReplyHandler var3);

    protected void handlePingReply(PingReply pingReply, ReplyHandler replyHandler) {
        ReplyHandler replyHandler2;
        boolean bl = RouterService.getHostCatcher().add(pingReply);
        if (bl && !pingReply.isUDPHostCache()) {
            PongCacher.instance().addPong(pingReply);
        }
        if ((replyHandler2 = this._pingRouteTable.getReplyHandler(pingReply.getGUID())) != null) {
            replyHandler2.handlePingReply(pingReply, replyHandler);
        } else {
            RouteErrorStat.PING_REPLY_ROUTE_ERRORS.incrementStat();
            replyHandler.countDroppedMessage();
        }
        boolean bl2 = pingReply.supportsUnicast();
        if (bl && (pingReply.isUltrapeer() || bl2)) {
            List list = _manager.getInitializedClientConnections();
            int n = 0;
            while (n < list.size()) {
                ManagedConnection managedConnection = (ManagedConnection)list.get(n);
                Assert.that(managedConnection != null, "null c.");
                if (managedConnection != replyHandler && managedConnection != replyHandler2 && managedConnection.allowNewPongs()) {
                    managedConnection.handlePingReply(pingReply, replyHandler);
                }
                ++n;
            }
        }
    }

    public void handleQueryReply(QueryReply queryReply, ReplyHandler replyHandler) {
        if (queryReply == null) {
            throw new NullPointerException("null query reply");
        }
        if (replyHandler == null) {
            throw new NullPointerException("null ReplyHandler");
        }
        RouteTable.ReplyRoutePair replyRoutePair = this._queryRouteTable.getReplyHandler(queryReply.getGUID(), queryReply.getTotalLength(), queryReply.getUniqueResultCount());
        if (replyRoutePair != null) {
            queryReply.setPriority(replyRoutePair.getBytesRouted());
            this._pushRouteTable.routeReply(queryReply.getClientGUID(), replyHandler);
            ReplyHandler replyHandler2 = replyRoutePair.getReplyHandler();
            if (!this.shouldDropReply(replyRoutePair, replyHandler2, queryReply)) {
                replyHandler2.handleQueryReply(queryReply, replyHandler);
                this.UNICASTER.handleQueryReply(queryReply);
            } else {
                RouteErrorStat.HARD_LIMIT_QUERY_REPLY_ROUTE_ERRORS.incrementStat();
                byte by = queryReply.getTTL();
                if (by < RouteErrorStat.HARD_LIMIT_QUERY_REPLY_TTL.length) {
                    RouteErrorStat.HARD_LIMIT_QUERY_REPLY_TTL[by].incrementStat();
                } else {
                    RouteErrorStat.HARD_LIMIT_QUERY_REPLY_TTL[RouteErrorStat.HARD_LIMIT_QUERY_REPLY_TTL.length - 1].incrementStat();
                }
                replyHandler.countDroppedMessage();
            }
        } else {
            RouteErrorStat.NO_ROUTE_QUERY_REPLY_ROUTE_ERRORS.incrementStat();
            replyHandler.countDroppedMessage();
        }
    }

    private boolean shouldDropReply(RouteTable.ReplyRoutePair replyRoutePair, ReplyHandler replyHandler, QueryReply queryReply) {
        byte by = queryReply.getTTL();
        if (replyHandler == this.FOR_ME_REPLY_HANDLER) {
            return false;
        }
        if (by == 0) {
            return true;
        }
        int n = replyRoutePair.getResultsRouted();
        if (n > 100) {
            return true;
        }
        int n2 = replyRoutePair.getBytesRouted();
        if (by > 2 && n2 < 51200) {
            return false;
        }
        if (by == 1 && n2 < 204800) {
            return false;
        }
        return by != 2 || n2 >= 102400;
    }

    private void handleGiveStats(GiveStatsVendorMessage giveStatsVendorMessage, ReplyHandler replyHandler) {
        StatisticVendorMessage statisticVendorMessage = null;
        try {
            if (StatisticVendorMessage.isSupported(giveStatsVendorMessage)) {
                statisticVendorMessage = new StatisticVendorMessage(giveStatsVendorMessage);
                replyHandler.handleStatisticVM(statisticVendorMessage);
            }
        }
        catch (IOException iOException) {
            return;
        }
    }

    private void handleStatisticsMessage(StatisticVendorMessage statisticVendorMessage, ReplyHandler replyHandler) {
    }

    private void handleSimppRequest(SimppRequestVM simppRequestVM, ReplyHandler replyHandler) {
        if (simppRequestVM.getVersion() > 1) {
            return;
        }
        byte[] byArray = SimppManager.instance().getSimppBytes();
        if (byArray != null) {
            SimppVM simppVM = new SimppVM(byArray);
            try {
                replyHandler.handleSimppVM(simppVM);
            }
            catch (IOException iOException) {
                return;
            }
        }
    }

    private void handleSimppVM(SimppVM simppVM) {
        SimppManager.instance().checkAndUpdate(simppVM.getPayload());
    }

    private void handleContentResponse(ContentResponse contentResponse, ReplyHandler replyHandler) {
        RouterService.getContentManager().handleContentResponse(contentResponse);
    }

    protected void handlePushRequest(PushRequest pushRequest, ReplyHandler replyHandler) {
        if (pushRequest == null) {
            throw new NullPointerException("null request");
        }
        if (replyHandler == null) {
            throw new NullPointerException("null ReplyHandler");
        }
        ReplyHandler replyHandler2 = this.getPushHandler(pushRequest.getClientGUID());
        if (replyHandler2 != null) {
            replyHandler2.handlePushRequest(pushRequest, replyHandler);
        } else {
            RouteErrorStat.PUSH_REQUEST_ROUTE_ERRORS.incrementStat();
            replyHandler.countDroppedMessage();
        }
    }

    protected ReplyHandler getPushHandler(byte[] byArray) {
        ReplyHandler replyHandler = this._pushRouteTable.getReplyHandler(byArray);
        if (replyHandler != null) {
            return replyHandler;
        }
        if (Arrays.equals(this._clientGUID, byArray)) {
            return this.FOR_ME_REPLY_HANDLER;
        }
        return null;
    }

    protected void sendPingReply(PingReply pingReply, ReplyHandler replyHandler) {
        if (pingReply == null) {
            throw new NullPointerException("null pong");
        }
        if (replyHandler == null) {
            throw new NullPointerException("null reply handler");
        }
        replyHandler.handlePingReply(pingReply, null);
    }

    protected void sendQueryReply(QueryReply queryReply) throws IOException {
        if (queryReply == null) {
            throw new NullPointerException("null reply");
        }
        RouteTable.ReplyRoutePair replyRoutePair = this._queryRouteTable.getReplyHandler(queryReply.getGUID(), queryReply.getTotalLength(), queryReply.getResultCount());
        if (replyRoutePair == null) {
            throw new IOException("no route for reply");
        }
        queryReply.setPriority(replyRoutePair.getBytesRouted());
        replyRoutePair.getReplyHandler().handleQueryReply(queryReply, null);
    }

    public void sendPushRequest(PushRequest pushRequest) throws IOException {
        if (pushRequest == null) {
            throw new NullPointerException("null push");
        }
        ReplyHandler replyHandler = this.getPushHandler(pushRequest.getClientGUID());
        if (replyHandler == null) {
            throw new IOException("no route for push");
        }
        replyHandler.handlePushRequest(pushRequest, this.FOR_ME_REPLY_HANDLER);
    }

    protected void sendMulticastPushRequest(PushRequest pushRequest) {
        if (pushRequest == null) {
            throw new NullPointerException("null push");
        }
        Assert.that(pushRequest.getTTL() == 1, "multicast push ttl not 1");
        MulticastService.instance().send(pushRequest);
        SentMessageStatHandler.MULTICAST_PUSH_REQUESTS.addMessage(pushRequest);
    }

    public Iterator responsesToQueryReplies(Response[] responseArray, QueryRequest queryRequest) {
        return this.responsesToQueryReplies(responseArray, queryRequest, 10);
    }

    private Iterator responsesToQueryReplies(Response[] responseArray, QueryRequest queryRequest, int n) {
        int n2;
        Response[] responseArray2;
        int n3;
        LinkedList linkedList = new LinkedList();
        byte[] byArray = queryRequest.getGUID();
        byte by = (byte)(queryRequest.getHops() + 1);
        UploadManager uploadManager = RouterService.getUploadManager();
        long l = uploadManager.measuredUploadSpeed();
        boolean bl = true;
        if (l == -1L) {
            l = ConnectionSettings.CONNECTION_SPEED.getValue();
            bl = false;
        }
        int n4 = responseArray.length;
        int n5 = 0;
        byte by2 = queryRequest.getHops();
        if (n > 1 && by2 > 2 && n4 > 10) {
            n3 = (int)(Math.random() * (double)n4) % (n4 - 10);
            responseArray2 = new Response[10];
            n2 = 0;
            while (n2 < 10) {
                responseArray2[n2] = responseArray[n3];
                ++n2;
                ++n3;
            }
            responseArray = responseArray2;
            n4 = responseArray.length;
        }
        while (n4 > 0) {
            boolean bl2;
            n3 = n4 < n ? n4 : n;
            if (n5 == 0 && n3 < n) {
                responseArray2 = responseArray;
            } else {
                responseArray2 = new Response[n3];
                n2 = 0;
                while (n2 < n3) {
                    responseArray2[n2] = responseArray[n5];
                    ++n5;
                    ++n2;
                }
            }
            n4 -= n3;
            n2 = uploadManager.isServiceable() ? 0 : 1;
            boolean bl3 = uploadManager.hadSuccesfulUpload();
            boolean bl4 = queryRequest.isMulticast() && queryRequest.getTTL() + queryRequest.getHops() == 1;
            boolean bl5 = bl2 = queryRequest.canDoFirewalledTransfer() && UDPService.instance().canDoFWT() && !RouterService.acceptedIncomingConnection();
            if (bl4) {
                by = 1;
            }
            List list = this.createQueryReply(byArray, by, l, responseArray2, this._clientGUID, n2 != 0, bl3, bl, bl4, bl2);
            linkedList.addAll(list);
        }
        return linkedList.iterator();
    }

    protected abstract List createQueryReply(byte[] var1, byte var2, long var3, Response[] var5, byte[] var6, boolean var7, boolean var8, boolean var9, boolean var10, boolean var11);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void handleResetTableMessage(ResetTableMessage resetTableMessage, ManagedConnection managedConnection) {
        if (!MessageRouter.isQRPConnection(managedConnection)) {
            return;
        }
        Object object = managedConnection.getQRPLock();
        synchronized (object) {
            managedConnection.resetQueryRouteTable(resetTableMessage);
        }
        if (managedConnection.isLeafConnection()) {
            this._lastQueryRouteTable = MessageRouter.createRouteTable();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void handlePatchTableMessage(PatchTableMessage patchTableMessage, ManagedConnection managedConnection) {
        if (!MessageRouter.isQRPConnection(managedConnection)) {
            return;
        }
        Object object = managedConnection.getQRPLock();
        synchronized (object) {
            managedConnection.patchQueryRouteTable(patchTableMessage);
        }
        if (managedConnection.isLeafConnection()) {
            this._lastQueryRouteTable = MessageRouter.createRouteTable();
        }
    }

    private void updateMessage(QueryRequest queryRequest, ReplyHandler replyHandler) {
        if (!(replyHandler instanceof Connection)) {
            return;
        }
        Connection connection = (Connection)((Object)replyHandler);
        QueryReply queryReply = StaticMessages.getUpdateReply();
        if (queryRequest.getHops() == 1 && connection.isOldLimeWire() && queryReply != null) {
            QueryReply queryReply2 = new QueryReply(queryRequest.getGUID(), queryReply);
            try {
                this.sendQueryReply(queryReply2);
            }
            catch (IOException iOException) {}
        }
    }

    private static boolean isQRPConnection(Connection connection) {
        if (connection.isSupernodeClientConnection()) {
            return true;
        }
        return connection.isUltrapeerQueryRoutingConnection();
    }

    private void forwardQueryRouteTables() {
        long l = System.currentTimeMillis();
        List list = _manager.getInitializedConnections();
        QueryRouteTable queryRouteTable = null;
        List list2 = null;
        QueryRouteTable queryRouteTable2 = null;
        int n = 0;
        while (n < list.size()) {
            ManagedConnection managedConnection = (ManagedConnection)list.get(n);
            if (!(!RouterService.isSupernode() ? !managedConnection.isClientSupernodeConnection() || !managedConnection.isQueryRoutingEnabled() : !managedConnection.isUltrapeerQueryRoutingConnection())) {
                if (l >= managedConnection.getNextQRPForwardTime()) {
                    managedConnection.incrementNextQRPForwardTime(l);
                    if (queryRouteTable == null) {
                        this._lastQueryRouteTable = queryRouteTable = MessageRouter.createRouteTable();
                    }
                    if (queryRouteTable2 == managedConnection.getQueryRouteTableSent()) {
                        if (list2 == null) {
                            list2 = queryRouteTable.encode(queryRouteTable2, true);
                        }
                    } else {
                        queryRouteTable2 = managedConnection.getQueryRouteTableSent();
                        list2 = queryRouteTable.encode(queryRouteTable2, true);
                    }
                    if (!ConnectionSettings.SEND_QRP.getValue()) {
                        return;
                    }
                    Iterator iterator = list2.iterator();
                    while (iterator.hasNext()) {
                        managedConnection.send((RouteTableMessage)iterator.next());
                    }
                    managedConnection.setQueryRouteTableSent(queryRouteTable);
                }
            }
            ++n;
        }
    }

    public QueryRouteTable getQueryRouteTable() {
        return this._lastQueryRouteTable;
    }

    private static QueryRouteTable createRouteTable() {
        QueryRouteTable queryRouteTable = _fileManager.getQRT();
        if (RouterService.isSupernode()) {
            MessageRouter.addQueryRoutingEntriesForLeaves(queryRouteTable);
        }
        return queryRouteTable;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void addQueryRoutingEntriesForLeaves(QueryRouteTable queryRouteTable) {
        List list = _manager.getInitializedClientConnections();
        int n = 0;
        while (n < list.size()) {
            ManagedConnection managedConnection = (ManagedConnection)list.get(n);
            Object object = managedConnection.getQRPLock();
            synchronized (object) {
                QueryRouteTable queryRouteTable2;
                if (!managedConnection.isBusyLeaf() && (queryRouteTable2 = managedConnection.getQueryRouteTableReceived()) != null) {
                    queryRouteTable.addAll(queryRouteTable2);
                }
            }
            ++n;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void registerMessageListener(byte[] byArray, MessageListener messageListener) {
        messageListener.registered(byArray);
        Object object = this.MESSAGE_LISTENER_LOCK;
        synchronized (object) {
            TreeMap treeMap = new TreeMap(GUID.GUID_BYTE_COMPARATOR);
            treeMap.putAll(this._messageListeners);
            ArrayList<MessageListener> arrayList = (ArrayList<MessageListener>)treeMap.get(byArray);
            if (arrayList == null) {
                arrayList = new ArrayList<MessageListener>(1);
                arrayList.add(messageListener);
            } else {
                ArrayList<MessageListener> arrayList2 = new ArrayList<MessageListener>(arrayList.size() + 1);
                arrayList2.addAll(arrayList);
                arrayList = arrayList2;
                arrayList.add(messageListener);
            }
            treeMap.put(byArray, Collections.unmodifiableList(arrayList));
            this._messageListeners = Collections.unmodifiableMap(treeMap);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void unregisterMessageListener(byte[] byArray, MessageListener messageListener) {
        boolean bl = false;
        Object object = this.MESSAGE_LISTENER_LOCK;
        synchronized (object) {
            ArrayList arrayList = (ArrayList)this._messageListeners.get(byArray);
            if (arrayList != null && (arrayList = new ArrayList(arrayList)).remove(messageListener)) {
                bl = true;
                TreeMap treeMap = new TreeMap(GUID.GUID_BYTE_COMPARATOR);
                treeMap.putAll(this._messageListeners);
                if (arrayList.isEmpty()) {
                    treeMap.remove(byArray);
                } else {
                    treeMap.put(byArray, Collections.unmodifiableList(arrayList));
                }
                this._messageListeners = Collections.unmodifiableMap(treeMap);
            }
        }
        if (bl) {
            messageListener.unregistered(byArray);
        }
    }

    private void handleUDPCrawlerPing(UDPCrawlerPing uDPCrawlerPing, ReplyHandler replyHandler) {
        if (!this._promotionManager.allowUDPPing(replyHandler)) {
            return;
        }
        UDPCrawlerPong uDPCrawlerPong = new UDPCrawlerPong(uDPCrawlerPing);
        replyHandler.reply(uDPCrawlerPong);
    }

    private void handleHeadPing(HeadPing headPing, ReplyHandler replyHandler) {
        if (DownloadSettings.DROP_HEADPINGS.getValue()) {
            return;
        }
        GUID gUID = headPing.getClientGuid();
        ReplyHandler replyHandler2 = gUID != null ? this.getPushHandler(gUID.bytes()) : this.FOR_ME_REPLY_HANDLER;
        if (replyHandler2 == null) {
            return;
        }
        if (replyHandler2 instanceof ForMeReplyHandler) {
            HeadPong headPong = new HeadPong(headPing);
            replyHandler.reply(headPong);
        } else {
            this._headPongRouteTable.routeReply(headPing.getGUID(), replyHandler);
            if (!(replyHandler instanceof Connection) || ((Connection)((Object)replyHandler)).supportsVMRouting()) {
                replyHandler2.reply(headPing);
            } else {
                replyHandler2.reply(new HeadPing(headPing));
            }
        }
    }

    private void handleHeadPong(HeadPong headPong, ReplyHandler replyHandler) {
        ReplyHandler replyHandler2 = this._headPongRouteTable.getReplyHandler(headPong.getGUID());
        if (replyHandler2 != null && !(replyHandler2 instanceof ForMeReplyHandler)) {
            replyHandler2.reply(headPong);
            this._headPongRouteTable.removeReplyHandler(replyHandler2);
        }
    }

    private class QRPPropagator
    extends ManagedThread {
        public QRPPropagator() {
            this.setName("QRPPropagator");
            this.setDaemon(true);
        }

        public void managedRun() {
            try {
                while (true) {
                    Thread.sleep(10000L);
                    MessageRouter.this.forwardQueryRouteTables();
                }
            }
            catch (Throwable throwable) {
                ErrorService.error(throwable);
                return;
            }
        }
    }

    private static class QueryResponseBundle {
        public final QueryRequest _query;
        public final Response[] _responses;

        public QueryResponseBundle(QueryRequest queryRequest, Response[] responseArray) {
            this._query = queryRequest;
            this._responses = responseArray;
        }
    }

    private class Expirer
    implements Runnable {
        Expirer() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            try {
                HashSet<GUID.TimedGUID> hashSet = new HashSet<GUID.TimedGUID>();
                Map map = MessageRouter.this._outOfBandReplies;
                synchronized (map) {
                    Iterator<Object> iterator = MessageRouter.this._outOfBandReplies.keySet().iterator();
                    while (iterator.hasNext()) {
                        GUID.TimedGUID timedGUID = (GUID.TimedGUID)iterator.next();
                        if (timedGUID == null || !timedGUID.shouldExpire()) continue;
                        hashSet.add(timedGUID);
                    }
                    iterator = hashSet.iterator();
                    while (iterator.hasNext()) {
                        MessageRouter.this._outOfBandReplies.remove(iterator.next());
                    }
                }
            }
            catch (Throwable throwable) {
                ErrorService.error(throwable);
            }
        }
    }

    static class ConnectBackExpirer
    implements Runnable {
        ConnectBackExpirer() {
        }

        public void run() {
            try {
                _tcpConnectBacks.clear();
                _udpConnectBacks.clear();
            }
            catch (Throwable throwable) {
                ErrorService.error(throwable);
            }
        }
    }

    static class HopsFlowManager
    implements Runnable {
        private static final byte BUSY_HOPS_FLOW = 0;
        private static final byte FREE_HOPS_FLOW = 5;
        private static boolean _oldBusyState = false;

        HopsFlowManager() {
        }

        public void run() {
            if (RouterService.isSupernode()) {
                return;
            }
            boolean bl = !RouterService.getUploadManager().isServiceable();
            List list = _manager.getInitializedConnections();
            HopsFlowVendorMessage hopsFlowVendorMessage = new HopsFlowVendorMessage(bl ? (byte)0 : 5);
            if (bl == _oldBusyState) {
                int n = 0;
                while (n < list.size()) {
                    ManagedConnection managedConnection = (ManagedConnection)list.get(n);
                    if (managedConnection != null && (double)managedConnection.getConnectionTime() + 18750.0 > (double)System.currentTimeMillis() && managedConnection.isClientSupernodeConnection()) {
                        managedConnection.send(hopsFlowVendorMessage);
                    }
                    ++n;
                }
            } else {
                _oldBusyState = bl;
                int n = 0;
                while (n < list.size()) {
                    ManagedConnection managedConnection = (ManagedConnection)list.get(n);
                    if (managedConnection != null && managedConnection.isClientSupernodeConnection()) {
                        managedConnection.send(hopsFlowVendorMessage);
                    }
                    ++n;
                }
            }
        }
    }

    public static interface MessageHandler {
        public void handleMessage(Message var1, InetSocketAddress var2, ReplyHandler var3);
    }

    private class PingRequestHandler
    implements MessageHandler {
        PingRequestHandler() {
        }

        public void handleMessage(Message message, InetSocketAddress inetSocketAddress, ReplyHandler replyHandler) {
            ReceivedMessageStatHandler.TCP_PING_REQUESTS.addMessage(message);
            MessageRouter.this.handlePingRequestPossibleDuplicate((PingRequest)message, replyHandler);
        }
    }

    private class PingReplyHandler
    implements MessageHandler {
        PingReplyHandler() {
        }

        public void handleMessage(Message message, InetSocketAddress inetSocketAddress, ReplyHandler replyHandler) {
            ReceivedMessageStatHandler.TCP_PING_REPLIES.addMessage(message);
            MessageRouter.this.handlePingReply((PingReply)message, replyHandler);
        }
    }

    private class QueryRequestHandler
    implements MessageHandler {
        QueryRequestHandler() {
        }

        public void handleMessage(Message message, InetSocketAddress inetSocketAddress, ReplyHandler replyHandler) {
            ReceivedMessageStatHandler.TCP_QUERY_REQUESTS.addMessage(message);
            MessageRouter.this.handleQueryRequestPossibleDuplicate((QueryRequest)message, (ManagedConnection)replyHandler);
        }
    }

    private class QueryReplyHandler
    implements MessageHandler {
        QueryReplyHandler() {
        }

        public void handleMessage(Message message, InetSocketAddress inetSocketAddress, ReplyHandler replyHandler) {
            ReceivedMessageStatHandler.TCP_QUERY_REPLIES.addMessage(message);
            QueryReply queryReply = (QueryReply)message;
            MessageRouter.this.handleQueryReply(queryReply, replyHandler);
        }
    }

    private class PushRequestHandler
    implements MessageHandler {
        PushRequestHandler() {
        }

        public void handleMessage(Message message, InetSocketAddress inetSocketAddress, ReplyHandler replyHandler) {
            ReceivedMessageStatHandler.TCP_PUSH_REQUESTS.addMessage(message);
            MessageRouter.this.handlePushRequest((PushRequest)message, replyHandler);
        }
    }

    private class ResetTableHandler
    implements MessageHandler {
        ResetTableHandler() {
        }

        public void handleMessage(Message message, InetSocketAddress inetSocketAddress, ReplyHandler replyHandler) {
            ReceivedMessageStatHandler.TCP_RESET_ROUTE_TABLE_MESSAGES.addMessage(message);
            MessageRouter.this.handleResetTableMessage((ResetTableMessage)message, (ManagedConnection)replyHandler);
        }
    }

    private class PatchTableHandler
    implements MessageHandler {
        PatchTableHandler() {
        }

        public void handleMessage(Message message, InetSocketAddress inetSocketAddress, ReplyHandler replyHandler) {
            ReceivedMessageStatHandler.TCP_PATCH_ROUTE_TABLE_MESSAGES.addMessage(message);
            MessageRouter.this.handlePatchTableMessage((PatchTableMessage)message, (ManagedConnection)replyHandler);
        }
    }

    private class TCPConnectBackHandler
    implements MessageHandler {
        TCPConnectBackHandler() {
        }

        public void handleMessage(Message message, InetSocketAddress inetSocketAddress, ReplyHandler replyHandler) {
            ReceivedMessageStatHandler.TCP_TCP_CONNECTBACK.addMessage(message);
            MessageRouter.this.handleTCPConnectBackRequest((TCPConnectBackVendorMessage)message, (ManagedConnection)replyHandler);
        }
    }

    private class UDPConnectBackHandler
    implements MessageHandler {
        UDPConnectBackHandler() {
        }

        public void handleMessage(Message message, InetSocketAddress inetSocketAddress, ReplyHandler replyHandler) {
            ReceivedMessageStatHandler.TCP_UDP_CONNECTBACK.addMessage(message);
            MessageRouter.this.handleUDPConnectBackRequest((UDPConnectBackVendorMessage)message, (ManagedConnection)replyHandler);
        }
    }

    private class TCPConnectBackRedirectHandler
    implements MessageHandler {
        TCPConnectBackRedirectHandler() {
        }

        public void handleMessage(Message message, InetSocketAddress inetSocketAddress, ReplyHandler replyHandler) {
            MessageRouter.this.handleTCPConnectBackRedirect((TCPConnectBackRedirect)message, (ManagedConnection)replyHandler);
        }
    }

    private class UDPConnectBackRedirectHandler
    implements MessageHandler {
        UDPConnectBackRedirectHandler() {
        }

        public void handleMessage(Message message, InetSocketAddress inetSocketAddress, ReplyHandler replyHandler) {
            MessageRouter.this.handleUDPConnectBackRedirect((UDPConnectBackRedirect)message, (ManagedConnection)replyHandler);
        }
    }

    private class PushProxyRequestHandler
    implements MessageHandler {
        PushProxyRequestHandler() {
        }

        public void handleMessage(Message message, InetSocketAddress inetSocketAddress, ReplyHandler replyHandler) {
            MessageRouter.this.handlePushProxyRequest((PushProxyRequest)message, (ManagedConnection)replyHandler);
        }
    }

    private class QueryStatusResponseHandler
    implements MessageHandler {
        QueryStatusResponseHandler() {
        }

        public void handleMessage(Message message, InetSocketAddress inetSocketAddress, ReplyHandler replyHandler) {
            MessageRouter.this.handleQueryStatus((QueryStatusResponse)message, (ManagedConnection)replyHandler);
        }
    }

    private class GiveStatsHandler
    implements MessageHandler {
        GiveStatsHandler() {
        }

        public void handleMessage(Message message, InetSocketAddress inetSocketAddress, ReplyHandler replyHandler) {
            MessageRouter.this.handleGiveStats((GiveStatsVendorMessage)message, replyHandler);
        }
    }

    private class StatisticsHandler
    implements MessageHandler {
        StatisticsHandler() {
        }

        public void handleMessage(Message message, InetSocketAddress inetSocketAddress, ReplyHandler replyHandler) {
            MessageRouter.this.handleStatisticsMessage((StatisticVendorMessage)message, replyHandler);
        }
    }

    private class HeadPingHandler
    implements MessageHandler {
        HeadPingHandler() {
        }

        public void handleMessage(Message message, InetSocketAddress inetSocketAddress, ReplyHandler replyHandler) {
            MessageRouter.this.handleHeadPing((HeadPing)message, replyHandler);
        }
    }

    private class SimppRequestVMHandler
    implements MessageHandler {
        SimppRequestVMHandler() {
        }

        public void handleMessage(Message message, InetSocketAddress inetSocketAddress, ReplyHandler replyHandler) {
            MessageRouter.this.handleSimppRequest((SimppRequestVM)message, replyHandler);
        }
    }

    private class SimppVMHandler
    implements MessageHandler {
        SimppVMHandler() {
        }

        public void handleMessage(Message message, InetSocketAddress inetSocketAddress, ReplyHandler replyHandler) {
            MessageRouter.this.handleSimppVM((SimppVM)message);
        }
    }

    private class HeadPongHandler
    implements MessageHandler {
        HeadPongHandler() {
        }

        public void handleMessage(Message message, InetSocketAddress inetSocketAddress, ReplyHandler replyHandler) {
            MessageRouter.this.handleHeadPong((HeadPong)message, replyHandler);
        }
    }

    public class VendorMessageHandler
    implements MessageHandler {
        public void handleMessage(Message message, InetSocketAddress inetSocketAddress, ReplyHandler replyHandler) {
            ((ManagedConnection)replyHandler).handleVendorMessage((VendorMessage)message);
        }
    }

    private class UDPQueryRequestHandler
    implements MessageHandler {
        UDPQueryRequestHandler() {
        }

        public void handleMessage(Message message, InetSocketAddress inetSocketAddress, ReplyHandler replyHandler) {
            int n;
            InetAddress inetAddress = inetSocketAddress.getAddress();
            if (MessageRouter.this.hasValidQueryKey(inetAddress, n = inetSocketAddress.getPort(), (QueryRequest)message)) {
                MessageRouter.this.sendAcknowledgement(inetSocketAddress, message.getGUID());
                if (!MessageRouter.this.handleUDPQueryRequestPossibleDuplicate((QueryRequest)message, replyHandler)) {
                    ReceivedMessageStatHandler.UDP_DUPLICATE_QUERIES.addMessage(message);
                }
            }
            ReceivedMessageStatHandler.UDP_QUERY_REQUESTS.addMessage(message);
        }
    }

    private class UDPQueryReplyHandler
    implements MessageHandler {
        UDPQueryReplyHandler() {
        }

        public void handleMessage(Message message, InetSocketAddress inetSocketAddress, ReplyHandler replyHandler) {
            QueryReply queryReply = (QueryReply)message;
            ReceivedMessageStatHandler.UDP_QUERY_REPLIES.addMessage(message);
            short s = queryReply.getResultCount();
            if (!queryReply.isReplyToMulticastQuery()) {
                OutOfBandThroughputStat.RESPONSES_RECEIVED.addData(s);
            }
            MessageRouter.this.handleQueryReply(queryReply, replyHandler);
        }
    }

    private class UDPPingRequestHandler
    implements MessageHandler {
        UDPPingRequestHandler() {
        }

        public void handleMessage(Message message, InetSocketAddress inetSocketAddress, ReplyHandler replyHandler) {
            ReceivedMessageStatHandler.UDP_PING_REQUESTS.addMessage(message);
            MessageRouter.this.handleUDPPingRequestPossibleDuplicate((PingRequest)message, replyHandler, inetSocketAddress);
        }
    }

    private class UDPPingReplyHandler
    implements MessageHandler {
        UDPPingReplyHandler() {
        }

        public void handleMessage(Message message, InetSocketAddress inetSocketAddress, ReplyHandler replyHandler) {
            ReceivedMessageStatHandler.UDP_PING_REPLIES.addMessage(message);
            MessageRouter.this.handleUDPPingReply((PingReply)message, replyHandler, inetSocketAddress.getAddress(), inetSocketAddress.getPort());
        }
    }

    private class UDPPushRequestHandler
    implements MessageHandler {
        UDPPushRequestHandler() {
        }

        public void handleMessage(Message message, InetSocketAddress inetSocketAddress, ReplyHandler replyHandler) {
            ReceivedMessageStatHandler.UDP_PUSH_REQUESTS.addMessage(message);
            MessageRouter.this.handlePushRequest((PushRequest)message, replyHandler);
        }
    }

    private class UDPLimeACKVendorMessageHandler
    implements MessageHandler {
        UDPLimeACKVendorMessageHandler() {
        }

        public void handleMessage(Message message, InetSocketAddress inetSocketAddress, ReplyHandler replyHandler) {
            ReceivedMessageStatHandler.UDP_LIME_ACK.addMessage(message);
            MessageRouter.this.handleLimeACKMessage((LimeACKVendorMessage)message, inetSocketAddress);
        }
    }

    private class UDPReplyNumberMessageHandler
    implements MessageHandler {
        UDPReplyNumberMessageHandler() {
        }

        public void handleMessage(Message message, InetSocketAddress inetSocketAddress, ReplyHandler replyHandler) {
            MessageRouter.this.handleReplyNumberMessage((ReplyNumberVendorMessage)message, inetSocketAddress);
        }
    }

    private class UDPGiveStatsHandler
    implements MessageHandler {
        UDPGiveStatsHandler() {
        }

        public void handleMessage(Message message, InetSocketAddress inetSocketAddress, ReplyHandler replyHandler) {
            MessageRouter.this.handleGiveStats((GiveStatsVendorMessage)message, replyHandler);
        }
    }

    private class UDPStatisticsMessageHandler
    implements MessageHandler {
        UDPStatisticsMessageHandler() {
        }

        public void handleMessage(Message message, InetSocketAddress inetSocketAddress, ReplyHandler replyHandler) {
            MessageRouter.this.handleStatisticsMessage((StatisticVendorMessage)message, replyHandler);
        }
    }

    private class UDPUDPCrawlerPingHandler
    implements MessageHandler {
        UDPUDPCrawlerPingHandler() {
        }

        public void handleMessage(Message message, InetSocketAddress inetSocketAddress, ReplyHandler replyHandler) {
            MessageRouter.this.handleUDPCrawlerPing((UDPCrawlerPing)message, replyHandler);
        }
    }

    private class UDPHeadPingHandler
    implements MessageHandler {
        UDPHeadPingHandler() {
        }

        public void handleMessage(Message message, InetSocketAddress inetSocketAddress, ReplyHandler replyHandler) {
            MessageRouter.this.handleHeadPing((HeadPing)message, replyHandler);
        }
    }

    private class UDPContentResponseHandler
    implements MessageHandler {
        UDPContentResponseHandler() {
        }

        public void handleMessage(Message message, InetSocketAddress inetSocketAddress, ReplyHandler replyHandler) {
            MessageRouter.this.handleContentResponse((ContentResponse)message, replyHandler);
        }
    }

    public class MulticastQueryRequestHandler
    implements MessageHandler {
        public void handleMessage(Message message, InetSocketAddress inetSocketAddress, ReplyHandler replyHandler) {
            if (!MessageRouter.this.handleUDPQueryRequestPossibleDuplicate((QueryRequest)message, replyHandler)) {
                ReceivedMessageStatHandler.MULTICAST_DUPLICATE_QUERIES.addMessage(message);
            }
            ReceivedMessageStatHandler.MULTICAST_QUERY_REQUESTS.addMessage(message);
        }
    }

    public class MulticastQueryReplyHandler
    implements MessageHandler {
        public void handleMessage(Message message, InetSocketAddress inetSocketAddress, ReplyHandler replyHandler) {
            ReceivedMessageStatHandler.UDP_QUERY_REPLIES.addMessage(message);
            MessageRouter.this.handleQueryReply((QueryReply)message, replyHandler);
        }
    }

    public class MulticastPingRequestHandler
    implements MessageHandler {
        public void handleMessage(Message message, InetSocketAddress inetSocketAddress, ReplyHandler replyHandler) {
            ReceivedMessageStatHandler.MULTICAST_PING_REQUESTS.addMessage(message);
            MessageRouter.this.handleUDPPingRequestPossibleDuplicate((PingRequest)message, replyHandler, inetSocketAddress);
        }
    }

    public class MulticastPingReplyHandler
    implements MessageHandler {
        public void handleMessage(Message message, InetSocketAddress inetSocketAddress, ReplyHandler replyHandler) {
            ReceivedMessageStatHandler.UDP_PING_REPLIES.addMessage(message);
            MessageRouter.this.handleUDPPingReply((PingReply)message, replyHandler, inetSocketAddress.getAddress(), inetSocketAddress.getPort());
        }
    }

    public class MulticastPushRequestHandler
    implements MessageHandler {
        public void handleMessage(Message message, InetSocketAddress inetSocketAddress, ReplyHandler replyHandler) {
            ReceivedMessageStatHandler.MULTICAST_PUSH_REQUESTS.addMessage(message);
            MessageRouter.this.handlePushRequest((PushRequest)message, replyHandler);
        }
    }
}

