/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella;

import com.limegroup.gnutella.BandwidthTrackerImpl;
import com.limegroup.gnutella.ByteOrder;
import com.limegroup.gnutella.Connection;
import com.limegroup.gnutella.ConnectionManager;
import com.limegroup.gnutella.ErrorService;
import com.limegroup.gnutella.GUID;
import com.limegroup.gnutella.InsufficientDataException;
import com.limegroup.gnutella.MessageDispatcher;
import com.limegroup.gnutella.ReplyHandler;
import com.limegroup.gnutella.RouterService;
import com.limegroup.gnutella.UDPService;
import com.limegroup.gnutella.connection.CompositeQueue;
import com.limegroup.gnutella.connection.ConnectionStats;
import com.limegroup.gnutella.connection.DeflaterWriter;
import com.limegroup.gnutella.connection.GnetConnectObserver;
import com.limegroup.gnutella.connection.InflaterReader;
import com.limegroup.gnutella.connection.MessageQueue;
import com.limegroup.gnutella.connection.MessageReader;
import com.limegroup.gnutella.connection.MessageReceiver;
import com.limegroup.gnutella.connection.MessageWriter;
import com.limegroup.gnutella.connection.OutputRunner;
import com.limegroup.gnutella.connection.SentMessageHandler;
import com.limegroup.gnutella.filters.SpamFilter;
import com.limegroup.gnutella.handshaking.AsyncIncomingHandshaker;
import com.limegroup.gnutella.handshaking.AsyncOutgoingHandshaker;
import com.limegroup.gnutella.handshaking.BadHandshakeException;
import com.limegroup.gnutella.handshaking.DefaultHandshakeResponder;
import com.limegroup.gnutella.handshaking.DefaultHeaders;
import com.limegroup.gnutella.handshaking.HandshakeObserver;
import com.limegroup.gnutella.handshaking.HandshakeResponder;
import com.limegroup.gnutella.handshaking.Handshaker;
import com.limegroup.gnutella.handshaking.LeafHandshakeResponder;
import com.limegroup.gnutella.handshaking.LeafHeaders;
import com.limegroup.gnutella.handshaking.NoGnutellaOkException;
import com.limegroup.gnutella.handshaking.UltrapeerHandshakeResponder;
import com.limegroup.gnutella.handshaking.UltrapeerHeaders;
import com.limegroup.gnutella.io.ChannelWriter;
import com.limegroup.gnutella.io.ConnectObserver;
import com.limegroup.gnutella.io.DelayedBufferWriter;
import com.limegroup.gnutella.io.IOStateObserver;
import com.limegroup.gnutella.io.InterestWriteChannel;
import com.limegroup.gnutella.io.NBThrottle;
import com.limegroup.gnutella.io.NIOMultiplexor;
import com.limegroup.gnutella.io.Throttle;
import com.limegroup.gnutella.io.ThrottleWriter;
import com.limegroup.gnutella.messages.BadPacketException;
import com.limegroup.gnutella.messages.Message;
import com.limegroup.gnutella.messages.PingReply;
import com.limegroup.gnutella.messages.PushRequest;
import com.limegroup.gnutella.messages.QueryReply;
import com.limegroup.gnutella.messages.QueryRequest;
import com.limegroup.gnutella.messages.vendor.CapabilitiesVM;
import com.limegroup.gnutella.messages.vendor.HopsFlowVendorMessage;
import com.limegroup.gnutella.messages.vendor.MessagesSupportedVendorMessage;
import com.limegroup.gnutella.messages.vendor.PushProxyAcknowledgement;
import com.limegroup.gnutella.messages.vendor.PushProxyRequest;
import com.limegroup.gnutella.messages.vendor.QueryStatusResponse;
import com.limegroup.gnutella.messages.vendor.SimppRequestVM;
import com.limegroup.gnutella.messages.vendor.TCPConnectBackVendorMessage;
import com.limegroup.gnutella.messages.vendor.UDPConnectBackVendorMessage;
import com.limegroup.gnutella.messages.vendor.VendorMessage;
import com.limegroup.gnutella.routing.PatchTableMessage;
import com.limegroup.gnutella.routing.QueryRouteTable;
import com.limegroup.gnutella.routing.ResetTableMessage;
import com.limegroup.gnutella.search.SearchResultHandler;
import com.limegroup.gnutella.settings.ConnectionSettings;
import com.limegroup.gnutella.simpp.SimppManager;
import com.limegroup.gnutella.statistics.OutOfBandThroughputStat;
import com.limegroup.gnutella.statistics.ReceivedMessageStatHandler;
import com.limegroup.gnutella.util.BandwidthThrottle;
import com.limegroup.gnutella.util.DataUtils;
import com.limegroup.gnutella.util.ThreadFactory;
import com.limegroup.gnutella.util.ThrottledOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InterruptedIOException;
import java.io.OutputStream;
import java.net.Socket;
import java.util.Arrays;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class ManagedConnection
extends Connection
implements ReplyHandler,
MessageReceiver,
SentMessageHandler {
    private static final Log LOG;
    private long LEAF_QUERY_ROUTE_UPDATE_TIME = 300000L;
    private long ULTRAPEER_QUERY_ROUTE_UPDATE_TIME = 60000L;
    private static final int CONNECT_TIMEOUT = 6000;
    private static final int TOTAL_OUTGOING_MESSAGING_BANDWIDTH = 8000;
    private static final int MAX_UDP_CONNECT_BACK_ATTEMPTS = 15;
    private static final int MAX_TCP_CONNECT_BACK_ATTEMPTS = 10;
    private ConnectionManager _manager;
    private volatile SpamFilter _routeFilter = SpamFilter.newRouteFilter();
    private volatile SpamFilter _personalFilter = SpamFilter.newPersonalFilter();
    private final Object QRP_LOCK = new Object();
    private static final Throttle _nbThrottle;
    private static final BandwidthThrottle _throttle;
    private OutputRunner _outputRunner;
    private final ConnectionStats _connectionStats = new ConnectionStats();
    private static long MIN_BUSY_LEAF_TIME;
    private long _nextQRPForwardTime;
    private BandwidthTrackerImpl _upBandwidthTracker = new BandwidthTrackerImpl();
    private BandwidthTrackerImpl _downBandwidthTracker = new BandwidthTrackerImpl();
    private boolean _isKillable = true;
    private volatile int hopsFlowMax = -1;
    private volatile long _busyTime = -1L;
    private volatile boolean _pushProxy;
    private static int _numUDPConnectBackRequests;
    private static int _numTCPConnectBackRequests;
    private QueryRouteTable _lastQRPTableReceived;
    private QueryRouteTable _lastQRPTableSent;
    private Map _guidMap = null;
    private static long TIMED_GUID_LIFETIME;
    private boolean supernodeClientAtLooping = false;
    private byte[] clientGUID = DataUtils.EMPTY_GUID;
    private boolean _useLocalPreference;
    static /* synthetic */ Class class$0;

    static {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("com.limegroup.gnutella.ManagedConnection");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        LOG = LogFactory.getLog((Class)clazz);
        _nbThrottle = new NBThrottle(true, 8000.0f, ConnectionSettings.NUM_CONNECTIONS.getValue(), 5000);
        _throttle = new BandwidthThrottle(8000.0f);
        MIN_BUSY_LEAF_TIME = 20000L;
        _numUDPConnectBackRequests = 0;
        _numTCPConnectBackRequests = 0;
        TIMED_GUID_LIFETIME = 600000L;
    }

    public ManagedConnection(String string, int n) {
        super(string, n);
        this._manager = RouterService.getConnectionManager();
    }

    ManagedConnection(Socket socket) {
        super(socket);
        this._manager = RouterService.getConnectionManager();
    }

    public void initialize() throws IOException, NoGnutellaOkException, BadHandshakeException {
        this.initialize(null);
    }

    public void initialize(GnetConnectObserver gnetConnectObserver) throws IOException, NoGnutellaOkException, BadHandshakeException {
        DefaultHandshakeResponder defaultHandshakeResponder;
        DefaultHeaders defaultHeaders;
        if (this.isOutgoing()) {
            String string = this.getAddress();
            if (RouterService.isSupernode()) {
                defaultHeaders = new UltrapeerHeaders(string);
                defaultHandshakeResponder = new UltrapeerHandshakeResponder(string);
            } else {
                defaultHeaders = new LeafHeaders(string);
                defaultHandshakeResponder = new LeafHandshakeResponder(string);
            }
        } else {
            String string = this.getSocket().getInetAddress().getHostAddress();
            defaultHeaders = null;
            defaultHandshakeResponder = RouterService.isSupernode() ? new UltrapeerHandshakeResponder(string) : new LeafHandshakeResponder(string);
        }
        super.initialize(defaultHeaders, defaultHandshakeResponder, 6000, gnetConnectObserver);
    }

    protected ConnectObserver createAsyncConnectObserver(Properties properties, HandshakeResponder handshakeResponder, GnetConnectObserver gnetConnectObserver) {
        return new AsyncHandshakeConnecter(properties, handshakeResponder, gnetConnectObserver);
    }

    protected void preHandshakeInitialize(Properties properties, HandshakeResponder handshakeResponder, GnetConnectObserver gnetConnectObserver) throws IOException, NoGnutellaOkException, BadHandshakeException {
        handshakeResponder.setLocalePreferencing(this._useLocalPreference);
        super.preHandshakeInitialize(properties, handshakeResponder, gnetConnectObserver);
    }

    protected void performHandshake(Properties properties, HandshakeResponder handshakeResponder, GnetConnectObserver gnetConnectObserver) throws IOException, BadHandshakeException, NoGnutellaOkException {
        if (gnetConnectObserver == null || !this.isAsynchronous()) {
            if (!this.isOutgoing() && gnetConnectObserver != null) {
                throw new IllegalStateException("cannot support incoming blocking w/ observer");
            }
            super.performHandshake(properties, handshakeResponder, gnetConnectObserver);
        } else {
            Handshaker handshaker = this.createAsyncHandshaker(properties, handshakeResponder, gnetConnectObserver);
            try {
                handshaker.shake();
            }
            catch (IOException iOException) {
                ErrorService.error(iOException);
            }
        }
    }

    protected Handshaker createAsyncHandshaker(Properties properties, HandshakeResponder handshakeResponder, GnetConnectObserver gnetConnectObserver) {
        HandshakeWatcher handshakeWatcher = new HandshakeWatcher(gnetConnectObserver);
        IOStateObserver iOStateObserver = this.isOutgoing() ? new AsyncOutgoingHandshaker(properties, handshakeResponder, this._socket, handshakeWatcher) : new AsyncIncomingHandshaker(handshakeResponder, this._socket, handshakeWatcher);
        handshakeWatcher.setHandshaker((Handshaker)((Object)iOStateObserver));
        return iOStateObserver;
    }

    protected void postHandshakeInitialize(Handshaker handshaker) {
        super.postHandshakeInitialize(handshaker);
        this.startOutput();
    }

    public void resetQueryRouteTable(ResetTableMessage resetTableMessage) {
        if (this._lastQRPTableReceived == null) {
            this._lastQRPTableReceived = new QueryRouteTable(resetTableMessage.getTableSize(), resetTableMessage.getInfinity());
        } else {
            this._lastQRPTableReceived.reset(resetTableMessage);
        }
    }

    public void patchQueryRouteTable(PatchTableMessage patchTableMessage) {
        if (this._lastQRPTableReceived == null) {
            this._lastQRPTableReceived = new QueryRouteTable();
        }
        try {
            this._lastQRPTableReceived.patch(patchTableMessage);
        }
        catch (BadPacketException badPacketException) {}
    }

    public void setBusy(boolean bl) {
        if (bl) {
            if (this._busyTime == -1L) {
                this._busyTime = System.currentTimeMillis();
            }
        } else {
            this._busyTime = -1L;
        }
    }

    public byte getHopsFlowMax() {
        return (byte)this.hopsFlowMax;
    }

    public boolean isBusyLeaf() {
        boolean bl = this.isSupernodeClientConnection() && this.getHopsFlowMax() == 0;
        return bl;
    }

    public boolean isBusyEnoughToTriggerQRTRemoval() {
        if (this._busyTime == -1L) {
            return false;
        }
        return System.currentTimeMillis() > this._busyTime + MIN_BUSY_LEAF_TIME;
    }

    public boolean shouldForwardQuery(QueryRequest queryRequest) {
        if (queryRequest.isFeatureQuery()) {
            if (this.isSupernodeClientConnection()) {
                return this.getRemoteHostFeatureQuerySelector() >= queryRequest.getFeatureSelector();
            }
            if (this.isSupernodeSupernodeConnection()) {
                return this.getRemoteHostSupportsFeatureQueries();
            }
            return false;
        }
        return this.hitsQueryRouteTable(queryRequest);
    }

    protected boolean hitsQueryRouteTable(QueryRequest queryRequest) {
        if (this._lastQRPTableReceived == null) {
            return false;
        }
        return this._lastQRPTableReceived.contains(queryRequest);
    }

    public QueryRouteTable getQueryRouteTableReceived() {
        return this._lastQRPTableReceived;
    }

    public double getQueryRouteTablePercentFull() {
        return this._lastQRPTableReceived == null ? 0.0 : this._lastQRPTableReceived.getPercentFull();
    }

    public int getQueryRouteTableSize() {
        return this._lastQRPTableReceived == null ? 0 : this._lastQRPTableReceived.getSize();
    }

    public int getQueryRouteTableEmptyUnits() {
        return this._lastQRPTableReceived == null ? -1 : this._lastQRPTableReceived.getEmptyUnits();
    }

    public int getQueryRouteTableUnitsInUse() {
        return this._lastQRPTableReceived == null ? -1 : this._lastQRPTableReceived.getUnitsInUse();
    }

    protected OutputStream createDeflatedOutputStream(OutputStream outputStream) {
        if (this.isAsynchronous()) {
            return outputStream;
        }
        return super.createDeflatedOutputStream(outputStream);
    }

    protected InputStream createInflatedInputStream(InputStream inputStream) {
        if (this.isAsynchronous()) {
            return inputStream;
        }
        return super.createInflatedInputStream(inputStream);
    }

    protected OutputStream getOutputStream() throws IOException {
        return new ThrottledOutputStream(super.getOutputStream(), _throttle);
    }

    public Message receive() throws IOException, BadPacketException {
        Message message = null;
        try {
            message = super.receive();
        }
        catch (IOException iOException) {
            if (this._manager != null) {
                this._manager.remove(this);
            }
            throw iOException;
        }
        this._connectionStats.addReceived();
        return message;
    }

    public Message receive(int n) throws IOException, BadPacketException, InterruptedIOException {
        Message message = null;
        try {
            message = super.receive(n);
        }
        catch (InterruptedIOException interruptedIOException) {
            throw interruptedIOException;
        }
        catch (IOException iOException) {
            if (this._manager != null) {
                this._manager.remove(this);
            }
            throw iOException;
        }
        this._connectionStats.addReceived();
        return message;
    }

    private void startOutput() {
        CompositeQueue compositeQueue = new CompositeQueue();
        if (this.isAsynchronous()) {
            InterestWriteChannel interestWriteChannel;
            MessageWriter messageWriter = new MessageWriter(this._connectionStats, compositeQueue, this);
            this._outputRunner = messageWriter;
            ChannelWriter channelWriter = messageWriter;
            if (this.isWriteDeflated()) {
                interestWriteChannel = new DeflaterWriter(this._deflater);
                messageWriter.setWriteChannel(interestWriteChannel);
                channelWriter = interestWriteChannel;
            }
            interestWriteChannel = new DelayedBufferWriter(1400);
            channelWriter.setWriteChannel(interestWriteChannel);
            channelWriter = interestWriteChannel;
            channelWriter.setWriteChannel(new ThrottleWriter(_nbThrottle));
            ((NIOMultiplexor)((Object)this._socket)).setWriteObserver(messageWriter);
        } else {
            this._outputRunner = new BlockingRunner(compositeQueue);
        }
    }

    public void send(Message message) {
        int n;
        if (!this.supportsGGEP()) {
            message = message.stripExtendedPayload();
        }
        if ((n = this.hopsFlowMax) > -1 && message instanceof QueryRequest && message.getHops() >= n) {
            return;
        }
        this._outputRunner.send(message);
    }

    public void originateQuery(QueryRequest queryRequest) {
        queryRequest.originate();
        this.send(queryRequest);
    }

    public void flush() throws IOException {
    }

    public void close() {
        if (this._outputRunner != null) {
            this._outputRunner.shutdown();
        }
        super.close();
        if (this._guidMap != null) {
            GuidMapExpirer.removeMap(this._guidMap);
        }
    }

    void loopForMessages() throws IOException {
        this.supernodeClientAtLooping = this.isSupernodeClientConnection();
        if (!this.isAsynchronous()) {
            Thread.currentThread().setName("MessageLoopingThread");
            while (true) {
                Message message = null;
                try {
                    message = this.receive();
                    if (message == null) continue;
                    this.handleMessageInternal(message);
                }
                catch (BadPacketException badPacketException) {}
            }
        }
        this._socket.setSoTimeout(0);
        MessageReader messageReader = new MessageReader(this);
        if (this.isReadDeflated()) {
            messageReader.setReadChannel(new InflaterReader(this._inflater));
        }
        ((NIOMultiplexor)((Object)this._socket)).setReadObserver(messageReader);
    }

    public void messagingClosed() {
        if (this._manager != null) {
            this._manager.remove(this);
        }
    }

    public void processReadMessage(Message message) throws IOException {
        this.updateReadStatistics(message);
        this._connectionStats.addReceived();
        this.handleMessageInternal(message);
    }

    public void processSentMessage(Message message) {
        this.updateWriteStatistics(message);
    }

    private void handleMessageInternal(Message message) {
        if (this.isSpam(message)) {
            ReceivedMessageStatHandler.TCP_FILTERED_MESSAGES.addMessage(message);
            this._connectionStats.addReceivedDropped();
        } else {
            if (message instanceof QueryReply && message.getHops() == 0) {
                this.clientGUID = ((QueryReply)message).getClientGUID();
            }
            if (this.supernodeClientAtLooping) {
                if (message instanceof QueryRequest) {
                    message = this.tryToProxy((QueryRequest)message);
                } else if (message instanceof QueryStatusResponse) {
                    message = this.morphToStopQuery((QueryStatusResponse)message);
                }
            }
            MessageDispatcher.instance().dispatchTCP(message, this);
        }
    }

    public int getNetwork() {
        return 1;
    }

    private QueryRequest tryToProxy(QueryRequest queryRequest) {
        if (this.remoteHostSupportsLeafGuidance() < 1) {
            return queryRequest;
        }
        if (queryRequest.desiresOutOfBandReplies()) {
            return queryRequest;
        }
        if (queryRequest.doNotProxy()) {
            return queryRequest;
        }
        if (!(RouterService.isOOBCapable() && OutOfBandThroughputStat.isSuccessRateGreat() && OutOfBandThroughputStat.isOOBEffectiveForProxy())) {
            return queryRequest;
        }
        byte[] byArray = queryRequest.getGUID();
        byte[] byArray2 = new byte[byArray.length];
        System.arraycopy(byArray, 0, byArray2, 0, byArray.length);
        GUID.addressEncodeGuid(byArray2, RouterService.getAddress(), RouterService.getPort());
        queryRequest = QueryRequest.createProxyQuery(queryRequest, byArray2);
        if (this._guidMap == null) {
            this._guidMap = new Hashtable();
            GuidMapExpirer.addMapToExpire(this._guidMap);
        }
        GUID.TimedGUID timedGUID = new GUID.TimedGUID(new GUID(byArray2), TIMED_GUID_LIFETIME);
        this._guidMap.put(timedGUID, new GUID(byArray));
        OutOfBandThroughputStat.OOB_QUERIES_SENT.incrementStat();
        return queryRequest;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private QueryStatusResponse morphToStopQuery(QueryStatusResponse queryStatusResponse) {
        if (this._guidMap == null) {
            return queryStatusResponse;
        }
        GUID gUID = queryStatusResponse.getQueryGUID();
        GUID gUID2 = null;
        Map map = this._guidMap;
        synchronized (map) {
            Iterator iterator = this._guidMap.entrySet().iterator();
            while (iterator.hasNext()) {
                Map.Entry entry = iterator.next();
                if (!gUID.equals(entry.getValue())) continue;
                gUID2 = ((GUID.TimedGUID)entry.getKey()).getGUID();
                break;
            }
        }
        if (gUID2 != null) {
            return new QueryStatusResponse(gUID2, queryStatusResponse.getNumResults());
        }
        return queryStatusResponse;
    }

    public boolean isSpam(Message message) {
        return !this._routeFilter.allow(message);
    }

    public void countDroppedMessage() {
        this._connectionStats.addReceivedDropped();
    }

    public boolean isPersonalSpam(Message message) {
        return !this._personalFilter.allow(message);
    }

    public void setRouteFilter(SpamFilter spamFilter) {
        this._routeFilter = spamFilter;
    }

    public void setPersonalFilter(SpamFilter spamFilter) {
        this._personalFilter = spamFilter;
    }

    public void handlePingReply(PingReply pingReply, ReplyHandler replyHandler) {
        this.send(pingReply);
    }

    public void handleQueryReply(QueryReply queryReply, ReplyHandler replyHandler) {
        GUID.TimedGUID timedGUID;
        GUID gUID;
        if (this._guidMap != null && (gUID = (GUID)this._guidMap.get(timedGUID = new GUID.TimedGUID(new GUID(queryReply.getGUID()), TIMED_GUID_LIFETIME))) != null) {
            byte by = queryReply.getHops();
            queryReply = new QueryReply(gUID.bytes(), queryReply);
            queryReply.setTTL((byte)2);
            queryReply.setHops(by);
        }
        this.send(queryReply);
    }

    public byte[] getClientGUID() {
        return this.clientGUID;
    }

    public void handlePushRequest(PushRequest pushRequest, ReplyHandler replyHandler) {
        this.send(pushRequest);
    }

    protected void handleVendorMessage(VendorMessage vendorMessage) {
        super.handleVendorMessage(vendorMessage);
        if (vendorMessage instanceof HopsFlowVendorMessage) {
            HopsFlowVendorMessage hopsFlowVendorMessage = (HopsFlowVendorMessage)vendorMessage;
            if (this.isSupernodeClientConnection()) {
                this.setBusy(hopsFlowVendorMessage.getHopValue() == 0);
            }
            this.hopsFlowMax = hopsFlowVendorMessage.getHopValue();
        } else if (vendorMessage instanceof PushProxyAcknowledgement) {
            PushProxyAcknowledgement pushProxyAcknowledgement = (PushProxyAcknowledgement)vendorMessage;
            if (Arrays.equals(pushProxyAcknowledgement.getGUID(), RouterService.getMessageRouter()._clientGUID)) {
                this._pushProxy = true;
            }
        } else if (vendorMessage instanceof CapabilitiesVM) {
            CapabilitiesVM capabilitiesVM = (CapabilitiesVM)vendorMessage;
            if (capabilitiesVM.supportsSIMPP() > SimppManager.instance().getVersion()) {
                SimppRequestVM simppRequestVM = new SimppRequestVM();
                this.send(simppRequestVM);
            }
        } else if (vendorMessage instanceof MessagesSupportedVendorMessage) {
            Object object;
            Object object2;
            if (this.isClientSupernodeConnection() && this.remoteHostSupportsLeafGuidance() >= 0) {
                object2 = RouterService.getSearchResultHandler();
                object = ((SearchResultHandler)object2).getQueriesToReSend();
                Iterator iterator = object.iterator();
                while (iterator.hasNext()) {
                    this.send((Message)iterator.next());
                }
            }
            if (this.remoteHostSupportsPushProxy() > -1) {
                object2 = new GUID(RouterService.getMessageRouter()._clientGUID);
                object = new PushProxyRequest((GUID)object2);
                this.send((Message)object);
            }
            if (!UDPService.instance().canReceiveUnsolicited() && _numUDPConnectBackRequests < 15 && this.remoteHostSupportsUDPRedirect() > -1) {
                object2 = RouterService.getUDPConnectBackGUID();
                object = new UDPConnectBackVendorMessage(RouterService.getPort(), (GUID)object2);
                this.send((Message)object);
                ++_numUDPConnectBackRequests;
            }
            if (!RouterService.acceptedIncomingConnection() && _numTCPConnectBackRequests < 10 && this.remoteHostSupportsTCPRedirect() > -1) {
                object2 = new TCPConnectBackVendorMessage(RouterService.getPort());
                this.send((Message)object2);
                ++_numTCPConnectBackRequests;
            }
        }
    }

    public int getNumMessagesSent() {
        return this._connectionStats.getSent();
    }

    public int getNumMessagesReceived() {
        return this._connectionStats.getReceived();
    }

    public int getNumSentMessagesDropped() {
        return this._connectionStats.getSentDropped();
    }

    public long getNumReceivedMessagesDropped() {
        return this._connectionStats.getReceivedDropped();
    }

    public float getPercentReceivedDropped() {
        return this._connectionStats.getPercentReceivedDropped();
    }

    public float getPercentSentDropped() {
        return this._connectionStats.getPercentSentDropped();
    }

    public void measureBandwidth() {
        this._upBandwidthTracker.measureBandwidth(ByteOrder.long2int(this.getBytesSent()));
        this._downBandwidthTracker.measureBandwidth(ByteOrder.long2int(this.getBytesReceived()));
    }

    public float getMeasuredUpstreamBandwidth() {
        float f = 0.0f;
        try {
            f = this._upBandwidthTracker.getMeasuredBandwidth();
        }
        catch (InsufficientDataException insufficientDataException) {
            return 0.0f;
        }
        return f;
    }

    public float getMeasuredDownstreamBandwidth() {
        float f = 0.0f;
        try {
            f = this._downBandwidthTracker.getMeasuredBandwidth();
        }
        catch (InsufficientDataException insufficientDataException) {
            return 0.0f;
        }
        return f;
    }

    public long getNextQRPForwardTime() {
        return this._nextQRPForwardTime;
    }

    public void incrementNextQRPForwardTime(long l) {
        this._nextQRPForwardTime = this.isLeafConnection() ? l + this.LEAF_QUERY_ROUTE_UPDATE_TIME : l + this.ULTRAPEER_QUERY_ROUTE_UPDATE_TIME;
    }

    public boolean isKillable() {
        return this._isKillable;
    }

    public QueryRouteTable getQueryRouteTableSent() {
        return this._lastQRPTableSent;
    }

    public void setQueryRouteTableSent(QueryRouteTable queryRouteTable) {
        this._lastQRPTableSent = queryRouteTable;
    }

    public boolean isPushProxy() {
        return this._pushProxy;
    }

    public Object getQRPLock() {
        return this.QRP_LOCK;
    }

    public void setLocalePreferencing(boolean bl) {
        this._useLocalPreference = bl;
    }

    public void reply(Message message) {
        this.send(message);
    }

    private class BlockingRunner
    implements Runnable,
    OutputRunner {
        private final Object LOCK = new Object();
        private final MessageQueue queue;
        private boolean shutdown = false;

        public BlockingRunner(MessageQueue messageQueue) {
            this.queue = messageQueue;
            ThreadFactory.startThread(this, "OutputRunner");
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void send(Message message) {
            Object object = this.LOCK;
            synchronized (object) {
                ManagedConnection.this._connectionStats.addSent();
                this.queue.add(message);
                int n = this.queue.resetDropped();
                ManagedConnection.this._connectionStats.addSentDropped(n);
                this.LOCK.notify();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void shutdown() {
            Object object = this.LOCK;
            synchronized (object) {
                this.shutdown = true;
                this.LOCK.notify();
            }
        }

        public void run() {
            try {
                while (true) {
                    this.waitForQueued();
                    this.sendQueued();
                }
            }
            catch (IOException iOException) {
                if (ManagedConnection.this._manager != null) {
                    ManagedConnection.this._manager.remove(ManagedConnection.this);
                }
            }
            catch (Throwable throwable) {
                if (ManagedConnection.this._manager != null) {
                    ManagedConnection.this._manager.remove(ManagedConnection.this);
                }
                ErrorService.error(throwable);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private final void waitForQueued() throws IOException {
            Object object = this.LOCK;
            synchronized (object) {
                while (!this.shutdown && ManagedConnection.this.isOpen() && this.queue.isEmpty()) {
                    try {
                        this.LOCK.wait();
                    }
                    catch (InterruptedException interruptedException) {
                        throw new RuntimeException(interruptedException);
                    }
                }
            }
            if (!ManagedConnection.this.isOpen() || this.shutdown) {
                throw CONNECTION_CLOSED;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private final void sendQueued() throws IOException {
            while (true) {
                Message message = null;
                Object object = this.LOCK;
                synchronized (object) {
                    message = this.queue.removeNext();
                    int n = this.queue.resetDropped();
                    ManagedConnection.this._connectionStats.addSentDropped(n);
                }
                if (message == null) break;
                ManagedConnection.super.send(message);
            }
            ManagedConnection.super.flush();
        }
    }

    private static class GuidMapExpirer
    implements Runnable {
        private static List toExpire = new LinkedList();
        private static boolean scheduled = false;
        static /* synthetic */ Class class$0;

        public static synchronized void addMapToExpire(Map map) {
            if (!scheduled) {
                RouterService.schedule(new GuidMapExpirer(), 0L, TIMED_GUID_LIFETIME);
                scheduled = true;
            }
            toExpire.add(map);
        }

        public static synchronized void removeMap(Map map) {
            toExpire.remove(map);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            Class<?> clazz = class$0;
            if (clazz == null) {
                try {
                    clazz = class$0 = Class.forName("com.limegroup.gnutella.ManagedConnection$GuidMapExpirer");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            Class<?> clazz2 = clazz;
            synchronized (clazz) {
                Iterator iterator = toExpire.iterator();
                while (iterator.hasNext()) {
                    Map map;
                    Map map2 = map = (Map)iterator.next();
                    synchronized (map2) {
                        Iterator iterator2 = map.keySet().iterator();
                        while (iterator2.hasNext()) {
                            if (!((GUID.TimedGUID)iterator2.next()).shouldExpire()) continue;
                            iterator2.remove();
                        }
                    }
                }
                // ** MonitorExit[var1_1] (shouldn't be in output)
                return;
            }
        }
    }

    private class AsyncHandshakeConnecter
    implements ConnectObserver {
        private Properties requestHeaders;
        private HandshakeResponder responder;
        private GnetConnectObserver observer;

        AsyncHandshakeConnecter(Properties properties, HandshakeResponder handshakeResponder, GnetConnectObserver gnetConnectObserver) {
            this.requestHeaders = properties;
            this.responder = handshakeResponder;
            this.observer = gnetConnectObserver;
        }

        public void handleConnect(Socket socket) throws IOException {
            ManagedConnection.this._socket = socket;
            ManagedConnection.this.preHandshakeInitialize(this.requestHeaders, this.responder, this.observer);
        }

        public void shutdown() {
            this.observer.shutdown();
        }

        public void handleIOException(IOException iOException) {
        }
    }

    private class HandshakeWatcher
    implements HandshakeObserver {
        private Handshaker shaker;
        private GnetConnectObserver observer;

        HandshakeWatcher(GnetConnectObserver gnetConnectObserver) {
            this.observer = gnetConnectObserver;
        }

        void setHandshaker(Handshaker handshaker) {
            this.shaker = handshaker;
        }

        public void shutdown() {
            ManagedConnection.this.setHeaders(this.shaker);
            ManagedConnection.this.close();
            this.observer.shutdown();
        }

        public void handleHandshakeFinished(Handshaker handshaker) {
            ManagedConnection.this.postHandshakeInitialize(handshaker);
            this.observer.handleConnect();
        }

        public void handleBadHandshake() {
            ManagedConnection.this.setHeaders(this.shaker);
            ManagedConnection.this.close();
            this.observer.handleBadHandshake();
        }

        public void handleNoGnutellaOk(int n, String string) {
            ManagedConnection.this.setHeaders(this.shaker);
            ManagedConnection.this.close();
            this.observer.handleNoGnutellaOk(n, string);
        }
    }
}

