/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella;

import com.limegroup.gnutella.ConnectionDispatcher;
import com.limegroup.gnutella.ConnectionManager;
import com.limegroup.gnutella.MessageService;
import com.limegroup.gnutella.MulticastService;
import com.limegroup.gnutella.RouterService;
import com.limegroup.gnutella.UDPService;
import com.limegroup.gnutella.UPnPManager;
import com.limegroup.gnutella.filters.IPFilter;
import com.limegroup.gnutella.io.AbstractChannelInterestRead;
import com.limegroup.gnutella.io.AcceptObserver;
import com.limegroup.gnutella.io.BufferUtils;
import com.limegroup.gnutella.io.NIOMultiplexor;
import com.limegroup.gnutella.io.SocketFactory;
import com.limegroup.gnutella.settings.ConnectionSettings;
import com.limegroup.gnutella.settings.SettingsHandler;
import com.limegroup.gnutella.statistics.HTTPStat;
import com.limegroup.gnutella.util.IOUtils;
import com.limegroup.gnutella.util.NetworkUtils;
import com.limegroup.gnutella.util.ThreadFactory;
import java.io.IOException;
import java.io.InputStream;
import java.net.DatagramSocket;
import java.net.InetAddress;
import java.net.MulticastSocket;
import java.net.ServerSocket;
import java.net.Socket;
import java.net.SocketException;
import java.net.UnknownHostException;
import java.nio.ByteBuffer;
import java.util.Arrays;
import java.util.Random;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class Acceptor {
    private static final Log LOG;
    static long INCOMING_EXPIRE_TIME;
    static long WAIT_TIME_AFTER_REQUESTS;
    static long TIME_BETWEEN_VALIDATES;
    private static final UPnPManager UPNP_MANAGER;
    private volatile ServerSocket _socket = null;
    private volatile int _port = 6346;
    private static byte[] _address;
    private static byte[] _externalAddress;
    private volatile boolean _acceptedIncoming = false;
    private volatile long _lastIncomingTime = 0L;
    private volatile long _lastConnectBackTime = System.currentTimeMillis();
    private volatile boolean _started;
    static /* synthetic */ Class class$0;

    static {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("com.limegroup.gnutella.Acceptor");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        LOG = LogFactory.getLog((Class)clazz);
        INCOMING_EXPIRE_TIME = 1800000L;
        WAIT_TIME_AFTER_REQUESTS = 30000L;
        TIME_BETWEEN_VALIDATES = 600000L;
        UPNP_MANAGER = !ConnectionSettings.DISABLE_UPNP.getValue() ? UPnPManager.instance() : null;
        _address = new byte[4];
        _externalAddress = new byte[4];
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setAddress(InetAddress inetAddress) {
        byte[] byArray = inetAddress.getAddress();
        if (!NetworkUtils.isValidAddress(byArray)) {
            return;
        }
        if (byArray[0] == 127 && ConnectionSettings.LOCAL_IS_PRIVATE.getValue()) {
            return;
        }
        boolean bl = false;
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("com.limegroup.gnutella.Acceptor");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        Class<?> clazz2 = clazz;
        synchronized (clazz) {
            if (!Arrays.equals(_address, byArray)) {
                _address = byArray;
                bl = true;
            }
            // ** MonitorExit[var4_4] (shouldn't be in output)
            if (bl) {
                RouterService.addressChanged();
            }
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setExternalAddress(InetAddress inetAddress) {
        byte[] byArray = inetAddress.getAddress();
        if (byArray[0] == 127 && ConnectionSettings.LOCAL_IS_PRIVATE.getValue()) {
            return;
        }
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("com.limegroup.gnutella.Acceptor");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        Class<?> clazz2 = clazz;
        synchronized (clazz) {
            _externalAddress = byArray;
            // ** MonitorExit[var3_3] (shouldn't be in output)
            return;
        }
    }

    /*
     * Unable to fully structure code
     * Could not resolve type clashes
     */
    public void init() {
        block22: {
            var2_1 = ConnectionSettings.PORT.isDefault() != false && ConnectionSettings.EVER_ACCEPTED_INCOMING.getValue() == false && ConnectionSettings.FORCE_IP_ADDRESS.getValue() == false;
            var3_2 = null;
            if (var2_1) {
                var3_2 = new Random();
                var1_3 = var3_2.nextInt(50000) + 2000;
            } else {
                var1_3 = ConnectionSettings.PORT.getValue();
            }
            try {
                this.setAddress(Acceptor.UPNP_MANAGER != null ? NetworkUtils.getLocalAddress() : InetAddress.getLocalHost());
            }
            catch (UnknownHostException v0) {
            }
            catch (SecurityException v1) {}
            var4_4 = var1_3;
            try {
                this.setListeningPort(var1_3);
                this._port = var1_3;
                break block22;
            }
            catch (IOException var5_5) {
                Acceptor.LOG.warn((Object)"can't set initial port", (Throwable)var5_5);
                var6_7 = 20 != 0;
                var7_8 = false;
                ** while (var7_8 < var6_7)
            }
lbl-1000:
            // 1 sources

            {
                if (var3_2 == null) {
                    var3_2 = new Random();
                }
                var1_3 = var3_2.nextInt(50000);
                if ((var1_3 += 2000) == ConnectionSettings.MULTICAST_PORT.getValue()) {
                    var6_7 += 1;
                } else {
                    try {
                        this.setListeningPort(var1_3);
                        this._port = var1_3;
                        break;
                    }
                    catch (IOException var8_9) {
                        Acceptor.LOG.warn((Object)"can't set port", (Throwable)var8_9);
                    }
                }
                var7_8 += 1;
                continue;
            }
lbl39:
            // 2 sources

            if (this._socket == null) {
                MessageService.showError("ERROR_NO_PORTS_AVAILABLE");
            }
        }
        if (this._port != var4_4 || var2_1) {
            ConnectionSettings.PORT.setValue(this._port);
            SettingsHandler.save();
            RouterService.addressChanged();
        }
        if (this._socket != null && Acceptor.UPNP_MANAGER != null) {
            Acceptor.UPNP_MANAGER.waitForDevice();
            Acceptor.UPNP_MANAGER.stop();
            var5_6 = Acceptor.UPNP_MANAGER.isNATPresent();
            var6_7 = NetworkUtils.isValidPort(this._port);
            v2 = var7_8 = ConnectionSettings.FORCE_IP_ADDRESS.getValue() != false && ConnectionSettings.UPNP_IN_USE.getValue() == false;
            if (Acceptor.LOG.isDebugEnabled()) {
                Acceptor.LOG.debug((Object)("Natted: " + var5_6 + ", validPort: " + var6_7 + ", forcedIP: " + var7_8));
            }
            if (var5_6 && var6_7 && !var7_8) {
                var8_10 = Acceptor.UPNP_MANAGER.mapPort(this._port);
                if (Acceptor.LOG.isDebugEnabled()) {
                    Acceptor.LOG.debug((Object)("UPNP port mapped: " + var8_10));
                }
                if (var8_10 != 0) {
                    Acceptor.UPNP_MANAGER.clearMappingsOnShutdown();
                    ConnectionSettings.FORCE_IP_ADDRESS.setValue(true);
                    ConnectionSettings.FORCED_PORT.setValue(var8_10);
                    ConnectionSettings.UPNP_IN_USE.setValue(true);
                    if (var8_10 != this._port) {
                        RouterService.addressChanged();
                    }
                    this.resetLastConnectBackTime();
                    UDPService.instance().resetLastConnectBackTime();
                }
            }
        }
    }

    public void start() {
        MulticastService.instance().start();
        UDPService.instance().start();
        RouterService.schedule(new IncomingValidator(), TIME_BETWEEN_VALIDATES, TIME_BETWEEN_VALIDATES);
        this._started = true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isAddressExternal() {
        if (!ConnectionSettings.LOCAL_IS_PRIVATE.getValue()) {
            return true;
        }
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("com.limegroup.gnutella.Acceptor");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        Class<?> clazz2 = clazz;
        synchronized (clazz) {
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return Arrays.equals(this.getAddress(true), _externalAddress);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public byte[] getExternalAddress() {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("com.limegroup.gnutella.Acceptor");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        Class<?> clazz2 = clazz;
        synchronized (clazz) {
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return _externalAddress;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public byte[] getAddress(boolean bl) {
        Class<?> clazz;
        Object object;
        if (bl && ConnectionSettings.FORCE_IP_ADDRESS.getValue()) {
            object = ConnectionSettings.FORCED_IP_ADDRESS_STRING.getValue();
            try {
                InetAddress inetAddress = InetAddress.getByName((String)object);
                return inetAddress.getAddress();
            }
            catch (UnknownHostException unknownHostException) {}
        }
        if ((clazz = class$0) == null) {
            try {
                clazz = class$0 = Class.forName("com.limegroup.gnutella.Acceptor");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        object = clazz;
        synchronized (clazz) {
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return _address;
        }
    }

    public int getPort(boolean bl) {
        if (bl && ConnectionSettings.FORCE_IP_ADDRESS.getValue()) {
            return ConnectionSettings.FORCED_PORT.getValue();
        }
        return this._port;
    }

    public void setListeningPort(int n) throws IOException {
        Object object;
        if (this._socket != null && this._port == n) {
            return;
        }
        if (n == 0) {
            LOG.trace((Object)"shutting off service.");
            IOUtils.close(this._socket);
            this._socket = null;
            this._port = 0;
            UDPService.instance().setListeningSocket(null);
            MulticastService.instance().setListeningSocket(null);
            LOG.trace((Object)"service OFF.");
            return;
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("changing port to " + n));
        }
        DatagramSocket datagramSocket = UDPService.instance().newListeningSocket(n);
        LOG.trace((Object)"UDP Service is ready.");
        MulticastSocket multicastSocket = null;
        try {
            object = InetAddress.getByName(ConnectionSettings.MULTICAST_ADDRESS.getValue());
            multicastSocket = MulticastService.instance().newListeningSocket(ConnectionSettings.MULTICAST_PORT.getValue(), (InetAddress)object);
            LOG.trace((Object)"multicast service setup");
        }
        catch (IOException iOException) {
            LOG.warn((Object)"can't create multicast socket", (Throwable)iOException);
            multicastSocket = null;
        }
        object = null;
        try {
            object = SocketFactory.newServerSocket(n, new SocketListener());
        }
        catch (IOException iOException) {
            LOG.warn((Object)"can't create ServerSocket", (Throwable)iOException);
            datagramSocket.close();
            throw iOException;
        }
        catch (IllegalArgumentException illegalArgumentException) {
            LOG.warn((Object)"can't create ServerSocket", (Throwable)illegalArgumentException);
            datagramSocket.close();
            throw new IOException("could not create a listening socket");
        }
        IOUtils.close(this._socket);
        this._socket = object;
        this._port = n;
        LOG.trace((Object)"Acceptor ready..");
        UDPService.instance().setListeningSocket(datagramSocket);
        if (multicastSocket != null) {
            MulticastService.instance().setListeningSocket(multicastSocket);
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("listening UDP/TCP on " + this._port));
        }
    }

    public boolean acceptedIncoming() {
        return this._acceptedIncoming;
    }

    private boolean setIncoming(boolean bl) {
        if (this._acceptedIncoming == bl) {
            return false;
        }
        this._acceptedIncoming = bl;
        RouterService.getCallback().acceptedIncomingChanged(bl);
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    public void checkFirewall(InetAddress inetAddress) {
        boolean bl = false;
        if (this.isOutsideConnection(inetAddress)) {
            Class<?> clazz = class$0;
            if (clazz == null) {
                try {
                    clazz = class$0 = Class.forName("com.limegroup.gnutella.Acceptor");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            Class<?> clazz2 = clazz;
            // MONITORENTER : clazz
            bl = this.setIncoming(true);
            ConnectionSettings.EVER_ACCEPTED_INCOMING.setValue(true);
            this._lastIncomingTime = System.currentTimeMillis();
            // MONITOREXIT : clazz2
        }
        if (!bl) return;
        RouterService.incomingStatusChanged();
    }

    public void accept(Socket socket) {
        this.accept(socket, null);
    }

    public void accept(Socket socket, String string) {
        if (!this._started) {
            IOUtils.close(socket);
            return;
        }
        InetAddress inetAddress = socket.getInetAddress();
        if (inetAddress == null) {
            IOUtils.close(socket);
            LOG.warn((Object)"connection closed while accepting");
        } else if (this.isBannedIP(inetAddress.getAddress())) {
            if (LOG.isWarnEnabled()) {
                LOG.warn((Object)("Ignoring banned host: " + inetAddress));
            }
            HTTPStat.BANNED_REQUESTS.incrementStat();
            IOUtils.close(socket);
        } else {
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("Dispatching new client connecton: " + inetAddress));
            }
            if (!ConnectionSettings.UNSET_FIREWALLED_FROM_CONNECTBACK.getValue()) {
                this.checkFirewall(socket.getInetAddress());
            }
            InetAddress inetAddress2 = socket.getLocalAddress();
            this.setAddress(inetAddress2);
            try {
                this._socket.setSoTimeout(8000);
            }
            catch (SocketException socketException) {
                IOUtils.close(this._socket);
                return;
            }
            if (socket instanceof NIOMultiplexor) {
                ((NIOMultiplexor)((Object)socket)).setReadObserver(new AsyncConnectionDispatcher(socket, string));
            } else {
                ThreadFactory.startThread(new BlockingConnectionDispatcher(socket, string), "ConnectionDispatchRunner");
            }
        }
    }

    private boolean isOutsideConnection(InetAddress inetAddress) {
        if (!ConnectionSettings.LOCAL_IS_PRIVATE.getValue()) {
            return true;
        }
        return !RouterService.isConnectedTo(inetAddress) && !NetworkUtils.isLocalAddress(inetAddress);
    }

    public boolean isBannedIP(byte[] byArray) {
        return !IPFilter.instance().allow(byArray);
    }

    void resetLastConnectBackTime() {
        this._lastConnectBackTime = System.currentTimeMillis() - INCOMING_EXPIRE_TIME - 1L;
    }

    public void shutdown() {
        if (UPNP_MANAGER != null && UPNP_MANAGER.isNATPresent() && UPNP_MANAGER.mappingsExist() && ConnectionSettings.UPNP_IN_USE.getValue()) {
            ConnectionSettings.FORCE_IP_ADDRESS.revertToDefault();
            ConnectionSettings.FORCED_PORT.revertToDefault();
            ConnectionSettings.UPNP_IN_USE.revertToDefault();
        }
    }

    static /* synthetic */ boolean access$5(Acceptor acceptor, boolean bl) {
        return acceptor.setIncoming(bl);
    }

    private class SocketListener
    implements AcceptObserver {
        SocketListener() {
        }

        public void handleIOException(IOException iOException) {
            LOG.warn((Object)"IOX while accepting", (Throwable)iOException);
        }

        public void shutdown() {
            LOG.debug((Object)"shutdown one SocketListener");
        }

        public void handleAccept(Socket socket) {
            Acceptor.this.accept(socket);
        }
    }

    private class IncomingValidator
    implements Runnable {
        static /* synthetic */ Class class$0;

        public void run() {
            long l = System.currentTimeMillis();
            ConnectionManager connectionManager = RouterService.getConnectionManager();
            if ((Acceptor.this._acceptedIncoming && l - Acceptor.this._lastIncomingTime > INCOMING_EXPIRE_TIME || !Acceptor.this._acceptedIncoming && l - Acceptor.this._lastConnectBackTime > INCOMING_EXPIRE_TIME) && connectionManager.sendTCPConnectBackRequests()) {
                Acceptor.this._lastConnectBackTime = System.currentTimeMillis();
                Runnable runnable = new Runnable(this, l){
                    final /* synthetic */ IncomingValidator this$1;
                    private final /* synthetic */ long val$currTime;
                    {
                        this.this$1 = incomingValidator;
                        this.val$currTime = l;
                    }

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    public void run() {
                        boolean bl = false;
                        Class<?> clazz = IncomingValidator.class$0;
                        if (clazz == null) {
                            try {
                                clazz = IncomingValidator.class$0 = Class.forName("com.limegroup.gnutella.Acceptor");
                            }
                            catch (ClassNotFoundException classNotFoundException) {
                                throw new NoClassDefFoundError(classNotFoundException.getMessage());
                            }
                        }
                        Class<?> clazz2 = clazz;
                        synchronized (clazz) {
                            if (Acceptor.access$2(IncomingValidator.access$0(this.this$1)) < this.val$currTime) {
                                bl = Acceptor.access$5(IncomingValidator.access$0(this.this$1), false);
                            }
                            // ** MonitorExit[var2_2] (shouldn't be in output)
                            if (bl) {
                                RouterService.incomingStatusChanged();
                            }
                            return;
                        }
                    }
                };
                RouterService.schedule(runnable, WAIT_TIME_AFTER_REQUESTS, 0L);
            }
        }

        static /* synthetic */ Acceptor access$0(IncomingValidator incomingValidator) {
            return incomingValidator.Acceptor.this;
        }
    }

    private static class AsyncConnectionDispatcher
    extends AbstractChannelInterestRead {
        private final Socket client;
        private final String allowedWord;

        AsyncConnectionDispatcher(Socket socket, String string) {
            this.client = socket;
            this.allowedWord = string;
        }

        protected int getBufferSize() {
            return RouterService.getConnectionDispatcher().getMaximumWordSize() + 1;
        }

        public void shutdown() {
            super.shutdown();
            HTTPStat.CLOSED_REQUESTS.incrementStat();
        }

        public void handleRead() throws IOException {
            int n = 0;
            while (this.buffer.hasRemaining() && (n = this.source.read(this.buffer)) > 0) {
            }
            int n2 = 0;
            while (n2 < this.buffer.position()) {
                if (this.buffer.get(n2) == 32) {
                    String string = new String(this.buffer.array(), 0, n2);
                    if (this.allowedWord != null && !this.allowedWord.equals(string)) {
                        throw new IOException("wrong word!");
                    }
                    this.buffer.limit(this.buffer.position()).position(n2 + 1);
                    this.source.interest(false);
                    RouterService.getConnectionDispatcher().dispatch(string, this.client, true);
                    return;
                }
                ++n2;
            }
            if (!this.buffer.hasRemaining() || n == -1) {
                this.close();
            }
        }

        public int read(ByteBuffer byteBuffer) {
            return BufferUtils.transfer(this.buffer, byteBuffer, false);
        }
    }

    private static class BlockingConnectionDispatcher
    implements Runnable {
        private final Socket client;
        private final String allowedWord;

        public BlockingConnectionDispatcher(Socket socket, String string) {
            this.client = socket;
            this.allowedWord = string;
        }

        public void run() {
            try {
                InputStream inputStream = null;
                try {
                    inputStream = this.client.getInputStream();
                }
                catch (IOException iOException) {
                    HTTPStat.CLOSED_REQUESTS.incrementStat();
                    throw iOException;
                }
                catch (NullPointerException nullPointerException) {
                    throw new IOException(nullPointerException.getMessage());
                }
                ConnectionDispatcher connectionDispatcher = RouterService.getConnectionDispatcher();
                String string = IOUtils.readLargestWord(inputStream, connectionDispatcher.getMaximumWordSize());
                if (this.allowedWord != null && !this.allowedWord.equals(string)) {
                    throw new IOException("wrong word!");
                }
                connectionDispatcher.dispatch(string, this.client, false);
            }
            catch (IOException iOException) {
                HTTPStat.CLOSED_REQUESTS.incrementStat();
                IOUtils.close(this.client);
            }
        }
    }
}

