package com.limegroup.gnutella.gui.download;

import java.awt.event.ActionListener;

import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;

import com.limegroup.gnutella.gui.BoxPanel;
import com.limegroup.gnutella.gui.ButtonRow;
import com.limegroup.gnutella.gui.GUIMediator;

/**
 * This class contains the buttons in the download window, allowing
 * classes in this package to enable or disable buttons at specific
 * indeces in the row.
 */
final class DownloadButtons {
    
    /**
     * The JPanel of the queued up/down buttons.
     */
    private JPanel QUEUE_PANEL;


	/**
	 * The row of buttons for the donwload window.
	 */
	private ButtonRow BUTTONS;
	
	/**
	 * The index of the up button.
	 */
	static final int UP_BUTTON = 0;
	
	/**
	 * The index of the down button.
	 */
	static final int DOWN_BUTTON = 1;

	/**
	 * The index of the kill button in the button row.
	 */
	static final int KILL_BUTTON   = 2;

	/**
	 * The index of the resume button in the button row.
	 */
	static final int RESUME_BUTTON = 3;
	
	/**
	 * The index of the pause button in the button row.
	 */
	static final int PAUSE_BUTTON = 4;

	/**
	 * The index of the launch button in the button row.
	 */
	static final int LAUNCH_BUTTON = 5;

	/**
	 * The index of the clear button in the button row.
	 */
	static final int CLEAR_BUTTON  = 6;
	
    /**
     * The string for the resume button label...
     */
    private static final String RESUME_BUTTON_LABEL =
        GUIMediator.getStringResource("DOWNLOAD_RESUME_BUTTON_LABEL");

    /**
     * The string for the resume button tip...
     */
    private static final String RESUME_BUTTON_TIP =
        GUIMediator.getStringResource("DOWNLOAD_RESUME_BUTTON_TIP");
	

    /**
     * The string for the sources button label...
     */
    private static final String SOURCES_BUTTON_LABEL =
        GUIMediator.getStringResource("DOWNLOAD_SOURCES_BUTTON_LABEL");

    /**
     * The string for the sources button tip...
     */
    private static final String SOURCES_BUTTON_TIP =
        GUIMediator.getStringResource("DOWNLOAD_SOURCES_BUTTON_TIP");

	/**
	 * The constructor creates the row of buttons with their associated
	 * listeners.
	 */
	DownloadButtons(final DownloadMediator dm) {
        String[] buttonLabelKeys = {
			"",
            "",
			"DOWNLOAD_KILL_BUTTON_LABEL",
			"DOWNLOAD_RESUME_BUTTON_LABEL",
			"DOWNLOAD_PAUSE_BUTTON_LABEL",
			"DOWNLOAD_LAUNCH_BUTTON_LABEL",
			"DOWNLOAD_CLEAR_BUTTON_LABEL",
		};
        String[] buttonTipKeys = {
			"DOWNLOAD_PRIORITY_UP_BUTTON_TIP",
			"DOWNLOAD_PRIORITY_DOWN_BUTTON_TIP",
			"DOWNLOAD_KILL_BUTTON_TIP",
			"DOWNLOAD_RESUME_BUTTON_TIP",
			"DOWNLOAD_PAUSE_BUTTON_TIP",
			"DOWNLOAD_LAUNCH_BUTTON_TIP",
			"DOWNLOAD_CLEAR_BUTTON_TIP",
		};

		ActionListener[] buttonListeners = {
			dm.PRIORITY_UP_LISTENER,
			dm.PRIORITY_DOWN_LISTENER,
			dm.REMOVE_LISTENER,
			dm.RESUME_LISTENER,
			dm.PAUSE_LISTENER,
			dm.LAUNCH_LISTENER,
			dm.CLEAR_LISTENER,
		};
		
		String[] iconNames =  {
		    "DOWNLOAD_PRIORITY_UP",
		    "DOWNLOAD_PRIORITY_DOWN",
		    "DOWNLOAD_KILL",
		    "DOWNLOAD_FILE_MORE_SOURCES",
		    "DOWNLOAD_PAUSE",
		    "DOWNLOAD_LAUNCH",
		    "DOWNLOAD_CLEAR",
		};		

		BUTTONS = new ButtonRow(buttonLabelKeys,buttonTipKeys,buttonListeners,
		                        iconNames, ButtonRow.X_AXIS, ButtonRow.NO_GLUE);
		                        
        JButton up = BUTTONS.getButtonAtIndex(UP_BUTTON);
        JButton down = BUTTONS.getButtonAtIndex(DOWN_BUTTON);
        BUTTONS.remove(up); BUTTONS.remove(down);
        JPanel panel = new BoxPanel(BoxPanel.X_AXIS);
        panel.add(up);
        panel.add(new JLabel(GUIMediator.getStringResource("DOWNLOAD_PRIORITY_PRIORITIZE")));
        panel.add(down);
        BUTTONS.add(panel, 0);
        QUEUE_PANEL = panel;
	}
	
	ButtonRow getComponent() { return BUTTONS; }


    /**
     * Sets the mutable 'resume' button to the resume button.
     */
    void transformSourcesButton() {
        BUTTONS.transformButton(RESUME_BUTTON, RESUME_BUTTON_LABEL,
                                RESUME_BUTTON_TIP);
    }

    /**
     * Sets the mutable 'resume' button to the sources button.
     */
    void transformResumeButton() {
        BUTTONS.transformButton(RESUME_BUTTON, SOURCES_BUTTON_LABEL,
                                SOURCES_BUTTON_TIP);
    }
    
    /**
     * Sets the queue panel either visible or invisible.
     */
    void setQueuePanelVisible(boolean visible) {
        QUEUE_PANEL.setVisible(visible);
    }
}
