package com.limegroup.gnutella.gui;

import java.awt.Dimension;

import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.SwingConstants;

import com.limegroup.gnutella.settings.UISettings;

/**
 * A JButton that uses an Icon.
 */
public class IconButton extends JButton {
    
    private String message;
    private String iconName;
    private boolean initialized;
    
    /**
     * Constructs a new IconButton with the given text & icon name.
     */
    public IconButton(String text, String iconName) {
        setRolloverEnabled(true);        
        this.iconName = iconName;
        this.message = text;
        initialized = true;
        updateButton();
    }
    
    /**
     * Updates the UI, possibly changing the icons or text.
     */
    public void updateUI() {
        super.updateUI();
        updateButton();
    }
    
    /**
     * Updates the text of the icon.
     */
    public void setText(String text) {
        message = text;
        updateButton();
    }
    
    /**
     * Updates the button.
     */
    private void updateButton() {
        if(!initialized) return;
        
        Icon icon = IconManager.instance().getIconForButton(iconName);
        if(icon == null) {
            super.setText(message);
            setVerticalTextPosition(SwingConstants.CENTER);
            setHorizontalTextPosition(SwingConstants.CENTER);
            setContentAreaFilled(true);
            setBorderPainted(true);
            setOpaque(true);
        } else {
            super.setIcon(icon);
            Icon rollover =
                IconManager.instance().getRolloverIconForButton(iconName);
            super.setRolloverIcon(rollover);
            if(UISettings.TEXT_WITH_ICONS.getValue() &&
               message != null && !message.equals("")) {
                super.setText(message);
                setPreferredSize(null);
            } else {
                super.setText(null);
                int height = icon.getIconHeight() + 15;
                int width = icon.getIconWidth() + 15;
                if(message != null && message.equals("")) {
                    height = icon.getIconHeight();
                    width = icon.getIconWidth();
                }
                setPreferredSize(new Dimension(height, width));
            }
            setVerticalTextPosition(SwingConstants.BOTTOM);
            setHorizontalTextPosition(SwingConstants.CENTER);
            setContentAreaFilled(false);
            setBorderPainted(false);
            setOpaque(false);
        }
    }
}