package com.limegroup.gnutella.gui;

import java.awt.Color;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.IOException;
import java.net.URL;

import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JCheckBox;
import javax.swing.JDialog;
import javax.swing.JPanel;
import javax.swing.Timer;
import javax.swing.border.Border;
import javax.swing.event.HyperlinkEvent;
import javax.swing.event.HyperlinkListener;

import com.limegroup.gnutella.util.CommonUtils;

/**
 * Contains the <tt>JDialog</tt> instance that shows "about" information
 * for the application.
 */
//2345678|012345678|012345678|012345678|012345678|012345678|012345678|012345678|
final class AboutWindow {
	/**
	 * Constant handle to the <tt>JDialog</tt> that contains about
	 * information.
	 */
	private final JDialog DIALOG = new JDialog();

	/**
	 * Constant dimension for the dialog.
	 */
	private final Dimension DIALOG_DIMENSION = new Dimension(450, 400);

	/**
	 * Constant for the scolling pane of credits.
	 */
	private final ScrollingTextPane SCROLLING_PANE;

	/**
	 * Check box to specify whether to scroll or not.
	 */
	private final JCheckBox SCROLL_CHECK_BOX = 
		new JCheckBox(GUIMediator.getStringResource(
            "ABOUT_SCROLL_CHECK_BOX_LABEL"));

	/**
	 * Constructs the elements of the about window.
	 */
	AboutWindow() {
        if (!(CommonUtils.isMacOSX() && CommonUtils.isJava14OrLater()))
            DIALOG.setModal(true);
		DIALOG.setResizable(false);
		DIALOG.setTitle(GUIMediator.getStringResource("ABOUT_TITLE"));
		
		String aboutName = "about_" +
		     ResourceManager.getLocale().toString() + ".html";
        URL aboutUrl = GUIMediator.getURLResource(aboutName);
        // if nothing by that name, default to the english file.
        if(aboutUrl == null)
            aboutUrl = GUIMediator.getURLResource("about.html");            
        SCROLLING_PANE = new ScrollingTextPane(aboutUrl);
		SCROLLING_PANE.addHyperlinkListener(GUIUtils.getHyperlinkListener());

		SCROLL_CHECK_BOX.setSelected(true);
		SCROLL_CHECK_BOX.addActionListener(new ActionListener() {
			public void actionPerformed(ActionEvent ae) {
				if(SCROLL_CHECK_BOX.isSelected()) {
					SCROLLING_PANE.startScroll();
				} else {
					SCROLLING_PANE.stopScroll();
                }
			}
		});
		BoxPanel topPanel = new BoxPanel(BoxPanel.Y_AXIS);
		// set the main panel's border
		Border border = BorderFactory.createEmptyBorder(6,6,6,6);
		topPanel.setBorder(border);
		topPanel.add(GUIMediator.getVerticalSeparator());
		LogoPanel logo = new LogoPanel();
		logo.setSearching(true);
		topPanel.add(logo);
		topPanel.add(Box.createVerticalStrut(17));
		String labelStart =
		    GUIMediator.getStringResource("ABOUT_LABEL_START");
		String version = CommonUtils.getLimeWireVersion();
		String labelAddress =
		    GUIMediator.getStringResource("ABOUT_LABEL_ADDRESS");
		String[] strs = {labelStart+" "+version, labelAddress};
		MultiLineLabel label =
		    new MultiLineLabel(strs);
		label.setFont(new Font("Sans Serif", Font.PLAIN, 11));
		label.setForeground(Color.black);
		Dimension dim = new Dimension(DIALOG_DIMENSION.width-12, 40);
		label.setPreferredSize(dim);
		label.setMaximumSize(dim);
		BoxPanel labelPanel = new BoxPanel(BoxPanel.X_AXIS);
		labelPanel.add(Box.createRigidArea(
		    new Dimension((DIALOG_DIMENSION.width/2)-
						  ((label.getFontMetrics(label.getFont()).
						  stringWidth(labelAddress))/2), 0)));
		labelPanel.add(label);

		topPanel.add(labelPanel);
		topPanel.add(SCROLLING_PANE);		
		DIALOG.setSize(DIALOG_DIMENSION);
		GUIUtils.addHideAction((JComponent)DIALOG.getContentPane());
		
		DIALOG.addWindowListener(new WindowAdapter() {
		    public void windowClosed(WindowEvent we) {
		        SCROLLING_PANE.stopScroll();
		    }
		    public void windowClosing(WindowEvent we) {
		        SCROLLING_PANE.stopScroll();
		    }
		});

		JButton button = new JButton(GUIMediator.getStringResource("ABOUT_BUTTON_LABEL"));
		button.setToolTipText(GUIMediator.getStringResource("ABOUT_BUTTON_TIP"));
		button.addActionListener(GUIUtils.getDisposeAction());
		JPanel buttonPanel = new BoxPanel(BoxPanel.X_AXIS);
		buttonPanel.add(Box.createHorizontalGlue());
		buttonPanel.add(SCROLL_CHECK_BOX);
		buttonPanel.add(GUIMediator.getHorizontalSeparator());
		buttonPanel.add(button);
		buttonPanel.add(Box.createHorizontalGlue());
        final Container CONTENT_PANE = DIALOG.getContentPane();
        CONTENT_PANE.setLayout(new BoxLayout(CONTENT_PANE, BoxLayout.Y_AXIS));
        CONTENT_PANE.add(topPanel);
        CONTENT_PANE.add(GUIMediator.getVerticalSeparator());
        CONTENT_PANE.add(buttonPanel);
        CONTENT_PANE.add(Box.createVerticalStrut(6));
	}

	/**
	 * Displays the "About" dialog window to the user.
	 */
	void showDialog() {
		if(GUIMediator.isAppVisible())
			DIALOG.setLocationRelativeTo(GUIMediator.getAppFrame());
		else {
			DIALOG.setLocation(GUIMediator.getScreenCenterPoint(DIALOG));
		}

		if(SCROLL_CHECK_BOX.isSelected()) {
			ActionListener startTimerListener = new ActionListener() {
				public void actionPerformed(ActionEvent ae) {
				    //need to check isSelected() again,
				    //it might have changed in the past 10 seconds.
				    if(SCROLL_CHECK_BOX.isSelected()) {
				        //activate scroll timer
					    SCROLLING_PANE.startScroll();
					}
				}
			};
			
			Timer startTimer = new Timer(10000, startTimerListener);
			startTimer.setRepeats(false);			
			startTimer.start();
		}
		DIALOG.setVisible(true);
	}

	/*
	public static void main(String[] args) {
	    AboutWindow aw = new AboutWindow();
	    aw.showDialog();
	}
	*/
}
