/*
 * Copyright (c) 2002-2004 David Keiichi Watanabe
 * davew@xlife.org
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 */

package com.acquisitionx;

import com.limegroup.gnutella.*;
import com.limegroup.gnutella.downloader.ManagedDownloader;
import com.limegroup.gnutella.search.HostData;
import com.limegroup.gnutella.xml.LimeXMLDocument;
import java.io.*;
import java.util.*;


public class AqEvent 
{
/* State */

    public static boolean shouldSignalEvents = true;
    public static final String kSep = "<aq/>";
    public static OutputStreamWriter writer = null;
    public static Map downloadStateCache = new HashMap();


/* Event Codes */

    public static final int kLWEventConnectionInitialized 	= 1;
    public static final int kLWEventConnectionClosed      	= 2;
    public static final int kLWEventUpdateConnectionStats 	= 3;
    public static final int kLWEventConnectionsUpdated    	= 14;

    public static final int kLWEventQueryResult            	= 5;

    public static final int kLWEventAddUpload             	= 6;
    public static final int kLWEventRemoveUpload          	= 7;
    public static final int kLWEventUpdateUploadStats     	= 8;
    public static final int kLWEventUploadsUpdated        	= 12;

    public static final int kLWEventAddDownload           	= 9;
    public static final int kLWEventRemoveDownload        	= 10;
    public static final int kLWEventUpdateDownloadStats   	= 11;
    public static final int kLWEventDownloadsUpdated      	= 13;

    public static final int kShutdownSettingsHandler		= 90;
    public static final int kShutdownTigerTree                  = 91;
    public static final int kShutdownCreationTime		= 92;
    public static final int kShutdownURNCache                   = 93;
    public static final int kShutdownDownloadsCache		= 94;
    public static final int kShutdownDownloadsFile		= 95;
    public static final int kShutdownCleanDirectory		= 96;


/* Util */

    public static String replaceStringWithString(String string, String target, String replacement) {
        int position;
        while (-1 < (position = string.indexOf(target))) {
            string = string.substring(0, position) + replacement + string.substring(position + target.length());
        }
        return string;
    }

    public static String correctedString(String string) {
        if (string == null) return null;
        
        //System.err.println("correctedString A: " + string);
        
        string = AqEvent.replaceStringWithString(string, "&apos;", "'");
        string = AqEvent.replaceStringWithString(string, "apos;", "'");
        string = AqEvent.replaceStringWithString(string, "&amp;", "");
        string = AqEvent.replaceStringWithString(string, "amp;", "");

        //System.err.println("correctedString B: " + string);
        return string;
    }


/* Signal */

    public static void signalEvent(int type) {
        signalEvent(type, null, null, null);
    }

    public static void signalEvent(int type, Object obj) {
        signalEvent(type, obj, null, null);
    }

    public static void signalEvent(int type, Object obj, Object obj1) {
        signalEvent(type, obj, obj1, null);
    }

    public static void signalEvent(int type, Object obj, Object obj2, Object obj3)
    {
        if ((!shouldSignalEvents && type < 90) || (shouldSignalEvents && type >= 90)) return;
        String event = null;
        if (writer == null) {
            try {
                writer = new OutputStreamWriter(System.out, "UTF-8");
            } catch (Exception e) {
                System.err.println(e);
            }
        }
        
        switch(type)
        {

        /* Connections */
        
            case kLWEventConnectionInitialized:
            {
                ManagedConnection c = (ManagedConnection)obj;
                String ua = c.getUserAgent();

                String connectionType;
                if (c.isClientSupernodeConnection() || c.isSupernodeConnection()) connectionType = "Ultrapeer";
                else if (c.isSupernodeClientConnection()) connectionType = "Leaf";
                else connectionType = "Peer";
                
                if (ua == null) ua = "";
                
                event = (
                    type 
                    + kSep + c.getAddress()
                    + kSep + c.getPort()
                    + kSep + ua
                    + kSep + connectionType
                );
                break;
            }
            
            case kLWEventConnectionClosed:
            {
                ManagedConnection c = (ManagedConnection)obj;
                event = (
                    type 
                    + kSep + c.getAddress()
                    + kSep + c.getPort()
                );
                break;
            }
            
            case kLWEventUpdateConnectionStats:
            {
                ManagedConnection c = (ManagedConnection)obj;

                ConnectionManager cm = RouterService.getConnectionManager();
                int total = cm.getNumInitializedConnections() + cm.getNumInitializedClientConnections();
                int negotiating = cm.getNumConnections() - total;
                if (negotiating < 0) negotiating = 0;

                event = (
                    type
                    + kSep + c.getAddress()
                    + kSep + c.getPort()
                    + kSep + c.getNumFiles()
                    + kSep + negotiating
                );
                break;
            }

        /* Queries */
        
            case kLWEventQueryResult:
            {
                RemoteFileDesc r = (RemoteFileDesc)obj;
                HostData hd = (HostData)obj2;
                Set locs = (Set)obj3;
                
                /* quality ranges from -1 to 3, where -1 is unreachable (both firewalled) */

                int quality = hd.getQuality();
                if (quality < 0) quality = 0;
                if (quality == 3 && hd.getSpeed() > 2000 && hd.isMeasuredSpeed()) quality = 4;
                    
                /* index */

                int queryIndex = AqEventHandler.queries.indexOf(new GUID(hd.getMessageGUID()).toString());

                /* note RFD */
                    
                AqEventHandler.responses.add(r);
                AqEventHandler.alts.add(locs);
                AqEventHandler.queryGUIDs.add(new GUID(hd.getMessageGUID()));
                int localIndex = AqEventHandler.responses.size() - 1;
                
                /* bitrate & xml metadata */

                int bitrate = 0;
                String artist = null;
                String album = null;
                String year = null;
                String title = null;
                    
                LimeXMLDocument xml = r.getXMLDoc();
                if (xml != null) {
                    String value = xml.getValue("audios__audio__bitrate__");
                    if (value != null) {
                        try {
                            bitrate = new Integer(value).intValue();
                        } catch (Exception e) {
                            bitrate = 0;
                        }
                    }

                    artist = correctedString(xml.getValue("audios__audio__artist__"));
                    album  = correctedString(xml.getValue("audios__audio__album__"));
                    year   = xml.getValue("audios__audio__year__");
                    title  = correctedString(xml.getValue("audios__audio__title__"));
                }
                    
                if (bitrate > 1000) bitrate = 0;
                if (artist == null) artist = "";
                if (album == null) album = "";
                if (year == null) year = "";
                if (title == null) title = "";
                    
                /* browse host */
                
                GUID cguid = new GUID(hd.getClientGUID());
                int bh = hd.isBrowseHostEnabled() ? 1 : 0;
                    
                if (!AqEventHandler.hosts.containsKey(hd.getIP() + hd.getPort())) {
                    AqEventHandler.hosts.put(hd.getIP() + hd.getPort(), cguid);
                }
                
                /* sha1 */
                    
                String sha1 = "";
                
                if (r.getSHA1Urn() != null) {
                    sha1 = r.getSHA1Urn().toString();
                }

                event = (
                    type
                    + kSep + queryIndex
                    + kSep + hd.getIP()
                    + kSep + hd.getPort()
                    + kSep + ""
                    + kSep + quality
                    + kSep + hd.getSpeed()
                    + kSep + r.getIndex()
                    + kSep + r.getSize()
                    + kSep + r.getFileName()
                    + kSep + sha1
                    + kSep + bitrate
                    + kSep + localIndex
                    + kSep + bh
                    + kSep + artist
                    + kSep + album
                    + kSep + year
                    + kSep + title
                    + kSep + locs.size()
                );
                break;
            }
            
        /* Uploads */
        
            case kLWEventAddUpload:
            {
                Uploader u = (Uploader)obj;
                String ua = u.getUserAgent();
                String p = "";
                int bh = u.isBrowseHostEnabled() ? 1 : 0;
 
                if (u.getFileDesc() != null) {
                    p = u.getFileDesc().getPath();
                }
                
                if (ua == null) ua = "";
                
                event = (
                    type
                    + kSep + u.getHost()
                    + kSep + u.getIndex()
                    + kSep + u.getFileName()
                    + kSep + ua
                    + kSep + u.getState()
                    + kSep + u.getAmountRequested()
                    + kSep + p
                    + kSep + bh
                    + kSep + u.getGnutellaPort()
                );

                break;
            }

            case kLWEventRemoveUpload:
            {
                Uploader u = (Uploader)obj;
                event = (
                    type
                    + kSep + u.getHost()
                    + kSep + u.getIndex()
                    + kSep + u.getFileName()
                    + kSep + u.getState()
                );
                break;
            }

            case kLWEventUpdateUploadStats:
            {
                Uploader u = (Uploader)obj;
                
                float b  = 0;
                float b1 = 0;

                try {
                    b = u.getMeasuredBandwidth() * 1024;
                    b1 = u.getAverageBandwidth() * 1024;
                } catch (Exception e) {
                }
                
                event = (
                    type
                    + kSep + u.getHost()
                    + kSep + u.getIndex()
                    + kSep + u.getFileName()
                    + kSep + u.getState()
                    + kSep + u.getFileSize()
                    + kSep + u.getTotalAmountUploaded()
                    + kSep + b
                    + kSep + b1
                );
                break;
            }
            
        /* Downloads */
        
            case kLWEventAddDownload:
            {
                ManagedDownloader d = (ManagedDownloader)obj;
				String index = (String)AqEventHandler.downloadsToIndices.get(d);
				if(index == null)
					index = "";
                event = (
                    type
                    + kSep + index
                    + kSep + d.getFileName()
                    + kSep + d.getState()
                    + kSep + d.getContentLength()
                    + kSep + d.getAmountReadDW()
                    + kSep + d.downloadSHA1()
                );
                break;
            }
            
            case kLWEventRemoveDownload:
            {
                ManagedDownloader d = (ManagedDownloader)obj;
				String index = (String)AqEventHandler.downloadsToIndices.get(d);
				if(index == null)
					index = "";
                event = (
                    type
                    + kSep + index
                );
				downloadStateCache.remove(d);
                break;
            }

            case kLWEventUpdateDownloadStats:
            {
                ManagedDownloader d = (ManagedDownloader)obj;
				String index = (String)AqEventHandler.downloadsToIndices.get(d);
				if(index == null)
					index = "";

                String p = "";
                if (d.getDownloadFragment() != null) {
                    p = d.getDownloadFragment().getAbsolutePath();
                }

                float b  = 0;
                float b1 = 0;

                try {
                    b = d.getMeasuredBandwidth() * 1024;
                    b1 = d.getAverageBandwidth() * 1024;
                } catch (Exception e) {
                }
                
                /* amount read / wanted */
                int l = d.getContentLength();
                if (l < 0) l = 1;
                int r;
                if (d.getState() != Downloader.HASHING && d.getState() != Downloader.SAVING) {
                    r = d.getAmountReadDW();
                } else {
                    r = l;
                }
                
                /* hosts */
                
                String hosts = "";
                for(Iterator i = d.getHosts(); i.hasNext();) {
                    Endpoint e = (Endpoint)i.next();
                    hosts = hosts + e.getAddress() + ":" + e.getPort() + ",";
                }
                
                event = (
                    type
                    + kSep + index
                    + kSep + d.getState()
                    + kSep + l
                    + kSep + r
                    + kSep + b
                    + kSep + b1
                    + kSep + d.numberOfDownloaders()
                    + kSep + d.getBusyHostCount()
                    + kSep + d.numberOfFiles()
                    + kSep + d.getQueuedHostCount()
                    + kSep + p
                    + kSep + d.amountForPreview()
                    + kSep + hosts
                );
                
				String lastWrittenString = (String)downloadStateCache.get(d);
				if(lastWrittenString != null && lastWrittenString.equals(event))
					event = null;
				else
					downloadStateCache.put(d, event);
                break;
            }

        /* Default */
            
            default:
            {
                String s1, s2, s3;
                s1 = (obj != null) ? (kSep + obj) : "";
                s2 = (obj2 != null) ? (kSep + obj2) : "";
                s3 = (obj3 != null) ? (kSep + obj3) : "";
                event = (
                    type + s1 + s2 + s3
                );
                break;
            }
        }
        
        if (event != null) {
            boolean wasWritten = false;
            if (writer != null) {
                synchronized (System.out) {
                    try {
                        writer.write(event);
                        writer.write("\n");
                        writer.flush();
                        wasWritten = true;
                    } catch (Exception e) {
                        System.err.println(e);
                        wasWritten = false;
                    }
                }
            } 
            if (!wasWritten) {
                synchronized (System.out) {
                    System.out.println(event);
                }
            }
        }
    }
}