/*
 * Decompiled with CFR 0.152.
 */
package org.logi.crypto.io;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.logi.crypto.Crypto;
import org.logi.crypto.io.CipherStream;
import org.logi.crypto.io.DecryptStream;
import org.logi.crypto.io.EncryptStream;
import org.logi.crypto.keys.CipherKey;
import org.logi.crypto.modes.DecryptMode;
import org.logi.crypto.modes.EncryptMode;
import org.logi.crypto.protocols.CryptoProtocolException;
import org.logi.crypto.protocols.InterKeyExServer;
import org.logi.crypto.protocols.InterProtocolServer;

public class CipherStreamServer
extends CipherStream {
    public void execute(InterProtocolServer interProtocolServer) throws IOException, CryptoProtocolException {
        InputStream inputStream = this.cIn == null ? this.in : this.cIn;
        OutputStream outputStream = this.cOut == null ? this.out : this.cOut;
        byte[] byArray = null;
        do {
            int n;
            if ((n = Crypto.readInt(inputStream)) < 0 || n > interProtocolServer.maxMessageSize()) {
                throw new CryptoProtocolException(n + " is not a valid message size for this protocol.");
            }
            if (byArray == null || byArray.length != n) {
                byArray = new byte[n];
            }
            if ((n = inputStream.read(byArray)) < 0) {
                throw new CryptoProtocolException("Client broke connection");
            }
            if ((byArray = interProtocolServer.message(byArray)) == null) break;
            Crypto.writeInt(outputStream, byArray.length);
            outputStream.write(byArray);
            outputStream.flush();
        } while (!interProtocolServer.completed());
    }

    public CipherStreamServer(InputStream inputStream, OutputStream outputStream, InterKeyExServer interKeyExServer, EncryptMode encryptMode, DecryptMode decryptMode) throws CryptoProtocolException, IOException {
        this.in = inputStream;
        this.out = outputStream;
        if (interKeyExServer != null) {
            CipherKey cipherKey;
            this.execute(interKeyExServer);
            try {
                cipherKey = (CipherKey)interKeyExServer.sessionKey();
            }
            catch (ClassCastException classCastException) {
                throw new CryptoProtocolException("The exchanged Key was not a CipherKey.");
            }
            encryptMode.setKey(cipherKey);
            decryptMode.setKey(cipherKey);
        }
        this.cOut = new EncryptStream(outputStream, null, encryptMode);
        this.cIn = new DecryptStream(inputStream, null, decryptMode);
        this.encrypt = encryptMode;
        this.decrypt = decryptMode;
    }
}

