/*
 * Decompiled with CFR 0.152.
 */
package org.logi.crypto.io;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.logi.crypto.Crypto;
import org.logi.crypto.io.CipherStream;
import org.logi.crypto.io.DecryptStream;
import org.logi.crypto.io.EncryptStream;
import org.logi.crypto.keys.CipherKey;
import org.logi.crypto.modes.DecryptMode;
import org.logi.crypto.modes.EncryptMode;
import org.logi.crypto.protocols.CryptoProtocolException;
import org.logi.crypto.protocols.InterKeyExClient;
import org.logi.crypto.protocols.InterProtocolClient;

public class CipherStreamClient
extends CipherStream {
    public void execute(InterProtocolClient interProtocolClient) throws IOException, CryptoProtocolException {
        InputStream inputStream = this.cIn == null ? this.in : this.cIn;
        OutputStream outputStream = this.cOut == null ? this.out : this.cOut;
        byte[] byArray = interProtocolClient.message(null);
        while (byArray != null) {
            Crypto.writeInt(outputStream, byArray.length);
            outputStream.write(byArray);
            outputStream.flush();
            if (interProtocolClient.completed()) break;
            int n = Crypto.readInt(inputStream);
            if (n < 0 || n > interProtocolClient.maxMessageSize()) {
                throw new CryptoProtocolException(n + " is not a valid message size for this protocol.");
            }
            if (byArray.length != n) {
                byArray = new byte[n];
            }
            if ((n = inputStream.read(byArray)) < 0) {
                throw new CryptoProtocolException("Server broke connection");
            }
            byArray = interProtocolClient.message(byArray);
        }
    }

    public CipherStreamClient(InputStream inputStream, OutputStream outputStream, InterKeyExClient interKeyExClient, EncryptMode encryptMode, DecryptMode decryptMode) throws CryptoProtocolException, IOException {
        this.in = inputStream;
        this.out = outputStream;
        if (interKeyExClient != null) {
            CipherKey cipherKey;
            this.execute(interKeyExClient);
            try {
                cipherKey = (CipherKey)interKeyExClient.sessionKey();
            }
            catch (ClassCastException classCastException) {
                throw new CryptoProtocolException("The exchanged Key was not a CipherKey.");
            }
            encryptMode.setKey(cipherKey);
            decryptMode.setKey(cipherKey);
        }
        this.cOut = new EncryptStream(outputStream, null, encryptMode);
        this.cIn = new DecryptStream(inputStream, null, decryptMode);
        this.encrypt = encryptMode;
        this.decrypt = decryptMode;
    }
}

