/*
 * Copyright (c) 2006 - 2006, the original author or authors. All rights
 * reserved. Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are met: *
 * Redistributions of source code must retain the above copyright notice, this
 * list of conditions and the following disclaimer. * Redistributions in binary
 * form must reproduce the above copyright notice, this list of conditions and
 * the following disclaimer in the documentation and/or other materials provided
 * with the distribution. * Neither the name of the University of California,
 * Berkeley nor the names of its contributors may be used to endorse or promote
 * products derived from this software without specific prior written
 * permission. THIS SOFTWARE IS PROVIDED BY THE REGENTS AND CONTRIBUTORS ``AS
 * IS'' AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO,
 * THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR
 * PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE REGENTS AND CONTRIBUTORS BE
 * LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR
 * CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF
 * SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
 * INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN
 * CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
 * ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE
 * POSSIBILITY OF SUCH DAMAGE.
 */

package jp.sf.bli.framework.validate;

import java.io.UnsupportedEncodingException;
import java.util.Iterator;
import java.util.List;
import java.util.ResourceBundle;

import jp.sf.bli.framework.common.util.CastUtil;
import jp.sf.bli.framework.logging.Logging;

/**
 * Number型のValidate実行クラス
 * 
 * @author takeda
 */
public class ValidateInteger extends AbstractVlidateObject {

    /**
     * Number型のValidateをプロパティに基づいて実行する
     * 
     * @param ユーザID
     * @param Validate用のプロパティファイルが割り当てられたResourceBundle
     * @param Validateを行うフィールド名
     * @param Validateを行うオブジェクト
     * @param エラー文字列改行文字
     * @return エラー文字列
     * @throws ValidateException
     */
    public static String validate( String id, ResourceBundle bundleConfing,
            ResourceBundle bundleMes, String fieldName, Object obj,
            String errorMesLinefeed, GetMessageDB getMessageDB )
            throws ValidateException {

        StringBuffer errorMes = new StringBuffer("");
        
        Integer chkObj = ( Integer ) obj;

        String chkObjStr = null;

        if ( chkObj != null ) {

            chkObjStr = chkObj.toString();

        } else {

            chkObjStr = null;

        }

        Logging.debug( ValidateInteger.class, "BLI000044", id,
                "validate fieldName:" + fieldName + " chkInteger:" + chkObjStr );

        boolean nullChk = chkNameMakeBoolean( id, bundleConfing, fieldName,
                "nullChk" );

        boolean emptyChk = chkNameMakeBoolean( id, bundleConfing, fieldName,
                "emptyChk" );

        int lengthChk = chkNameMakeInt( id, bundleConfing, fieldName,
                "lengthChk" );

        String minChk = chkNameMakeString( id, bundleConfing, fieldName,
                "minChk" );

        String maxChk = chkNameMakeString( id, bundleConfing, fieldName,
                "maxChk" );

        String valueChk = chkNameMakeString( id, bundleConfing, fieldName,
                "valueChk" );

        if ( nullChk ) {

            if ( chkObj == null ) {
                // nullをチェックする

                errorMes.append( errorMesMake( id, bundleMes, fieldName,
                        "nullChk", errorMesLinefeed, getMessageDB ) );

                // nullが来たらこれ以降のチェックでNullPointerで落ちるので処理を抜ける
                return errorMes.toString();

            }

        }

        if ( chkObj == null ) {

            // nullが来たらこれ以降のチェックでNullPointerで落ちるので処理を抜ける
            return errorMes.toString();

        }

        if ( emptyChk ) {

            if ( chkObjStr.equals( "" ) ) {

                errorMes.append( errorMesMake( id, bundleMes, fieldName,
                        "emptyChk", errorMesLinefeed, getMessageDB ) );

            }
        }

        if ( lengthChk < 0 ) {

            try {
                if ( lengthChk < chkObjStr.getBytes( "MS932" ).length ) {

                    errorMes.append( errorMesMake( id, bundleMes, fieldName,
                            "lengthChk", errorMesLinefeed, getMessageDB ) );

                }
            } catch ( UnsupportedEncodingException e ) {
            }
        }

        if ( minChk != null ) {

            if ( Integer.valueOf( minChk ).intValue() > chkObj.intValue() ) {

                errorMes.append( errorMesMake( id, bundleMes, fieldName,
                        "minChk", errorMesLinefeed, getMessageDB ) );

            }

        }

        if ( maxChk != null ) {

            if ( Integer.valueOf( maxChk ).intValue() < chkObj.intValue() ) {

                errorMes.append( errorMesMake( id, bundleMes, fieldName,
                        "maxChk", errorMesLinefeed, getMessageDB ) );

            }

        }

        // 文字列配列の数字に合致しないとエラー
        if ( valueChk != null ) {

            // valueChk文字列を,で分割してArrayListに変換
            List valueChkArray = CastUtil.string2Array( valueChk, "," );

            boolean ngFlag = true;

            Iterator itr = valueChkArray.iterator();

            String nowChar = "";

            while ( itr.hasNext() ) {

                nowChar = ( String ) itr.next();

                if ( nowChar.equals( chkObjStr ) ) {
                    ngFlag = false;
                }

            }

            if ( ngFlag == true ) {

                errorMes.append( errorMesMake( id, bundleMes, fieldName,
                        "valueChk", errorMesLinefeed, getMessageDB ) );

            }

        }
        return errorMes.toString();
    }
}
