/*
 * Copyright (C) 2006-2007 BLI Project
 * All rights reserved.
 * 
 * Redistribution and use in source and binary forms,
 * with or without modification, are permitted provided
 * that the following conditions are
 * met:
 * 
 * 1. Redistributions of source code must retain
 * the above copyright notice, this list of conditions
 * and the following disclaimer as the first lines of this file unmodified.
 * 
 * 2. Redistributions  in  binary  form must reproduce 
 * the above copyright notice, this list of conditions 
 * and the following disclaimer in the documentation
 * and/or other materials provided with the distribution.
 * 
 * THIS SOFTWARE IS PROVIDED BY THE AUTHOR ``AS IS'' AND ANY EXPRESS
 * OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO,
 * THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS
 * FOR A PARTICULAR PURPOSE ARE DISCLAIMED.
 * IN NO EVENT SHALL THE AUTHOR BE LIABLE FOR ANY DIRECT,
 * INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES
 * (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
 *  OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT,
 * STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING
 * IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED
 * OF THE POSSIBILITY OF SUCH DAMAGE.
 */
package jp.sf.bli.framework.logging;

import jp.sf.bli.framework.common.util.StrUtil;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

/**
 * ログ出力クラス<br />
 * logLevel接頭文字1文字＋logCount loginId logMessage ログ出力クラス名<br />
 * という書式でcommonsLoggingをラッパーしてログを出力
 * 
 * @author takeda
 */
public class Logging {

    private static Log log    = null;

    private static int lenCut = 10;


    /**
     * FATAL エラーログ出力メソッド
     * 
     * @param cls
     * @param logCount
     * @param UserId
     * @param logMessage
     */
    public static void fatal( Class cls, String logCount, String id,
            String logMessage ) {

        Logging.log = LogFactory.getLog( cls );

        log.fatal( "F" + logCount + " " + StrUtil.matchLength( id, lenCut )
                + " " + logMessage + " " + cls.getName() );
    }


    /**
     * ERROR エラーログ出力メソッド
     * 
     * @param cls
     * @param logCount
     * @param UserId
     * @param logMessage
     */
    public static void error( Class cls, String logCount, String id,
            String logMessage ) {

        Logging.log = LogFactory.getLog( cls );

        log.error( "E" + logCount + " " + StrUtil.matchLength( id, lenCut )
                + " " + logMessage + " " + cls.getName() );
    }


    /**
     * WARN エラーログ出力メソッド
     * 
     * @param エラー出力クラス
     * @param ログカウント文字列
     * @param ユーザID
     * @param ログメッセージ
     */
    public static void warn( Class cls, String logCount, String id,
            String logMessage ) {

        Logging.log = LogFactory.getLog( cls );

        log.warn( "W" + logCount + " " + StrUtil.matchLength( id, lenCut ) + " "
                + logMessage + " " + cls.getName() );
    }


    /**
     * INFO エラーログ出力メソッド
     * 
     * @param エラー出力クラス
     * @param ログカウント文字列
     * @param ユーザID
     * @param ログメッセージ
     */
    public static void info( Class cls, String logCount, String id,
            String logMessage ) {

        Logging.log = LogFactory.getLog( cls );

        log.info( "I" + logCount + " " + StrUtil.matchLength( id, lenCut ) + " "
                + logMessage + " " + cls.getName() );
    }


    /**
     * DEBUG エラーログ出力メソッド
     * 
     * @param エラー出力クラス
     * @param ログカウント文字列
     * @param ユーザID
     * @param ログメッセージ
     */
    public static void debug( Class cls, String logCount, String id,
            String logMessage ) {

        Logging.log = LogFactory.getLog( cls );

        log.debug( "D" + logCount + " " + StrUtil.matchLength( id, lenCut )
                + " " + logMessage + " " + cls.getName() );
    }

}
