/*
 * Copyright (C) 2006-2007 BLI Project
 * All rights reserved.
 * 
 * Redistribution and use in source and binary forms,
 * with or without modification, are permitted provided
 * that the following conditions are
 * met:
 * 
 * 1. Redistributions of source code must retain
 * the above copyright notice, this list of conditions
 * and the following disclaimer as the first lines of this file unmodified.
 * 
 * 2. Redistributions  in  binary  form must reproduce 
 * the above copyright notice, this list of conditions 
 * and the following disclaimer in the documentation
 * and/or other materials provided with the distribution.
 * 
 * THIS SOFTWARE IS PROVIDED BY THE AUTHOR ``AS IS'' AND ANY EXPRESS
 * OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO,
 * THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS
 * FOR A PARTICULAR PURPOSE ARE DISCLAIMED.
 * IN NO EVENT SHALL THE AUTHOR BE LIABLE FOR ANY DIRECT,
 * INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES
 * (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
 *  OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT,
 * STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING
 * IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED
 * OF THE POSSIBILITY OF SUCH DAMAGE.
 */
package jp.sf.bli.framework.common.util;

import java.io.UnsupportedEncodingException;
import java.util.Random;


/**
 * Stringに関するUtilityメソッドを集めたクラス
 * 
 * @author takeda
 */
public class StrUtil {

    /**
     * 引数１の値を引数２の桁数になるよう左詰にして半角スペースで文字列の後ろを埋める
     * 
     * @param sArg
     *            桁合わせ対象文字列
     * @param iKeta
     *            固定値項目の桁数
     * @return 桁合わせをした文字列
     */
    public static String matchLength( String sArg, int iKeta ) {

        String wk = null; // 桁編集用

        // 初期値として,桁数分の空白文字列を生成する
        StringBuffer sb = new StringBuffer( "" );

        for ( int idx = 1; idx <= iKeta; idx++ ) {
            sb.append( " " );
        }

        if ( sArg == null ) { // 引数がNull値の時
            wk = sb.toString();
        } else { // 引数に値が設定されている時
            String tempStr = sArg.trim();
            try {
                if ( tempStr.getBytes( "MS932" ).length < iKeta ) {
                    // 余分な桁を削る
                    sb = sb.delete( 0, tempStr.getBytes( "MS932" ).length );

                    // 桁数が足りない分、後ろに空白を追加
                    wk = tempStr + sb.toString();

                } else {
                    wk = tempStr;
                }
            } catch ( UnsupportedEncodingException e ) {
            }
        }
        return wk;
    }
    
    /**
     * ランダムな文字列10文字を取得する
     * 
     * @return
     */
    public static String getRandomStr() {

        Random rnd = new Random();

        int rndInt = rnd.nextInt();

        if ( rndInt < 0 ) {
            rndInt = rndInt * -1;
        }

        String rndStr = Integer.valueOf( rndInt ).toString();

        rndStr = matchLength( rndStr, 10 );

        return rndStr;
    }
    /**
     * 半角カナ存在チェック
     * 
     * @param str
     * @return
     */
    public static boolean charHanKanaCheck( String str ) {

        if ( str != null ) {
            char[] chars = str.toCharArray();
            for ( int i = 0; i < chars.length; i++ ) {
                char target = chars[i];
                // 半角カナが存在する場合
                if ( 0xff66 <= target && target <= 0xff9f ) {
                    return true;
                }
            }
        }

        return false;
    }


    /**
     * 半角数字、半角英字かチェックする
     * 
     * @param str
     * @return
     */
    public static boolean charHanAlpNum( String str ) {

        if ( str != null ) {
            char[] chars = str.toCharArray();
            for ( int i = 0; i < chars.length; i++ ) {

                char target = chars[i];

                // 半角アルファベッド・半角数字以外が含まれる場合エラー
                if ( ( 0x0030 <= target && target <= 0x0039 ) || // 半角数字
                        ( 0x0041 <= target && target <= 0x005a ) || // 半角英大文字
                        ( 0x0061 <= target && target <= 0x007a ) // 半角英小文字
                ) {

                } else {

                    return false;

                }
            }
        }

        return true;

    }

    /**
     * 引数の文字列に半角英字以外が含まれているかどうかチェックする
     * 
     * @return true:半角英字のみ、false:半角英字以外が含まれる
     */
    public static boolean charHanAlp( String str ) {

        if ( str != null ) {
            char[] chars = str.toCharArray();
            for ( int i = 0; i < chars.length; i++ ) {
                char target = chars[i];
                // 半角英字以外が含まれる場合エラー
                if ( ( 0x0041 <= target && target <= 0x005a ) || // 半角英大文字
                        ( 0x0061 <= target && target <= 0x007a ) // 半角英小文字
                ) {
                } else {
                    return false;
                }
            }
        }
        return true;
    }


    /**
     * 引数の文字列に半角数字以外が含まれているかどうかチェックする
     * 
     * @return true:半角数字のみ、false:半角数字以外が含まれる
     */
    public static boolean charHanNum( String str ) {

        if ( str != null ) {
            char[] chars = str.toCharArray();
            for ( int i = 0; i < chars.length; i++ ) {
                char target = chars[i];
                // 半角数字以外が含まれる場合エラー
                if ( 0x0030 <= target && target <= 0x0039 ) {
                } else {
                    return false;
                }
            }
        }
        return true;
    }
}
