/*
 * Copyright (C) 2006-2007 BLI Project
 * All rights reserved.
 * 
 * Redistribution and use in source and binary forms,
 * with or without modification, are permitted provided
 * that the following conditions are
 * met:
 * 
 * 1. Redistributions of source code must retain
 * the above copyright notice, this list of conditions
 * and the following disclaimer as the first lines of this file unmodified.
 * 
 * 2. Redistributions  in  binary  form must reproduce 
 * the above copyright notice, this list of conditions 
 * and the following disclaimer in the documentation
 * and/or other materials provided with the distribution.
 * 
 * THIS SOFTWARE IS PROVIDED BY THE AUTHOR ``AS IS'' AND ANY EXPRESS
 * OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO,
 * THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS
 * FOR A PARTICULAR PURPOSE ARE DISCLAIMED.
 * IN NO EVENT SHALL THE AUTHOR BE LIABLE FOR ANY DIRECT,
 * INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES
 * (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
 *  OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT,
 * STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING
 * IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED
 * OF THE POSSIBILITY OF SUCH DAMAGE.
 */
package jp.sf.bli.framework.common.util;

import java.util.List;
import java.util.Map;

import javax.servlet.http.HttpSession;

import jp.sf.bli.framework.common.Globals;


/**
 * Frameworkで使用するUtilityメソッドを集めたクラス
 * 
 * @author takeda
 */
public class FrameworkUtil {

    /**
     * HttpSessionに格納されているユーザID取得
     * 
     * @param session
     * @return
     */
    public static String getLoginId( HttpSession session ) {

        String loginName = ( String ) session
                .getAttribute( Globals.SESSION_KEY_LOGIN_ID );

        if ( loginName == null ) {
            loginName = Globals.NO_LOGIN_ID;
        }

        return loginName;
    }


    /**
     * HttpSessionに格納されているユーザIDにひもづく権限ロール取得
     * 
     * @param session
     * @return
     */
    @SuppressWarnings ( "unchecked" )
    public static List< String > getRole( HttpSession session ) {

        List< String > loginRole = ( List< String > ) session
                .getAttribute( Globals.SESSION_KEY_LOGIN_ROLE );

        return loginRole;
    }


    /**
     * HttpSessionにエラーメッセージを格納する
     * 
     * @param session
     * @param errorMes
     */
    public static void setSessionErrorMes( HttpSession session,
            String errorMes, int firstFlag ) {

        String sessionErrorMes = "";

        if ( firstFlag == 1 ) {
            sessionErrorMes = ( String ) session
                    .getAttribute( Globals.SESSION_KEY_ERROR_MES );
        }
        
        if(sessionErrorMes == null){
            sessionErrorMes = "";
        }
        

        session.removeAttribute( Globals.SESSION_KEY_ERROR_MES );
        session.setAttribute( Globals.SESSION_KEY_ERROR_MES, sessionErrorMes
                + errorMes );

    }


    /**
     * Mapにエラーメッセージを格納する
     * 
     * @param session
     * @param errorMes
     */
    public static void setMapErrorMes( Map<String,Object> outputValueMap,
            String errorMes, int firstFlag ) {

        String allErrorMes = "";

        if ( firstFlag == 1 ) {
            allErrorMes = ( String ) outputValueMap
                    .get( Globals.SESSION_KEY_ERROR_MES );
        }

        outputValueMap.put( Globals.SESSION_KEY_ERROR_MES, allErrorMes
                + errorMes );

    }
    

    /**
     * Mapからエラーメッセージを取り出す
     * 
     * @param session
     * @param errorMes
     */
    public static String getMapErrorMes( Map<String,Object> outputValueMap ) {

        String allErrorMes = (String)outputValueMap.get( Globals.SESSION_KEY_ERROR_MES);
        

        if(allErrorMes == null){
            allErrorMes = "";
        }
        
        return allErrorMes;


    }


    /**
     * HttpSessionに表示メッセージを追加格納する
     * 
     * @param session
     * @param dispNumber
     */
    public static void setSessionMes( HttpSession session, String mes,
            int firstFlag ) {

        String sessionMes = "";

        if ( firstFlag == 1 ) {
            sessionMes = ( String ) session.getAttribute( Globals.SESSION_KEY_MES );
        }
        

        if(sessionMes == null){
            sessionMes = "";
        }
        

        session.removeAttribute( Globals.SESSION_KEY_MES );
        session.setAttribute( Globals.SESSION_KEY_MES, sessionMes + mes );

    }
    

    /**
     * Mapにメッセージを追加格納する
     * 
     * @param session
     * @param dispNumber
     */
    public static void setMapMes( Map<String,Object> outputValueMap, String mes,
            int firstFlag ) {

        String allMes = "";

        if ( firstFlag == 1 ) {
            allMes = ( String ) outputValueMap
                    .get( Globals.SESSION_KEY_MES );
        }

        outputValueMap.put( Globals.SESSION_KEY_MES, allMes + mes );

    }
    

    /**
     * Mapからメッセージを取り出す
     * 
     * @param session
     * @param dispNumber
     */
    public static String getMapMes( Map<String,Object> outputValueMap) {

        String allMes = (String)outputValueMap.get( Globals.SESSION_KEY_ERROR_MES);
        
        if(allMes == null){
            allMes = "";
        }
        
        return allMes;

    }
}
