/*
 * Copyright (C) 2006-2007 BLI Project
 * All rights reserved.
 * 
 * Redistribution and use in source and binary forms,
 * with or without modification, are permitted provided
 * that the following conditions are
 * met:
 * 
 * 1. Redistributions of source code must retain
 * the above copyright notice, this list of conditions
 * and the following disclaimer as the first lines of this file unmodified.
 * 
 * 2. Redistributions  in  binary  form must reproduce 
 * the above copyright notice, this list of conditions 
 * and the following disclaimer in the documentation
 * and/or other materials provided with the distribution.
 * 
 * THIS SOFTWARE IS PROVIDED BY THE AUTHOR ``AS IS'' AND ANY EXPRESS
 * OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO,
 * THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS
 * FOR A PARTICULAR PURPOSE ARE DISCLAIMED.
 * IN NO EVENT SHALL THE AUTHOR BE LIABLE FOR ANY DIRECT,
 * INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES
 * (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
 *  OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT,
 * STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING
 * IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED
 * OF THE POSSIBILITY OF SUCH DAMAGE.
 */
package jp.sf.bli.framework.common.util;

import java.sql.Timestamp;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.List;


/**
 * 型変換系メソッドを集めたユーティリティクラス
 * 
 * @author takeda
 */
public class CastUtil {

    /**
     * java.sql.TimeStamp型をjava.util.Date型に変換
     * 
     * @param timeStamp
     * @return
     */
    public static java.util.Date sqlTimeStamp2UtilDate( Timestamp timeStamp ) {

        java.util.Date date = new java.util.Date( timeStamp.getTime() );

        return date;
    }


    /**
     * 文字列をSimpleDateFormatのフォーマット指定でjava.sql.Timestamp型へ変換
     * 
     * @param 時間文字列
     * @param SimpleDateFormatのフォーマット文字列
     * @return java.sql.Timestamp型のDateインスタンス
     * @throws CommonException
     */
    public static java.sql.Timestamp string2Timestamp( String strDate, String strFormat ) throws Exception {

        java.util.Date utilDate = null;
        java.sql.Timestamp timestamp = null;

        SimpleDateFormat sdfFrom = new SimpleDateFormat( strFormat );


        utilDate = ( java.util.Date ) sdfFrom.parse( strDate );

        timestamp = new java.sql.Timestamp( utilDate.getTime() );


        return timestamp;
    }


    /**
     * java.sql.Timestamp型をSimpleDateFormatのフォーマット指定で文字列へ変換
     * 
     * @param 時間文字列
     * @param SimpleDateFormatのフォーマット文字列
     * @return java.sql.Timestamp型のDateインスタンス
     * @throws CommonException
     */
    public static String timestamp2String( 
            java.sql.Timestamp timeStamp, String strFormat ) {

        java.util.Date utilDate = sqlTimeStamp2UtilDate( timeStamp );

        SimpleDateFormat sdfFrom = new SimpleDateFormat( strFormat );
        sdfFrom.setLenient( false );

        String strDate = sdfFrom.format( utilDate );

        return strDate;
    }


    /**
     * 文字列をArrayListに変換する
     * 
     * @param originalStr
     * @param sepStr
     * @return
     */
    public static List string2Array( String originalStr,
            String sepStr ) {

        List< String > valueChkArray = new ArrayList< String >();

        String nowValue = "";
        String nowValueChk = "";

        int comaIndex = originalStr.indexOf( sepStr );
        int nowIndex = 0;
        int valueChkLength = originalStr.length();

        if ( comaIndex > 0 ) {

            while ( comaIndex < valueChkLength + 1 ) {

                nowValue = originalStr.substring( nowIndex, comaIndex );

                valueChkArray.add( nowValue );

                if ( comaIndex == valueChkLength ) {
                    break;
                } else {
                    nowValueChk = originalStr.substring( comaIndex + 1,
                            valueChkLength );
                }

                nowIndex = comaIndex + 1;

                if ( nowValueChk.indexOf( sepStr ) == -1 ) {
                    comaIndex = valueChkLength;
                } else {
                    comaIndex = comaIndex + 1 + nowValueChk.indexOf( sepStr );
                }

            }

        } else {

            valueChkArray.add( originalStr );

        }

        return valueChkArray;
    }

}
