/*
 * Decompiled with CFR 0.152.
 */
package jp.sf.bli.framework.batch;

import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import jp.sf.bli.framework.batch.BusinessLogicDoBT;
import jp.sf.bli.framework.batch.BusinessLogicValidateBT;
import jp.sf.bli.framework.common.BusinessLogicException;
import jp.sf.bli.framework.common.util.FrameworkUtil;
import jp.sf.bli.framework.logging.Logging;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class BusinessLogicCtrlBT {
    protected String loginId = "Batch-User";
    protected BusinessLogicValidateBT blValidate = null;
    protected List<BusinessLogicDoBT> blList = null;
    protected Map<String, Object> inputValueMap = null;
    protected Map<String, Object> outputValueMap = null;

    public String getLoginId() {
        return this.loginId;
    }

    public void setLoginId(String loginId) {
        this.loginId = loginId;
    }

    public List<BusinessLogicDoBT> getBlList() {
        return this.blList;
    }

    public BusinessLogicValidateBT getBlValidate() {
        return this.blValidate;
    }

    public Map<String, Object> getInputValueMap() {
        return this.inputValueMap;
    }

    public void setInputValueMap(Map<String, Object> inputValueMap) {
        this.inputValueMap = inputValueMap;
    }

    public Map<String, Object> getOutputValueMap() {
        return this.outputValueMap;
    }

    public void setOutputValueMap(Map<String, Object> outputValueMap) {
        this.outputValueMap = outputValueMap;
    }

    public void setBlValidate(BusinessLogicValidateBT blValidate) {
        this.blValidate = blValidate;
    }

    public void setBlList(List<BusinessLogicDoBT> blList) {
        this.blList = blList;
    }

    public int doBizCtrl(String[] args) throws BusinessLogicException {
        int resultFlagInt = -1000;
        try {
            this.init(args);
            this.initProcess(args);
            this.parameter2InputValueMap(args);
            this.blDoLoop(args, this.doVaildate(args));
            this.endProcess(args);
            this.end(args);
        }
        catch (Exception e) {
            Logging.fatal(this.getClass(), "BLI000020", this.getLoginId(), "doBizCtrl:BLCtrl catch Exception. " + e.getMessage());
            e.printStackTrace();
            throw new BusinessLogicException("LogCount\uff1aBLI000017");
        }
        resultFlagInt = (Integer)this.outputValueMap.get("resultFlag");
        return resultFlagInt;
    }

    protected void blDoLoop(String[] args, int resultFlagInt) throws Exception {
        if (resultFlagInt != -999 && resultFlagInt != 0) {
            Iterator<BusinessLogicDoBT> itr = this.blList.iterator();
            while (itr.hasNext()) {
                Logging.debug(this.getClass(), "BLI000023", this.getLoginId(), "blDoLoop:BusineesLogicDo Strat");
                BusinessLogicDoBT blDo = itr.next();
                if (!this.doBL(args, blDo)) {
                    Logging.debug(this.getClass(), "BLI000024", this.getLoginId(), "blDoLoop:BusineesLogicDo No Normal End");
                    Integer resultFlag = (Integer)this.outputValueMap.get("resultFlag");
                    resultFlagInt = resultFlag;
                    if (resultFlagInt == -999 || resultFlagInt == 0) {
                        Logging.debug(this.getClass(), "BLI000025", this.getLoginId(), "blDoLoop:break; resultFlag:" + resultFlagInt);
                        break;
                    }
                }
                Logging.debug(this.getClass(), "BLI000026", this.getLoginId(), "blDoLoop:BusineesLogicDo Normal End");
            }
        }
    }

    public void init(String[] args) throws Exception {
        this.inputValueMap = new HashMap<String, Object>();
        this.outputValueMap = new HashMap<String, Object>();
        Logging.debug(this.getClass(), "BLI000021", this.getLoginId(), "doBizCtrl:BLCtrl started.");
    }

    protected abstract void initProcess(String[] var1) throws Exception;

    protected abstract void parameter2InputValueMap(String[] var1) throws Exception;

    protected int doVaildate(String[] args) throws Exception {
        int resultFlagInt = 0;
        Integer resultFlag = null;
        if (this.blValidate != null) {
            this.blValidate.doValidate(this.loginId, this.inputValueMap, this.outputValueMap);
            resultFlag = (Integer)this.outputValueMap.get("resultFlag");
            if (resultFlag == null || resultFlag == 0) {
                String errorMes = (String)this.outputValueMap.get("mapKeyErrorMes");
                FrameworkUtil.setMapErrorMes(this.outputValueMap, errorMes, 0);
                if (resultFlag == null) {
                    resultFlagInt = -999;
                    resultFlag = -999;
                    this.outputValueMap.put("resultFlag", resultFlagInt);
                }
                Logging.error(this.getClass(), "BLI000022", this.getLoginId(), "doBizCtrl:Validate ended because of the error. rtnFlag:[" + resultFlag + "] errerMes:[" + errorMes + "]");
            }
        } else {
            resultFlag = -1000;
        }
        resultFlagInt = resultFlag;
        return resultFlagInt;
    }

    protected boolean doBL(String[] args, BusinessLogicDoBT blDo) throws Exception {
        boolean rtnFlag = true;
        blDo.doBizLogic(this.loginId, this.inputValueMap, this.outputValueMap);
        Integer resultFlag = (Integer)this.outputValueMap.get("resultFlag");
        if (resultFlag == null || resultFlag == 0) {
            rtnFlag = false;
            String errorMes = (String)this.outputValueMap.get("mapKeyErrorMes");
            FrameworkUtil.setMapErrorMes(this.outputValueMap, errorMes, 1);
            if (resultFlag == null) {
                resultFlag = -999;
                this.outputValueMap.put("resultFlag", resultFlag);
            }
            Logging.error(this.getClass(), "BLI000027", this.getLoginId(), "doBizCtrl:Validate ended because of the error. rtnFlag:[" + resultFlag + "] errerMes:[" + errorMes + "]");
        }
        return rtnFlag;
    }

    protected abstract void endProcess(String[] var1) throws Exception;

    protected void end(String[] args) throws Exception {
        Logging.debug(this.getClass(), "BLI000028", this.loginId, "doBizCtrl:BLCtrl ended normally. rtnFlag:[0]");
    }
}

