/*
 * blanco Framework
 * Copyright (C) 2004-2006 IGA Tosiki
 * 
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 */
package blanco.cg;

import java.io.File;

import junit.framework.TestCase;
import blanco.cg.transformer.BlancoCgTransformerFactory;
import blanco.cg.valueobject.BlancoCgClass;
import blanco.cg.valueobject.BlancoCgField;
import blanco.cg.valueobject.BlancoCgInterface;
import blanco.cg.valueobject.BlancoCgMethod;
import blanco.cg.valueobject.BlancoCgSourceFile;

/**
 * C#.NETp̐B
 * 
 * @author IGA Tosiki
 */
public class BlancoCgTransformerCsTest extends TestCase {
    /**
     * C#.NET̎B
     * 
     * @throws Exception
     */
    public void testTransformerCs() throws Exception {
        final BlancoCgObjectFactory cgFactory = BlancoCgObjectFactory
                .getInstance();

        // \[Xt@C𐶐܂B
        final BlancoCgSourceFile cgSourceFile = cgFactory.createSourceFile(
                "Myprog", "eXgp̃NX");
        cgSourceFile.getImportList().add("System.Text.DummyText");
        // pbP[W̃C|[gB
        cgSourceFile.getImportList().add("Myprog.MyClass2");

        // NX𐶐܂B
        final BlancoCgClass cgClass = cgFactory.createClass("MyClass",
                "̃NX́AeXĝ߂̃NXłB");
        cgSourceFile.getClassList().add(cgClass);
        cgClass.getLangDoc().getTagList().add(
                cgFactory.createLangDocTag("author", null, "blanco Framework"));
        cgClass.getExtendClassList().add(
                cgFactory.createType("java.lang.Thread"));
        cgClass.getImplementInterfaceList().add(
                cgFactory.createType("System.WebException"));
        cgClass.getImplementInterfaceList().add(
                cgFactory.createType("System.WebException2"));

        // tB[h𐶐܂B
        final BlancoCgField cgField = cgFactory.createField("myField",
                "java.util.Date", "ttB[h̎łB");
        cgClass.getFieldList().add(cgField);
        cgField.setDefault("new DateTime()");

        // \bh𐶐܂B
        final BlancoCgMethod cgMethod = cgFactory.createMethod("MyMethod",
                "\bh̎łB");
        cgClass.getMethodList().add(cgMethod);

        // p[^ǉ܂B
        cgMethod.getParameterList().add(
                cgFactory.createParameter("argString", "System.String",
                        "B"));
        cgMethod.getParameterList()
                .add(
                        cgFactory.createParameter("argDate", "System.DateTime",
                                "tB"));
        // ߂lݒ肵܂B
        cgMethod.setReturn(cgFactory.createReturn("bool", "ȂtrueB"));

        cgMethod.getThrowList().add(
                cgFactory.createException("System.IO.IOException",
                        "o͗OꍇB"));

        // Ame[V̒ǉB
        cgMethod.getAnnotationList().add(
                "Copyright(value=\"blanco Framework\")");

        // \bh̓eǉ܂B
        cgMethod.getLineList().add("// ̎łB");
        cgMethod.getLineList().add("int a = 0;");

        final BlancoCgTransformer cgTransformerCs = BlancoCgTransformerFactory
                .getCsSourceTransformer();
        cgTransformerCs.transform(cgSourceFile, new File("./tmp/blanco"));
    }

    /**
     * C^tF[X̓WJB
     * 
     * @throws Exception
     */
    public void testTransformerInterface() throws Exception {
        final BlancoCgObjectFactory cgOf = BlancoCgObjectFactory.getInstance();

        // \[Xt@C𐶐܂B
        final BlancoCgSourceFile cgSourceFile = cgOf.createSourceFile("Myprog",
                "eXgp̃C^tF[X");
        cgSourceFile.getImportList().add("Myprog.Class2");
        cgSourceFile.getImportList().add("Myprog2.ClassOther");

        // NX𐶐܂B
        final BlancoCgInterface cgInterface = cgOf.createInterface(
                "MyInterface", "̃C^tF[X́AeXĝ߂̃C^tF[XłB");
        cgSourceFile.getInterfaceList().add(cgInterface);
        cgInterface.getLangDoc().getTagList().add(
                cgOf.createLangDocTag("author", null, "blanco Framework"));
        cgInterface.getExtendClassList().add(
                cgOf.createType("System.IO.IOException"));

        // tB[h𐶐܂B
        final BlancoCgField cgField = cgOf.createField("myField",
                "System.DateTime", "ttB[h̎łB");
        cgInterface.getFieldList().add(cgField);
        cgField.setDefault("new DateTime()");

        // \bh𐶐܂B
        final BlancoCgMethod cgMethod = cgOf.createMethod("MyMethod",
                "\bh̎łB");
        cgInterface.getMethodList().add(cgMethod);

        // p[^ǉ܂B
        cgMethod.getParameterList().add(
                cgOf.createParameter("argString", "System.String", "B"));
        cgMethod.getParameterList().add(
                cgOf.createParameter("argDate", "System.DateTime", "tB"));
        // ߂lݒ肵܂B
        cgMethod.setReturn(cgOf.createReturn("bool", "ȂtrueB"));

        cgMethod.getThrowList().add(
                cgOf.createException("System.IO.IOException", "o͗OꍇB"));

        final BlancoCgTransformer cgTransformerCs = BlancoCgTransformerFactory
                .getCsSourceTransformer();
        cgTransformerCs.transform(cgSourceFile, new File("./tmp/blanco"));
    }
}
