/*******************************************************************************
 * Copyright (c) 2009 Information-technology Promotion Agency, Japan.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *******************************************************************************/
package benten.twa.filter.handler;

import java.io.IOException;

import org.eclipse.core.commands.IHandler;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.jface.dialogs.StatusDialog;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.widgets.Shell;
import org.xml.sax.SAXException;

import benten.twa.filter.core.BentenImportHtmlBatchProcess;
import benten.twa.filter.core.BentenImportHtmlProcessImpl;
import benten.twa.filter.core.valueobject.BentenImportHtmlProcessInput;
import benten.twa.filter.dialogs.ImportHtmlDialog;
import benten.twa.filter.messages.BentenImportHtmlMessages;
import benten.twa.filter.status.BentenImportHtmlStatus;
import benten.twa.ui.jobs.AbstractWorkflowHandler;
import benten.ui.preference.BentenProjectProperty;
import benten.ui.preference.BentenProjectProperty.ProjectProperty;

/**
 * 翻訳対象物インポート・ハンドラーです。
 *
 * 翻訳対象のインポート
 *
 * <pre>
 * 翻訳対象物をプロジェクトにインポートします。
 *   1.  翻訳対象物のファイルをプロジェクトにインポートします。
 *   2.  インポートされた翻訳対象物は、デフォルトではプロジェクト内の [.benten/source] ディレクトリ以下に配置されます。
 *   3.  インポートされた翻訳対象物は、エクスポートの際に利用されます。
 *   4.  インポートされた翻訳対象物は、直接編集しないでください。
 * </pre>
 * 
 * ★基本設計「翻訳ワークフロー支援機能: 翻訳対象物－翻訳中間形式変換機能: HTMLインポート機能」に対応します。
 * 
 * @author KASHIHARA Shinji
 */
public class ImportHtmlHandler extends AbstractWorkflowHandler implements IHandler {
	/**
	 * HTMLインポート機能のためのメッセージ。
	 */
	protected static final BentenImportHtmlMessages fMsg = new BentenImportHtmlMessages();

	@Override
	protected StatusDialog createDialog(final Shell shell, final IStructuredSelection selection) {
		setJobMessage(fMsg.getJobName());
		return new ImportHtmlDialog(shell, selection);
	}

	@Override
	protected void processFile(final IStatus iStatus) throws IOException, SAXException {
		final BentenImportHtmlStatus status = (BentenImportHtmlStatus) iStatus;

		final BentenImportHtmlProcessInput input = new BentenImportHtmlProcessInput();
		input.setSourcedir(status.getFromDir().getAbsolutePath());
		input.setTargetdir(status.getToDir().getAbsolutePath());
		input.setNormalizehtml(status.getNormalizeHtml());

		new BentenImportHtmlBatchProcess().validateInput(input);
		final BentenImportHtmlProcessImpl process = new BentenImportHtmlProcessImpl() {
			@Override
			protected void beginTask(final int totalWork) {
				monitor.beginTask(null, totalWork);
			}

			@Override
			public boolean progress(final String argProgressMessage) {
				monitor.subTask(argProgressMessage);
				monitor.worked(1);
				Thread.yield();
				return monitor.isCanceled();
			}
		};
		process.execute(input);
		resultInfo = process.getResultInfo();
	}

	@Override
	protected void complete(final IStatus iStatus) {
		// このプロジェクトで処理済みとマーク
		final BentenImportHtmlStatus status = (BentenImportHtmlStatus) iStatus;
		final IPreferenceStore projectStore = BentenProjectProperty.getStore(status.getProject());
		projectStore.setValue(ProjectProperty.TRANS_TARGET_IMPORTED.name(), true);
	}
}
