/*******************************************************************************
 * Copyright (c) 2010 IGA Tosiki.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *******************************************************************************/
/*
 * Copyright (C) 2010 IGA Tosiki.
 * 
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 */
package benten.twa.filter.core;

import java.io.EOFException;
import java.io.IOException;
import java.io.Reader;
import java.io.Writer;
import java.util.Properties;

import benten.core.model.HelpTransUnitId;
import benten.twa.process.BentenProcessResultInfo;
import blanco.xliff.valueobject.BlancoXliffFile;

/**
 * gettext の PO ファイル処理の共通処理。
 * @author IGA Tosiki
 */
abstract class BentenTwaFilterGettextPoCommon {
	/**
	 * PO ファイルを処理します。
	 * @param id ID。
	 * @param xliffFile XLIFF ファイル。
	 * @param props プロパティ。
	 * @param reader リーダー。
	 * @param writer ライター。
	 * @param resultInfo 処理結果情報。
	 * @return 処理したかどうか。
	 * @throws IOException 入出力例外が発生した場合。
	 */
	boolean processPoFile(final HelpTransUnitId id, final BlancoXliffFile xliffFile, final Properties props,
			final Reader reader, final Writer writer, final BentenProcessResultInfo resultInfo) throws IOException {
		final boolean isProcessed = false;

		try {
			for (;;) {
				final StringBuffer translatorComments = new StringBuffer();
				final StringBuffer extractedComments = new StringBuffer();
				final StringBuffer reference = new StringBuffer();
				final StringBuffer flag = new StringBuffer();
				if (processComment(translatorComments, extractedComments, reference, flag, reader, writer)) {
					// 頭からやり直し。
					continue;
				}
			}
		} catch (final EOFException ex) {
			// ファイルが終端に到達しました。
		}

		return isProcessed;
	}

	/**
	 * コメントの処理。
	 * @param translatorComments 翻訳コメント。
	 * @param extractedComments 展開コメント。
	 * @param reference 参照。
	 * @param flag フラグ。
	 * @param reader 入力リーダー。
	 * @param writer 出力ライター。
	 * @return 処理中断すべき場合は true。
	 * @throws IOException 入出力例外が発生した場合。
	 */
	public static boolean processComment(final StringBuffer translatorComments, final StringBuffer extractedComments,
			final StringBuffer reference, final StringBuffer flag, final Reader reader, final Writer writer)
			throws IOException {
		for (;;) {
			// 該当行がコメント行かどうかをチェックします。
			reader.mark(2);
			final int iReadCheck = reader.read();
			if (iReadCheck < 0) {
				// チェックの最中にファイルの終端に到達しました。
				throw new EOFException();
			}

			final char cReadCheck = (char) iReadCheck;
			if (cReadCheck == '#') {
				// 該当行はコメント行でした。

				final int iReadCheck2 = reader.read();
				if (iReadCheck2 < 0) {
					// チェックの最中にファイルの終端に到達しました。
					throw new EOFException();
				}
				final char cReadCheck2 = (char) iReadCheck2;

				if (cReadCheck2 == ':') {
					// リファレンス。
					writer.write(cReadCheck);
					writer.write(cReadCheck2);
					reference.append(copyAtLineEnd(reader, writer).trim());
				} else if (cReadCheck2 == ',') {
					// フラグ。
					writer.write(cReadCheck);
					writer.write(cReadCheck2);
					flag.append(copyAtLineEnd(reader, writer).trim());
				} else if (cReadCheck2 == '.') {
					// extracted コメント。
					writer.write(cReadCheck);
					writer.write(cReadCheck2);
					extractedComments.append(copyAtLineEnd(reader, writer).trim());
				} else {
					reader.reset();
					translatorComments.append(copyAtLineEnd(reader, writer));
				}
				return true;
			} else if (cReadCheck == ' ') {
				writer.write(cReadCheck);
			} else {
				// 最後に読み込んだ文字は巻き戻しします。
				reader.reset();
				return false;
			}
		}
	}

	/**
	 * 与えられたリーダーについて、行末までコピーします。
	 * @param reader 入力リーダー。
	 * @param writer 出力ライター。
	 * @return 行末までの文字列。
	 * @throws IOException 入出力例外が発生した場合。
	 */
	public static String copyAtLineEnd(final Reader reader, final Writer writer) throws IOException {
		final StringBuffer result = new StringBuffer();
		boolean isLineBreaked = false;
		for (;;) {
			reader.mark(1);
			final int iRead = reader.read();
			if (iRead < 0) {
				reader.reset();
				break;
			}
			final char cRead = (char) iRead;
			if (cRead == '\n' || cRead == '\r') {
				isLineBreaked = true;
			} else {
				if (isLineBreaked) {
					reader.reset();
					break;
				}
			}
			writer.write(cRead);
			if (isLineBreaked == false) {
				result.append(cRead);
			}
		}

		return result.toString();
	}
}
