/*
 * Copyright (c) 2009 Information-technology Promotion Agency, Japan.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 */
package benten.twa.filter.messages;

import java.text.MessageFormat;
import java.util.Locale;
import java.util.MissingResourceException;
import java.util.ResourceBundle;

/**
 * HTMLエクスポート機能のためのメッセージ。
 *
 * リソースバンドル定義: [BentenExportHtmlMessages]。<BR>
 * このクラスはリソースバンドル定義書から自動生成されたリソースバンドルクラスです。<BR>
 * 既知のロケール<BR>
 * <UL>
 * <LI>en
 * <LI>ja
 * </UL>
 */
public class BentenExportHtmlMessages {
    /**
     * リソースバンドルオブジェクト。
     *
     * 内部的に実際に入力を行うリソースバンドルを記憶します。
     */
    private ResourceBundle fResourceBundle;

    /**
     * BentenExportHtmlMessagesクラスのコンストラクタ。
     *
     * 基底名[BentenExportHtmlMessages]、デフォルトのロケール、呼び出し側のクラスローダを使用して、リソースバンドルを取得します。
     */
    public BentenExportHtmlMessages() {
        try {
            fResourceBundle = ResourceBundle.getBundle("benten/twa/filter/messages/BentenExportHtmlMessages");
        } catch (MissingResourceException ex) {
        }
    }

    /**
     * BentenExportHtmlMessagesクラスのコンストラクタ。
     *
     * 基底名[BentenExportHtmlMessages]、指定されたロケール、呼び出し側のクラスローダを使用して、リソースバンドルを取得します。
     *
     * @param locale ロケールの指定
     */
    public BentenExportHtmlMessages(final Locale locale) {
        try {
            fResourceBundle = ResourceBundle.getBundle("benten/twa/filter/messages/BentenExportHtmlMessages", locale);
        } catch (MissingResourceException ex) {
        }
    }

    /**
     * BentenExportHtmlMessagesクラスのコンストラクタ。
     *
     * 基底名[BentenExportHtmlMessages]、指定されたロケール、指定されたクラスローダを使用して、リソースバンドルを取得します。
     *
     * @param locale ロケールの指定
     * @param loader クラスローダの指定
     */
    public BentenExportHtmlMessages(final Locale locale, final ClassLoader loader) {
        try {
            fResourceBundle = ResourceBundle.getBundle("benten/twa/filter/messages/BentenExportHtmlMessages", locale, loader);
        } catch (MissingResourceException ex) {
        }
    }

    /**
     * 内部的に保持しているリソースバンドルオブジェクトを取得します。
     *
     * @return 内部的に保持しているリソースバンドルオブジェクト。
     */
    public ResourceBundle getResourceBundle() {
        return fResourceBundle;
    }

    /**
     * bundle[BentenExportHtmlMessages], key[WindowTitle]
     *
     * [Export Translation Results] (en)<br>
     * [翻訳成果のエクスポート] (ja)<br>
     *
     * @return key[WindowTitle]に対応する値。外部から読み込みができない場合には、定義書の値を戻します。必ずnull以外の値が戻ります。
     */
    public String getWindowTitle() {
        // 初期値として定義書の値を利用します。
        String strFormat = "Export Translation Results";
        try {
            if (fResourceBundle != null) {
                strFormat = fResourceBundle.getString("WindowTitle");
            }
        } catch (MissingResourceException ex) {
        }
        // 置換文字列はひとつもありません。
        return strFormat;
    }

    /**
     * bundle[BentenExportHtmlMessages], key[JobName]
     *
     * [Exporting the translation results...] (en)<br>
     * [翻訳成果のエクスポート中...] (ja)<br>
     *
     * @return key[JobName]に対応する値。外部から読み込みができない場合には、定義書の値を戻します。必ずnull以外の値が戻ります。
     */
    public String getJobName() {
        // 初期値として定義書の値を利用します。
        String strFormat = "Exporting the translation results...";
        try {
            if (fResourceBundle != null) {
                strFormat = fResourceBundle.getString("JobName");
            }
        } catch (MissingResourceException ex) {
        }
        // 置換文字列はひとつもありません。
        return strFormat;
    }

    /**
     * bundle[BentenExportHtmlMessages], key[WizardPageTitle]
     *
     * [Welcome] (en)<br>
     * [ようこそ] (ja)<br>
     *
     * @return key[WizardPageTitle]に対応する値。外部から読み込みができない場合には、定義書の値を戻します。必ずnull以外の値が戻ります。
     */
    public String getWizardPageTitle() {
        // 初期値として定義書の値を利用します。
        String strFormat = "Welcome";
        try {
            if (fResourceBundle != null) {
                strFormat = fResourceBundle.getString("WizardPageTitle");
            }
        } catch (MissingResourceException ex) {
        }
        // 置換文字列はひとつもありません。
        return strFormat;
    }

    /**
     * bundle[BentenExportHtmlMessages], key[WizardPageDescription]
     *
     * [Export the translation results from the project.] (en)<br>
     * [翻訳成果物をプロジェクトからエクスポートします。] (ja)<br>
     *
     * @return key[WizardPageDescription]に対応する値。外部から読み込みができない場合には、定義書の値を戻します。必ずnull以外の値が戻ります。
     */
    public String getWizardPageDescription() {
        // 初期値として定義書の値を利用します。
        String strFormat = "Export the translation results from the project.";
        try {
            if (fResourceBundle != null) {
                strFormat = fResourceBundle.getString("WizardPageDescription");
            }
        } catch (MissingResourceException ex) {
        }
        // 置換文字列はひとつもありません。
        return strFormat;
    }

    /**
     * bundle[BentenExportHtmlMessages], key[WizardPageLabel1]
     *
     * [This wizard exports the translation results from the project.\n\n 1.  Export the translation results using XLIFF and the imported translation target.] (en)<br>
     * [このウィザードは、翻訳成果物をプロジェクトからエクスポートします。\n\n 1.  XLIFF とインポートされた翻訳対象物をもちいて、翻訳成果物をエクスポートします。] (ja)<br>
     *
     * @return key[WizardPageLabel1]に対応する値。外部から読み込みができない場合には、定義書の値を戻します。必ずnull以外の値が戻ります。
     */
    public String getWizardPageLabel1() {
        // 初期値として定義書の値を利用します。
        String strFormat = "This wizard exports the translation results from the project.\n\n 1.  Export the translation results using XLIFF and the imported translation target.";
        try {
            if (fResourceBundle != null) {
                strFormat = fResourceBundle.getString("WizardPageLabel1");
            }
        } catch (MissingResourceException ex) {
        }
        // 置換文字列はひとつもありません。
        return strFormat;
    }

    /**
     * bundle[BentenExportHtmlMessages], key[WizardPage2Title]
     *
     * [Target Directory] (en)<br>
     * [対象ディレクトリーの指定] (ja)<br>
     *
     * @return key[WizardPage2Title]に対応する値。外部から読み込みができない場合には、定義書の値を戻します。必ずnull以外の値が戻ります。
     */
    public String getWizardPage2Title() {
        // 初期値として定義書の値を利用します。
        String strFormat = "Target Directory";
        try {
            if (fResourceBundle != null) {
                strFormat = fResourceBundle.getString("WizardPage2Title");
            }
        } catch (MissingResourceException ex) {
        }
        // 置換文字列はひとつもありません。
        return strFormat;
    }

    /**
     * bundle[BentenExportHtmlMessages], key[WizardPage2Description]
     *
     * [Specify the necessary directory to export.] (en)<br>
     * [エクスポートに必要なディレクトリーを指定します。] (ja)<br>
     *
     * @return key[WizardPage2Description]に対応する値。外部から読み込みができない場合には、定義書の値を戻します。必ずnull以外の値が戻ります。
     */
    public String getWizardPage2Description() {
        // 初期値として定義書の値を利用します。
        String strFormat = "Specify the necessary directory to export.";
        try {
            if (fResourceBundle != null) {
                strFormat = fResourceBundle.getString("WizardPage2Description");
            }
        } catch (MissingResourceException ex) {
        }
        // 置換文字列はひとつもありません。
        return strFormat;
    }

    /**
     * bundle[BentenExportHtmlMessages], key[WizardPage3ResultMessage]
     *
     * [Translation results exported.] (en)<br>
     * [翻訳成果物をエクスポートしました。] (ja)<br>
     *
     * @return key[WizardPage3ResultMessage]に対応する値。外部から読み込みができない場合には、定義書の値を戻します。必ずnull以外の値が戻ります。
     */
    public String getWizardPage3ResultMessage() {
        // 初期値として定義書の値を利用します。
        String strFormat = "Translation results exported.";
        try {
            if (fResourceBundle != null) {
                strFormat = fResourceBundle.getString("WizardPage3ResultMessage");
            }
        } catch (MissingResourceException ex) {
        }
        // 置換文字列はひとつもありません。
        return strFormat;
    }

    /**
     * bundle[BentenExportHtmlMessages], key[DialogCtrlLabelFromXliffDir]
     *
     * [XLIFF] (en)<br>
     * [XLIFF] (ja)<br>
     *
     * @return key[DialogCtrlLabelFromXliffDir]に対応する値。外部から読み込みができない場合には、定義書の値を戻します。必ずnull以外の値が戻ります。
     */
    public String getDialogCtrlLabelFromXliffDir() {
        // 初期値として定義書の値を利用します。
        String strFormat = "XLIFF";
        try {
            if (fResourceBundle != null) {
                strFormat = fResourceBundle.getString("DialogCtrlLabelFromXliffDir");
            }
        } catch (MissingResourceException ex) {
        }
        // 置換文字列はひとつもありません。
        return strFormat;
    }

    /**
     * bundle[BentenExportHtmlMessages], key[DialogCtrlLabelFromHtmlDir]
     *
     * [Translation Target] (en)<br>
     * [翻訳対象] (ja)<br>
     *
     * @return key[DialogCtrlLabelFromHtmlDir]に対応する値。外部から読み込みができない場合には、定義書の値を戻します。必ずnull以外の値が戻ります。
     */
    public String getDialogCtrlLabelFromHtmlDir() {
        // 初期値として定義書の値を利用します。
        String strFormat = "Translation Target";
        try {
            if (fResourceBundle != null) {
                strFormat = fResourceBundle.getString("DialogCtrlLabelFromHtmlDir");
            }
        } catch (MissingResourceException ex) {
        }
        // 置換文字列はひとつもありません。
        return strFormat;
    }

    /**
     * bundle[BentenExportHtmlMessages], key[DialogCtrlLabelFromHtmlDirInfoDescription]
     *
     * [The default location is {0} of the translation project, \nit is invisible in the project explorer.] (en)<br>
     * [デフォルトのロケーションは翻訳プロジェクトの {0} となっており、\nプロジェクト・エクスプローラーでは不可視になっています。] (ja)<br>
     *
     * @param arg0 置換文字列{0}を置換する値。java.lang.String型を与えてください。
     * @return key[DialogCtrlLabelFromHtmlDirInfoDescription]に対応する値。外部から読み込みができない場合には、定義書の値を戻します。必ずnull以外の値が戻ります。
     */
    public String getDialogCtrlLabelFromHtmlDirInfoDescription(final String arg0) {
        // 初期値として定義書の値を利用します。
        String strFormat = "The default location is {0} of the translation project, \nit is invisible in the project explorer.";
        try {
            if (fResourceBundle != null) {
                strFormat = fResourceBundle.getString("DialogCtrlLabelFromHtmlDirInfoDescription");
            }
        } catch (MissingResourceException ex) {
        }
        final MessageFormat messageFormat = new MessageFormat(strFormat);
        final StringBuffer strbuf = new StringBuffer();
        // 与えられた引数を元に置換文字列を置き換えます。
        messageFormat.format(new Object[] {arg0}, strbuf, null);
        return strbuf.toString();
    }

    /**
     * bundle[BentenExportHtmlMessages], key[DialogCtrlLabelToDir]
     *
     * [Export destination] (en)<br>
     * [エクスポート先] (ja)<br>
     *
     * @return key[DialogCtrlLabelToDir]に対応する値。外部から読み込みができない場合には、定義書の値を戻します。必ずnull以外の値が戻ります。
     */
    public String getDialogCtrlLabelToDir() {
        // 初期値として定義書の値を利用します。
        String strFormat = "Export destination";
        try {
            if (fResourceBundle != null) {
                strFormat = fResourceBundle.getString("DialogCtrlLabelToDir");
            }
        } catch (MissingResourceException ex) {
        }
        // 置換文字列はひとつもありません。
        return strFormat;
    }

    /**
     * bundle[BentenExportHtmlMessages], key[CoreP001]
     *
     * [Planning the process items...] (en)<br>
     * [処理内容を計画中...] (ja)<br>
     *
     * @return key[CoreP001]に対応する値。外部から読み込みができない場合には、定義書の値を戻します。必ずnull以外の値が戻ります。
     */
    public String getCoreP001() {
        // 初期値として定義書の値を利用します。
        String strFormat = "Planning the process items...";
        try {
            if (fResourceBundle != null) {
                strFormat = fResourceBundle.getString("CoreP001");
            }
        } catch (MissingResourceException ex) {
        }
        // 置換文字列はひとつもありません。
        return strFormat;
    }

    /**
     * bundle[BentenExportHtmlMessages], key[CoreP002]
     *
     * [Processing the directory listings...] (en)<br>
     * [ディレクトリー一覧処理を実行中...] (ja)<br>
     *
     * @return key[CoreP002]に対応する値。外部から読み込みができない場合には、定義書の値を戻します。必ずnull以外の値が戻ります。
     */
    public String getCoreP002() {
        // 初期値として定義書の値を利用します。
        String strFormat = "Processing the directory listings...";
        try {
            if (fResourceBundle != null) {
                strFormat = fResourceBundle.getString("CoreP002");
            }
        } catch (MissingResourceException ex) {
        }
        // 置換文字列はひとつもありません。
        return strFormat;
    }

    /**
     * bundle[BentenExportHtmlMessages], key[CoreP004]
     *
     * [Process completed.\n{0}] (en)<br>
     * [処理を完了しました。\n{0}] (ja)<br>
     *
     * @param arg0 置換文字列{0}を置換する値。java.lang.String型を与えてください。
     * @return key[CoreP004]に対応する値。外部から読み込みができない場合には、定義書の値を戻します。必ずnull以外の値が戻ります。
     */
    public String getCoreP004(final String arg0) {
        // 初期値として定義書の値を利用します。
        String strFormat = "Process completed.\n{0}";
        try {
            if (fResourceBundle != null) {
                strFormat = fResourceBundle.getString("CoreP004");
            }
        } catch (MissingResourceException ex) {
        }
        final MessageFormat messageFormat = new MessageFormat(strFormat);
        final StringBuffer strbuf = new StringBuffer();
        // 与えられた引数を元に置換文字列を置き換えます。
        messageFormat.format(new Object[] {arg0}, strbuf, null);
        return strbuf.toString();
    }

    /**
     * bundle[BentenExportHtmlMessages], key[CoreP011]
     *
     * [Processing the HTML file [{0}]...] (en)<br>
     * [HTML ファイル [{0}] を処理中...] (ja)<br>
     *
     * @param arg0 置換文字列{0}を置換する値。java.lang.String型を与えてください。
     * @return key[CoreP011]に対応する値。外部から読み込みができない場合には、定義書の値を戻します。必ずnull以外の値が戻ります。
     */
    public String getCoreP011(final String arg0) {
        // 初期値として定義書の値を利用します。
        String strFormat = "Processing the HTML file [{0}]...";
        try {
            if (fResourceBundle != null) {
                strFormat = fResourceBundle.getString("CoreP011");
            }
        } catch (MissingResourceException ex) {
        }
        final MessageFormat messageFormat = new MessageFormat(strFormat);
        final StringBuffer strbuf = new StringBuffer();
        // 与えられた引数を元に置換文字列を置き換えます。
        messageFormat.format(new Object[] {arg0}, strbuf, null);
        return strbuf.toString();
    }

    /**
     * bundle[BentenExportHtmlMessages], key[CoreP012]
     *
     * [Processing the HTML file [{0}] using XLIFF file...] (en)<br>
     * [HTML ファイル [{0}] を XLIFF ファイルをもちいて処理中...] (ja)<br>
     *
     * @param arg0 置換文字列{0}を置換する値。java.lang.String型を与えてください。
     * @return key[CoreP012]に対応する値。外部から読み込みができない場合には、定義書の値を戻します。必ずnull以外の値が戻ります。
     */
    public String getCoreP012(final String arg0) {
        // 初期値として定義書の値を利用します。
        String strFormat = "Processing the HTML file [{0}] using XLIFF file...";
        try {
            if (fResourceBundle != null) {
                strFormat = fResourceBundle.getString("CoreP012");
            }
        } catch (MissingResourceException ex) {
        }
        final MessageFormat messageFormat = new MessageFormat(strFormat);
        final StringBuffer strbuf = new StringBuffer();
        // 与えられた引数を元に置換文字列を置き換えます。
        messageFormat.format(new Object[] {arg0}, strbuf, null);
        return strbuf.toString();
    }

    /**
     * bundle[BentenExportHtmlMessages], key[CoreP013]
     *
     * [Processing the binary file [{0}]...] (en)<br>
     * [バイナリー・ファイル [{0}] を処理中...] (ja)<br>
     *
     * @param arg0 置換文字列{0}を置換する値。java.lang.String型を与えてください。
     * @return key[CoreP013]に対応する値。外部から読み込みができない場合には、定義書の値を戻します。必ずnull以外の値が戻ります。
     */
    public String getCoreP013(final String arg0) {
        // 初期値として定義書の値を利用します。
        String strFormat = "Processing the binary file [{0}]...";
        try {
            if (fResourceBundle != null) {
                strFormat = fResourceBundle.getString("CoreP013");
            }
        } catch (MissingResourceException ex) {
        }
        final MessageFormat messageFormat = new MessageFormat(strFormat);
        final StringBuffer strbuf = new StringBuffer();
        // 与えられた引数を元に置換文字列を置き換えます。
        messageFormat.format(new Object[] {arg0}, strbuf, null);
        return strbuf.toString();
    }

    /**
     * bundle[BentenExportHtmlMessages], key[CoreE004]
     *
     * [Input XLIFF directory [{0}] could not be found.] (en)<br>
     * [入力 XLIFF ディレクトリー [{0}] は見つかりませんでした。] (ja)<br>
     *
     * @param arg0 置換文字列{0}を置換する値。java.lang.String型を与えてください。
     * @return key[CoreE004]に対応する値。外部から読み込みができない場合には、定義書の値を戻します。必ずnull以外の値が戻ります。
     */
    public String getCoreE004(final String arg0) {
        // 初期値として定義書の値を利用します。
        String strFormat = "Input XLIFF directory [{0}] could not be found.";
        try {
            if (fResourceBundle != null) {
                strFormat = fResourceBundle.getString("CoreE004");
            }
        } catch (MissingResourceException ex) {
        }
        final MessageFormat messageFormat = new MessageFormat(strFormat);
        final StringBuffer strbuf = new StringBuffer();
        // 与えられた引数を元に置換文字列を置き換えます。
        messageFormat.format(new Object[] {arg0}, strbuf, null);
        return strbuf.toString();
    }

    /**
     * bundle[BentenExportHtmlMessages], key[CoreE005]
     *
     * [Input XLIFF directory [{0}] is actually not a directory.] (en)<br>
     * [入力 XLIFF ディレクトリー [{0}] は、実際にはディレクトリーではありませんでした。] (ja)<br>
     *
     * @param arg0 置換文字列{0}を置換する値。java.lang.String型を与えてください。
     * @return key[CoreE005]に対応する値。外部から読み込みができない場合には、定義書の値を戻します。必ずnull以外の値が戻ります。
     */
    public String getCoreE005(final String arg0) {
        // 初期値として定義書の値を利用します。
        String strFormat = "Input XLIFF directory [{0}] is actually not a directory.";
        try {
            if (fResourceBundle != null) {
                strFormat = fResourceBundle.getString("CoreE005");
            }
        } catch (MissingResourceException ex) {
        }
        final MessageFormat messageFormat = new MessageFormat(strFormat);
        final StringBuffer strbuf = new StringBuffer();
        // 与えられた引数を元に置換文字列を置き換えます。
        messageFormat.format(new Object[] {arg0}, strbuf, null);
        return strbuf.toString();
    }

    /**
     * bundle[BentenExportHtmlMessages], key[CoreE006]
     *
     * [Input HTML directory [{0}] could not be found.] (en)<br>
     * [入力 HTML ディレクトリー [{0}] は見つかりませんでした。] (ja)<br>
     *
     * @param arg0 置換文字列{0}を置換する値。java.lang.String型を与えてください。
     * @return key[CoreE006]に対応する値。外部から読み込みができない場合には、定義書の値を戻します。必ずnull以外の値が戻ります。
     */
    public String getCoreE006(final String arg0) {
        // 初期値として定義書の値を利用します。
        String strFormat = "Input HTML directory [{0}] could not be found.";
        try {
            if (fResourceBundle != null) {
                strFormat = fResourceBundle.getString("CoreE006");
            }
        } catch (MissingResourceException ex) {
        }
        final MessageFormat messageFormat = new MessageFormat(strFormat);
        final StringBuffer strbuf = new StringBuffer();
        // 与えられた引数を元に置換文字列を置き換えます。
        messageFormat.format(new Object[] {arg0}, strbuf, null);
        return strbuf.toString();
    }

    /**
     * bundle[BentenExportHtmlMessages], key[CoreE007]
     *
     * [Input HTML directory [{0}] is actually not a directory.] (en)<br>
     * [入力 HTML ディレクトリー [{0}] は、実際にはディレクトリーではありませんでした。] (ja)<br>
     *
     * @param arg0 置換文字列{0}を置換する値。java.lang.String型を与えてください。
     * @return key[CoreE007]に対応する値。外部から読み込みができない場合には、定義書の値を戻します。必ずnull以外の値が戻ります。
     */
    public String getCoreE007(final String arg0) {
        // 初期値として定義書の値を利用します。
        String strFormat = "Input HTML directory [{0}] is actually not a directory.";
        try {
            if (fResourceBundle != null) {
                strFormat = fResourceBundle.getString("CoreE007");
            }
        } catch (MissingResourceException ex) {
        }
        final MessageFormat messageFormat = new MessageFormat(strFormat);
        final StringBuffer strbuf = new StringBuffer();
        // 与えられた引数を元に置換文字列を置き換えます。
        messageFormat.format(new Object[] {arg0}, strbuf, null);
        return strbuf.toString();
    }

    /**
     * bundle[BentenExportHtmlMessages], key[CoreE008]
     *
     * [Failed to create the output directory [{0}] while trying to do since it does not exist.] (en)<br>
     * [出力ディレクトリー [{0}] が存在しないので作成しようとしましたが失敗しました。] (ja)<br>
     *
     * @param arg0 置換文字列{0}を置換する値。java.lang.String型を与えてください。
     * @return key[CoreE008]に対応する値。外部から読み込みができない場合には、定義書の値を戻します。必ずnull以外の値が戻ります。
     */
    public String getCoreE008(final String arg0) {
        // 初期値として定義書の値を利用します。
        String strFormat = "Failed to create the output directory [{0}] while trying to do since it does not exist.";
        try {
            if (fResourceBundle != null) {
                strFormat = fResourceBundle.getString("CoreE008");
            }
        } catch (MissingResourceException ex) {
        }
        final MessageFormat messageFormat = new MessageFormat(strFormat);
        final StringBuffer strbuf = new StringBuffer();
        // 与えられた引数を元に置換文字列を置き換えます。
        messageFormat.format(new Object[] {arg0}, strbuf, null);
        return strbuf.toString();
    }

    /**
     * bundle[BentenExportHtmlMessages], key[CoreE009]
     *
     * [Output directory [{0}] exists, but it is actually not a directory.] (en)<br>
     * [出力ディレクトリー [{0}] が存在しますが、実際にはディレクトリーではありませんでした。] (ja)<br>
     *
     * @param arg0 置換文字列{0}を置換する値。java.lang.String型を与えてください。
     * @return key[CoreE009]に対応する値。外部から読み込みができない場合には、定義書の値を戻します。必ずnull以外の値が戻ります。
     */
    public String getCoreE009(final String arg0) {
        // 初期値として定義書の値を利用します。
        String strFormat = "Output directory [{0}] exists, but it is actually not a directory.";
        try {
            if (fResourceBundle != null) {
                strFormat = fResourceBundle.getString("CoreE009");
            }
        } catch (MissingResourceException ex) {
        }
        final MessageFormat messageFormat = new MessageFormat(strFormat);
        final StringBuffer strbuf = new StringBuffer();
        // 与えられた引数を元に置換文字列を置き換えます。
        messageFormat.format(new Object[] {arg0}, strbuf, null);
        return strbuf.toString();
    }
}
