/*
 * Copyright (c) 2009 Information-technology Promotion Agency, Japan.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 */
package benten.twa.filter.messages;

import java.text.MessageFormat;
import java.util.Locale;
import java.util.MissingResourceException;
import java.util.ResourceBundle;

/**
 * HTML－XLIFF変換機能のためのメッセージ。
 *
 * リソースバンドル定義: [BentenConvertToXliffMessages]。<BR>
 * このクラスはリソースバンドル定義書から自動生成されたリソースバンドルクラスです。<BR>
 * 既知のロケール<BR>
 * <UL>
 * <LI>en
 * <LI>ja
 * </UL>
 */
public class BentenConvertToXliffMessages {
    /**
     * リソースバンドルオブジェクト。
     *
     * 内部的に実際に入力を行うリソースバンドルを記憶します。
     */
    private ResourceBundle fResourceBundle;

    /**
     * BentenConvertToXliffMessagesクラスのコンストラクタ。
     *
     * 基底名[BentenConvertToXliffMessages]、デフォルトのロケール、呼び出し側のクラスローダを使用して、リソースバンドルを取得します。
     */
    public BentenConvertToXliffMessages() {
        try {
            fResourceBundle = ResourceBundle.getBundle("benten/twa/filter/messages/BentenConvertToXliffMessages");
        } catch (MissingResourceException ex) {
        }
    }

    /**
     * BentenConvertToXliffMessagesクラスのコンストラクタ。
     *
     * 基底名[BentenConvertToXliffMessages]、指定されたロケール、呼び出し側のクラスローダを使用して、リソースバンドルを取得します。
     *
     * @param locale ロケールの指定
     */
    public BentenConvertToXliffMessages(final Locale locale) {
        try {
            fResourceBundle = ResourceBundle.getBundle("benten/twa/filter/messages/BentenConvertToXliffMessages", locale);
        } catch (MissingResourceException ex) {
        }
    }

    /**
     * BentenConvertToXliffMessagesクラスのコンストラクタ。
     *
     * 基底名[BentenConvertToXliffMessages]、指定されたロケール、指定されたクラスローダを使用して、リソースバンドルを取得します。
     *
     * @param locale ロケールの指定
     * @param loader クラスローダの指定
     */
    public BentenConvertToXliffMessages(final Locale locale, final ClassLoader loader) {
        try {
            fResourceBundle = ResourceBundle.getBundle("benten/twa/filter/messages/BentenConvertToXliffMessages", locale, loader);
        } catch (MissingResourceException ex) {
        }
    }

    /**
     * 内部的に保持しているリソースバンドルオブジェクトを取得します。
     *
     * @return 内部的に保持しているリソースバンドルオブジェクト。
     */
    public ResourceBundle getResourceBundle() {
        return fResourceBundle;
    }

    /**
     * bundle[BentenConvertToXliffMessages], key[WindowTitle]
     *
     * [Convert the translation target to XLIFF] (en)<br>
     * [翻訳対象を XLIFF に変換] (ja)<br>
     *
     * @return key[WindowTitle]に対応する値。外部から読み込みができない場合には、定義書の値を戻します。必ずnull以外の値が戻ります。
     */
    public String getWindowTitle() {
        // 初期値として定義書の値を利用します。
        String strFormat = "Convert the translation target to XLIFF";
        try {
            if (fResourceBundle != null) {
                strFormat = fResourceBundle.getString("WindowTitle");
            }
        } catch (MissingResourceException ex) {
        }
        // 置換文字列はひとつもありません。
        return strFormat;
    }

    /**
     * bundle[BentenConvertToXliffMessages], key[JobName]
     *
     * [Converting the translation target to XLIFF] (en)<br>
     * [翻訳対象を XLIFF に変換中...] (ja)<br>
     *
     * @return key[JobName]に対応する値。外部から読み込みができない場合には、定義書の値を戻します。必ずnull以外の値が戻ります。
     */
    public String getJobName() {
        // 初期値として定義書の値を利用します。
        String strFormat = "Converting the translation target to XLIFF";
        try {
            if (fResourceBundle != null) {
                strFormat = fResourceBundle.getString("JobName");
            }
        } catch (MissingResourceException ex) {
        }
        // 置換文字列はひとつもありません。
        return strFormat;
    }

    /**
     * bundle[BentenConvertToXliffMessages], key[WizardPageTitle]
     *
     * [Welcome] (en)<br>
     * [ようこそ] (ja)<br>
     *
     * @return key[WizardPageTitle]に対応する値。外部から読み込みができない場合には、定義書の値を戻します。必ずnull以外の値が戻ります。
     */
    public String getWizardPageTitle() {
        // 初期値として定義書の値を利用します。
        String strFormat = "Welcome";
        try {
            if (fResourceBundle != null) {
                strFormat = fResourceBundle.getString("WizardPageTitle");
            }
        } catch (MissingResourceException ex) {
        }
        // 置換文字列はひとつもありません。
        return strFormat;
    }

    /**
     * bundle[BentenConvertToXliffMessages], key[WizardPageDescription]
     *
     * [Convert the translation target to XLIFF] (en)<br>
     * [翻訳対象物を XLIFF に変換します。] (ja)<br>
     *
     * @return key[WizardPageDescription]に対応する値。外部から読み込みができない場合には、定義書の値を戻します。必ずnull以外の値が戻ります。
     */
    public String getWizardPageDescription() {
        // 初期値として定義書の値を利用します。
        String strFormat = "Convert the translation target to XLIFF";
        try {
            if (fResourceBundle != null) {
                strFormat = fResourceBundle.getString("WizardPageDescription");
            }
        } catch (MissingResourceException ex) {
        }
        // 置換文字列はひとつもありません。
        return strFormat;
    }

    /**
     * bundle[BentenConvertToXliffMessages], key[WizardPageLabel1]
     *
     * [This wizard converts the translation target to XLIFF.\n\n 1.  Convert the translation target imported into the project to XLIFF.\n 2.  Currently only HTML file is supported.] (en)<br>
     * [このウィザードは、翻訳対象物を XLIFF に変換します。\n\n 1.  プロジェクト内にインポートされた翻訳対象物を、XLIFF に変換します。\n 2.  現在は HTML ファイルに対応しています。] (ja)<br>
     *
     * @return key[WizardPageLabel1]に対応する値。外部から読み込みができない場合には、定義書の値を戻します。必ずnull以外の値が戻ります。
     */
    public String getWizardPageLabel1() {
        // 初期値として定義書の値を利用します。
        String strFormat = "This wizard converts the translation target to XLIFF.\n\n 1.  Convert the translation target imported into the project to XLIFF.\n 2.  Currently only HTML file is supported.";
        try {
            if (fResourceBundle != null) {
                strFormat = fResourceBundle.getString("WizardPageLabel1");
            }
        } catch (MissingResourceException ex) {
        }
        // 置換文字列はひとつもありません。
        return strFormat;
    }

    /**
     * bundle[BentenConvertToXliffMessages], key[WizardPage2Title]
     *
     * [Target Directory] (en)<br>
     * [対象ディレクトリーの指定] (ja)<br>
     *
     * @return key[WizardPage2Title]に対応する値。外部から読み込みができない場合には、定義書の値を戻します。必ずnull以外の値が戻ります。
     */
    public String getWizardPage2Title() {
        // 初期値として定義書の値を利用します。
        String strFormat = "Target Directory";
        try {
            if (fResourceBundle != null) {
                strFormat = fResourceBundle.getString("WizardPage2Title");
            }
        } catch (MissingResourceException ex) {
        }
        // 置換文字列はひとつもありません。
        return strFormat;
    }

    /**
     * bundle[BentenConvertToXliffMessages], key[WizardPage2Description]
     *
     * [Specify the directories for conversion source and conversion destination respectively.] (en)<br>
     * [変換元と変換先のディレクトリーを指定します。] (ja)<br>
     *
     * @return key[WizardPage2Description]に対応する値。外部から読み込みができない場合には、定義書の値を戻します。必ずnull以外の値が戻ります。
     */
    public String getWizardPage2Description() {
        // 初期値として定義書の値を利用します。
        String strFormat = "Specify the directories for conversion source and conversion destination respectively.";
        try {
            if (fResourceBundle != null) {
                strFormat = fResourceBundle.getString("WizardPage2Description");
            }
        } catch (MissingResourceException ex) {
        }
        // 置換文字列はひとつもありません。
        return strFormat;
    }

    /**
     * bundle[BentenConvertToXliffMessages], key[WizardPage3ResultMessage]
     *
     * [Convert the translation target to XLIFF] (en)<br>
     * [翻訳対象物を XLIFF に変換しました。] (ja)<br>
     *
     * @return key[WizardPage3ResultMessage]に対応する値。外部から読み込みができない場合には、定義書の値を戻します。必ずnull以外の値が戻ります。
     */
    public String getWizardPage3ResultMessage() {
        // 初期値として定義書の値を利用します。
        String strFormat = "Convert the translation target to XLIFF";
        try {
            if (fResourceBundle != null) {
                strFormat = fResourceBundle.getString("WizardPage3ResultMessage");
            }
        } catch (MissingResourceException ex) {
        }
        // 置換文字列はひとつもありません。
        return strFormat;
    }

    /**
     * bundle[BentenConvertToXliffMessages], key[DialogCtrlLabelFromDir]
     *
     * [Conversion Source] (en)<br>
     * [変換元] (ja)<br>
     *
     * @return key[DialogCtrlLabelFromDir]に対応する値。外部から読み込みができない場合には、定義書の値を戻します。必ずnull以外の値が戻ります。
     */
    public String getDialogCtrlLabelFromDir() {
        // 初期値として定義書の値を利用します。
        String strFormat = "Conversion Source";
        try {
            if (fResourceBundle != null) {
                strFormat = fResourceBundle.getString("DialogCtrlLabelFromDir");
            }
        } catch (MissingResourceException ex) {
        }
        // 置換文字列はひとつもありません。
        return strFormat;
    }

    /**
     * bundle[BentenConvertToXliffMessages], key[DialogCtrlLabelFromDirInfoDescription]
     *
     * [The default location is {0} of the translation project, \nit is invisible in the project explorer.] (en)<br>
     * [デフォルトのロケーションは翻訳プロジェクトの {0} となっており、\nプロジェクト・エクスプローラーでは不可視になっています。] (ja)<br>
     *
     * @param arg0 置換文字列{0}を置換する値。java.lang.String型を与えてください。
     * @return key[DialogCtrlLabelFromDirInfoDescription]に対応する値。外部から読み込みができない場合には、定義書の値を戻します。必ずnull以外の値が戻ります。
     */
    public String getDialogCtrlLabelFromDirInfoDescription(final String arg0) {
        // 初期値として定義書の値を利用します。
        String strFormat = "The default location is {0} of the translation project, \nit is invisible in the project explorer.";
        try {
            if (fResourceBundle != null) {
                strFormat = fResourceBundle.getString("DialogCtrlLabelFromDirInfoDescription");
            }
        } catch (MissingResourceException ex) {
        }
        final MessageFormat messageFormat = new MessageFormat(strFormat);
        final StringBuffer strbuf = new StringBuffer();
        // 与えられた引数を元に置換文字列を置き換えます。
        messageFormat.format(new Object[] {arg0}, strbuf, null);
        return strbuf.toString();
    }

    /**
     * bundle[BentenConvertToXliffMessages], key[DialogCtrlLabelToDir]
     *
     * [Conversion Destination] (en)<br>
     * [変換先] (ja)<br>
     *
     * @return key[DialogCtrlLabelToDir]に対応する値。外部から読み込みができない場合には、定義書の値を戻します。必ずnull以外の値が戻ります。
     */
    public String getDialogCtrlLabelToDir() {
        // 初期値として定義書の値を利用します。
        String strFormat = "Conversion Destination";
        try {
            if (fResourceBundle != null) {
                strFormat = fResourceBundle.getString("DialogCtrlLabelToDir");
            }
        } catch (MissingResourceException ex) {
        }
        // 置換文字列はひとつもありません。
        return strFormat;
    }

    /**
     * bundle[BentenConvertToXliffMessages], key[DialogMsg.01]
     *
     * [Do you overwrite?] (en)<br>
     * [上書きしますか?] (ja)<br>
     *
     * @return key[DialogMsg.01]に対応する値。外部から読み込みができない場合には、定義書の値を戻します。必ずnull以外の値が戻ります。
     */
    public String getDialogMsg01() {
        // 初期値として定義書の値を利用します。
        String strFormat = "Do you overwrite?";
        try {
            if (fResourceBundle != null) {
                strFormat = fResourceBundle.getString("DialogMsg.01");
            }
        } catch (MissingResourceException ex) {
        }
        // 置換文字列はひとつもありません。
        return strFormat;
    }

    /**
     * bundle[BentenConvertToXliffMessages], key[DialogMsg.02]
     *
     * [Are you sure to overwrite?] (en)<br>
     * [本当に上書きしますか?] (ja)<br>
     *
     * @return key[DialogMsg.02]に対応する値。外部から読み込みができない場合には、定義書の値を戻します。必ずnull以外の値が戻ります。
     */
    public String getDialogMsg02() {
        // 初期値として定義書の値を利用します。
        String strFormat = "Are you sure to overwrite?";
        try {
            if (fResourceBundle != null) {
                strFormat = fResourceBundle.getString("DialogMsg.02");
            }
        } catch (MissingResourceException ex) {
        }
        // 置換文字列はひとつもありません。
        return strFormat;
    }

    /**
     * bundle[BentenConvertToXliffMessages], key[DialogMsg.03]
     *
     * [Do not show me again] (en)<br>
     * [今後このメッセージを表示しない] (ja)<br>
     *
     * @return key[DialogMsg.03]に対応する値。外部から読み込みができない場合には、定義書の値を戻します。必ずnull以外の値が戻ります。
     */
    public String getDialogMsg03() {
        // 初期値として定義書の値を利用します。
        String strFormat = "Do not show me again";
        try {
            if (fResourceBundle != null) {
                strFormat = fResourceBundle.getString("DialogMsg.03");
            }
        } catch (MissingResourceException ex) {
        }
        // 置換文字列はひとつもありません。
        return strFormat;
    }

    /**
     * bundle[BentenConvertToXliffMessages], key[DialogMsg.04]
     *
     * [Already converted to XLIFF. Please note that the files will be overwritten if executed.] (en)<br>
     * [すでに XLIFF に変換されています。実行した場合は上書きされることに注意してください。] (ja)<br>
     *
     * @return key[DialogMsg.04]に対応する値。外部から読み込みができない場合には、定義書の値を戻します。必ずnull以外の値が戻ります。
     */
    public String getDialogMsg04() {
        // 初期値として定義書の値を利用します。
        String strFormat = "Already converted to XLIFF. Please note that the files will be overwritten if executed.";
        try {
            if (fResourceBundle != null) {
                strFormat = fResourceBundle.getString("DialogMsg.04");
            }
        } catch (MissingResourceException ex) {
        }
        // 置換文字列はひとつもありません。
        return strFormat;
    }

    /**
     * bundle[BentenConvertToXliffMessages], key[CoreP001]
     *
     * [Planning the process items...] (en)<br>
     * [処理内容を計画中...] (ja)<br>
     *
     * @return key[CoreP001]に対応する値。外部から読み込みができない場合には、定義書の値を戻します。必ずnull以外の値が戻ります。
     */
    public String getCoreP001() {
        // 初期値として定義書の値を利用します。
        String strFormat = "Planning the process items...";
        try {
            if (fResourceBundle != null) {
                strFormat = fResourceBundle.getString("CoreP001");
            }
        } catch (MissingResourceException ex) {
        }
        // 置換文字列はひとつもありません。
        return strFormat;
    }

    /**
     * bundle[BentenConvertToXliffMessages], key[CoreP002]
     *
     * [Processing the directory listings...] (en)<br>
     * [ディレクトリー一覧処理を実行中...] (ja)<br>
     *
     * @return key[CoreP002]に対応する値。外部から読み込みができない場合には、定義書の値を戻します。必ずnull以外の値が戻ります。
     */
    public String getCoreP002() {
        // 初期値として定義書の値を利用します。
        String strFormat = "Processing the directory listings...";
        try {
            if (fResourceBundle != null) {
                strFormat = fResourceBundle.getString("CoreP002");
            }
        } catch (MissingResourceException ex) {
        }
        // 置換文字列はひとつもありません。
        return strFormat;
    }

    /**
     * bundle[BentenConvertToXliffMessages], key[CoreP003]
     *
     * [Process completed.\n{0}] (en)<br>
     * [処理を完了しました。\n{0}] (ja)<br>
     *
     * @param arg0 置換文字列{0}を置換する値。java.lang.String型を与えてください。
     * @return key[CoreP003]に対応する値。外部から読み込みができない場合には、定義書の値を戻します。必ずnull以外の値が戻ります。
     */
    public String getCoreP003(final String arg0) {
        // 初期値として定義書の値を利用します。
        String strFormat = "Process completed.\n{0}";
        try {
            if (fResourceBundle != null) {
                strFormat = fResourceBundle.getString("CoreP003");
            }
        } catch (MissingResourceException ex) {
        }
        final MessageFormat messageFormat = new MessageFormat(strFormat);
        final StringBuffer strbuf = new StringBuffer();
        // 与えられた引数を元に置換文字列を置き換えます。
        messageFormat.format(new Object[] {arg0}, strbuf, null);
        return strbuf.toString();
    }

    /**
     * bundle[BentenConvertToXliffMessages], key[CoreP011]
     *
     * [Processing the file [{0}]...] (en)<br>
     * [ファイル [{0}] を処理中...] (ja)<br>
     *
     * @param arg0 置換文字列{0}を置換する値。java.lang.String型を与えてください。
     * @return key[CoreP011]に対応する値。外部から読み込みができない場合には、定義書の値を戻します。必ずnull以外の値が戻ります。
     */
    public String getCoreP011(final String arg0) {
        // 初期値として定義書の値を利用します。
        String strFormat = "Processing the file [{0}]...";
        try {
            if (fResourceBundle != null) {
                strFormat = fResourceBundle.getString("CoreP011");
            }
        } catch (MissingResourceException ex) {
        }
        final MessageFormat messageFormat = new MessageFormat(strFormat);
        final StringBuffer strbuf = new StringBuffer();
        // 与えられた引数を元に置換文字列を置き換えます。
        messageFormat.format(new Object[] {arg0}, strbuf, null);
        return strbuf.toString();
    }

    /**
     * bundle[BentenConvertToXliffMessages], key[CoreE004]
     *
     * [Input directory [{0}] could not be found.] (en)<br>
     * [入力ディレクトリー [{0}] は見つかりませんでした。] (ja)<br>
     *
     * @param arg0 置換文字列{0}を置換する値。java.lang.String型を与えてください。
     * @return key[CoreE004]に対応する値。外部から読み込みができない場合には、定義書の値を戻します。必ずnull以外の値が戻ります。
     */
    public String getCoreE004(final String arg0) {
        // 初期値として定義書の値を利用します。
        String strFormat = "Input directory [{0}] could not be found.";
        try {
            if (fResourceBundle != null) {
                strFormat = fResourceBundle.getString("CoreE004");
            }
        } catch (MissingResourceException ex) {
        }
        final MessageFormat messageFormat = new MessageFormat(strFormat);
        final StringBuffer strbuf = new StringBuffer();
        // 与えられた引数を元に置換文字列を置き換えます。
        messageFormat.format(new Object[] {arg0}, strbuf, null);
        return strbuf.toString();
    }

    /**
     * bundle[BentenConvertToXliffMessages], key[CoreE005]
     *
     * [Input directory [{0}] is actually not a directory.] (en)<br>
     * [入力ディレクトリー [{0}] は、実際にはディレクトリーではありませんでした。] (ja)<br>
     *
     * @param arg0 置換文字列{0}を置換する値。java.lang.String型を与えてください。
     * @return key[CoreE005]に対応する値。外部から読み込みができない場合には、定義書の値を戻します。必ずnull以外の値が戻ります。
     */
    public String getCoreE005(final String arg0) {
        // 初期値として定義書の値を利用します。
        String strFormat = "Input directory [{0}] is actually not a directory.";
        try {
            if (fResourceBundle != null) {
                strFormat = fResourceBundle.getString("CoreE005");
            }
        } catch (MissingResourceException ex) {
        }
        final MessageFormat messageFormat = new MessageFormat(strFormat);
        final StringBuffer strbuf = new StringBuffer();
        // 与えられた引数を元に置換文字列を置き換えます。
        messageFormat.format(new Object[] {arg0}, strbuf, null);
        return strbuf.toString();
    }

    /**
     * bundle[BentenConvertToXliffMessages], key[CoreE006]
     *
     * [Failed to create the output directory [{0}] while trying to do since it does not exist.] (en)<br>
     * [出力ディレクトリー [{0}] が存在しないので作成しようとしましたが失敗しました。] (ja)<br>
     *
     * @param arg0 置換文字列{0}を置換する値。java.lang.String型を与えてください。
     * @return key[CoreE006]に対応する値。外部から読み込みができない場合には、定義書の値を戻します。必ずnull以外の値が戻ります。
     */
    public String getCoreE006(final String arg0) {
        // 初期値として定義書の値を利用します。
        String strFormat = "Failed to create the output directory [{0}] while trying to do since it does not exist.";
        try {
            if (fResourceBundle != null) {
                strFormat = fResourceBundle.getString("CoreE006");
            }
        } catch (MissingResourceException ex) {
        }
        final MessageFormat messageFormat = new MessageFormat(strFormat);
        final StringBuffer strbuf = new StringBuffer();
        // 与えられた引数を元に置換文字列を置き換えます。
        messageFormat.format(new Object[] {arg0}, strbuf, null);
        return strbuf.toString();
    }

    /**
     * bundle[BentenConvertToXliffMessages], key[CoreE007]
     *
     * [Output directory [{0}] exists, but it is actually not a directory.] (en)<br>
     * [出力ディレクトリー [{0}] が存在しますが、実際にはディレクトリーではありませんでした。] (ja)<br>
     *
     * @param arg0 置換文字列{0}を置換する値。java.lang.String型を与えてください。
     * @return key[CoreE007]に対応する値。外部から読み込みができない場合には、定義書の値を戻します。必ずnull以外の値が戻ります。
     */
    public String getCoreE007(final String arg0) {
        // 初期値として定義書の値を利用します。
        String strFormat = "Output directory [{0}] exists, but it is actually not a directory.";
        try {
            if (fResourceBundle != null) {
                strFormat = fResourceBundle.getString("CoreE007");
            }
        } catch (MissingResourceException ex) {
        }
        final MessageFormat messageFormat = new MessageFormat(strFormat);
        final StringBuffer strbuf = new StringBuffer();
        // 与えられた引数を元に置換文字列を置き換えます。
        messageFormat.format(new Object[] {arg0}, strbuf, null);
        return strbuf.toString();
    }
}
